<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>


class Reportabilidad
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteUsoInsumoMensual">
    public function reporteUsoInsumoMensual($inicial, $resultados, $fechas, $idproducto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	SELECT
						inventario.codinterno,
						sum(reportinventario.cantidad)as cantidad,
						inventario.modelo,
						marcasmaquina.nombremarca,
						inventario.tipo,
						inventario.descripcion
					FROM
						reportinventario
						Inner Join inventario ON inventario.ID = reportinventario.IDproducto
						Inner Join marcasmaquina ON marcasmaquina.ID = inventario.marca
					WHERE
						reportinventario.idreport in 
							(select 
								idreport 
							from 
								reports
							$fechas
							)
						$idproducto
					group by
						inventario.codinterno
					order by 
						inventario.codinterno
					LIMIT $inicial, $resultados
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteUsoInsumoMensualToExcel">
    public function reporteUsoInsumoMensualToExcel($fechas, $idproducto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
					SELECT
						inventario.codinterno,
						sum(reportinventario.cantidad)as cantidad,
						inventario.modelo,
						marcasmaquina.nombremarca,
						inventario.tipo,
						inventario.descripcion
					FROM
						reportinventario
						Inner Join inventario ON inventario.ID = reportinventario.IDproducto
						Inner Join marcasmaquina ON marcasmaquina.ID = inventario.marca
					WHERE
						reportinventario.idreport in 
							(select 
								idreport 
							from 
								reports
							$fechas
							)
						$idproducto
					group by
						inventario.codinterno
					order by 
						inventario.codinterno
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteUsoInsumoMensualToExcelPorCliente">
    public function reporteUsoInsumoMensualToExcelPorCliente($fechas, $idproducto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
					SELECT
						inventario.codinterno,
						sum(reportinventario.cantidad) as cantidad,
						inventario.modelo,
						marcasmaquina.nombremarca,
						inventario.tipo,
						inventario.descripcion,
						clientes.razonsocial
					FROM
						reportinventario
						Inner Join inventario ON inventario.ID = reportinventario.IDproducto
						Inner Join marcasmaquina ON marcasmaquina.ID = inventario.marca
						Inner Join reports ON reports.idreport = reportinventario.idreport
						Inner Join clientes ON clientes.rut = reports.rut
					WHERE
						reportinventario.idreport in 
							(	select idreport 
								from 
									reports 
								$fechas 
							)
						$idproducto 
					group by 
						inventario.codinterno,
						clientes.razonsocial,
						inventario.modelo,
						marcasmaquina.nombremarca,
						inventario.tipo,
						inventario.descripcion
					order by 
						inventario.codinterno,
						clientes.razonsocial
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    public function cantidadReporteUsoInsumoMensual($fechas, $idproducto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					count( distinct reportinventario.IDproducto) AS cantidad
				FROM
					reportinventario
					Inner Join inventario ON inventario.ID = reportinventario.IDproducto
					Inner Join marcasmaquina ON marcasmaquina.ID = inventario.marca
				WHERE
					reportinventario.idreport in 
						( 
						select 
							idreport 
						from 
							reports
						$fechas
						)
					$idproducto
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteCantidadMaquinaMensual">
    public function reporteCantidadMaquinaMensual($inicial, $resultados, $fechas, $idmaquina)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					maquinas.serieinterna,
					marcasmaquina.nombremarca,
					maquinas.modelo,
					Count(maquinas.serieinterna) as cantidad,
					tiposmaquina.tipo,
					maquinas.formato
				FROM
					maquinas
					Inner Join marcasmaquina ON marcasmaquina.ID = maquinas.marca
					Inner Join tiposmaquina ON maquinas.tipomaquina = tiposmaquina.ID
				WHERE
					maquinas.existe =  '1'
				$fechas
				$idmaquina
				GROUP BY
					marcasmaquina.nombremarca,
					maquinas.modelo
				ORDER BY
					marcasmaquina.nombremarca ASC
				LIMIT $inicial, $resultados
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadReporteCantidadMaquinaMensual">
    public function cantidadReporteCantidadMaquinaMensual($fechas, $idmaquina)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("				
				SELECT
					maquinas.serieinterna,
					marcasmaquina.nombremarca,
					maquinas.modelo,
					Count(maquinas.serieinterna) AS cantidad,
					tiposmaquina.tipo
				FROM
					maquinas
					Inner Join marcasmaquina ON marcasmaquina.ID = maquinas.marca
					Inner Join tiposmaquina ON maquinas.tipomaquina = tiposmaquina.ID
				WHERE
					maquinas.existe =  '1'
				$fechas
				$idmaquina
				GROUP BY
					marcasmaquina.nombremarca,
					maquinas.modelo
				ORDER BY
					marcasmaquina.nombremarca ASC;
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteCantidadMaquinaMensualToExcel">
    public function reporteCantidadMaquinaMensualToExcel($fechas, $idmaquina)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					maquinas.serieinterna,
					marcasmaquina.nombremarca,
					maquinas.modelo,
					Count(maquinas.serieinterna) as cantidad,
					tiposmaquina.tipo,
					maquinas.formato
				FROM
					maquinas
					Inner Join marcasmaquina ON marcasmaquina.ID = maquinas.marca
					Inner Join tiposmaquina ON maquinas.tipomaquina = tiposmaquina.ID
				WHERE
					maquinas.existe =  '1'
				$fechas
				$idmaquina
				GROUP BY
					marcasmaquina.nombremarca,
					maquinas.modelo
				ORDER BY
					marcasmaquina.nombremarca ASC
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteComprasCategoriaMensual">
    public function reporteComprasCategoriaMensual($inicial, $resultados, $fechas, $idproducto, $whereCat, $whereTip)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca,
					ocitems.IDproducto,
					inventario.modelo,
					inventario.descripcion,
					Sum(ocitems.cantidad) AS total,
					oc.fecha
				FROM
					ocitems
					Inner Join inventario ON ocitems.IDproducto = inventario.ID
					Inner Join categorias ON categorias.IDcategoria = inventario.categoria
					Inner Join oc ON ocitems.IDoc = oc.IDoc
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
				WHERE
					oc.estado =  '0'
				$fechas
				$idproducto
				$whereCat
				$whereTip				
				GROUP BY
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca,
					ocitems.IDproducto,
					inventario.modelo,
					inventario.descripcion
				ORDER BY 
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca
				LIMIT $inicial, $resultados
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadComprasCategoriaMensual">
    public function cantidadComprasCategoriaMensual($fechas, $idproducto, $whereCat, $whereTip)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca,
					ocitems.IDproducto,
					inventario.modelo,
					inventario.descripcion,
					Sum(ocitems.cantidad) AS total,
					oc.fecha
				FROM
					ocitems
					Inner Join inventario ON ocitems.IDproducto = inventario.ID
					Inner Join categorias ON categorias.IDcategoria = inventario.categoria
					Inner Join oc ON ocitems.IDoc = oc.IDoc
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
				WHERE
					oc.estado =  '0'
				$fechas
				$idproducto	
				$whereCat
				$whereTip				
				GROUP BY
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca,
					ocitems.IDproducto,
					inventario.modelo,
					inventario.descripcion
				ORDER BY 
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca;
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteComprasCategoriaMensualToExcel">
    public function reporteComprasCategoriaMensualToExcel($fechas, $idproducto, $whereCat, $whereTip)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca,
					ocitems.IDproducto,
					inventario.modelo,
					inventario.descripcion,
					Sum(ocitems.cantidad) AS total,
					oc.fecha
				FROM
					ocitems
					Inner Join inventario ON ocitems.IDproducto = inventario.ID
					Inner Join categorias ON categorias.IDcategoria = inventario.categoria
					Inner Join oc ON ocitems.IDoc = oc.IDoc
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
				WHERE
					oc.estado =  '0'
				$fechas
				$idproducto					
				$whereCat
				$whereTip
				GROUP BY
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca,
					ocitems.IDproducto,
					inventario.modelo,
					inventario.descripcion
				ORDER BY 
					inventario.tipo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca;
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteDevolucionInsumoMensual">
    public function reporteDevolucionInsumoMensual($inicial, $resultados, $fechas, $idproducto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					controldevolucioninventario.IDproducto,
					Sum(controldevolucioninventario.cantidad) AS cantidad,
					inventario.modelo,
					marcasmaquina.nombremarca,
					inventario.tipo,
					inventario.descripcion,
					inventario.codinterno
				FROM
					controldevolucioninventario
					Inner Join inventario ON controldevolucioninventario.idProducto = inventario.ID
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID					
				WHERE
					$fechas
					$idproducto
				GROUP BY
					controldevolucioninventario.IDproducto
				ORDER BY
					inventario.codinterno
				LIMIT $inicial, $resultados;
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadReporteDevolucionInsumoMensual">
    public function cantidadReporteDevolucionInsumoMensual($fechas, $idproducto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					count( distinct controldevolucioninventario.IDproducto) AS cantidad
				FROM
					controldevolucioninventario
					Inner Join inventario ON controldevolucioninventario.IDproducto = inventario.ID
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID					
				WHERE
					$fechas
					$idproducto;
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteDevolucionInsumoMensualToExcel">
    public function reporteDevolucionInsumoMensualToExcel($fechas, $idproducto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					controldevolucioninventario.IDproducto,
					Sum(controldevolucioninventario.cantidad) AS cantidad,
					inventario.modelo,
					marcasmaquina.nombremarca,
					inventario.tipo,
					inventario.descripcion,
					inventario.codinterno
				FROM
					controldevolucioninventario
					Inner Join inventario ON controldevolucioninventario.idProducto = inventario.ID
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID					
				WHERE
					$fechas
					$idproducto
				GROUP BY
					controldevolucioninventario.IDproducto
				ORDER BY
					inventario.codinterno
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteDevolucionInsumoMensualDetalleToExcel">
    public function reporteDevolucionInsumoMensualDetalleToExcel($fechas, $idproducto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					controldevolucioninventario.idProducto,
					controldevolucioninventario.cantidad,
					controldevolucioninventario.fechaDevolucion,
					controldevolucioninventario.fechaDevolucionReal,
					inventario.modelo,
					marcasmaquina.nombremarca,
					inventario.tipo,
					inventario.descripcion,
					inventario.codinterno,
					controldevolucioninventario.idControl,
					controlsalida.nombrecliente,
					controlsalida.rutcliente,
					centrocosto.nombreCentroCosto,
					clientes.razonsocial,
					clientes.rut,
					clientes.dv
				FROM
					controldevolucioninventario
					Inner Join inventario ON controldevolucioninventario.idProducto = inventario.ID
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
					Inner Join controlsalida ON controldevolucioninventario.idControl = controlsalida.IDcontrol
					Inner Join centrocosto ON controlsalida.idCentroCosto = centrocosto.idCentroCosto
					Inner Join clientes ON controlsalida.rut = clientes.rut
				WHERE
					$fechas
					$idproducto
				ORDER BY
					controldevolucioninventario.idControl;
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteCentroCostoInsumoMensual">
    public function reporteCentroCostoInsumoMensual($inicial, $resultados, $fechas, $idproducto, $cliente, $IdCentroCosto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT
					v_reporte_insumos_centro_costo.IDCONTROL 			as IdControl,
					Sum(v_reporte_insumos_centro_costo.CANTIDAD) 		as cantidad,
					v_reporte_insumos_centro_costo.IDPRODUCTO 			as IDproducto,
					v_reporte_insumos_centro_costo.RUT 					as rut,
					v_reporte_insumos_centro_costo.FECHA 				as fecha,
					v_reporte_insumos_centro_costo.RECINTO 				as recinto,
					v_reporte_insumos_centro_costo.NOMBRECENTROCOSTO 	as nombreCentroCosto,
					v_reporte_insumos_centro_costo.RAZONSOCIAL 			as razonsocial,
					v_reporte_insumos_centro_costo.CLIENTE				as cliente,
					v_reporte_insumos_centro_costo.MODELO				as modelo,
					v_reporte_insumos_centro_costo.TIPO					as tipo,
					v_reporte_insumos_centro_costo.DESCRIPCION			as descripcion,
					v_reporte_insumos_centro_costo.PRECIOVENTA 			as precioventa,
					v_reporte_insumos_centro_costo.PRECIOCOMPRA			as preciocompra,
					v_reporte_insumos_centro_costo.NOMBREMARCA			as nombremarca,
					v_reporte_insumos_centro_costo.CODINTERNO   		as codinterno,
					v_reporte_insumos_centro_costo.NOMBRECATEGORIA 		as nombrecategoria
				FROM
					v_reporte_insumos_centro_costo
				WHERE
					$fechas
					$idproducto
					$cliente
					$IdCentroCosto
				GROUP BY idcontrol,idproducto	
				HAVING cantidad > 0				
				LIMIT $inicial, $resultados;	
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadReporteCentroCostoInsumoMensual">
    public function cantidadReporteCentroCostoInsumoMensual($fechas, $idproducto, $cliente, $IdCentroCosto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					v_reporte_insumos_centro_costo.IDCONTROL,
					Sum(v_reporte_insumos_centro_costo.CANTIDAD) as CANTIDAD,
					v_reporte_insumos_centro_costo.IDPRODUCTO,
					v_reporte_insumos_centro_costo.RUT,
					v_reporte_insumos_centro_costo.FECHA,
					v_reporte_insumos_centro_costo.RECINTO,
					v_reporte_insumos_centro_costo.NOMBRECENTROCOSTO,
					v_reporte_insumos_centro_costo.RAZONSOCIAL,
					v_reporte_insumos_centro_costo.CLIENTE,
					v_reporte_insumos_centro_costo.MODELO,
					v_reporte_insumos_centro_costo.TIPO,
					v_reporte_insumos_centro_costo.DESCRIPCION,
					v_reporte_insumos_centro_costo.PRECIOVENTA,
					v_reporte_insumos_centro_costo.PRECIOCOMPRA,
					v_reporte_insumos_centro_costo.NOMBREMARCA,
					v_reporte_insumos_centro_costo.CODINTERNO,
					v_reporte_insumos_centro_costo.NOMBRECATEGORIA
				FROM
					v_reporte_insumos_centro_costo
				WHERE
					$fechas
					$idproducto
					$cliente
					$IdCentroCosto
				GROUP BY idcontrol,idproducto					
				HAVING cantidad > 0;
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteCentroCostoInsumoMensualToExcel">
    public function reporteCentroCostoInsumoMensualToExcel($fechas, $idproducto, $cliente, $IdCentroCosto)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("									
				SELECT
					v_reporte_insumos_centro_costo.IDCONTROL 			as IdControl,
					Sum(v_reporte_insumos_centro_costo.CANTIDAD) 		as cantidad,
					v_reporte_insumos_centro_costo.IDPRODUCTO 			as IDproducto,
					v_reporte_insumos_centro_costo.RUT 					as rut,
					v_reporte_insumos_centro_costo.FECHA 				as fecha,
					v_reporte_insumos_centro_costo.RECINTO 				as recinto,
					v_reporte_insumos_centro_costo.NOMBRECENTROCOSTO 	as nombreCentroCosto,
					v_reporte_insumos_centro_costo.RAZONSOCIAL 			as razonsocial,
					v_reporte_insumos_centro_costo.CLIENTE				as cliente,
					v_reporte_insumos_centro_costo.MODELO				as modelo,
					v_reporte_insumos_centro_costo.TIPO					as tipo,
					v_reporte_insumos_centro_costo.DESCRIPCION			as descripcion,
					v_reporte_insumos_centro_costo.PRECIOVENTA 			as precioventa,
					v_reporte_insumos_centro_costo.PRECIOCOMPRA			as preciocompra,
					v_reporte_insumos_centro_costo.NOMBREMARCA			as nombremarca,
					v_reporte_insumos_centro_costo.CODINTERNO   		as codinterno,
					v_reporte_insumos_centro_costo.NOMBRECATEGORIA 		as nombrecategoria
				FROM
					v_reporte_insumos_centro_costo
				WHERE
					$fechas
					$idproducto
					$cliente
					$IdCentroCosto
				GROUP BY idcontrol,idproducto	
				HAVING cantidad > 0;			
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteServiciosCliente">
    public function reporteServiciosCliente($inicial, $resultados, $cliente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					servicios.servicio,
					servicios.precio,
					servicios.tipocambio,
					servicios.IDCliente,
					clientes.rut,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre
				FROM
					servicios
				left outer Join 
					clientes 
				ON servicios.IDCliente = clientes.rut
				WHERE
					clientes.rut = '$cliente'
				ORDER BY
					clientes.rut,
					servicios.servicio
				LIMIT $inicial, $resultados		
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadReporteServiciosCliente">
    public function cantidadReporteServiciosCliente($cliente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					servicios.servicio,
					servicios.precio,
					servicios.tipocambio,
					servicios.IDCliente,
					clientes.rut,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre
				FROM
					servicios
				left outer Join 
					clientes 
				ON servicios.IDCliente = clientes.rut
				WHERE
					clientes.rut =  '$cliente'
				ORDER BY
					clientes.rut,
					servicios.servicio;
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteServiciosClienteToExcel">
    public function reporteServiciosClienteToExcel($cliente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("					
				SELECT
					servicios.servicio,
					servicios.precio,
					servicios.tipocambio,
					servicios.IDCliente,
					clientes.rut,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre
				FROM
					servicios
				left outer Join 
					clientes 
				ON servicios.IDCliente = clientes.rut
				WHERE
					clientes.rut =  '$cliente'
				ORDER BY
					clientes.rut,
					servicios.servicio			
		");
        if ($this->NX_DB->NUM_ROWS() > 0) {
            while ($_ROW = $this->NX_DB->FETCH_ARRAY()) {
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteGestionHorasLlamadoReporte">
    public function reporteGestionHorasLlamadoReporte($inicial, $resultados, $buscar, $orden, $fechas, $idReport, $idllamado)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.fecha,
                llamados.pendiente,
		        clientes.rut as RutCliente,
		        clientes.razonsocial as RazonSocial,
		        clientes.ciudad,
                clientes.direccion,
                reports.fecha,
                reports.horadespacho,
                reports.horallegada,
                reports.horasalida,        
                llamados.fecha as FechaLlamadoCompleto,
		        reports.tecnico as RutTecnico,
		        reports.serieinterna,
		        maquinas.modelo,		        
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
		        date_format(llamados.fecha,'%H:%i') AS HoraLlamado,
		        date_format(reports.fecha,'%d/%m/%Y') AS FechaLlegada,
		        date_format(reports.horallegada,'%H:%i') AS HoraLlegada,
                STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') as FechaLlegadaCompleto,        
                DATEDIFF( STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d '),llamados.fecha ) AS DiasTransLlegada,
                TIMESTAMPDIFF(HOUR, llamados.fecha,STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') ) AS HorasTransLlegada,
                TIMESTAMPDIFF(MINUTE, llamados.fecha,STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') ) AS MinutosTransLlegada
            FROM
                llamados
                Left Outer Join reports ON llamados.report = reports.idreport
	            Left Outer Join clientes ON llamados.rut = clientes.rut
                Left Outer Join usuarios ON reports.tecnico = usuarios.rut 
                Left outer Join maquinas on reports.serieinterna = maquinas.serieinterna            
            WHERE 
                clientes.razonsocial like '%$buscar%'
                and llamados.pendiente= 'NO'
                and llamados.eliminado= 'NO' 
                $idReport
                $idllamado
                $fechas             
            order by llamados.fecha desc
    				LIMIT $inicial, $resultados;		
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadReporteGestionHorasLlamadoReporte">
    public function cantidadReporteGestionHorasLlamadoReporte($buscar, $fechas, $idReport, $idllamado)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("	
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.fecha,
                llamados.pendiente,
		        clientes.rut as RutCliente,
		        clientes.razonsocial as RazonSocial,
		        clientes.ciudad,
                clientes.direccion,
                reports.fecha,
                reports.horadespacho,
                reports.horallegada,
                reports.horasalida,        
                llamados.fecha as FechaLlamadoCompleto,
		        reports.tecnico as RutTecnico,
		        reports.serieinterna,
		        maquinas.modelo,		        
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
		        date_format(llamados.fecha,'%H:%i') AS HoraLlamado,
		        date_format(reports.fecha,'%d/%m/%Y') AS FechaLlegada,
		        date_format(reports.horallegada,'%H:%i') AS HoraLlegada,
                STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') as FechaLlegadaCompleto,        
                DATEDIFF( STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d '),llamados.fecha ) AS DiasTransLlegada,
                TIMESTAMPDIFF(HOUR, llamados.fecha,STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') ) AS HorasTransLlegada,
                TIMESTAMPDIFF(MINUTE, llamados.fecha,STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') ) AS MinutosTransLlegada
            FROM
                llamados
                Left Outer Join reports ON llamados.report = reports.idreport
	            Left Outer Join clientes ON llamados.rut = clientes.rut
                Left Outer Join usuarios ON reports.tecnico = usuarios.rut 
                Left outer Join maquinas on reports.serieinterna = maquinas.serieinterna            
            WHERE 
                clientes.razonsocial like '%$buscar%'
                and llamados.pendiente= 'NO'
                and llamados.eliminado= 'NO' 
                $idReport
                $idllamado
                $fechas             
            order by llamados.fecha desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteGestionHorasLlamadoReporteToExcel">
    public function reporteGestionHorasLlamadoReporteToExcel($buscar, $fechas, $idReport, $idllamado)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.fecha,
                llamados.pendiente,
		        clientes.rut as RutCliente,
		        clientes.razonsocial as RazonSocial,
		        clientes.ciudad,
                clientes.direccion,
                reports.fecha,
                reports.horadespacho,
                reports.horallegada,
                reports.horasalida,        
                llamados.fecha as FechaLlamadoCompleto,
		        reports.tecnico as RutTecnico,
		        reports.serieinterna,
		        maquinas.modelo,		        
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
		        date_format(llamados.fecha,'%H:%i') AS HoraLlamado,
		        date_format(reports.fecha,'%d/%m/%Y') AS FechaLlegada,
		        date_format(reports.horallegada,'%H:%i') AS HoraLlegada,
                STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') as FechaLlegadaCompleto,        
                DATEDIFF( STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d '),llamados.fecha ) AS DiasTransLlegada,
                TIMESTAMPDIFF(HOUR, llamados.fecha,STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') ) AS HorasTransLlegada,
                TIMESTAMPDIFF(MINUTE, llamados.fecha,STR_TO_DATE(CONCAT(reports.fecha, ' ', reports.horallegada), '%Y-%m-%d %H:%i:%s') ) AS MinutosTransLlegada
            FROM
                llamados
                Left Outer Join reports ON llamados.report = reports.idreport
	            Left Outer Join clientes ON llamados.rut = clientes.rut
                Left Outer Join usuarios ON reports.tecnico = usuarios.rut 
                Left outer Join maquinas on reports.serieinterna = maquinas.serieinterna            
            WHERE 
                clientes.razonsocial like '%$buscar%'
                and llamados.pendiente= 'NO'
                and llamados.eliminado= 'NO' 
                $idReport
                $idllamado
                $fechas             
            order by llamados.fecha desc;
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>
}