<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class RebajaInsumo {

	//<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	private $NX_DB;
	private $NX_CONFIG;
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
		$this->NX_CONFIG = $NX_CONFIG;
		$this->NX_DB = new NX_MYSQL(
			$this->NX_CONFIG["DB_HOST"],
			$this->NX_CONFIG["DB_PORT"],
			$this->NX_CONFIG["DB_USER"],
			$this->NX_CONFIG["DB_PASS"],
			$this->NX_CONFIG["DB_NAME"],
			$this->NX_CONFIG["DB_CHARSET"]
		);
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT MAX(LAST_INSERT_ID(IDrebajainsumo)) AS numero
				FROM rebajainsumo
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($numerorebajainsumo, $idCentroCosto, $detalle)
	{
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
				INSERT INTO rebajainsumo(IDrebajainsumo, fecha, idCentroCosto, detalle)
				VALUES($numerorebajainsumo, NOW(), '$idCentroCosto', '$detalle') 
		");
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : ingresarinventario">
	public function ingresarinventario($numerorebajainsumo, $id, $cantidad)
	{
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
				INSERT INTO rebajainsumoitems(IDrebajainsumo, IDproducto, cantidad)
				VALUES($numerorebajainsumo, '$id', '$cantidad') 
		");
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listar_control_cliente">
	public function listar_control_cliente($inicial, $resultados, $buscar, $rut, $orden)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT * 
				FROM controlsalida
				WHERE rut = '$rut' AND
				CAST( controlsalida.IDcontrol AS CHAR) LIKE '%" . addslashes($buscar) . "%'  
				ORDER BY $orden
				LIMIT $inicial, $resultados
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad_control_cliente">
	public function cantidad_control_cliente($buscar, $rut)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM controlsalida
				WHERE rut = '$rut' AND				
				CAST( controlsalida.IDcontrol AS CHAR) LIKE '%" . addslashes($buscar) . "%'  
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosControl">
	public function obtenerdatosControl($idcontrol)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT *, centrocosto.nombreCentroCosto
				FROM controlsalida, clientes, centrocosto
				WHERE controlsalida.IDcontrol = $idcontrol AND
				clientes.rut = controlsalida.rut AND
				controlsalida.idCentroCosto = centrocosto.idCentroCosto
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerInventarioControl">
	public function obtenerInventarioControl($idcontrol)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT controlinventario.*, inventario.*, nombrecategoria, nombremarca
				FROM controlinventario, inventario, categorias, marcasmaquina
				WHERE controlinventario.IDcontrol = $idcontrol AND
				inventario.marca = marcasmaquina.ID AND
				controlinventario.IDproducto = inventario.ID AND
				inventario.categoria = categorias.IDcategoria
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerMaquinasControl">
	public function obtenerMaquinasControl($idcontrol)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT controlinventario.*, maquinas.*, nombremarca, tipo
				FROM controlinventario, maquinas, marcasmaquina, tiposmaquina
				WHERE controlinventario.IDcontrol = $idcontrol AND
				maquinas.serieinterna = controlinventario.IDproducto AND
				maquinas.marca = marcasmaquina.ID AND
				maquinas.tipomaquina = tiposmaquina.ID
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $fechas)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = 0;
		$this->NX_DB->QUERY("				
				SELECT
					salidainterna.IDsalidainterna,
					salidainterna.fecha,
					salidainterna.detalle,
					centrocosto.nombreCentroCosto,
					salidainternaitems.cantidad,
					inventario.tipo,
					inventario.modelo,
					categorias.nombrecategoria,
					marcasmaquina.nombremarca,
					inventario.descripcion,
					inventario.codinterno
					FROM
					salidainterna
					Inner Join centrocosto ON salidainterna.idCentroCosto = centrocosto.idCentroCosto
					Inner Join salidainternaitems ON salidainterna.IDsalidainterna = salidainternaitems.IDsalidainterna
					Inner Join inventario ON salidainternaitems.IDproducto = inventario.ID
					Inner Join categorias ON inventario.categoria = categorias.IDcategoria
					Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
					where inventario.codinterno LIKE '%" . addslashes($buscar) . "%'
					$fechas 
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->NUM_ROWS();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $orden, $fechas)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("				
				SELECT
				rebajainsumo.IDrebajainsumo,
				rebajainsumo.fecha,
				rebajainsumo.detalle,
				centrocosto.nombreCentroCosto,
				rebajainsumoitems.cantidad,
				inventario.tipo,
				inventario.modelo,
				categorias.nombrecategoria,
				marcasmaquina.nombremarca,
				inventario.descripcion,
				inventario.codinterno
				FROM
				rebajainsumo
				Inner Join centrocosto ON rebajainsumo.idCentroCosto = centrocosto.idCentroCosto
				Inner Join rebajainsumoitems ON rebajainsumo.IDrebajainsumo = rebajainsumoitems.IDrebajainsumo
				Inner Join inventario ON rebajainsumoitems.IDproducto = inventario.ID
				Inner Join categorias ON inventario.categoria = categorias.IDcategoria
				Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
				where inventario.codinterno LIKE '%" . addslashes($buscar) . "%'
				$fechas 
				ORDER BY $orden
				LIMIT $inicial, $resultados
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listarPorID">
	public function listarPorID($inicial, $resultados, $buscar, $orden, $idcontrol)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT controlsalida.*, clientes.razonsocial, centrocosto.nombreCentroCosto
				FROM controlsalida, clientes, centrocosto
				WHERE clientes.razonsocial LIKE '%" . addslashes($buscar) . "%' AND
				controlsalida.rut = clientes.rut AND
				controlsalida.idCentroCosto = centrocosto.idCentroCosto
				and controlsalida.idcontrol like '%" . addslashes($idcontrol) . "%'
				ORDER BY $orden
				LIMIT $inicial, $resultados;
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadPorID">
	public function cantidadPorID($buscar, $idcontrol)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM controlsalida, clientes
				WHERE controlsalida.rut = clientes.rut AND
				razonsocial LIKE '%" . addslashes($buscar) . "%'  
				and controlsalida.idcontrol like '%" . addslashes($idcontrol) . "%'				
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCEL">
	public function listarTOEXCEL($buscar, $orden, $fechas)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("				
				SELECT
				rebajainsumo.IDrebajainsumo,
				rebajainsumo.fecha,
				rebajainsumo.detalle,
				centrocosto.nombreCentroCosto,
				rebajainsumoitems.cantidad,
				inventario.tipo,
				inventario.modelo,
				categorias.nombrecategoria,
				marcasmaquina.nombremarca,
				inventario.descripcion,
				inventario.codinterno
				FROM
				rebajainsumo
				Inner Join centrocosto ON rebajainsumo.idCentroCosto = centrocosto.idCentroCosto
				Inner Join rebajainsumoitems ON rebajainsumo.IDrebajainsumo = rebajainsumoitems.IDrebajainsumo
				Inner Join inventario ON rebajainsumoitems.IDproducto = inventario.ID
				Inner Join categorias ON inventario.categoria = categorias.IDcategoria
				Inner Join marcasmaquina ON inventario.marca = marcasmaquina.ID
				where inventario.codinterno LIKE '%" . addslashes($buscar) . "%'
				$fechas 
				ORDER BY $orden		
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listarResponsables">
	public function listarResponsables()
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT
					usuarios.rut,
					usuarios.dv,
					usuarios.nombre,
					usuarios.apellidos,
					UPPER(concat_ws(' ', usuarios.nombre, usuarios.apellidos)) as nombrecompleto,
					concat_ws('-', usuarios.rut, usuarios.dv) as rutcompleto,
					usuarios.estado,
					usuarios.area
				from usuarios
				where usuarios.rut <> 1
				order by 
					usuarios.area desc,
					usuarios.nombre asc
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>
		
}