<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Proveedor {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : asociarProducto">
	public function asociarProducto($rutprov, $iditem, $pcompra, $codigo)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO proveedoritems(rutp, IDitem, precio, codigoprov)
			VALUES('$rutprov','$iditem', '$pcompra', '$codigo')
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : borrarProducto">
    public function borrarProducto($rutprov, $iditem)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				DELETE FROM proveedoritems
				WHERE rutp = '$rutprov' AND 
				IDitem = '$iditem'
				");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    public function listar($inicial, $resultados, $buscar, $orden)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM proveedores
				WHERE razonsocial LIKE '%" . addslashes($buscar) . "%' OR
				rut LIKE '%" . addslashes($buscar) . "%'
				ORDER BY $orden
				LIMIT $inicial, $resultados;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    public function cantidad($buscar)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM proveedores
				WHERE razonsocial LIKE '%" . addslashes($buscar) . "%'		
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadproductos">
    public function cantidadproductos($codinterno, $rutp)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT count(*) AS TOTAL
				FROM proveedoritems, inventario
				WHERE proveedoritems.IDitem = inventario.ID AND
				rutp = '{$rutp}' AND
				inventario.codinterno LIKE '%" . addslashes($codinterno) . "%';");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["TOTAL"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarproductos">
    public function listarproductos($inicial, $resultados, $rutp, $codinterno)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM proveedoritems, inventario, categorias, marcasmaquina
				WHERE proveedoritems.IDitem = inventario.ID AND
				categorias.IDcategoria = inventario.categoria AND
				marcasmaquina.ID = inventario.marca AND
				rutp = '{$rutp}' AND
				inventario.activo = 1 AND
				inventario.codinterno LIKE '%" . addslashes($codinterno) . "%'
				LIMIT {$inicial}, {$resultados};
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerProveedores">
    public function obtenerProveedores($iditem)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM proveedoritems, proveedores
				WHERE proveedoritems.IDitem = '$iditem' AND
				proveedoritems.rutp = proveedores.rut
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : existe">
    public function existe($rut)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM proveedores
				WHERE rut = '{$rut}'
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    public function nuevo($rut, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO proveedores(rut, razonsocial, nombre, telefono, direccion, ciudad, giro)
				VALUES('$rut', '$razonSocial', '$nombre', '$telefono', '$direccion', '$ciudad', '$giro')
				");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminar">
    public function eliminar($rut)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				DELETE FROM proveedores
				WHERE rut = '$rut'
				");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatos">
    public function obtenerDatos($rut)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM proveedores
				WHERE rut =	'$rut'	
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : modificar">
    public function modificar($rut, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE proveedores
				SET razonsocial = '$razonSocial', nombre = '$nombre', telefono = '$telefono',
				    direccion = '$direccion', ciudad = '$ciudad', giro = '$giro'
				WHERE rut = '$rut'
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

}