﻿<?php
//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>
class OrdenTrabajo {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    function nuevo($numeroot, $rut, $idtalonario, $responsable, $fecha, $totalneto, $tipopago, $idsucursal)
    {
        list( $dia, $mes, $anio) = explode( '-', $fecha );
        $fecha2 = "$anio/$mes/$dia";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO 
		        ot (IDot, rutcliente, idtalonario, nombreresp, fecha, total, tipopago, idsucursal)
			VALUES
			    ('$numeroot', '$rut', '$idtalonario', '$responsable', '$fecha2', $totalneto, $tipopago, $idsucursal ) 				
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerservicios">
    function obtenerservicios($rut, $idsucursal, $idfamilia, $idformato, $idtipo, $idgramaje)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = "
                SELECT
                    servicios.IDservicio, 
                    servicios.servicio, 
                    servicios.precio, 
                    servicios.tipocambio, 
                    servicios.IDCliente, 
                    serviciosfamilia.familiadesc, 
                    serviciosformato.formatodesc, 
                    serviciostipo.tipodesc, 
                    serviciosgramaje.gramajedesc, 
                    serviciosformato.idformato, 
                    serviciostipo.idtipo, 
                    serviciosgramaje.idgramaje, 
                    serviciosfamilia.idserviciofamilia, 
                    servicios.idsucursal
                FROM
                    servicios
                    INNER JOIN
                    serviciosfamilia
                    ON 
                        servicios.idfamilia = serviciosfamilia.idserviciofamilia
                    INNER JOIN
                    serviciosformato
                    ON 
                        servicios.idformato = serviciosformato.idformato
                    INNER JOIN
                    serviciostipo
                    ON 
                        servicios.idtipo = serviciostipo.idtipo
                    INNER JOIN
                    serviciosgramaje
                    ON 
                        servicios.idgramaje = serviciosgramaje.idgramaje
                WHERE IDCliente = '$rut'
                and idsucursal = $idsucursal
                $idfamilia
                $idformato
                $idtipo
                $idgramaje
                ORDER BY servicios.servicio ASC
                ";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerserviciosBuscar">
    function obtenerserviciosBuscar($rut, $servicio, $idsucursal, $idfamilia, $idformato, $idtipo, $idgramaje)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = "
                SELECT
                    servicios.IDservicio, 
                    servicios.servicio, 
                    servicios.precio, 
                    servicios.tipocambio, 
                    servicios.IDCliente, 
                    serviciosfamilia.familiadesc, 
                    serviciosformato.formatodesc, 
                    serviciostipo.tipodesc, 
                    serviciosgramaje.gramajedesc, 
                    serviciosformato.idformato, 
                    serviciostipo.idtipo, 
                    serviciosgramaje.idgramaje, 
                    serviciosfamilia.idserviciofamilia, 
                    servicios.idsucursal
                FROM
                    servicios
                    INNER JOIN
                    serviciosfamilia
                    ON 
                        servicios.idfamilia = serviciosfamilia.idserviciofamilia
                    INNER JOIN
                    serviciosformato
                    ON 
                        servicios.idformato = serviciosformato.idformato
                    INNER JOIN
                    serviciostipo
                    ON 
                        servicios.idtipo = serviciostipo.idtipo
                    INNER JOIN
                    serviciosgramaje
                    ON 
                        servicios.idgramaje = serviciosgramaje.idgramaje
                WHERE servicios.IDCliente = '$rut'
                AND servicios.idsucursal = $idsucursal
                AND servicios.servicio like '%$servicio%'
                $idfamilia
                $idformato
                $idtipo
                $idgramaje
                ORDER BY servicios.servicio ASC
                ";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresarservicios">
    function ingresarservicios($numeroot, $rut, $servicios, $cantorig, $coporig, $unidades, $precio, $idsucursal)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO 
		        otservicios (IDot, rutcliente, IDservicio, cantoriginales, copiasoriginales, unidades, precio, idsucursal)
			VALUES 
			    ('$numeroot', '$rut', '$servicios', $cantorig, $coporig, $unidades, $precio, $idsucursal ); 				
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar_ot_cliente">
    function listar_ot_cliente($inicial, $resultados, $buscar, $rut, $orden, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = "
                SELECT *
                FROM ot,sucursal
                WHERE rutcliente = '$rut' AND
                ot.idsucursal = sucursal.idsucursal AND
                $sucursal
                CAST( ot.IDot AS CHAR) LIKE '%" . addslashes($buscar) . "%'
                ORDER BY $orden
                LIMIT $inicial, $resultados
                ";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad_ot_cliente">
    function cantidad_ot_cliente($buscar, $rut, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM ot
				WHERE rutcliente = '$rut' AND
				$sucursal				
				CAST( ot.IDot AS CHAR) LIKE '%" . addslashes($buscar) . "%';  
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : asignarboleta">
    function asignarboleta($idot, $rut, $numboleta, $tipopago, $ajuste, $totalapagar)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE ot
				SET numboleta = $numboleta,
				tipopago = $tipopago,
				ajuste = $ajuste,
				totalapagar = $totalapagar
				WHERE ot.IDot = $idot AND
				ot.rutcliente = '$rut'; 
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="FUNCION : asignarfactura">
    function asignarfactura($idot, $rut, $numfactura, $tipopago, $ajuste, $totalapagar)
    {
        $sql = "
                UPDATE ot
                SET idfactura = $numfactura,
                tipopago = $tipopago,
                ajuste = $ajuste,
                totalapagar = $totalapagar
                WHERE ot.IDot = $idot AND
                ot.rutcliente = '$rut'
                ";       
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosOT">
    function obtenerdatosOT($idot, $rut, $idsucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = "
                SELECT
                    *
                FROM
                ot
                INNER JOIN
                clientes
                ON 
                    ot.rutcliente = clientes.rut
                INNER JOIN
                tipospagoot
                ON 
                    ot.tipopago = tipospagoot.idTipoPagoOT
                INNER JOIN
                sucursal
                ON 
                    ot.idsucursal = sucursal.idsucursal
                WHERE
                ot.IDot = $idot AND
                clientes.rut = '$rut' AND
                ot.idsucursal = $idsucursal
		";
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerServiciosOT">
    function obtenerServiciosOT($idot, $rut, $idsucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql ="
                SELECT
                    *,
                    concat(servicios.servicio,' ',serviciosfamilia.familiadesc,' ',serviciosformato.formatodesc,' ',serviciostipo.tipodesc,' ',serviciosgramaje.gramajedesc) AS serviciodesc   
                FROM
                    otservicios
                    INNER JOIN
                    servicios
                    ON 
                        otservicios.IDservicio = servicios.IDservicio
                    INNER JOIN
                    serviciosfamilia
                    ON 
                        servicios.idfamilia = serviciosfamilia.idserviciofamilia
                    INNER JOIN
                    serviciosformato
                    ON 
                        servicios.idformato = serviciosformato.idformato
                    INNER JOIN
                    serviciosgramaje
                    ON 
                        servicios.idgramaje = serviciosgramaje.idgramaje
                    INNER JOIN
                    serviciostipo
                    ON 
                        servicios.idtipo = serviciostipo.idtipo
                WHERE   otservicios.IDot = $idot AND
                        otservicios.rutcliente = '$rut' AND
                        otservicios.idsucursal = '$idsucursal' AND
                        servicios.IDservicio = otservicios.IDservicio
                ";
        $this->NX_DB->QUERY($sql);
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    function cantidad($buscar, $fechas, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM ot, clientes, tipospagoot
				WHERE ot.rutcliente = clientes.rut AND
				ot.tipopago = tipospagoot.idTipoPagoOT AND
				razonsocial LIKE '%" . addslashes($buscar) . "%'  
				$fechas
				$sucursal
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    function listar($inicial, $resultados, $buscar, $fechas, $sucursal)
    {
    	$sql = "
				SELECT * 
				FROM ot, clientes, tipospagoot, sucursal
				WHERE ot.rutcliente = clientes.rut AND
				ot.tipopago = tipospagoot.idTipoPagoOT AND
				ot.idsucursal = sucursal.idsucursal AND
				razonsocial LIKE '%" . addslashes($buscar) . "%' 
				$fechas
				$sucursal
				ORDER BY fecha DESC, ot.IDot DESC
				LIMIT $inicial, $resultados
		";
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
		
		
		$logFile = fopen("log.txt", 'a') or die("Error creando archivo");
        fwrite($logFile, "\n" . date("d/m/Y H:i:s") . " USUARIO: [". $_SESSION['usuario']. "] - ARCHIVO: [". basename(__FILE__). "] - FUNCION: [".__FUNCTION__."]: " . $sql) or die("Error escribiendo en el archivo");
        fclose($logFile);
		
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCEL">
    function listarTOEXCEL($buscar, $fechas, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM ot, clientes, tipospagoot, sucursal
				WHERE ot.rutcliente = clientes.rut AND
				ot.tipopago = tipospagoot.idTipoPagoOT AND
				sucursal.idsucursal = ot.idsucursal AND
				razonsocial LIKE '%" . addslashes($buscar) . "%' 
				$fechas
				$sucursal
				ORDER BY fecha;
		");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarToExcelOTDetalle">
    function listarToExcelOTDetalle($buscar, $fechas, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					ot.IDot,
					ot.rutcliente,
					ot.idtalonario,
					ot.idfactura,
					ot.nombreresp,
					ot.fecha,
					ot.numboleta,
					ot.idguia,
					ot.total,
					clientes.rut,
					clientes.dv,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre,
					clientes.telefono,
					clientes.direccion,
					clientes.ciudad,
					clientes.giro,
					otservicios.Id,
					otservicios.rutcliente,
					otservicios.IDservicio,
					otservicios.cantoriginales,
					otservicios.copiasoriginales,
					otservicios.unidades,
					otservicios.precio,
					otservicios.IDot,
					servicios.servicio,
					servicios.precio,
					servicios.tipocambio,
					servicios.IDCliente,
					tipospagoot.descripcion,
					sucursal.nombresucursal,
					serviciosfamilia.familiadesc,
					serviciosformato.formatodesc,
					serviciostipo.tipodesc,
					serviciosgramaje.gramajedesc					
				FROM
					ot
					Inner Join clientes ON ot.rutcliente = clientes.rut
					Inner Join otservicios ON otservicios.IDot = ot.IDot
					Inner Join servicios ON otservicios.IDservicio = servicios.IDservicio
					Inner Join tipospagoot ON ot.tipopago = tipospagoot.idTipoPagoOT
				    Inner Join sucursal ON ot.idsucursal = sucursal.idsucursal
				    Inner Join serviciosfamilia ON servicios.idfamilia = serviciosfamilia.idserviciofamilia
				    Inner Join serviciosformato ON servicios.idformato = serviciosformato.idformato
				    Inner Join serviciostipo ON servicios.idtipo = serviciostipo.idtipo
				    Inner Join serviciosgramaje ON servicios.idgramaje = serviciosgramaje.idgramaje
				WHERE ot.rutcliente = clientes.rut
					AND razonsocial LIKE '%" . addslashes($buscar) . "%' 
					$fechas
					$sucursal
				ORDER BY ot.fecha;
		");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : precioTotalLista">
    function precioTotalLista($buscar, $fechas, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT SUM(total) AS total
				FROM ot, clientes
				WHERE  ot.rutcliente = clientes.rut AND
				razonsocial LIKE '%" . addslashes($buscar) . "%' 
				$fechas
				$sucursal
		");//GROUP BY rutcliente
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarOT">
    function actualizarOT($idot, $rut, $boleta, $totalneto, $responsable)
    {
        $this->NX_DB->CONECTAR();
        if($boleta == '')
        {
            $this->NX_DB->QUERY("
				UPDATE ot
				SET total = $totalneto, nombreresp = '$responsable'
				WHERE IDot = '$idot' AND rutcliente = '$rut';
				");
        }
        else
        {
            $this->NX_DB->QUERY("
				UPDATE ot
				SET total = $totalneto, numboleta = $boleta, nombreresp = '$responsable'
				WHERE IDot = '$idot' AND rutcliente = '$rut';
				");
        }
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarServicios">
    function actualizarServicios($id, $servicios, $cantorig, $coporig, $unidades, $precio)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        otservicios
		    SET 
		        IDservicio = $servicios, 
		        cantoriginales = $cantorig, 
		        copiasoriginales = '$coporig', 
		        unidades = $unidades, 
		        precio = $precio
			WHERE 
			    Id = $id;
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar_ot_cliente_anual">
    function listar_ot_cliente_anual($rut, $anio)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				ot.rutcliente,
				count(ot.IDot) as Cantidad,
				monthname(ot.fecha) as Mes,
				month(ot.fecha) as MesNumero
				FROM ot
				WHERE rutcliente = '$rut'
				and year(ot.fecha) = '$anio'
				and ot.idfactura is null
				GROUP BY
				month(ot.fecha)
				order by month(ot.fecha)
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorCliente">
    function obtenerDatosFacturacionMensualPorCliente($rut, $anio, $mes)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT ot.rutcliente, 
				count(ot.IDot) as Cantidad, 
				month(ot.fecha) AS MesNumero, 
				count(otservicios.IDservicio), 
				sum(otservicios.cantoriginales) as cantoriginales, 
				sum(otservicios.copiasoriginales) as copiasoriginales, 
				sum(otservicios.unidades) as unidades, 
				otservicios.precio, 
				servicios.servicio as nombreTipoServicio, 
				servicios.tipocambio 
				FROM ot INNER JOIN otservicios ON otservicios.IDot = ot.IDot INNER JOIN servicios ON servicios.IDservicio = otservicios.IDservicio 
				WHERE 
				ot.rutcliente = '$rut' 
				and year(ot.fecha) = '$anio' 
				and month(ot.fecha) = '$mes'
				and ot.idfactura is null 
				group by 
				otservicios.IDservicio,
				otservicios.precio,
				servicios.servicio,
				servicios.tipocambio;
		");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorClienteConIdOt">
    function obtenerDatosFacturacionMensualPorClienteConIdOt($rut, $anio, $mes)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT ot.rutcliente, 
				ot.IDot, 
				month(ot.fecha) AS MesNumero, 
				otservicios.IDservicio, 
				otservicios.cantoriginales, 
				otservicios.copiasoriginales, 
				otservicios.unidades, 
				otservicios.precio, 
				servicios.servicio as nombreTipoServicio, 
				servicios.tipocambio 
				FROM ot INNER JOIN otservicios ON otservicios.IDot = ot.IDot INNER JOIN servicios ON servicios.IDservicio = otservicios.IDservicio 
				WHERE 
				ot.rutcliente = '$rut' 
				and year(ot.fecha) = '$anio' 
				and month(ot.fecha) = '$mes';
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorClienteSoloIdOt">
    function obtenerDatosFacturacionMensualPorClienteSoloIdOt($rut, $anio, $mes)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT ot.rutcliente, 
				ot.IDot 
				FROM ot
				WHERE
				ot.rutcliente = '$rut'
				and year(ot.fecha) = '$anio' 
				and month(ot.fecha) = '$mes'
				and ot.idfactura is null;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : grabarFactura">
    function grabarFactura($rut, $mes, $anio, $numerofactura)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
			UPDATE ot	
			SET idfactura = $numerofactura
			WHERE rutcliente = '$rut'
			and year(fecha) = '$anio'
			and month(fecha) = '$mes';			
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerserviciosCotizacion">
    function obtenerserviciosCotizacion($inicial, $resultados,$buscar,$rut)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM servicios
				WHERE IDCliente = '$rut'
				AND servicio LIKE '%" . addslashes($buscar) . "%'
				ORDER BY servicios.servicio ASC
				LIMIT $inicial, $resultados;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidaderviciosCotizacion">
    function cantidaderviciosCotizacion($buscar,$rut)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM servicios
				WHERE IDCliente = '$rut'
				AND servicio LIKE '%" . addslashes($buscar) . "%'
				ORDER BY servicios.servicio ASC;
		");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidaderviciosCotizacion">
    function obtenerClienteOT($idot)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = "
SELECT
	ot.rutcliente, 
	clientes.dv, 
	clientes.razonsocial, 
		clientes.giro, 
	clientes.direccion, 
	clientes.ciudad 
FROM
	ot
	INNER JOIN
	clientes
	ON 
		ot.rutcliente = clientes.rut
WHERE ot.IDot =  $idot
";
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //$this->NX_DB->QUERY($sql);
        //        return $this->controladorBD->fetch($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidaderviciosCotizacion">
    function obtenerDatosDetalleOTVenta($idot)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = "
		SELECT
        	otservicios.Id,
        	otservicios.IDot,
        	otservicios.unidades AS cantidad,
        	otservicios.precio AS precio,
        	servicios.servicio as descripcion
		FROM
			otservicios
			INNER JOIN
			servicios
			ON
			otservicios.IDservicio = servicios.IDservicio
		WHERE
			otservicios.IDot = $idot
		ORDER BY
			otservicios.Id ASC
		";
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>
}