<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class OTTalonario {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenertalonario">
    public function obtenertalonario($rut, $estado, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT ottalonarios.*
				FROM ottalonarios
				WHERE ottalonarios.rutcliente='$rut' and
				ottalonarios.idsucursal = $sucursal and
				ottalonarios.estado = $estado
				");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresartalonario">
    public function ingresartalonario($rut, $estado, $numinicio, $numfinal, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO 
		        ottalonarios (rutcliente, estado, numactual, numinicial, numfinal, fecha, idsucursal)
			VALUES 
			    ('$rut', '$estado', '$numinicio', '$numinicio', '$numfinal',NOW(), $sucursal)
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenercantidadtalonarios">
    public function obtenercantidadtalonarios($rut, $estado, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT COUNT(*) AS cantidad
				FROM ottalonarios
				WHERE ottalonarios.rutcliente = '$rut' and
				ottalonarios.idsucursal = $sucursal and
				ottalonarios.estado = $estado;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cambiarnumeroactual">
    public function cambiarnumeroactual($idtalonario, $newnumeroactual)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE ottalonarios
				SET numactual = $newnumeroactual
				WHERE ottalonarios.IDtalonario = $idtalonario;
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cambiarestado">
    public function cambiarestado($idtalonario, $estado)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE ottalonarios
				SET estado = $estado
				WHERE ottalonarios.IDtalonario = $idtalonario;
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernuevotalonario">
    public function obtenernuevotalonario($rut, $sucursal)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT MIN(IDtalonario)
				FROM ottalonarios
				WHERE rutcliente = '$rut' and
				idsucursal = $sucursal and
				estado = 2;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    public function listar($inicial, $resultados, $buscar, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					ottalonarios.IDtalonario,
					ottalonarios.rutcliente,
					ottalonarios.estado,
					ottalonarios.numactual,
					ottalonarios.numinicial,
					ottalonarios.numfinal,
					ottalonarios.fecha,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre
				FROM
					ottalonarios
					Inner Join clientes ON ottalonarios.rutcliente = clientes.rut
				WHERE
					razonsocial LIKE '%" . addslashes($buscar) . "%' 
					$fechas
				ORDER BY ottalonarios.estado,clientes.razonsocial
				LIMIT $inicial, $resultados;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    public function cantidad($buscar, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("				
				SELECT
					ottalonarios.IDtalonario,
					ottalonarios.rutcliente,
					ottalonarios.estado,
					ottalonarios.numactual,
					ottalonarios.numinicial,
					ottalonarios.numfinal,
					ottalonarios.fecha,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre
				FROM
					ottalonarios
					Inner Join clientes ON ottalonarios.rutcliente = clientes.rut
				WHERE
					razonsocial LIKE '%" . addslashes($buscar) . "%' 
					$fechas
				ORDER BY fecha
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarToExcel">
    public function listarToExcel($buscar, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					ottalonarios.IDtalonario,
					ottalonarios.rutcliente,
					ottalonarios.estado,
					ottalonarios.numactual,
					ottalonarios.numinicial,
					ottalonarios.numfinal,
					ottalonarios.fecha,
					clientes.razonsocial,
					clientes.cliente,
					clientes.nombre
				FROM
					ottalonarios
					Inner Join clientes ON ottalonarios.rutcliente = clientes.rut
				WHERE
					razonsocial LIKE '%" . addslashes($buscar) . "%' 
					$fechas
				ORDER BY ottalonarios.estado,clientes.razonsocial
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

}