<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Maquinas {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    function nuevo($serieinterna, $seriemaquina, $tipomaquina, $marca, $modelo, $fechacompra, $formato, $conectividad, $existe, $idfactura, $cargofijo)
    {
        list( $dia, $mes, $anio) = explode( '-', $fechacompra );
        $fecha2 = "$anio/$mes/$dia";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO 
		        maquinas (serieinterna, seriemaquina, tipomaquina, marca, modelo, fechacompra, formato, conectividad, existe, idfactura, cargofijo)
			VALUES
			    ('$serieinterna', '$seriemaquina', $tipomaquina, $marca, '$modelo', '$fecha2', '$formato', '$conectividad', $existe, $idfactura, $cargofijo);
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : existe">
    function existe($serieinterna)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		    SELECT 
		        count(*) AS cantidad
			FROM 
			    maquinas
			WHERE 
			    serieinterna = '$serieinterna' AND
				existe = 1;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminar">
    function eliminar($serieinterna)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE maquinas
				SET existe = 0
				WHERE serieinterna = '$serieinterna'
				");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : modificar">
    function modificar($serieinterna, $seriemaquina, $modelo, $formato, $conectividad, $cargofijo)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        maquinas
			SET 
			    modelo = '$modelo', 
			    formato = '$formato', 
			    conectividad = '$conectividad', 
			    cargofijo = $cargofijo, 
			    seriemaquina = '$seriemaquina'
			WHERE 
			    serieinterna = '$serieinterna';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    /********* PARA EL LISTAR y SELECCIONAR TODOS (controles, ot, etc.) **********/
    function cantidad($buscar, $whereMar, $whereTip, $whereExis)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM maquinas
				WHERE serieinterna LIKE '%" . addslashes($buscar) . "%'	and existe = 1 $whereMar $whereTip $whereExis
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    function listar($inicial, $resultados, $buscar, $orden, $whereMar, $whereTip, $whereExis)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM maquinas, tiposmaquina, marcasmaquina
				WHERE serieinterna LIKE '%" . addslashes($buscar) . "%' 
				and maquinas.tipomaquina = tiposmaquina.id
				and maquinas.marca = marcasmaquina.id
				and maquinas.existe = 1 
				$whereMar $whereTip $whereExis
				ORDER BY $orden
				LIMIT $inicial, $resultados;
		");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadPorCliente">
    function cantidadPorCliente($buscar, $rut, $ubicacion)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $sql = "
		    SELECT count(*) AS cantidad
			FROM clientemaquina, maquinas
			WHERE clientemaquina.serieintmaquina LIKE '%" . addslashes($buscar) . "%' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = '$rut'
			AND clientemaquina.estado = 1
			AND clientemaquina.ubicacion LIKE '%" . addslashes($ubicacion) . "%'
		";
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarPorCliente">
    function listarPorCliente($rut, $inicial, $resultados, $buscar, $orden, $ubicacion)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql= "
		    SELECT maquinas.*, tiposmaquina.tipo, marcasmaquina.nombremarca, clientemaquina.correlativo, clientemaquina.ubicacion
			FROM clientemaquina, maquinas, tiposmaquina, marcasmaquina
			WHERE clientemaquina.serieintmaquina LIKE '%" . addslashes($buscar) . "%' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna 
			AND tiposmaquina.id = maquinas.tipomaquina
			AND marcasmaquina.id = maquinas.marca
			AND clientemaquina.rutcliente = '$rut'
			AND clientemaquina.estado = 1
			AND clientemaquina.ubicacion LIKE '%" . addslashes($ubicacion) . "%'
			ORDER BY $orden
			LIMIT $inicial, $resultados
		";
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadRetiradasPorCliente">
    function cantidadRetiradasPorCliente($buscar, $rut)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM clientemaquina, maquinas
				WHERE clientemaquina.serieintmaquina LIKE '%" . addslashes($buscar) . "%' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = '$rut'
				AND clientemaquina.estado = 0
				AND clientemaquina.facturada = 0
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarRetiradasPorCliente">
    function listarRetiradasPorCliente($rut, $inicial, $resultados, $buscar, $orden)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT maquinas.*, tiposmaquina.tipo, marcasmaquina.nombremarca, clientemaquina.correlativo, clientemaquina.ubicacion
				FROM clientemaquina, maquinas, tiposmaquina, marcasmaquina
				WHERE clientemaquina.serieintmaquina LIKE '%" . addslashes($buscar) . "%' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna 
				AND tiposmaquina.id = maquinas.tipomaquina
				AND marcasmaquina.id = maquinas.marca
				AND clientemaquina.rutcliente = '$rut'
				AND clientemaquina.estado = 0 
				AND clientemaquina.facturada = 0
				ORDER BY $orden
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadClientes">
    function cantidadClientes($buscar, $serieinterna)//buscar: rut o razon social
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM clientemaquina, clientes, maquinas
				WHERE clientemaquina.serieintmaquina = '$serieinterna' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = clientes.rut AND
				clientemaquina.rutcliente LIKE '%" . addslashes($buscar) . "%' AND
				clientes.rut LIKE '%" . addslashes($buscar) . "%'
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarClientes">
    function listarClientes($inicial, $resultados, $buscar, $orden, $serieinterna)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM clientemaquina, clientes, maquinas
				WHERE clientemaquina.serieintmaquina = '$serieinterna' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = clientes.rut AND
				clientemaquina.rutcliente LIKE '%" . addslashes($buscar) . "%' AND
				clientes.rut LIKE '%" . addslashes($buscar) . "%'	
				ORDER BY $orden
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosMaquinaCliente">
    function obtenerDatosMaquinaCliente($buscar, $serieinterna)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT max(correlativo) as correlativo ,max(ubicacion) as ubicacion 
				FROM clientemaquina, clientes, maquinas
				WHERE clientemaquina.serieintmaquina = '$serieinterna' AND
				clientemaquina.serieintmaquina = maquinas.serieinterna AND
				clientemaquina.rutcliente = clientes.rut AND
				clientemaquina.estado= 1 AND
				clientemaquina.rutcliente LIKE '%" . addslashes($buscar) . "%' AND
				clientes.rut LIKE '%" . addslashes($buscar) . "%'	
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatos">
    function obtenerDatos($serieinterna)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		    SELECT 
		        *
		    FROM 
		        maquinas, 
		        tiposmaquina, 
		        marcasmaquina
			WHERE 
			    serieinterna = '$serieinterna' AND
				maquinas.tipomaquina = tiposmaquina.ID AND
				maquinas.marca = marcasmaquina.ID;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionarfallas">
    function seleccionarfallas()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT * 
				FROM fallas
				order by IDfalla desc
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : setEstadoHistorial">
    function setEstadoHistorial($serieInterna)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE clientemaquina
				   SET estado = 0
				 WHERE serieintmaquina = '$serieInterna'
				   AND estado = 1
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : setEstadoFacturada">
    function setEstadoFacturada($rut, $serieInterna, $estado)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE clientemaquina
				   SET facturada = $estado
				 WHERE serieintmaquina = '$serieInterna'
				  AND rutcliente = '$rut';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarStock">
    function actualizarStock($id, $cant, $oper, $col)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE maquinas
				SET $col = ($col $oper $cant)
				WHERE serieinterna = '$id';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionAnualPorCliente">
    function listarFacturacionAnualPorCliente($rut, $inicial, $resultados, $buscar, $anio)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				contadores.rutcliente,
				count(contadores.serieintmaquina) as Cantidad,
				monthname(contadores.fechafacturacion) as Mes,
				month(contadores.fechafacturacion) as MesNumero
				FROM
				contadores
				where 
				contadores.rutcliente = '$rut'
				and year(contadores.fechafacturacion) = '$anio'
				and contadores.idfactura is null
				GROUP BY
				month(contadores.fechafacturacion)
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionTotalPorCliente">
    function listarFacturacionTotalPorCliente($rut, $inicial, $resultados, $idmaquina, $anio, $mes, $buscar)
    {
        //Esta consulta incluye toda la información que se copiara en la nueva facturacion
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					contadores.rutcliente,
					contadores.serieintmaquina,
					monthname(contadores.fechafacturacion) AS MesNombre2,
					ELT(DATE_FORMAT(contadores.fechafacturacion,'%m'),'ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE') AS MesNombre,
					month(contadores.fechafacturacion) AS MesNumero,
					year(contadores.fechafacturacion) AS YearNumero,
					tiposerviciomaquina.idTipoServicio,
					tiposerviciomaquina.nombreTipoServicio,
					contadores.contador,
					contadores.copiasfacturadas,
					contadores.fechafacturacion,
					copiascliente.costocopia,
					copiascliente.minimocopia,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					marcasmaquina.nombremarca
				FROM				
					contadores
					LEFT OUTER JOIN copiascliente 
						ON copiascliente.rutcliente = contadores.rutcliente 
						AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina 
						AND copiascliente.serieintmaquina = contadores.serieintmaquina
					LEFT OUTER JOIN tiposerviciomaquina 
						ON contadores.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					INNER JOIN maquinas 
						ON maquinas.serieinterna = contadores.serieintmaquina
					INNER JOIN marcasmaquina 
						ON marcasmaquina.ID = maquinas.marca
				WHERE
					contadores.rutcliente = '$rut' 
					and contadores.serieintmaquina LIKE '%$buscar%'
					and year(contadores.fechafacturacion) LIKE  '%$anio%'
					$mes
					and contadores.serieintmaquina LIKE '%$idmaquina%'
					and contadores.idfactura is null										
				union
				SELECT
					copiascliente.rutcliente,
					copiascliente.serieintmaquina,
					'',
					'',
					0,
					0,
					tiposerviciomaquina.idTipoServicio,
					'CARGO FIJO ',
					1,
					1,
					0,
					copiascliente.costofijo,
					0,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					concat('',marcasmaquina.nombremarca)
				FROM
					copiascliente
					Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
					Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
					where copiascliente.rutcliente = '$rut' 
					and copiascliente.serieintmaquina LIKE '%$buscar%'
					and copiascliente.costofijo > 0
					group by copiascliente.serieintmaquina					
				ORDER BY 
					yearnumero, 
					mesnumero, 
					serieintmaquina, 
					idTipoServicioMaquina
				LIMIT $inicial, $resultados;
		");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadFacturacionTotalPorCliente">
    function cantidadFacturacionTotalPorCliente($rut,$idmaquina, $anio, $mes, $buscar)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
				SELECT
					contadores.rutcliente,
					contadores.serieintmaquina,
					monthname(contadores.fechafacturacion) AS MesNombre2,
					ELT(DATE_FORMAT(contadores.fechafacturacion,'%m'),'ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE') AS MesNombre,
					month(contadores.fechafacturacion) AS MesNumero,
					year(contadores.fechafacturacion) AS YearNumero,
					tiposerviciomaquina.idTipoServicio,
					tiposerviciomaquina.nombreTipoServicio,
					contadores.contador,
					contadores.copiasfacturadas,
					contadores.fechafacturacion,
					copiascliente.costocopia,
					copiascliente.minimocopia,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					marcasmaquina.nombremarca
				FROM				
					contadores
					LEFT OUTER JOIN copiascliente 
						ON copiascliente.rutcliente = contadores.rutcliente 
						AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina 
						AND copiascliente.serieintmaquina = contadores.serieintmaquina
					LEFT OUTER JOIN tiposerviciomaquina 
						ON contadores.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					INNER JOIN maquinas 
						ON maquinas.serieinterna = contadores.serieintmaquina
					INNER JOIN marcasmaquina 
						ON marcasmaquina.ID = maquinas.marca
				WHERE
					contadores.rutcliente = '$rut' 
					and contadores.serieintmaquina LIKE '%$buscar%'
					and year(contadores.fechafacturacion) LIKE  '%$anio%'
					$mes
					and contadores.serieintmaquina LIKE '%$idmaquina%'
					and contadores.idfactura is null					
				union
				SELECT
					copiascliente.rutcliente,
					copiascliente.serieintmaquina,
					'',
					'',
					0,
					0,
					tiposerviciomaquina.idTipoServicio,
					'CARGO FIJO ',
					1,
					1,
					0,
					copiascliente.costofijo,
					0,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					concat('',marcasmaquina.nombremarca)
				FROM
					copiascliente
					Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
					Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
				where
					copiascliente.rutcliente = '$rut' 
					and copiascliente.serieintmaquina LIKE '%$buscar%'
					and copiascliente.costofijo > 0
				group by copiascliente.serieintmaquina									
				ORDER BY 
					yearnumero, 
					mesnumero, 
					serieintmaquina, 
					idTipoServicioMaquina;
		");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionTotalPorClienteMinimoCopiadoGlobal">
    function listarFacturacionTotalPorClienteMinimoCopiadoGlobal($rut, $inicial, $resultados, $idmaquina, $anio, $mes, $buscar, $tiposervicio)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
					contadores.rutcliente,
					contadores.serieintmaquina,
					monthname(contadores.fechafacturacion) AS MesNombre2,
					ELT(DATE_FORMAT(contadores.fechafacturacion,'%m'),'ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE') AS MesNombre,
					month(contadores.fechafacturacion) AS MesNumero,
					year(contadores.fechafacturacion) AS YearNumero,
					tiposerviciomaquina.idTipoServicio,
					tiposerviciomaquina.nombreTipoServicio,
					contadores.contador,
					contadores.copiasfacturadas,
					contadores.fechafacturacion,
					copiascliente.costocopia,
					copiascliente.minimocopia,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					marcasmaquina.nombremarca
				FROM				
					contadores
					LEFT OUTER JOIN copiascliente 
						ON copiascliente.rutcliente = contadores.rutcliente 
						AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina 
						AND copiascliente.serieintmaquina = contadores.serieintmaquina
					LEFT OUTER JOIN tiposerviciomaquina 
						ON contadores.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					INNER JOIN maquinas 
						ON maquinas.serieinterna = contadores.serieintmaquina
					INNER JOIN marcasmaquina 
						ON marcasmaquina.ID = maquinas.marca
				WHERE
					contadores.rutcliente = '$rut'
					and contadores.serieintmaquina LIKE '%$buscar%'
					and year(contadores.fechafacturacion) LIKE  '%$anio%'
					$mes
					and contadores.serieintmaquina LIKE '%$idmaquina%'
					and contadores.idfactura is null	
					$tiposervicio									
				union
				SELECT
					copiascliente.rutcliente,
					copiascliente.serieintmaquina,
					'',
					'',
					0,
					0,
					tiposerviciomaquina.idTipoServicio,
					'CARGO FIJO ',
					1,
					1,
					0,
					copiascliente.costofijo,
					0,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					concat('',marcasmaquina.nombremarca)
				FROM
					copiascliente
					Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
					Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
					where copiascliente.rutcliente = '$rut' 
					and copiascliente.serieintmaquina LIKE '%$buscar%'
					and copiascliente.costofijo > 0
					group by copiascliente.serieintmaquina					
				ORDER BY 
					yearnumero, 
					mesnumero, 
					serieintmaquina, 
					idTipoServicioMaquina
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadFacturacionTotalPorClienteMinimoCopiadoGlobal">
    function cantidadFacturacionTotalPorClienteMinimoCopiadoGlobal($rut,$idmaquina, $anio, $mes, $buscar, $tiposervicio)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("	
				SELECT
					contadores.rutcliente,
					contadores.serieintmaquina,
					monthname(contadores.fechafacturacion) AS MesNombre2,
					ELT(DATE_FORMAT(contadores.fechafacturacion,'%m'),'ENERO','FEBRERO','MARZO','ABRIL','MAYO','JUNIO','JULIO','AGOSTO','SEPTIEMBRE','OCTUBRE','NOVIEMBRE','DICIEMBRE') AS MesNombre,
					month(contadores.fechafacturacion) AS MesNumero,
					year(contadores.fechafacturacion) AS YearNumero,
					tiposerviciomaquina.idTipoServicio,
					tiposerviciomaquina.nombreTipoServicio,
					contadores.contador,
					contadores.copiasfacturadas,
					contadores.fechafacturacion,
					copiascliente.costocopia,
					copiascliente.minimocopia,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					marcasmaquina.nombremarca
				FROM				
					contadores
					LEFT OUTER JOIN copiascliente 
						ON copiascliente.rutcliente = contadores.rutcliente 
						AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina 
						AND copiascliente.serieintmaquina = contadores.serieintmaquina
					LEFT OUTER JOIN tiposerviciomaquina 
						ON contadores.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					INNER JOIN maquinas 
						ON maquinas.serieinterna = contadores.serieintmaquina
					INNER JOIN marcasmaquina 
						ON marcasmaquina.ID = maquinas.marca
				WHERE
					contadores.rutcliente = '$rut' 
					and contadores.serieintmaquina LIKE '%$buscar%'
					and year(contadores.fechafacturacion) LIKE  '%$anio%'
					$mes
					and contadores.serieintmaquina LIKE '%$idmaquina%'
					and contadores.idfactura is null
					$tiposervicio					
				union
				SELECT
					copiascliente.rutcliente,
					copiascliente.serieintmaquina,
					'',
					'',
					0,
					0,
					tiposerviciomaquina.idTipoServicio,
					'CARGO FIJO ',
					1,
					1,
					0,
					copiascliente.costofijo,
					0,
					copiascliente.costofijo,
					copiascliente.idTipoServicioMaquina,
					maquinas.modelo,
					concat('',marcasmaquina.nombremarca)
				FROM
					copiascliente
					Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
					Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
					Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
				where
					copiascliente.rutcliente = '$rut' 
					and copiascliente.serieintmaquina LIKE '%$buscar%'
					and copiascliente.costofijo > 0
				group by copiascliente.serieintmaquina									
				ORDER BY 
					yearnumero, 
					mesnumero, 
					serieintmaquina, 
					idTipoServicioMaquina
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorCliente">
    function obtenerDatosFacturacionMensualPorCliente($rut, $anio, $mes)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT
				copiascliente.rutcliente,
				contadores.copiasfacturadas,
				copiascliente.serieintmaquina,
				contadores.fechafacturacion,
				Month(contadores.fechafacturacion) AS Mes,
				copiascliente.costocopia,
				copiascliente.minimocopia,
				copiascliente.costofijo,
				copiascliente.idTipoServicioMaquina,
				tiposerviciomaquina.nombreTipoServicio,
				maquinas.modelo,
				marcasmaquina.nombremarca
				FROM
				copiascliente
				Left Outer Join contadores ON copiascliente.rutcliente = contadores.rutcliente AND copiascliente.serieintmaquina = contadores.serieintmaquina AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina
				Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
				Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
				Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
				where copiascliente.rutcliente = '$rut'
				and (year(contadores.fechafacturacion) = '$anio'
						or year(contadores.fechafacturacion) is null)
				and (month(contadores.fechafacturacion) = '$mes'
					or month(contadores.fechafacturacion) is null)
				and contadores.idfactura is null
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosFacturacionMensualPorClienteCargoFijo">
    function obtenerDatosFacturacionMensualPorClienteCargoFijo($rut, $anio, $mes)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				copiascliente.rutcliente,
				copiascliente.serieintmaquina,
				contadores.fechafacturacion,
				maquinas.modelo,
				marcasmaquina.nombremarca,
				copiascliente.costofijo AS CargoFijo,
				copiascliente.idTipoServicioMaquina,
				tiposerviciomaquina.nombreTipoServicio
				FROM
				copiascliente
				Left Outer Join contadores ON copiascliente.rutcliente = contadores.rutcliente AND copiascliente.serieintmaquina = contadores.serieintmaquina AND copiascliente.idTipoServicioMaquina = contadores.idTipoServicioMaquina
				Inner Join tiposerviciomaquina ON copiascliente.idTipoServicioMaquina = tiposerviciomaquina.idTipoServicio
				Inner Join maquinas ON copiascliente.serieintmaquina = maquinas.serieinterna
				Inner Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
				where copiascliente.rutcliente = '$rut'
				and (year(contadores.fechafacturacion) = '$anio'
						or year(contadores.fechafacturacion) is null)
				and (month(contadores.fechafacturacion) = '$mes'
					or month(contadores.fechafacturacion) is null)
				and contadores.idfactura is null
				order by copiascliente.serieintmaquina,copiascliente.idTipoServicioMaquina
	    ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarUbicacionClienteMaquina">
    function actualizarUbicacionClienteMaquina($rut, $serieIntMaquina, $ubicacionNueva)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE clientemaquina
				SET ubicacion = '$ubicacionNueva'
				WHERE clientemaquina.serieintmaquina = '$serieIntMaquina'
					AND clientemaquina.estado= 1 
					AND clientemaquina.rutcliente = '$rut'
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaquinasParaCotizacion">
    function listarMaquinasParaCotizacion($inicial, $resultados, $buscar, $orden, $whereMar, $whereTip)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                cotizacionmaquinas.idmaquinacotizacion,
                cotizacionmaquinas.modelo,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo
            FROM
                cotizacionmaquinas
                Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
            WHERE
                activo = 1 AND 
                cotizacionmaquinas.modelo LIKE '%$buscar%'
				$whereMar $whereTip 
			ORDER BY 
			    $orden
			LIMIT $inicial, $resultados;
		");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadMaquinasParaCotizacion">
    function cantidadMaquinasParaCotizacion($buscar, $whereMar, $whereTip)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                cotizacionmaquinas.idMaquinaCotizacion,
                cotizacionmaquinas.modelo,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo
            FROM
                cotizacionmaquinas
                Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
            WHERE 
                activo = 1     
                and cotizacionmaquinas.modelo LIKE '%$buscar%'            
				$whereMar $whereTip 
		");
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoMaquinasParaCotizacion">
    function nuevoMaquinasParaCotizacion($ultimoIdMaquinaCotizacion,$tipomaquina, $marca, $modelo, $formato, $conectividad, $activo, $condiciones, $stockarriendo)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO 
		        cotizacionmaquinas (idmaquinacotizacion, tipomaquina, marca, modelo, formato, conectividad, activo, condiciones, stockarriendo)
			VALUES ($ultimoIdMaquinaCotizacion, $tipomaquina, $marca, '$modelo', '$formato', '$conectividad', $activo, '$condiciones', $stockarriendo);
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoMaquinasParaCotizacionValores">
    function nuevoMaquinasParaCotizacionValores($ultimoIdMaquinaCotizacion,$periodo, $bnMinimo, $colorMinimo, $scannerMinimo, $bnCosto, $colorCosto, $scannerCosto, $cargoFijo)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO 
		        cotizacionmaquinasperiodosvalores (idPeriodo, idMaquinaCotizacion, bnMinimo, colorMinimo, scannerMinimo, bnCosto, colorCosto, scannerCosto, cargoFijo)
			VALUES 
			    ($periodo, $ultimoIdMaquinaCotizacion, $bnMinimo, $colorMinimo, $scannerMinimo, $bnCosto, $colorCosto, $scannerCosto, $cargoFijo);
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ultimoIdMaquinaCotizacion">
    function ultimoIdMaquinaCotizacion()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		    SELECT 
		        max(idmaquinacotizacion) AS id
			FROM 
			    cotizacionmaquinas;
			");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaquinasCotizacion">
    function listarMaquinasCotizacion($inicial, $resultados, $buscarModelo, $buscarPeriodo)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                cotizacionmaquinas.idMaquinaCotizacion,
                cotizacionmaquinas.modelo,
                cotizacionmaquinas.formato,
				cotizacionmaquinas.stockarriendo,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo,
                cotizacionmaquinasperiodosvalores.bnMinimo,
                cotizacionmaquinasperiodosvalores.colorMinimo,
                cotizacionmaquinasperiodosvalores.scannerMinimo,
                cotizacionmaquinasperiodosvalores.bnCosto,
                cotizacionmaquinasperiodosvalores.colorCosto,
                cotizacionmaquinasperiodosvalores.scannerCosto,
                cotizacionmaquinasperiodosvalores.cargoFijo,
                cotizacionmaquinasperiodos.idPeriodo,
                cotizacionmaquinasperiodos.descripcionPeriodo
            FROM
                cotizacionmaquinas
                Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
                Inner Join cotizacionmaquinasperiodosvalores ON cotizacionmaquinas.idMaquinaCotizacion = cotizacionmaquinasperiodosvalores.idMaquinaCotizacion
                Inner Join cotizacionmaquinasperiodos ON cotizacionmaquinasperiodosvalores.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
            WHERE 
                activo = 1 and  
                cotizacionmaquinas.modelo LIKE '%$buscarModelo%' and 
                cotizacionmaquinasperiodos.descripcionPeriodo LIKE '%$buscarPeriodo%'
				LIMIT $inicial, $resultados				
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadMaquinasCotizacion">
    function cantidadMaquinasCotizacion($buscarModelo, $buscarPeriodo)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
            SELECT
                cotizacionmaquinas.idMaquinaCotizacion,
                cotizacionmaquinas.modelo,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo,
                cotizacionmaquinasperiodosvalores.bnMinimo,
                cotizacionmaquinasperiodosvalores.colorMinimo,
                cotizacionmaquinasperiodosvalores.bnCosto,
                cotizacionmaquinasperiodosvalores.colorCosto,
                cotizacionmaquinasperiodosvalores.cargoFijo,
                cotizacionmaquinasperiodos.idPeriodo,
                cotizacionmaquinasperiodos.descripcionPeriodo
            FROM
                cotizacionmaquinas
                Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
                Inner Join cotizacionmaquinasperiodosvalores ON cotizacionmaquinas.idMaquinaCotizacion = cotizacionmaquinasperiodosvalores.idMaquinaCotizacion
                Inner Join cotizacionmaquinasperiodos ON cotizacionmaquinasperiodosvalores.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
            WHERE 
                activo = 1 and  
                cotizacionmaquinas.modelo LIKE '%$buscarModelo%' and 
                cotizacionmaquinasperiodos.descripcionPeriodo LIKE '%$buscarPeriodo%'
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ultimoNumeroSerieInterna">
    function ultimoNumeroSerieInterna($tipo)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				select max(right(serieinterna,4)) AS numero 
				from maquinas
				where serieinterna like '%" . addslashes($tipo) . "%'
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosMaquinasCotizacion">
    function obtenerDatosMaquinasCotizacion($idmaquinacotizacion)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                cotizacionmaquinas.idmaquinacotizacion,
                cotizacionmaquinas.tipomaquina,
                cotizacionmaquinas.marca,
                cotizacionmaquinas.modelo,
                cotizacionmaquinas.formato,
                cotizacionmaquinas.conectividad,
                cotizacionmaquinas.stockarriendo,
                cotizacionmaquinas.activo,
                cotizacionmaquinas.precioarriendo,
                cotizacionmaquinas.precioventa,
                cotizacionmaquinas.maquinacondiciones,
                cotizacionmaquinas.condiciones,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo
            FROM
                cotizacionmaquinas
                Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
            WHERE idmaquinacotizacion = '$idmaquinacotizacion';
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosMaquinasCotizacionValores">
    function obtenerDatosMaquinasCotizacionValores($idmaquinacotizacion)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                *
            FROM
                cotizacionmaquinasperiodosvalores
            WHERE 
                idMaquinaCotizacion = $idmaquinacotizacion
            ORDER BY 
                idPeriodo
		");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarMaquinasParaCotizacionValores">
    function eliminarMaquinasParaCotizacionValores($idmaquinacotizacion)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    DELETE FROM 
		        cotizacionmaquinasperiodosvalores
			WHERE 
			    idMaquinaCotizacion = $idmaquinacotizacion;
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarMaquinasCotizacion">
    function eliminarMaquinasCotizacion($idmaquinacotizacion)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        cotizacionmaquinas
			SET 
			    activo = 0
			WHERE idmaquinacotizacion = '$idmaquinacotizacion';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarCotizacionItems">
    function eliminarCotizacionItems($idCotizacion)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    DELETE FROM 
		        cotizacionitems
			WHERE 
			    idCotizacion = '$idCotizacion';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obteneriDValorPeriodoMaquinaOpciones">
    function obteneriDValorPeriodoMaquinaOpciones($idPeriodo, $idMaquinaCotizacion)
    {
        $sql = 	"
            select idValor 
            from cotizacionmaquinasperiodosvalores 
            where idPeriodo = $idPeriodo and idMaquinaCotizacion = $idMaquinaCotizacion            
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        $RESPONSE = $this->NX_DB->NUM_ROWS();
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchOne($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosMaquinasCotizacionValoresOpciones">
    function obtenerDatosMaquinasCotizacionValoresOpciones($idValor)
    {
        $sql = 	"
            SELECT
                *
            FROM
                cotizacionmaquinasperiodosvaloresopciones
            WHERE idValor = $idValor
            ORDER BY idOpcion
				";
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchall($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarDatosMaquinasCotizacionValoresOpciones">
    function eliminarDatosMaquinasCotizacionValoresOpciones($idValor)
    {
        $sql = 	"
            DELETE
            FROM
                cotizacionmaquinasperiodosvaloresopciones
            WHERE idValor = $idValor
            ";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
        //return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresarDatosMaquinasCotizacionValoresOpciones">
    function ingresarDatosMaquinasCotizacionValoresOpciones($idValor, $descripcionOpcion, $valorOpcion)
    {
        $sql = 	"
				INSERT INTO cotizacionmaquinasperiodosvaloresopciones(idValor, descripcion, valor)
				VALUES($idValor, '$descripcionOpcion', $valorOpcion) 
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
       // return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : modificarMaquinasCotizacion">
    function modificarMaquinasCotizacion($idmaquinacotizacion, $modelo, $formato, $conectividad, $condiciones, $stockarriendo)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        cotizacionmaquinas
			SET 
			    modelo = '$modelo', 
			    formato = '$formato', 
			    conectividad = '$conectividad', 
			    condiciones = '$condiciones',
			    stockarriendo = '$stockarriendo'
			WHERE 
			    idmaquinacotizacion = '$idmaquinacotizacion';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : modificarMaquinasParaCotizacionValores">
    function modificarMaquinasParaCotizacionValores($idValor, $periodo, $bnMinimo, $colorMinimo, $scannerMinimo, $bnCosto, $colorCosto, $scannerCosto, $cargoFijo)
    {
        $sql = 	"
				UPDATE cotizacionmaquinasperiodosvalores
				SET
				    idPeriodo = $periodo, 
				    bnMinimo = $bnMinimo,
				    colorMinimo = $colorMinimo, 
				    scannerMinimo = $scannerMinimo, 
				    bnCosto = $bnCosto, 
				    colorCosto = $colorCosto, 
				    scannerCosto = $scannerCosto, 
				    cargoFijo = $cargoFijo
				WHERE idValor = $idValor
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>
    
    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarMaquinasParaCotizacionValoresporIdValor">
    function eliminarMaquinasParaCotizacionValoresporIdValor($idValor)
    {
        $sql = 	"
				delete from cotizacionmaquinasperiodosvalores
				WHERE idValor = $idValor
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarMaquinasParaCotizacionOpcionesporIdValor">
    function eliminarMaquinasParaCotizacionOpcionesporIdValor($idValor)
    {
        $sql = 	"
				delete from cotizacionmaquinasperiodosvaloresopciones
				WHERE idValor = $idValor
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaquinasParaCotizacionVentas">
    function listarMaquinasParaCotizacionVentas($inicial, $resultados, $buscar, $orden, $whereMar, $whereTip)
    {
        $sql = 	"
            SELECT
                cotizacionmaquinasventas.*,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo
            FROM
                cotizacionmaquinasventas
                Inner Join marcasmaquina ON cotizacionmaquinasventas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinasventas.tipomaquina = tiposmaquina.ID
            WHERE
                activo = 1 
                and cotizacionmaquinasventas.modelo LIKE '%$buscar%'
				$whereMar $whereTip 
				ORDER BY $orden
				LIMIT $inicial, $resultados
				";
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadMaquinasParaCotizacionVentas">
    function cantidadMaquinasParaCotizacionVentas($buscar, $whereMar, $whereTip)
    {
        $sql = "
            SELECT
                cotizacionmaquinasventas.*,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo
            FROM
                cotizacionmaquinasventas
                Inner Join marcasmaquina ON cotizacionmaquinasventas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinasventas.tipomaquina = tiposmaquina.ID
            WHERE
                activo = 1 
                and cotizacionmaquinasventas.modelo LIKE '%$buscar%'
				$whereMar $whereTip 
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;

        $this->NX_DB->QUERY($sql);

        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;


        //return $this->controladorBD->fetchNumRows($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoMaquinasParaCotizacionVentas">
    function nuevoMaquinasParaCotizacionVentas($ultimoIdMaquinaCotizacionVentas, $tipomaquina, $marca, $modelo, $formato, $conectividad, $activo,$preciocompra, $precioventa, $ganancia, $fleteproveedor, $fletecliente, $descripcion, $stockventa, $instalacion)
    {
        $sql = 	"
				INSERT INTO 
				cotizacionmaquinasventas(idmaquinacotizacionventas, tipomaquina, marca, modelo, formato, conectividad, activo, preciocompra, precioventa, ganancia, fleteproveedor, fletecliente, descripcion, stockventa, instalacion)
				VALUES(
				    $ultimoIdMaquinaCotizacionVentas, 
				    $tipomaquina, 
				    $marca, 
				    '$modelo', 
				    '$formato', 
				    '$conectividad', 
				    $activo,
				    $preciocompra,
				    $precioventa,
				    $ganancia,
				    $fleteproveedor,
				    $fletecliente,
				    '$descripcion',
				    $stockventa,
				    '$instalacion')
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ultimoIdMaquinaCotizacionVentas">
    function ultimoIdMaquinaCotizacionVentas()
    {
        $sql = 	"
				select max(idmaquinacotizacionventas) 
				from cotizacionmaquinasventas
				";
        return $this->controladorBD->fetchOne($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosMaquinasCotizacionVentas">
    function obtenerDatosMaquinasCotizacionVentas($idmaquinacotizacionventas)
    {
        $sql = 	"
            SELECT
                cotizacionmaquinasventas.*,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo
            FROM
                cotizacionmaquinasventas
                Inner Join marcasmaquina ON cotizacionmaquinasventas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinasventas.tipomaquina = tiposmaquina.ID
            WHERE idmaquinacotizacionventas = '$idmaquinacotizacionventas'
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;

        //return $this->controladorBD->fetch($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarMaquinasCotizacionVentas">
    function eliminarMaquinasCotizacionVentas($idmaquinacotizacionventas)
    {
        $sql = 	"
				UPDATE cotizacionmaquinasventas
				SET activo = 0
				WHERE idmaquinacotizacionventas = '$idmaquinacotizacionventas'
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : modificarMaquinasCotizacionVentas">
    function modificarMaquinasCotizacionVentas($idmaquinacotizacionventas, $modelo, $formato, $conectividad, $preciocompra, $precioventa, $ganancia, $fleteproveedor, $fletecliente, $descripcion, $stockventa, $instalacion)
            {
        $sql = 	"
				UPDATE cotizacionmaquinasventas
				SET 
				    modelo = '$modelo',
				    formato = '$formato', 
				    conectividad = '$conectividad', 
				    preciocompra = $preciocompra,
				    precioventa = $precioventa,
				    ganancia = $ganancia,
				    fleteproveedor = $fleteproveedor,
				    fletecliente = $fletecliente,
				    descripcion = '$descripcion',
				    stockventa = $stockventa,
				    instalacion = '$instalacion'
				WHERE idmaquinacotizacionventas = '$idmaquinacotizacionventas'
				";

                $this->NX_DB->CONECTAR();
                $this->NX_DB->QUERY($sql);
                $this->NX_DB->DESCONECTAR();
                return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaquinasCotizacionVentas">
    function listarMaquinasCotizacionVentas($inicial, $resultados, $buscarModelo)
    {
        $sql = 	"
            SELECT
                cotizacionmaquinasventas.*,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo
            FROM
                cotizacionmaquinasventas
                Inner Join marcasmaquina ON cotizacionmaquinasventas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinasventas.tipomaquina = tiposmaquina.ID
            WHERE 
                activo = 1 and  
                cotizacionmaquinasventas.modelo LIKE '%$buscarModelo%'
				LIMIT $inicial, $resultados				
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadMaquinasCotizacionVentas">
    function cantidadMaquinasCotizacionVentas($buscarModelo)
    {
        $sql = 	"
            SELECT
                cotizacionmaquinasventas.*,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo
            FROM
                cotizacionmaquinasventas
                Inner Join marcasmaquina ON cotizacionmaquinasventas.marca = marcasmaquina.ID
                Inner Join tiposmaquina ON cotizacionmaquinasventas.tipomaquina = tiposmaquina.ID
            WHERE 
                activo = 1 and  
                cotizacionmaquinasventas.modelo LIKE '%$buscarModelo%'
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;

        $this->NX_DB->QUERY($sql);

        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;

        //return $this->controladorBD->fetchNumRows($sql);
    }
    //</editor-fold>

}