<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Llamados {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    public function nuevo($rut, $serieInterna, $correlativo, $tipo, $otroTipo, $idFalla, $otraFalla, $codFalla, $prioridad, $nombrecontacto, $telefonocontacto)
    {

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("					
		    INSERT INTO llamados(rut, serieinterna, correlativo, tipo, otrotipo, idfalla, otrafalla, coderror, prioridad, pendiente, fecha, nombrecontacto, telefonocontacto)
			VALUES('$rut', '$serieInterna', $correlativo, '$tipo', '$otroTipo', $idFalla, '$otraFalla', '$codFalla', '$prioridad', 'SI', now(), '$nombrecontacto', '$telefonocontacto');
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cambiarestado">
    public function cambiarestado($rut, $serieInterna, $correlativo)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE llamados
				SET pendiente = 'NO'
				WHERE rut = '$rut' AND 
				serieinterna = '$serieInterna' AND
				correlativo = $correlativo;				
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cambiarestadollamado">
    public function cambiarestadollamado($idllamado, $idreport)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE llamados
				SET pendiente = 'NO', report = '$idreport'
				WHERE idllamado = $idllamado;			
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminar">
    public function eliminar($idllamado, $razon)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE llamados
				SET pendiente = 'NO', razon = '$razon', eliminado = 'SI'
				WHERE idllamado = $idllamado			
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : asignartecnico">
    public function asignartecnico($serieInterna, $ruttecnico)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				UPDATE llamados
				SET tecnicoasignado = '$ruttecnico'
				WHERE pendiente = 'SI'
				and llamados.serieinterna = '$serieInterna'				
		");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPendientesClientes">
    public function listarLlamadosPendientesClientes($inicial, $resultados, $buscar, $orden)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.*, count(*) total		
				FROM clientes, llamados
				WHERE clientes.rut = llamados.rut and
				llamados.pendiente = 'SI' and
				(razonsocial LIKE '%" . addslashes($buscar) . "%' OR
				clientes.rut LIKE '%" . addslashes($buscar) . "%')
				GROUP BY clientes.rut
				ORDER BY $orden
				LIMIT $inicial, $resultados;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPendientesByCliente">
    public function listarLlamadosPendientesByCliente($rut)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT date_format(llamados.fecha,'%d/%m/%Y')fechallamado, llamados.*, fallas.nombrefalla, tiposmaquina.tipo tipomaq				
				FROM fallas, llamados, tiposmaquina, maquinas
				WHERE llamados.rut = '$rut' and
				llamados.idfalla = fallas.idfalla and
				llamados.serieinterna = maquinas.serieinterna and
				maquinas.tipomaquina = tiposmaquina.id and
				llamados.pendiente = 'SI'
				ORDER BY fecha
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadllamadosPendientesMaquinas">
    public function cantidadllamadosPendientesMaquinas($buscar)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*)	AS cantidad
				FROM llamados
				WHERE llamados.pendiente = 'SI' AND
				serieinterna LIKE '%" . addslashes($buscar) . "%' 
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPendientesMaquinas">
    public function listarLlamadosPendientesMaquinas($inicial, $resultados, $buscar, $orden)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT maquinas.*, 
					clientes.razonsocial,
					llamados.fecha,
					DATE_FORMAT(DATE(llamados.fecha), '%d-%m-%Y') as dia,
					tiposmaquina.tipo, 
					marcasmaquina.nombremarca,
					clientemaquina.ubicacion,
					llamados.idllamado,
					TIME_FORMAT(TIME(llamados.fecha), '%H:%i') as hora
					FROM maquinas, llamados, fallas, clientemaquina, clientes, tiposmaquina, marcasmaquina 
					WHERE maquinas.serieinterna = llamados.serieinterna and	
					llamados.idfalla = fallas.IDfalla and
					maquinas.serieinterna = clientemaquina.serieintmaquina  and
					clientemaquina.rutcliente = clientes.rut and
					marcasmaquina.id = maquinas.marca and
					tiposmaquina.id = maquinas.tipomaquina and
					llamados.pendiente = 'SI' and
					clientemaquina.estado = 1 and
					maquinas.serieinterna LIKE '%" . addslashes($buscar) . "%' 
				ORDER BY $orden
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPendientesMaquinasTOEXCEL">
    public function listarLlamadosPendientesMaquinasTOEXCEL($buscar, $orden)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                    maquinas.*, 
                    clientes.razonsocial, 
                    clientes.ciudad,
                    llamados.idfalla, 
                    fallas.nombrefalla, 
                    llamados.otrafalla, 
                    llamados.coderror, 
                    llamados.prioridad, 
                    llamados.fecha, 
                    llamados.tecnicoasignado, 
                    llamados.idllamado,
                    DATE_FORMAT(DATE(llamados.fecha), '%d-%m-%Y') as dia,
					TIME_FORMAT(TIME(llamados.fecha), '%H:%i') as hora,
	                llamados.tecnicoasignado,
	                concat(usuarios.nombre,' ',usuarios.apellidos) as nombretecnicoasignado,
                    tiposmaquina.tipo, 
                    clientemaquina.ubicacion, 
                    marcasmaquina.nombremarca
            FROM
                    maquinas
                    INNER JOIN
                    llamados
                    ON 
                        maquinas.serieinterna = llamados.serieinterna
                    INNER JOIN
                    fallas
                    ON 
                        llamados.idfalla = fallas.IDfalla
                    INNER JOIN
                    clientemaquina
                    ON 
                        maquinas.serieinterna = clientemaquina.serieintmaquina
                    INNER JOIN
                    clientes
                    ON 
                        clientemaquina.rutcliente = clientes.rut
                    INNER JOIN
                    marcasmaquina
                    ON 
                        maquinas.marca = marcasmaquina.ID
                    INNER JOIN
                    tiposmaquina
                    ON 
                        maquinas.tipomaquina = tiposmaquina.ID
                    left outer JOIN
                    usuarios
                    ON 
                        llamados.tecnicoasignado = usuarios.rut
            WHERE
                    llamados.pendiente = 'SI' AND
                    clientemaquina.estado = 1 AND
                    maquinas.serieinterna LIKE '%" . addslashes($buscar) . "%' 
			ORDER BY $orden
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPendientesByMaquinaRep">
    public function listarLlamadosPendientesByMaquinaRep($serieInterna, $correlativo)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT date_format(llamados.fecha,'%d/%m/%Y')fechallamado, llamados.*, fallas.nombrefalla, clientes.*				
				FROM fallas, llamados, clientes
				WHERE llamados.serieinterna = '$serieInterna' and
				llamados.idfalla = fallas.idfalla and
				llamados.rut = clientes.rut and
				llamados.pendiente = 'SI'
				ORDER BY fecha
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPendientesByMaquina">
    public function listarLlamadosPendientesByMaquina($serieInterna)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT date_format(llamados.fecha,'%d/%m/%Y')fechallamado, llamados.*, fallas.nombrefalla, clientes.*, 
				concat(usuarios.nombre,' ',usuarios.apellidos) as nombrecompleto,
				TIME_FORMAT(TIME(llamados.fecha), '%H:%i') as hora
				FROM
				llamados
					Inner Join clientes ON llamados.rut = clientes.rut
					Inner Join fallas ON llamados.idfalla = fallas.IDfalla
					left outer  Join usuarios ON llamados.tecnicoasignado = usuarios.rut
				WHERE llamados.serieinterna = '$serieInterna' and
				llamados.pendiente = 'SI'
				ORDER BY fecha
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    public function cantidad($buscar)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*)	AS cantidad	
				FROM llamados
				WHERE llamados.pendiente = 'SI' AND
				serieinterna LIKE '%" . addslashes($buscar) . "%' 
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosResueltos">
    public function listarLlamadosResueltos($idreport)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *				
				FROM fallas, llamados
				WHERE llamados.idfalla = fallas.idfalla AND
				llamados.report = '$idreport' AND
				llamados.pendiente = 'NO'
				ORDER BY fecha
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPorTecnicoV1">
    public function listarLlamadosPorTecnicoV1()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
			SELECT
			count(llamados.idllamado)as cantidad,
			clientes.razonsocial as empresa,
			maquinas.seriemaquina as maquina,
			marcasmaquina.nombremarca as marca,
			llamados.tecnico,concat(usuarios.nombre,' ',usuarios.apellidos) as tecnico
			FROM
			llamados
			INNER JOIN clientes ON clientes.rut = llamados.rut
			INNER JOIN usuarios ON usuarios.rut = llamados.tecnico
			INNER JOIN maquinas ON maquinas.serieinterna = llamados.serieinterna
			INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
			group by clientes.razonsocial,llamados.tecnico,maquinas.seriemaquina,marcasmaquina.nombremarca
			order by usuarios.apellidos,marcasmaquina.nombremarca,maquinas.seriemaquina,clientes.razonsocial,count(llamados.idllamado) desc
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPorTecnico">
    public function listarLlamadosPorTecnico($inicial, $resultados, $buscar, $orden, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("	
			SELECT
			concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
			usuarios.rut AS RUTTecnico,
			llamados.rut AS RutCliente,
			llamados.tipo,
			llamados.otrotipo,
			llamados.coderror,
			llamados.prioridad,
			clientes.razonsocial AS ClienteRazonSocial,
			maquinas.modelo AS ModeloMaquina,
			llamados.serieinterna AS SerieInternaMaquina,
			marcasmaquina.nombremarca AS MarcaMaquina,
			tiposmaquina.tipo AS TipoMaquina,
			date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
			llamados.idfalla,
			llamados.otrafalla,
			Count(llamados.idllamado) AS Cantidad,
			llamados.rut AS RutCliente,
			clientes.razonsocial AS ClienteRazonSocial,
			maquinas.modelo AS ModeloMaquina,
			llamados.serieinterna AS SerieInternaMaquina,
			marcasmaquina.nombremarca AS MarcaMaquina,
			tiposmaquina.tipo AS TipoMaquina
			FROM
			llamados
			INNER JOIN reports ON reports.idreport = llamados.report
			INNER JOIN clientes ON clientes.rut = llamados.rut
			INNER JOIN usuarios ON usuarios.rut = reports.tecnico
			INNER JOIN maquinas ON maquinas.serieinterna = llamados.serieinterna
			INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
			INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
			where usuarios.apellidos LIKE '%" . addslashes($buscar) . "%' 
			$fechas
			GROUP BY
			llamados.rut,
			usuarios.rut,
			llamados.serieinterna
			ORDER by $orden
			LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadLlamadosPorTecnico2">
    public function cantidadLlamadosPorTecnico2($buscar , $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		        select count(*) AS cantidad
				from T_LlamadosPorTecnicoMaquinaCliente				
				WHERE SerieInternaMaquina LIKE '%" . addslashes($buscar) . "%' 
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadLlamadosPorTecnico">
    public function cantidadLlamadosPorTecnico($buscar, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("	
			SELECT
			concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
			usuarios.rut AS RUTTecnico,
			llamados.rut AS RutCliente,
			llamados.tipo,
			llamados.otrotipo,
			llamados.coderror,
			llamados.prioridad,
			clientes.razonsocial AS ClienteRazonSocial,
			maquinas.modelo AS ModeloMaquina,
			llamados.serieinterna AS SerieInternaMaquina,
			marcasmaquina.nombremarca AS MarcaMaquina,
			tiposmaquina.tipo AS TipoMaquina,
			date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
			llamados.idfalla,
			llamados.otrafalla,
			Count(llamados.idllamado) AS Cantidad,
			llamados.rut AS RutCliente,
			clientes.razonsocial AS ClienteRazonSocial,
			maquinas.modelo AS ModeloMaquina,
			llamados.serieinterna AS SerieInternaMaquina,
			marcasmaquina.nombremarca AS MarcaMaquina,
			tiposmaquina.tipo AS TipoMaquina
			FROM
			llamados
			INNER JOIN reports ON reports.idreport = llamados.report
			INNER JOIN clientes ON clientes.rut = llamados.rut
			INNER JOIN usuarios ON usuarios.rut = reports.tecnico
			INNER JOIN maquinas ON maquinas.serieinterna = llamados.serieinterna
			INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
			INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
			where usuarios.apellidos LIKE '%" . addslashes($buscar) . "%' 
			$fechas
			GROUP BY
			llamados.rut,
			usuarios.rut,
			llamados.serieinterna
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPorTecnicoByTecnico">
    public function listarLlamadosPorTecnicoByTecnico($tecnico,$empresa,$maquina)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
			SELECT
			concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
			usuarios.rut AS RUTTecnico,
			llamados.rut AS RutCliente,
			llamados.tipo,
			llamados.otrotipo,
			llamados.coderror,
			llamados.prioridad,
			clientes.razonsocial AS ClienteRazonSocial,
			maquinas.modelo AS ModeloMaquina,
			llamados.serieinterna AS SerieInternaMaquina,
			marcasmaquina.nombremarca AS MarcaMaquina,
			tiposmaquina.tipo AS TipoMaquina,
			date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
			llamados.idfalla,
			fallas.nombrefalla,
			llamados.otrafalla
			FROM
			llamados
			INNER JOIN reports ON reports.idreport = llamados.report
			INNER JOIN clientes ON clientes.rut = llamados.rut
			INNER JOIN usuarios ON usuarios.rut = reports.tecnico
			INNER JOIN maquinas ON maquinas.serieinterna = llamados.serieinterna
			INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
			INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
			INNER JOIN fallas ON fallas.IDfalla = llamados.idfalla
			where 
			usuarios.rut = '$tecnico' AND
			llamados.rut = '$empresa' AND
			llamados.serieinterna = '$maquina'
			order by llamados.fecha
	    ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosTecnicosClientesTOEXCEL">
    public function listarLlamadosTecnicosClientesTOEXCEL($buscar, $orden, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
			SELECT
			usuarios.rut AS RUTTecnico,
			concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
			llamados.rut AS RutCliente,
			clientes.razonsocial AS ClienteRazonSocial,
			date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
			llamados.tipo,
			llamados.otrotipo,
			llamados.idfalla,
			llamados.otrafalla,
			fallas.nombrefalla,
			llamados.coderror,
			llamados.prioridad,
			marcasmaquina.nombremarca AS MarcaMaquina,
			maquinas.modelo AS ModeloMaquina,
			llamados.serieinterna AS SerieInternaMaquina,
			tiposmaquina.tipo AS TipoMaquina
			FROM			
			llamados
			INNER JOIN reports ON reports.idreport = llamados.report
			INNER JOIN clientes ON clientes.rut = llamados.rut
			INNER JOIN usuarios ON usuarios.rut = reports.tecnico
			INNER JOIN maquinas ON maquinas.serieinterna = llamados.serieinterna
			INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
			INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
			INNER JOIN fallas ON fallas.IDfalla = llamados.idfalla
			where usuarios.apellidos LIKE '%" . addslashes($buscar) . "%' 
			$fechas
			ORDER by $orden
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosTecnicosClientesTOEXCEL">
    public function listarLlamadosHistoricosMaquinas($inicial, $resultados, $buscar, $orden, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				maquinas.serieinterna,
				maquinas.modelo,
				marcasmaquina.nombremarca,
				count(*) as Cantidad
				FROM
				llamados
				INNER JOIN maquinas ON maquinas.serieinterna = llamados.serieinterna
				INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
				where
				maquinas.serieinterna LIKE '%" . addslashes($buscar) . "%' 
				$fechas
				GROUP BY 
				maquinas.serieinterna,
				maquinas.modelo,
				marcasmaquina.nombremarca				
				ORDER BY $orden
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadLlamadosHistoricosMaquinas">
    public function cantidadLlamadosHistoricosMaquinas($buscar, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT
				maquinas.serieinterna,
				maquinas.modelo,
				marcasmaquina.nombremarca,
				count(*) as Cantidad
				FROM
				llamados
				INNER JOIN maquinas ON maquinas.serieinterna = llamados.serieinterna
				INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
				where
				maquinas.serieinterna LIKE '%" . addslashes($buscar) . "%' 
				$fechas
				GROUP BY 
				maquinas.serieinterna,
				maquinas.modelo,
				marcasmaquina.nombremarca				
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosHistoricosMaquinasByMaquina">
    public function listarLlamadosHistoricosMaquinasByMaquina($serieInterna)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				maquinas.serieinterna,
				maquinas.modelo,
				marcasmaquina.nombremarca,
				llamados.rut AS RutCliente,
				llamados.tipo,
				llamados.otrotipo,
				llamados.coderror,
				llamados.prioridad,
				date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
				clientes.razonsocial as ClienteRazonSocial,
				llamados.idfalla,
				fallas.nombrefalla,
				llamados.otrafalla
				FROM
				llamados
				INNER JOIN maquinas ON maquinas.serieinterna = llamados.serieinterna
				INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
				INNER JOIN clientes ON clientes.rut = llamados.rut
				INNER JOIN fallas ON fallas.IDfalla = llamados.idfalla
				where
				llamados.serieinterna = '$serieInterna'
				order by llamados.fecha
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosHistoricosClientes">
    public function listarLlamadosHistoricosClientes($inicial, $resultados, $buscar, $orden, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT clientes.*, count(*) total		
				FROM clientes, llamados
				WHERE clientes.rut = llamados.rut and
				(razonsocial LIKE '%" . addslashes($buscar) . "%' OR
				clientes.rut LIKE '%" . addslashes($buscar) . "%')
				$fechas
				GROUP BY clientes.rut
				ORDER BY $orden
				LIMIT $inicial, $resultados
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadLlamadosHistoricosClientes">
    public function cantidadLlamadosHistoricosClientes($buscar, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
				SELECT clientes.*, count(*) total		
				FROM clientes, llamados
				WHERE clientes.rut = llamados.rut and
				(razonsocial LIKE '%" . addslashes($buscar) . "%' OR
				clientes.rut LIKE '%" . addslashes($buscar) . "%')
				$fechas
				GROUP BY clientes.rut
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosHistoricosByCliente">
    public function listarLlamadosHistoricosByCliente($rut)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT date_format(llamados.fecha,'%d/%m/%Y')fechallamado, llamados.*, fallas.nombrefalla, tiposmaquina.tipo tipomaq				
				FROM fallas, llamados, tiposmaquina, maquinas
				WHERE llamados.rut = '$rut' and
				llamados.idfalla = fallas.idfalla and
				llamados.serieinterna = maquinas.serieinterna and
				maquinas.tipomaquina = tiposmaquina.id				
				ORDER BY maquinas.serieinterna,fecha
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosAsignacionPorTecnico">
    public function listarLlamadosAsignacionPorTecnico($inicial, $resultados, $buscar, $orden, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                llamados.serieinterna,
                llamados.tipo,
                llamados.prioridad,
                llamados.pendiente,
                date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
                llamados.razon,
                llamados.tecnicoasignado,
                clientes.razonsocial,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico                
            FROM
                llamados
            Inner Join clientes ON llamados.rut = clientes.rut
            Left Outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
            WHERE llamados.idllamado LIKE '%%' 
			$fechas            
            order by llamados.fecha desc
            LIMIT $inicial, $resultados
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadLlamadosAsignacionPorTecnico">
    public function cantidadLlamadosAsignacionPorTecnico($buscar, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                llamados.serieinterna,
                llamados.tipo,
                llamados.prioridad,
                llamados.pendiente,
                date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
                llamados.razon,
                llamados.tecnicoasignado,
                clientes.razonsocial,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico                
            FROM
                llamados
            Inner Join clientes ON llamados.rut = clientes.rut
            Left Outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
            WHERE llamados.idllamado LIKE '%%' 
			$fechas            
            order by llamados.fecha desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosAsignacionTecnicosClientesTOEXCEL">
    public function listarLlamadosAsignacionTecnicosClientesTOEXCEL($buscar, $orden, $fechas)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                llamados.serieinterna,
                llamados.tipo,
                llamados.prioridad,
                llamados.pendiente,
                date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
                llamados.razon,
                llamados.tecnicoasignado,
                clientes.razonsocial,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico                
            FROM
                llamados
            Inner Join clientes ON llamados.rut = clientes.rut
            Left Outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
            WHERE llamados.idllamado LIKE '%%' 
			$fechas            
            order by llamados.fecha desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosReportsSinLlamado">
    public function listarLlamadosReportsSinLlamado($inicial, $resultados, $buscar, $orden, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                reports.idreport,
                reports.rut as RutCliente,
                reports.serieinterna,
                reports.tecnico,
                date_format(reports.fecha,'%d/%m/%Y') as FechaReport,
                llamados.idllamado,
                llamados.rut,
                date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
                llamados.tecnicoasignado as RutTecnico,
                llamados.tipo,
                llamados.pendiente,
                clientes.rut,
                clientes.razonsocial,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico                
            FROM
                reports
                Left Outer Join llamados ON reports.idreport = llamados.report
                Left Outer Join clientes ON reports.rut = clientes.rut
                Left Outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
            WHERE 
                reports.idreport like '%$idReport%'
                $idllamado
                $fechas 
                $pendiente
            ORDER BY 
                reports.idreport desc
            LIMIT $inicial, $resultados
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadLlamadosReportsSinLlamado">
    public function cantidadLlamadosReportsSinLlamado($buscar, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
            SELECT
                reports.idreport,
                reports.rut as RutCliente,
                reports.serieinterna,
                reports.tecnico,
                date_format(reports.fecha,'%d/%m/%Y') as FechaReport,
                llamados.idllamado,
                llamados.rut,
                date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
                llamados.tecnicoasignado as RutTecnico,
                llamados.tipo,
                llamados.pendiente,
                clientes.rut,
                clientes.razonsocial,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico                
            FROM
                reports
                Left Outer Join llamados ON reports.idreport = llamados.report
                Left Outer Join clientes ON reports.rut = clientes.rut
                Left Outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
            WHERE 
                reports.idreport like '%$idReport%'
                $idllamado
                $fechas 
                $pendiente
            ORDER BY 
                reports.idreport desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosReportsSinLlamadoTOEXCEL">
    public function listarLlamadosReportsSinLlamadoTOEXCEL($buscar, $orden, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                reports.idreport,
                reports.rut as RutCliente,
                reports.serieinterna,
                reports.tecnico,
                date_format(reports.fecha,'%d/%m/%Y') as FechaReport,
                llamados.idllamado,
                llamados.rut,
                date_format(llamados.fecha,'%d/%m/%Y') as FechaLlamado,
                llamados.tecnicoasignado as RutTecnico,
                llamados.tipo,
                llamados.pendiente,
                clientes.rut,
                clientes.razonsocial,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico                
            FROM
                reports
                Left Outer Join llamados ON reports.idreport = llamados.report
                Left Outer Join clientes ON reports.rut = clientes.rut
                Left Outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
            WHERE 
                reports.idreport like '%$idReport%'
                $idllamado
                $fechas 
                $pendiente
            ORDER BY 
                reports.idreport desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosGeneral">
    public function listarLlamadosGeneral($inicial, $resultados, $buscar, $orden, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                clientes.razonsocial,
                clientes.cliente,
                llamados.serieinterna,
                maquinas.modelo,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo,
                llamados.tipo,
                llamados.otrotipo,
                llamados.otrafalla,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
                llamados.coderror,
                llamados.prioridad,
                llamados.pendiente,
                llamados.fecha,
                llamados.razon,
                llamados.nombrecontacto,
                llamados.telefonocontacto,
                usuarios.nombre,
                usuarios.apellidos,
                fallas.nombrefalla,
                llamados.tecnicoasignado as RutTecnico,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
                llamados.tecnicoasignado
            FROM
                llamados
                left outer Join clientes ON llamados.rut = clientes.rut
                left outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
                left outer Join fallas ON llamados.idfalla = fallas.IDfalla
                left outer Join maquinas ON llamados.serieinterna = maquinas.serieinterna
                left outer Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
                left outer Join tiposmaquina ON maquinas.tipomaquina = tiposmaquina.ID
            Where
                llamados.report like '%$idReport%'
                $idllamado
                $fechas 
                $pendiente
            ORDER BY 
                llamados.idllamado desc
            LIMIT $inicial, $resultados
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadLlamadosGeneral">
    public function cantidadLlamadosGeneral($buscar, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                clientes.razonsocial,
                clientes.cliente,
                llamados.serieinterna,
                maquinas.modelo,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo,
                llamados.tipo,
                llamados.otrotipo,
                llamados.otrafalla,
                llamados.coderror,
                llamados.prioridad,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
                llamados.pendiente,
                llamados.fecha,
                llamados.razon,
                llamados.nombrecontacto,
                llamados.telefonocontacto,
                usuarios.nombre,
                usuarios.apellidos,
                fallas.nombrefalla,
                llamados.tecnicoasignado as RutTecnico,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
                llamados.tecnicoasignado
            FROM
                llamados
                left outer Join clientes ON llamados.rut = clientes.rut
                left outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
                left outer Join fallas ON llamados.idfalla = fallas.IDfalla
                left outer Join maquinas ON llamados.serieinterna = maquinas.serieinterna
                left outer Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
                left outer Join tiposmaquina ON maquinas.tipomaquina = tiposmaquina.ID
            WHERE 
                llamados.report like '%$idReport%'
                $idllamado
                $fechas 
                $pendiente
            ORDER BY 
                llamados.idllamado desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosGeneralTOEXCEL">
    public function listarLlamadosGeneralTOEXCEL($buscar, $orden, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                clientes.razonsocial,
                clientes.cliente,
                llamados.serieinterna,
                maquinas.modelo,
                marcasmaquina.nombremarca,
                tiposmaquina.tipo as TipoMaquina,
                llamados.tipo as TipoLlamado,
                llamados.otrotipo,
                llamados.otrafalla,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
                llamados.coderror,
                llamados.prioridad,
                llamados.pendiente,
                llamados.fecha,
                llamados.razon,
                llamados.nombrecontacto,
                llamados.telefonocontacto,
                usuarios.nombre,
                usuarios.apellidos,
                fallas.nombrefalla,
                llamados.tecnicoasignado as RutTecnico,
                concat(usuarios.nombre,' ',usuarios.apellidos) AS NombreTecnico,
                llamados.tecnicoasignado
            FROM
                llamados
            left outer Join clientes ON llamados.rut = clientes.rut
            left outer Join usuarios ON llamados.tecnicoasignado = usuarios.rut
            left outer Join fallas ON llamados.idfalla = fallas.IDfalla
            left outer Join maquinas ON llamados.serieinterna = maquinas.serieinterna
            left outer Join marcasmaquina ON maquinas.marca = marcasmaquina.ID
            left outer Join tiposmaquina ON maquinas.tipomaquina = tiposmaquina.ID
            Where
                llamados.report like '%$idReport%'
                $idllamado
                $fechas 
                $pendiente
            ORDER BY 
                llamados.idllamado desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosEliminados">
    public function listarLlamadosEliminados($inicial, $resultados, $buscar, $orden, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                clientes.razonsocial,
                clientes.cliente,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
		        date_format(llamados.fecha,'%H:%i') AS HoraLlamado,
                llamados.pendiente,
                llamados.fecha,
                llamados.razon
            FROM
                llamados
                left outer Join clientes ON llamados.rut = clientes.rut	
	        WHERE 
		        llamados.eliminado= 'SI'
                $fechas 
            ORDER BY 
                llamados.fecha desc
            LIMIT $inicial, $resultados
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidadLlamadosEliminados">
    public function cantidadLlamadosEliminados($buscar, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = 0;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                clientes.razonsocial,
                clientes.cliente,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
		        date_format(llamados.fecha,'%H:%i') AS HoraLlamado,
                llamados.pendiente,
                llamados.fecha,
                llamados.razon
            FROM
                llamados
                left outer Join clientes ON llamados.rut = clientes.rut	
	        WHERE 
		        llamados.eliminado= 'SI'
                $fechas 
            ORDER BY 
                llamados.fecha desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->NUM_ROWS();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosEliminadosTOEXCEL">
    public function listarLlamadosEliminadosTOEXCEL($buscar, $orden, $fechas, $idReport, $idllamado, $pendiente)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
            SELECT
                llamados.idllamado,
                llamados.report,
                llamados.rut,
                clientes.razonsocial,
                clientes.cliente,
                date_format(llamados.fecha,'%d/%m/%Y') AS FechaLlamado,
		        date_format(llamados.fecha,'%H:%i') AS HoraLlamado,
                llamados.pendiente,
                llamados.fecha,
                llamados.razon
            FROM
                llamados
                left outer Join clientes ON llamados.rut = clientes.rut	
	        WHERE 
		        llamados.eliminado= 'SI'
                $fechas 
            ORDER BY 
                llamados.fecha desc
        ");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

}