<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Cotizacion {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
    function obtenernumero()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT MAX(LAST_INSERT_ID(cotizacion.IDcotizacion)) as numero
				FROM cotizacion
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    function nuevo($numerocotizacion, $fechaCotizacion, $tipoCotizacion, $validez, $nombreContacto, $empresa, $direccion, $ciudad, $correo, $telefono, $idVendedor)
    {
        list( $dia, $mes, $anio) = explode( '-', $fechaCotizacion );
        $fecha2 = "$anio/$mes/$dia";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO cotizacion(
					idCotizacion,
					fechaCotizacion, 
					estado,
					tipoCotizacion,
					validez, 
					nombreContacto, 
					empresa, 
					direccion, 
					ciudad, 
					correo,
					telefono,
					idVendedor,
					stock
				)
				VALUES(
					$numerocotizacion,
					'$fecha2',
					4,
					$tipoCotizacion,
					'$validez', 
					'$nombreContacto', 
					'$empresa', 
					'$direccion', 
					'$ciudad', 
					'$correo', 
					'$telefono',
					'$idVendedor',
					'$stock'
					) 
					");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritems">
    function ingresaritems($idCotizacion, $idPeriodo, $idMaquinaCotizacion, $cantidad, $bnMinimo, $colorMinimo, $scannerMinimo, $bnCosto, $colorCosto, $scannerCosto, $cargoFijo)
    {
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO cotizacionitems(idCotizacion, idPeriodo, idMaquinaCotizacion, cantidad, bnMinimo, colorMinimo, scannerMinimo, bnCosto, colorCosto, scannerCosto, cargoFijo)
				VALUES($idCotizacion, $idPeriodo, $idMaquinaCotizacion, $cantidad, $bnMinimo, $colorMinimo, $scannerMinimo, $bnCosto, $colorCosto, $scannerCosto, $cargoFijo ) 
				");
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritemsinventario">
    function ingresaritemsinventario($idCotizacion, $idInventario, $cantidad, $valorUnitario)
    {
        $sql = 	"
				INSERT INTO cotizacionitemsinventario(idCotizacion, idInventario, cantidad, valorUnitario)
				VALUES($idCotizacion, '$idInventario', $cantidad , $valorUnitario) 
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritemsservicio">
    function ingresaritemsservicio($idCotizacion, $idInventario, $cantidad, $valorUnitario)
    {
        $sql = 	"
				INSERT INTO cotizacionitemsservicio(idCotizacion, idServicio, cantidad, valorUnitario)
				VALUES($idCotizacion, '$idInventario', $cantidad , $valorUnitario) 
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritemsopciones">
    function ingresaritemsopciones($idCotizacion, $idCotizacionItem, $descripcion, $valor, $seleccionado)
    {
        $sql = 	"
				INSERT INTO cotizacionitemsopciones(idCotizacion, idCotizacionItem, descripcion, valor, seleccionado)
				VALUES($idCotizacion, $idCotizacionItem, '$descripcion', $valor, $seleccionado) 
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    function listar($inicial, $resultados, $buscar, $orden, $whereTip, $desde, $hasta)
    {
        $sql = 	"
			SELECT
				cotizacion.idCotizacion,
				cotizacion.fechaCotizacion,
				cotizacion.estado,
				cotizacion.tipocotizacion,
				cotizacion.validez,
				cotizacion.nombreContacto,
				cotizacion.empresa,
				cotizacion.direccion,
				cotizacion.ciudad,
				cotizacion.correo,
				cotizacion.telefono,
				cotizacion.idVendedor,
				cotizaciontipo.descripcion AS descripcionCotizacion,
				upper(cotizacionestado.descripcion) as descripcionEstado,
				concat(usuarios.nombre, ' ', usuarios.apellidos) AS Vendedor				
			FROM
				cotizacion
				Inner Join cotizaciontipo ON cotizacion.tipocotizacion = cotizaciontipo.idTipoCotizacion
				Inner Join cotizacionestado ON cotizacion.estado = cotizacionestado.idEstado
				Inner Join usuarios ON cotizacion.idVendedor = usuarios.rut				
			WHERE 
				cotizacion.idCotizacion LIKE '%" . addslashes($buscar) . "%' AND			
				cotizacion.fechaCotizacion BETWEEN '$desde' AND LAST_DAY('$hasta') 
				$whereTip
			ORDER BY $orden			
			LIMIT $inicial, $resultados";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
    function cantidad($buscar, $whereTip, $desde, $hasta)
    {
        $sql = 	"
			SELECT
				cotizacion.idCotizacion,
				cotizacion.fechaCotizacion,
				cotizacion.estado,
				cotizacion.tipocotizacion,
				cotizacion.validez,
				cotizacion.nombreContacto,
				cotizacion.empresa,
				cotizacion.direccion,
				cotizacion.ciudad,
				cotizacion.correo,
				cotizacion.telefono,
				cotizacion.idVendedor,
				cotizaciontipo.descripcion AS descripcionCotizacion,
				cotizacionestado.descripcion as descripcionEstado
			FROM
				cotizacion
				Inner Join cotizaciontipo ON cotizacion.tipocotizacion = cotizaciontipo.idTipoCotizacion
				Inner Join cotizacionestado ON cotizacion.estado = cotizacionestado.idEstado
			WHERE 
				cotizacion.idCotizacion LIKE '%\" . addslashes($buscar) . \"%' AND			
				cotizacion.fechaCotizacion BETWEEN '$desde' AND LAST_DAY('$hasta') 
				$whereTip
			";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;

        //return $this->controladorBD->fetchNumRows($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosMaquinaPeriodoCostoOpciones">
    function obtenerdatosMaquinaPeriodoCostoOpciones($idperiodo, $idmaquinacotizacion)
    {
        $sql = "
			SELECT
			* 
			FROM cotizacionmaquinasperiodosvaloresopciones
			WHERE 
			cotizacionmaquinasperiodosvaloresopciones.idValor in 
			    (
			    SELECT
				    cotizacionmaquinasperiodosvalores.idValor
			    FROM
				    cotizacionmaquinasperiodosvalores				
				Where 
				    cotizacionmaquinasperiodosvalores.idPeriodo = $idperiodo and
				    cotizacionmaquinasperiodosvalores.idMaquinaCotizacion = $idmaquinacotizacion
                )
		";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosMaquinaPeriodoCostoOpciones">
    function obtenerdatosMaquinaPeriodoCosto($idperiodo, $idmaquinacotizacion)
    {
        $sql = 	"
			SELECT
				cotizacionmaquinasperiodosvalores.bnMinimo,
				cotizacionmaquinasperiodosvalores.colorMinimo,
				cotizacionmaquinasperiodosvalores.scannerMinimo,
				cotizacionmaquinasperiodosvalores.bnCosto,
				cotizacionmaquinasperiodosvalores.colorCosto,
				cotizacionmaquinasperiodosvalores.scannerCosto,
				cotizacionmaquinasperiodosvalores.cargoFijo,
				cotizacionmaquinasperiodosvalores.idPeriodo,
				cotizacionmaquinasperiodosvalores.idMaquinaCotizacion,
				cotizacionmaquinasperiodos.descripcionPeriodo,
				cotizacionmaquinas.modelo,
				cotizacionmaquinas.marca,
				cotizacionmaquinas.formato,
				cotizacionmaquinas.maquinacondiciones,
				tiposmaquina.tipo,
				marcasmaquina.nombremarca,
				cotizacionmaquinas.tipomaquina 
			FROM
				cotizacionmaquinasperiodosvalores
				Inner Join cotizacionmaquinasperiodos ON cotizacionmaquinasperiodosvalores.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
				Inner Join cotizacionmaquinas ON cotizacionmaquinasperiodosvalores.idMaquinaCotizacion = cotizacionmaquinas.idmaquinacotizacion
				Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
				Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
			Where 
				cotizacionmaquinasperiodosvalores.idPeriodo = $idperiodo and
				cotizacionmaquinasperiodosvalores.idMaquinaCotizacion = $idmaquinacotizacion
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetch($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : anios">
    function anios()
    {
        $sql = 	"
				SELECT DISTINCT YEAR(fecha) anio
				FROM oc
				ORDER BY anio 
				";
        return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : aniosDesc">
    function aniosDesc()
    {
        $sql = 	"
				SELECT DISTINCT YEAR(fechaCotizacion) anio
				FROM cotizacion
				ORDER BY anio desc
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosCotizacion">
    function obtenerdatosCotizacion($idcotizacion)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = "			
				SELECT
					cotizacion.idCotizacion,
					cotizacion.fechaCotizacion,
					cotizacion.estado,
					cotizacion.tipocotizacion,
					cotizacion.validez,
					cotizacion.stock,
					cotizacion.nombreContacto,
					cotizacion.empresa,
					cotizacion.direccion,
					cotizacion.ciudad,
					cotizacion.correo,
					cotizacion.telefono,
					cotizacion.idVendedor,
					cotizacion.rutClienteAprobado,
					upper(cotizacionestado.descripcion) as estadocotizacion
				FROM
					cotizacion
					Inner Join cotizacionestado ON cotizacion.estado = cotizacionestado.idEstado
				WHERE cotizacion.idCotizacion = $idcotizacion
		";
        $this->NX_DB->QUERY($sql);

        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetch($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosCotizacionIdItem">
    function obtenerdatosCotizacionIdItem($idcotizacion, $idperiodo, $idmaquinacotizacion)
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $sql = "
				SELECT
	                cotizacionitems.idCotizacionItem as idCotizacionItem
                FROM
                    cotizacionitems
                WHERE
                    cotizacionitems.idCotizacion = $idcotizacion and
                    cotizacionitems.idPeriodo = $idperiodo and
                    cotizacionitems.idMaquinaCotizacion = $idmaquinacotizacion
		";
        $this->NX_DB->QUERY($sql);

       if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerItemsCotizacion">
    function obtenerItemsCotizacion($idcotizacion,$tipocotizacion)
    {
        switch ($tipocotizacion) {
            case 1:   //ARRIENDO MAQUINA
                $sql = 	"
			SELECT
				cotizacion.*,
				cotizacionitems.*,
				cotizacionmaquinasperiodos.*,
				cotizacionmaquinas.*,
				marcasmaquina.*,
				tiposmaquina.*
			FROM
				cotizacion
				Inner Join cotizacionitems ON cotizacion.idCotizacion = cotizacionitems.idCotizacion
				Inner Join cotizacionmaquinasperiodos ON cotizacionitems.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
				Inner Join cotizacionmaquinas ON cotizacionitems.idMaquinaCotizacion = cotizacionmaquinas.idmaquinacotizacion
				Inner Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
				Inner Join tiposmaquina ON cotizacionmaquinas.tipomaquina = tiposmaquina.ID
			WHERE cotizacion.idCotizacion = $idcotizacion 
				";
                break;
            case 2:   //VENTA MAQUINA
                $sql = "
            SELECT
		        cotizacion.*, 
	            cotizacionitemsmaquinaventa.*, 
	            cotizacionmaquinasventas.*, 
    	        marcasmaquina.*, 
	            tiposmaquina.*
            FROM
	            cotizacion
	        INNER JOIN cotizacionitemsmaquinaventa ON cotizacion.idCotizacion = cotizacionitemsmaquinaventa.idCotizacion
	        INNER JOIN cotizacionmaquinasventas ON cotizacionitemsmaquinaventa.idMaquinaCotizacionVentas = cotizacionmaquinasventas.idmaquinacotizacionventas
	        INNER JOIN marcasmaquina ON cotizacionmaquinasventas.marca = marcasmaquina.ID
	        INNER JOIN tiposmaquina ON cotizacionmaquinasventas.tipomaquina = tiposmaquina.ID
		    WHERE cotizacion.idCotizacion = $idcotizacion 
                ";
                break;
            case 3:   //VENTA INSUMOS
                $sql = 	"
					SELECT
						cotizacion.*, 
						cotizacionitemsinventario.*, 
						inventario.*
					FROM
						cotizacion
						INNER JOIN
						cotizacionitemsinventario
						ON 
							cotizacion.idCotizacion = cotizacionitemsinventario.idCotizacion
						INNER JOIN
						inventario
						ON 
							cotizacionitemsinventario.idInventario = inventario.codinterno
					WHERE
						cotizacion.idCotizacion = $idcotizacion 
				";
                break;
            case 4:   //VENTA SERVICIOS CLIENTE
                $sql = 	"
					SELECT
						cotizacion.*, 
						cotizacionitemsservicio.*, 
						servicios.*
					FROM
						cotizacion
						INNER JOIN
						cotizacionitemsservicio
						ON 
							cotizacion.idCotizacion = cotizacionitemsservicio.idCotizacion
						INNER JOIN
						servicios
						ON 
							cotizacionitemsservicio.idServicio = servicios.IDservicio
					WHERE
						cotizacion.idCotizacion = $idcotizacion 
				";
                break;
            case 6:   //VENTA SERVICIOS CLIENTE NUEVO
                $sql = 	"
					SELECT
						cotizacion.*, 
						cotizacionitemsservicio.*, 
						servicios.*
					FROM
						cotizacion
						INNER JOIN
						cotizacionitemsservicio
						ON 
							cotizacion.idCotizacion = cotizacionitemsservicio.idCotizacion
						INNER JOIN
						servicios
						ON 
							cotizacionitemsservicio.idServicio = servicios.IDservicio
					WHERE
						cotizacion.idCotizacion = $idcotizacion 
				";
                break;
        }

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerItemsCotizacionOpciones">
    function obtenerItemsCotizacionOpciones($idCotizacionItem){
        $sql = 	"
					SELECT
						 * 
					FROM
						`cotizacionitemsopciones`
					WHERE
						idCotizacionItem = $idCotizacionItem
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerItemsCotizacionOpcionesporIdCotizacion">
    function obtenerItemsCotizacionOpcionesporIdCotizacion($idCotizacion){
        $sql = 	"
					SELECT
						 * 
					FROM
						`cotizacionitemsopciones`
					WHERE
						idCotizacion = $idCotizacion
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosPeriodos">
    function obtenerDatosPeriodos()
    {
        $sql = 	"
				SELECT
					*
				FROM
					cotizacionmaquinasperiodos
				ORDER BY descripcionPeriodo
				";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
       // return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarCotizacion">
    function actualizarCotizacion($idCotizacion, $valor, $col)
    {
        $sql = 	"
				UPDATE cotizacion
				SET $col = $valor
				WHERE idCotizacion = $idCotizacion
				";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
        //return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarCotizacionMaquinaStockArriendo">
    function actualizarCotizacionMaquinaStockArriendo($idMaquinaCotizacion, $cantidad)
    {
        $sql = 	"
				UPDATE cotizacionmaquinas
				SET stockarriendo = stockarriendo - $cantidad
				WHERE idmaquinacotizacion = $idMaquinaCotizacion
				";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
        //return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarCotizacionCompleta">
    function actualizarCotizacionCompleta($idCotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor)
    {
        list( $dia, $mes, $anio) = explode( '-', $fecha);
        $fecha2 = "$anio/$mes/$dia";
        $sql = 	"
				UPDATE cotizacion
				SET
					fechaCotizacion = '$fecha2', 
					tipoCotizacion = $tipocotizacion,
					validez = '$validez', 
					nombreContacto = '$nombrecontacto', 
					empresa = '$nombreempresa',
					direccion = '$direccion', 
					ciudad = '$ciudad', 
					correo = '$correo', 
					telefono ='$telefono',
					idVendedor = '$idVendedor'  					
				WHERE idCotizacion = $idCotizacion
				";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
        //return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarCotizacionItemCargoFijo">
    function actualizarCotizacionItemCargoFijo($idCotizacionItem, $cargoFijo)
    {
        $sql = 	"
				UPDATE cotizacionitems
				SET
					cargoFijo = $cargoFijo
				WHERE idCotizacionItem = $idCotizacionItem
				";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
        return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarCotizacionItems">
    function eliminarCotizacionItems($idCotizacion,$tipocotizacion)
    {
        switch ($tipocotizacion) {
            case 1:   //ARRIENDO MAQUINA
                $sql = "
				DELETE FROM cotizacionitems
				WHERE idCotizacion = '$idCotizacion'
				";
                break;
            case 2:   //VENTA MAQUINA
                break;
            case 3:   //VENTA INSUMOS
                $sql = "
				DELETE FROM cotizacionitemsinventario
				WHERE idCotizacion = '$idCotizacion'
				";
                break;
            case 4:   //VENTA SERVICIOS
                $sql = "
				DELETE FROM cotizacionitemsservicio
				WHERE idCotizacion = '$idCotizacion'
				";
                break;
            case 6:   //VENTA SERVICIOS
                $sql = "
				DELETE FROM cotizacionitemsservicio
				WHERE idCotizacion = '$idCotizacion'
				";
                break;
        }

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
       // $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarCotizacionItemsOpciones">
    function eliminarCotizacionItemsOpciones($idCotizacion)
    {
        $sql = "
				DELETE FROM cotizacionitemsopciones
				WHERE idCotizacion = '$idCotizacion'
				";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
        //return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarEXCEL">
    function listarEXCEL($buscar, $orden, $whereTip, $desde, $hasta)
    {
        $sql = 	"
			SELECT
				cotizacion.idCotizacion,
				cotizacion.fechaCotizacion,
				cotizacion.estado,
				cotizacion.tipocotizacion,
				cotizacion.validez,
				cotizacion.nombreContacto,
				cotizacion.empresa,
				cotizacion.direccion,
				cotizacion.ciudad,
				cotizacion.correo,
				cotizacion.telefono,
				cotizacion.idVendedor,
				cotizacion.rutClienteAprobado,
				cotizaciontipo.descripcion AS descripcionCotizacion,
				upper(cotizacionestado.descripcion) as descripcionEstado,
				concat(usuarios.nombre, ' ', usuarios.apellidos) AS Vendedor		
			FROM
				cotizacion
				Inner Join cotizaciontipo ON cotizacion.tipocotizacion = cotizaciontipo.idTipoCotizacion
				Inner Join cotizacionestado ON cotizacion.estado = cotizacionestado.idEstado
				Inner Join usuarios ON cotizacion.idVendedor = usuarios.rut				
			WHERE 
				cotizacion.idCotizacion LIKE '%" . addslashes($buscar) . "%' AND			
				cotizacion.fechaCotizacion BETWEEN '$desde' AND LAST_DAY('$hasta') 
				$whereTip
			ORDER BY $orden ";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarEXCELDETALLE">
    function listarEXCELDETALLE($buscar, $orden, $whereTip, $desde, $hasta)
    {
        $sql = 	"
				SELECT
					cotizacion.idCotizacion,
					cotizacion.fechaCotizacion,
					cotizacion.estado,
					cotizacion.tipocotizacion,
					cotizacion.validez,
					cotizacion.nombreContacto,
					cotizacion.empresa,
					cotizacion.direccion,
					cotizacion.ciudad,
					cotizacion.correo,
					cotizacion.telefono,
					cotizacion.idVendedor,
					cotizacion.rutClienteAprobado,
					concat(usuarios.nombre, ' ', usuarios.apellidos) AS Vendedor	,		
					cotizacionitems.idCotizacionItem,
					cotizacionitems.idPeriodo,
					cotizacionitems.idMaquinaCotizacion,
					cotizacionitems.cantidad,
					cotizacionitems.bnMinimo,
					cotizacionitems.colorMinimo,
					cotizacionitems.scannerMinimo,					
					cotizacionitems.bnCosto,
					cotizacionitems.colorCosto,
					cotizacionitems.scannerCosto,
					cotizacionitems.cargoFijo,
					cotizacionmaquinasperiodos.descripcionPeriodo,
					cotizacionmaquinas.tipomaquina,
					cotizacionmaquinas.marca,
					cotizacionmaquinas.modelo,
					cotizacionmaquinas.formato,
					cotizacionmaquinas.conectividad,
					cotizacionmaquinas.activo,
					cotizacionmaquinas.precioarriendo,
					cotizacionmaquinas.precioventa,
					cotizacionmaquinas.maquinacondiciones,
					marcasmaquina.nombremarca,
					cotizaciontipo.descripcion AS descripcionCotizacion,
					upper(cotizacionestado.descripcion) as descripcionEstado
				FROM
					cotizacion
					Left Outer Join cotizacionitems ON cotizacion.idCotizacion = cotizacionitems.idCotizacion
					Left Outer Join cotizacionmaquinasperiodos ON cotizacionitems.idPeriodo = cotizacionmaquinasperiodos.idPeriodo
					Left Outer Join cotizacionmaquinas ON cotizacionitems.idMaquinaCotizacion = cotizacionmaquinas.idmaquinacotizacion
					Left Outer Join marcasmaquina ON cotizacionmaquinas.marca = marcasmaquina.ID
					Left Outer Join cotizacionestado ON cotizacion.estado = cotizacionestado.idEstado
					Left Outer Join cotizaciontipo ON cotizacion.tipocotizacion = cotizaciontipo.idTipoCotizacion
					Left Outer Join usuarios ON cotizacion.idVendedor = usuarios.rut
				WHERE
					cotizacion.idCotizacion LIKE '%" . addslashes($buscar) . "%' AND			
					cotizacion.fechaCotizacion BETWEEN '$desde' AND LAST_DAY('$hasta') 
					$whereTip
				ORDER BY $orden ";

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoPeriodoCotizacion">
    function nuevoPeriodoCotizacion($nuevoperiodo)
    {
        $sql = 	"
				insert into cotizacionmaquinasperiodos(descripcionPeriodo)
				values ('$nuevoperiodo')
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
       // return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritemsmaquinaventa">
    function ingresaritemsmaquinaventa($idCotizacion, $idMaquinaCotizacionVenta, $cantidad, $precioVenta)
    {
        $sql = 	"
				INSERT INTO cotizacionitemsmaquinaventa(idCotizacion, idMaquinaCotizacionVentas, cantidad, precioVenta)
				VALUES($idCotizacion, $idMaquinaCotizacionVenta, $cantidad, $precioVenta ) 
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
        //return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritemsnuevoservicioventa">
    function ingresaritemsnuevoservicioventa($idCotizacion, $detalle, $cantidad, $precioVenta)
    {
        $sql = 	"
				INSERT INTO cotizacionitemsnuevoservicioventa(idCotizacion, detalle, cantidad, precioVenta)
				VALUES($idCotizacion, '$detalle', $cantidad, $precioVenta ) 
				";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY($sql);
        $this->NX_DB->DESCONECTAR();
        return true;
        //return $this->controladorBD->query($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerItemsNuevoServicioVenta">
    function obtenerItemsNuevoServicioVenta($idCotizacion){
        $sql = 	"
					SELECT
						 * 
					FROM
						`cotizacionitemsnuevoservicioventa`
					WHERE
						idCotizacion = $idCotizacion
				";
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerValorServicioInstalacion">
    function obtenerValorServicioInstalacion(){
        $sql = 	"
					SELECT
						 * 
					FROM					
					    cotizacionlugarinstalacion
                    ORDER BY idLugarInstalacion
				";
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY($sql);
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
        //return $this->controladorBD->fetchAll($sql);
    }
    //</editor-fold>
}