<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Contadores {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($rut, $serieInterna, $correlativo, $instalacion, $fechaFacturacion, $contador, $copiaErrores, $diferencia,$copiasFacturadas, $fechaCaptura, $tipoCaptura, $firma, $idReport, $tipoServicioMaquina)
	{
		list( $dia, $mes, $anio) = explode( '-', $fechaFacturacion );
		$fechaF = "$anio/$mes/$dia"; 
		list( $dia, $mes, $anio) = explode( '-', $fechaCaptura );
		$fechaC = "$anio/$mes/$dia";
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    INSERT INTO 
		        contadores (rutcliente, serieintmaquina, correlativo, instalacion, fechafacturacion, contador, diferencia, copiaerrores, copiasfacturadas, fechacaptura, tipocaptura, firma, idreport, idTipoServicioMaquina)
			VALUES 
			    ('$rut', '$serieInterna', '$correlativo', '$instalacion', '$fechaF', $contador, $diferencia, $copiaErrores, $copiasFacturadas, '$fechaC', '$tipoCaptura', {$firma}, {$idReport},$tipoServicioMaquina);
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarByFechas">
	public function listarByFechas($rut, $serieinterna, $correlativo, $desde, $hasta,$tipoServicioMaquina)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT MONTH(fechafacturacion) mes, YEAR(fechafacturacion) anio, DATE_FORMAT(fechacaptura, '%d/%m/%Y') fecha, 
				       contador, copiasfacturadas, copiaerrores, fechacaptura, diferencia, instalacion, firma, idreport
				FROM contadores
				WHERE rutcliente = '$rut'
				AND idTipoServicioMaquina = '$tipoServicioMaquina'
				AND serieintmaquina = '$serieinterna'
				AND correlativo = '$correlativo'
				AND fechafacturacion BETWEEN '$desde' AND LAST_DAY('$hasta')
				ORDER BY contador ASC;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : anios">
	public function anios($rut, $serieinterna)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT DISTINCT YEAR(fechafacturacion) anio
				FROM contadores
				WHERE rutcliente = '$rut'
				AND serieintmaquina = '$serieinterna'
				ORDER BY anio 
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ultimoContador">
	public function ultimoContador($rut, $serieinterna,$tipoServicioMaquina)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT MAX(contador) AS contador
				FROM contadores
				WHERE rutcliente = '$rut'
				AND serieintmaquina = '$serieinterna'
				AND idTipoServicioMaquina = '$tipoServicioMaquina'
				AND correlativo >= (SELECT MAX(correlativo)
									FROM contadores
									WHERE rutcliente = '$rut'
									AND idTipoServicioMaquina = '$tipoServicioMaquina'
									AND serieintmaquina = '$serieinterna')
				AND fechafacturacion >= (SELECT MAX(fechafacturacion) 
										FROM contadores 
										WHERE rutcliente = '$rut'
										AND idTipoServicioMaquina = '$tipoServicioMaquina'
										AND serieintmaquina = '$serieinterna')
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ultimaFechaFacturacion">
	public function ultimaFechaFacturacion($rut, $serieinterna, $tipoServicioMaquina)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT fechafacturacion
				FROM contadores
				WHERE rutcliente = '$rut'
				AND idTipoServicioMaquina = '$tipoServicioMaquina'
				AND serieintmaquina = '$serieinterna'
				AND correlativo >= (SELECT MAX(correlativo)
									FROM contadores
									WHERE rutcliente = '$rut'
									AND serieintmaquina = '$serieinterna')
				AND fechafacturacion >= (SELECT MAX(fechafacturacion) 
										FROM contadores 
										WHERE rutcliente = '$rut'
										AND serieintmaquina = '$serieinterna');
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
	public function seleccionar($rut)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		    SELECT 
		        *
			FROM 
			    contadores
			WHERE 
			    idfactura IS NULL AND 
			    rutcliente =  '$rut';
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerMinCostCopia">
	public function obtenerMinCostCopia($rut, $tipoServicioMaquina, $serieIntMaquina)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT *
				FROM copiascliente
				WHERE rutcliente =  '$rut'
				and idTipoServicioMaquina = $tipoServicioMaquina
				and serieintmaquina = '$serieIntMaquina'
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarMinCostCopia">
	public function actualizarMinCostCopia($rut, $costocopia, $minimocopia, $costofijo, $tipoServicioMaquina, $serieIntMaquina)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT count(*) AS cantidad
				FROM copiascliente
				WHERE rutcliente =  '$rut'
				and idTipoServicioMaquina = $tipoServicioMaquina
				and serieintmaquina = '$serieIntMaquina';
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        $this->NX_DB->CONECTAR();
		if (isset($RESPONSE) && $RESPONSE["cantidad"] == 1)
		{
            $this->NX_DB->QUERY("
			    UPDATE copiascliente
				SET costocopia = $costocopia, minimocopia = $minimocopia, costofijo = $costofijo
				WHERE rutcliente = '$rut'
				and idTipoServicioMaquina = $tipoServicioMaquina
				and serieintmaquina = '$serieIntMaquina'
			");
		}
		else
		{
            $this->NX_DB->QUERY("
				INSERT INTO 
				    copiascliente (costocopia,minimocopia,costofijo,rutcliente,idTipoServicioMaquina,serieintmaquina)
				VALUES 
				    ($costocopia, $minimocopia, $costofijo, '$rut', $tipoServicioMaquina,'$serieIntMaquina');
			");
		}
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : grabarFactura">
	public function grabarFactura($rut, $mes, $anio, $numerofactura)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
			UPDATE contadores	
			SET idfactura = $numerofactura
			WHERE rutcliente = '$rut'
			and year(contadores.fechafacturacion) = '$anio'
			and month(contadores.fechafacturacion) = '$mes'			
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : grabarFacturaArriendo">
	public function grabarFacturaArriendo($rut, $mes, $anio, $numerofactura, $serieIntMaquina, $idTipoServicioMaquina)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
		    UPDATE 
		        contadores	
			SET
			    idfactura = $numerofactura
			WHERE 
			    rutcliente = '$rut' AND
			    year(contadores.fechafacturacion) = '$anio' AND
                month(contadores.fechafacturacion) = '$mes'	AND
			    contadores.idTipoServicioMaquina =$idTipoServicioMaquina AND
			    contadores.serieintmaquina ='$serieIntMaquina';
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : glosaTipoServicioMaquina">
	public function glosaTipoServicioMaquina($tipoServicioMaquina)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT nombreTipoServicio
				FROM tiposerviciomaquina
				WHERE idTipoServicio = $tipoServicioMaquina
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

}