<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class CompraDirecta {

	//<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	private $NX_DB;
	private $NX_CONFIG;
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
		$this->NX_CONFIG = $NX_CONFIG;
		$this->NX_DB = new NX_MYSQL(
			$this->NX_CONFIG["DB_HOST"],
			$this->NX_CONFIG["DB_PORT"],
			$this->NX_CONFIG["DB_USER"],
			$this->NX_CONFIG["DB_PASS"],
			$this->NX_CONFIG["DB_NAME"],
			$this->NX_CONFIG["DB_CHARSET"]
		);
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenernumero">
	public function obtenernumero()
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = 0;
		$this->NX_DB->QUERY("
			SELECT 
				MAX(LAST_INSERT_ID(cd.IDcd)) AS numero
			FROM 
			    cd
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo($numerocd, $rutp, $razon, $nombre, $fecha, $sumatotal)
	{	//Estado: 2: Pendiente total (producto + factura) / 1: Pendiente factura / 0: Recibida sin problemas
		list( $dia, $mes, $anio) = explode( '-', $fecha );
		$fecha2 = "$anio/$mes/$dia";
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
			INSERT INTO 
			    cd (IDcd, rutp, razonsocial, nombre, fecha, total)
			VALUES ($numerocd, '$rutp', '$razon', '$nombre', '$fecha2', $sumatotal); 
		");
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : ingresaritems">
	public function ingresaritems($numerocd, $id, $cant, $precio,$tipo)
	{
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
			INSERT INTO 
				cditems (IDcd, IDproducto, cantidad, precio, tipo)
			VALUES ($numerocd, '$id', $cant, $precio, $tipo); 
		");
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : ingresarMaqServ">
	public function ingresarMaqServ($numerocd, $id, $cant, $precio, $tipo, $descripcion)
	{
		$this->NX_DB->CONECTAR();
		$this->NX_DB->QUERY("
			INSERT INTO 
				cditems (IDcd, IDproducto, cantidad, precio, tipo, descripcion)
			VALUES ($numerocd, '$id', $cant, $precio, $tipo, '$descripcion'); 
		");
		$this->NX_DB->DESCONECTAR();
		return true;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : anios">
	public function anios()
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
			SELECT DISTINCT YEAR(fecha) anio
			FROM cd
			ORDER BY anio;
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $orden, $desde, $hasta)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
			SELECT 
				*
			FROM 
				cd
			WHERE 
				rutp LIKE '%" . addslashes($buscar) . "%' AND
				fecha BETWEEN '$desde' AND LAST_DAY('$hasta')
			ORDER BY $orden; 
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $desde, $hasta)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = 0;
		$this->NX_DB->QUERY("
			SELECT 
				count(*) AS cantidad
			FROM 
			    cd
			WHERE 
			    rutp LIKE '%" . addslashes($buscar) . "%'  AND
				fecha BETWEEN '$desde' AND LAST_DAY('$hasta');
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerdatosCD">
	public function obtenerdatosCD($idcd)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
			SELECT 
			    *
			FROM 
			    cd
			WHERE 
			    cd.IDcd = $idcd;
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			$RESPONSE = $this->NX_DB->FETCH_ARRAY();
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerItemsInventarioCD">
	public function obtenerItemsInventarioCD($idcd)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT cditems.*, inventario.*, categorias.nombrecategoria, marcasmaquina.nombremarca
				FROM cditems, inventario, categorias, marcasmaquina
				WHERE cditems.IDcd = $idcd AND
				inventario.marca = marcasmaquina.ID AND
				cditems.IDproducto = inventario.ID AND
				inventario.categoria = categorias.IDcategoria;
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

	//<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function obtenerItemsMaqServCD($idcd)
	{
		$this->NX_DB->CONECTAR();
		$RESPONSE = null;
		$this->NX_DB->QUERY("
				SELECT cditems.*
				FROM cditems
				WHERE cditems.IDcd = $idcd AND
				cditems.IDproducto = 'ESPECIAL';
		");
		if($this->NX_DB->NUM_ROWS() > 0){
			while($_ROW = $this->NX_DB->FETCH_ARRAY()){
				$RESPONSE[] = $_ROW;
			}
		}
		$this->NX_DB->DESCONECTAR();
		return $RESPONSE;
	}
	//</editor-fold>

}