<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("ControladorBD.php");
//</editor-fold>

class Boletas {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerUltimaBoleta">
    public function obtenerUltimaBoleta()
    {
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT max(idBoleta)+1 as UltimaBoleta
				FROM
				boletas
				");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY()["UltimaBoleta"];
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : cantidad">
	public function cantidad($buscar, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT count(*) AS cantidad
				FROM boletas
				Inner Join clientes ON boletas.rutCliente = clientes.rut
				WHERE 
				clientes.razonsocial LIKE '%" . addslashes($buscar) . "%'
				$fechas	
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar($inicial, $resultados, $buscar, $fechas)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				boletas.idBoleta,
				boletas.fechaBoleta,
				boletas.rutCliente,
				(select sum(cantidad * precio) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) as NETO,
				(select sum(round((cantidad * precio)*0.19,0)) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) AS IVA ,
				(select sum(round((cantidad * precio)*1.19,0)) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) AS TOTAL,
				clientes.*
				FROM
				boletas
				left outer JOIN clientes ON clientes.rut = boletas.rutCliente
				WHERE 
				clientes.razonsocial LIKE '%" . addslashes($buscar) . "%'
				$fechas						
				order by idBoleta
				LIMIT $inicial, $resultados;			
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarTOEXCEL">
	public function listarTOEXCEL($buscar, $fechas, $ordenStr)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				boletas.idBoleta,
				boletas.fechaBoleta,
				boletas.rutCliente,
				(select sum(cantidad * precio) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) as NETO,
				(select sum(round((cantidad * precio)*0.19,0)) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) AS IVA ,
				(select sum(round((cantidad * precio)*1.19,0)) from facturaitems where facturaitems.IDfactura = boletas.idBoleta) AS TOTAL,
				clientes.*
				FROM
				boletas
				left outer JOIN clientes ON clientes.rut = boletas.rutCliente
				order by idBoleta;
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosBoleta">
	public function obtenerDatosBoleta($idBoleta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				boletas.*,
				clientes.*
				FROM
				boletas
				left outer JOIN clientes ON clientes.rut = boletas.rutCliente
				where idBoleta = $idBoleta
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosDetalleBoletaVenta">
	public function obtenerDatosDetalleBoletaVenta($idBoleta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		    SELECT 
		        * 
		    FROM 
		        facturaitems
			WHERE 
			    IDBoleta = $idBoleta
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosDetalleBoletaCentroCopiado">
	public function obtenerDatosDetalleBoletaCentroCopiado($idBoleta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT 
				    * 
				FROM 
				    ot
				WHERE 
				    idfactura = $idBoleta
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosDetalleBoletaArriendo">
	public function obtenerDatosDetalleBoletaArriendo($idBoleta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
		    SELECT 
			    * 
			FROM 
				contadores
			WHERE 
				idfactura = $idBoleta
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosDetalleBoletaArriendoItem">
	public function obtenerDatosDetalleBoletaArriendoItem($idBoleta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("		
				SELECT
				facturaitems.IDfacturaitem,
				facturaitems.IDfactura,
				facturaitems.descripcion,
				concat(facturaitems.descripcion,' - ',facturaitems.IDinventario,' - ',clientedepartamentos.nombreDepartamentoCliente, ' - CC',centrocosto.idCentroCosto) as descripcionDetalle,
				facturaitems.cantidad,
				facturaitems.precio,
				facturaitems.IDinventario,
				facturaitems.IDdepartamentoCliente,
				facturaitems.IDcentroCosto,
				centrocosto.nombreCentroCosto,
				clientedepartamentos.nombreDepartamentoCliente,
				clientedepartamentos.estado
				FROM
				facturaitems
				Inner Join centrocosto ON facturaitems.IDcentroCosto = centrocosto.idCentroCosto
				Inner Join clientedepartamentos ON facturaitems.IDdepartamentoCliente = clientedepartamentos.idDepartamentoCliente
				where facturaitems.IDfactura = (
					select distinct idfactura from contadores
					where idfactura = $idBoleta);					
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoVentaGeneral">
	public function nuevoVentaGeneral ($idBoleta, $fechaBoleta, $rutCliente, $idCentroCosto)
	{		
		$dia = substr($fechaBoleta, 0, 2);    // returns "f"
		$mes = substr($fechaBoleta, 3, 2);    // returns "ef"
		$anio = substr($fechaBoleta, 6, 4); // returns "d"
		
		$fecha2 = "$anio/$mes/$dia";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO boletas (idBoleta, fechaBoleta, rutCliente, idCentroCosto)
				VALUES('$idBoleta', '$fecha2', '$rutCliente', '$idCentroCosto' ); 				
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoArriendo">
	public function nuevoArriendo($idBoleta, $fechaBoleta, $rutCliente, $formaPago, $referencia)
	{		
		$dia = substr($fechaBoleta, 0, 2);    // returns "f"
		$mes = substr($fechaBoleta, 3, 2);    // returns "ef"
		$anio = substr($fechaBoleta, 6, 4); // returns "d"
		
		$fecha2 = "$anio/$mes/$dia";

        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO boletas(idBoleta, fechaBoleta, rutCliente, formaPago, referencia)
				VALUES('$idBoleta', '$fecha2', '$rutCliente', '$formaPago', '$referencia' ) 				
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoItemVentaGeneral">
	public function nuevoItemVentaGeneral ($idBoleta, $descripcion, $cantidad, $precio)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO boletaitems(IDboleta, descripcion, cantidad, precio)
				VALUES('$idBoleta', '$descripcion', '$cantidad', '$precio') 				
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoItemVentaInventario">
	public function nuevoItemVentaInventario ($idBoleta, $descripcion, $cantidad, $precio, $idInventario)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO boletaitems(IDboleta, descripcion, cantidad, precio, IDinventario)
				VALUES('$idBoleta', '$descripcion', '$cantidad', '$precio', '$idInventario') 				
	    ");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoItemArriendo">
	public function nuevoItemArriendo ($idBoleta, $descripcion, $cantidad, $precio, $idInventario, $idDepartamentoCliente, $idCentroCosto)
	{
        $this->NX_DB->CONECTAR();
        $this->NX_DB->QUERY("
				INSERT INTO facturaitems(IDfactura, descripcion, cantidad, precio, IDinventario, IDdepartamentoCliente, IDcentroCosto)
				VALUES('$idBoleta', '$descripcion', '$cantidad', '$precio', '$idInventario', '$idDepartamentoCliente', '$idCentroCosto') 				
		");
        $this->NX_DB->DESCONECTAR();
        return true;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosBoletaTOEXCEL">
	public function obtenerDatosBoletaTOEXCEL($idBoleta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				boletas.*,
				clientes.*
				FROM
				boletas
				left outer JOIN clientes ON clientes.rut = boletas.rutCliente
				where idBoleta = $idBoleta
		");
        while($_ROW = $this->NX_DB->FETCH_ARRAY()){
            $RESPONSE[] = $_ROW;
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : obtenerDatosBoletaDetalleItemTOEXCEL">
	public function obtenerDatosBoletaDetalleItemTOEXCEL($idBoleta)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT
				facturaitems.cantidad,
				concat(descripcion,' ',ifnull(IDinventario,''), ' ',if(facturaitems.IDdepartamentocliente=0,'',concat('- ',clientedepartamentos.nombreDepartamentoCliente)),' ',IF(idcentrocosto=0,'',concat('- CC',idcentrocosto))) AS descripcion,
				facturaitems.precio AS precioUnitario,
				precio*cantidad AS precioTotal
				FROM
				facturaitems
				Left Outer Join clientedepartamentos ON facturaitems.IDdepartamentoCliente = clientedepartamentos.idDepartamentoCliente
				where idBoleta = $idBoleta
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}
    //</editor-fold>

}