<?php
require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/OrdenTrabajo.php');

$ot = new OrdenTrabajo($_CONF);

$idot = $_GET['idot'];

$datosFactura = $ot->obtenerClienteOT($idot);

$listaVentas = $ot->obtenerDatosDetalleOTVenta($idot);

$rutEmisor = '77192083-9';
$rutReceptor = $datosFactura["rutcliente"];

$totalNeto = 0;
$indice = 1;
foreach($listaVentas as $d)
{
    $cantidad =  $d["cantidad"];
    $precio = $d["precio"];
    $montoItem = $cantidad * $precio;
    $totalNeto = $totalNeto + $montoItem;
}

$ivatotal = round($totalNeto * 0.19,0);

$dteML_code = array();
$dteML_code['response'][0] = 'PDF';
$dteML_code['response'][1] = 'FOLIO' ;
$dteML_code['response'][2] = '80MM' ;

//codigo 39 para BOLETAS - codigo 33 para FACTURAS
$dteML_code['dte']['Encabezado']['IdDoc']['TipoDTE'] = 39;
$dteML_code['dte']['Encabezado']['IdDoc']['Folio'] = 0;
$dteML_code['dte']['Encabezado']['IdDoc']['FchEmis'] = Date("Y-m-d");
$dteML_code['dte']['Encabezado']['IdDoc']['IndServicio'] = '3';
$dteML_code['dte']['Encabezado']['IdDoc']['IndMntNeto'] = 2;

$dteML_code['dte']['Encabezado']['Emisor']['RUTEmisor']=$rutEmisor;
$dteML_code['dte']['Encabezado']['Emisor']['RznSoc']='SERVICIOS DIGITALES SPA';
$dteML_code['dte']['Encabezado']['Emisor']['GiroEmis']= 'VENTA AL POR MENOR POR CORREO, POR INTERNET Y VIA TELEFONICA';
$dteML_code['dte']['Encabezado']['Emisor']['Acteco']= '620200';
$dteML_code['dte']['Encabezado']['Emisor']['DirOrigen']= 'GALLEGUILLOS LORCA 1474';
$dteML_code['dte']['Encabezado']['Emisor']['CmnaOrigen']= 'Antofagasta';
$dteML_code['dte']['Encabezado']['Emisor']['Telefono']= '552635455';
$dteML_code['dte']['Encabezado']['Emisor']['CdgSIISucur']= '81303347';

$dteML_code['dte']['Encabezado']['Receptor']['RUTRecep'] = $datosFactura['rutcliente'].'-'.$datosFactura['dv'];
$dteML_code['dte']['Encabezado']['Receptor']['RznSocRecep'] = $datosFactura['razonsocial'];
$dteML_code['dte']['Encabezado']['Receptor']['GiroRecep'] = $datosFactura['giro'];
$dteML_code['dte']['Encabezado']['Receptor']['DirRecep'] = $datosFactura['direccion'];
$dteML_code['dte']['Encabezado']['Receptor']['CmnaRecep'] = $datosFactura['ciudad'];

$dteML_code['dte']['Encabezado']['Totales']['MntNeto'] = $totalNeto;
$dteML_code['dte']['Encabezado']['Totales']['TasaIVA'] = '19';
$dteML_code['dte']['Encabezado']['Totales']['IVA'] = $ivatotal;
$dteML_code['dte']['Encabezado']['Totales']['MntTotal'] = $totalNeto + $ivatotal;

$indice = 1;
foreach($listaVentas as $d)
{
    $descripcionItem = $d['descripcion'];
    $cantidad = $d["cantidad"];
    //$precio = round($d["precio"] * 1.19, 0);
    $precio = $d["precio"];
    $montoItem = $cantidad * $precio;

    $dteML_code['dte']['Detalle'][$indice-1]['NroLinDet'] = $indice;
    $dteML_code['dte']['Detalle'][$indice-1]['NmbItem'] = $descripcionItem;
    $dteML_code['dte']['Detalle'][$indice-1]['QtyItem'] = $cantidad;
    $dteML_code['dte']['Detalle'][$indice-1]['PrcItem'] = $precio;
    $dteML_code['dte']['Detalle'][$indice-1]['MontoItem'] = $montoItem;
    $indice +=1;
}

$dteML_code['custom']['informationNote'] = "IdOT: " . $idot;
$dteML_code['custom']['paymentNote'] = 'EFECTIVO';

$myJSON = json_encode($dteML_code);

$nombreArchivo = "boleta_ot_".$idot.".json";
$rutaArchivo = "../tempJSON/".$nombreArchivo;

$archivo = fopen($rutaArchivo,"w+b");
if( $archivo == false ) {
    echo "Error al crear el archivo";
}
else
{
    // Escribir en el archivo:
    fwrite($archivo, $myJSON);
    // Fuerza a que se escriban los datos pendientes en el buffer:
    fflush($archivo);
}
//Cerrar el archivo:
fclose($archivo);

// Establecer los encabezados para forzar la descarga
header('Content-Type: application/octet-stream');
header('Content-Disposition: attachment; filename="' . $nombreArchivo . '"');
header('Cache-Control: max-age=0');

// Imprimir el contenido del archivo
echo $myJSON;
?>