<?php

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Inventario.php');

//Obtención de datos

$inventario = new Inventario($_CONF);

$pagina 		= 1;
$resultados 	= 20;
$buscar 		= $_GET['buscar'] ?? null;
$orden 			= $_GET['orden'] ?? null;
$categoria 		= $_GET['categoria'] ?? null;
$tipo			= $_GET['tipo'] ?? null;
$nombre			= $_GET['nombre'] ?? null;

if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
    $pagina = $_GET['pagina'];
}
switch($orden)
{
	default:
		$ordenStr = 'modelo';
		$orden = 1;
		break;
	case 2:
		$ordenStr = 'modelo DESC';
		break;
	case 3:
		$ordenStr = 'nombremarca';
		break;
	case 4:
		$ordenStr = 'nombremarca DESC';
		break;
	case 5:
		$ordenStr = 'nombrecategoria';
		break;
	case 6:
		$ordenStr = 'nombrecategoria DESC';
		break;	
	case 7:
		$ordenStr = 'contreal';
		break;
	case 8:
		$ordenStr = 'contreal DESC';
		break;
}
		
switch($categoria)
{
	default:
		$whereCat = 'AND categoria='.$categoria;
		break;
	case 0:
		$whereCat = '';
		break;			
}
		
switch($tipo)
{
	default:
		$whereTip = '';
		break;
	case 1: //Insumos
		$whereTip = "AND tipo='Insumo'";
		break;	
	case 2: //Repuestos
		$whereTip = "AND tipo='Repuesto'";
		break;			
}


if($nombre=="stockminimo")
{
	$cantidad = $inventario->cantidadminima($buscar, $whereCat, $whereTip);
	$lista = $inventario->stockminimo($resultados * ($pagina-1), $resultados, $buscar, $ordenStr, $whereCat, $whereTip);
	$titulo = "STOCK MÍNIMO";
}

if($nombre=="stockcritico")
{
	$cantidad = $inventario->cantidadcritica($buscar, $whereCat, $whereTip);
	$lista = $inventario->stockcritico($resultados * ($pagina-1), $resultados, $buscar, $ordenStr, $whereCat, $whereTip);
	$titulo = "STOCK CRÍTICO";
}
		

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Lista Inventario")
							 ->setSubject("")
							 ->setDescription("Lista Inventario")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:J2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', $titulo);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Cod. Interno');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Categoría');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Marca');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Modelo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, "Stock Teórico");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Stock Real');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Stock Mínimo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Stock Crítico');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Cantidad a Comprar');
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);

if(count($lista)>0)
{
	$c=0;$f=4;
	foreach($lista as $i)
	{
		//echo $i["ID"];
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $i["codinterno"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["tipo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["nombrecategoria"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["nombremarca"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, iconv ("ISO-8859-1", "UTF-8", $i["modelo"]));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["contteorico"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["contreal"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["stockminimo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["stockcritico"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["cantidadacomprar"]);
		$c=0;$f++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Inventario');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaInventario.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');