<?php
/** Error reporting */
//error_reporting(E_ALL);

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
include '../modelos/ControladorBD.php';
//require('../modelos/Inventario.php');
//include ('../modelos/Inventario.php');
//Por error en la carga de Include que aun es desconocida la causa
//se incorpora directamente la Clase Inventario a este mismo archivo
//Tener precaución de actualizar tanto la clase dentro de MODELOS
//como esta clase 
class Inventario 
{
    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    private $NX_DB;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_DB = new NX_MYSQL(
            $this->NX_CONFIG["DB_HOST"],
            $this->NX_CONFIG["DB_PORT"],
            $this->NX_CONFIG["DB_USER"],
            $this->NX_CONFIG["DB_PASS"],
            $this->NX_CONFIG["DB_NAME"],
            $this->NX_CONFIG["DB_CHARSET"]
        );
    }
    //</editor-fold>

    public function cantidadCambioRepuesto($buscar, $whereCat, $whereTip, $whereCant)
	{
        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
				SELECT COUNT(*)
				FROM T_RepuestosUsadosPorMaquina				
				WHERE
				RepuestoCodigoInterno LIKE '%" . addslashes($buscar) . "%' 
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            $RESPONSE = $this->NX_DB->FETCH_ARRAY();
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}

	public function listarCambioRepuestoTOEXCEL($buscar, $orden, $whereCat, $whereTip, $whereCant, $buscarMaquina, $fechas)
	{

        $this->NX_DB->CONECTAR();
        $RESPONSE = null;
        $this->NX_DB->QUERY("
			SELECT Count(reports.serieinterna) AS Cantidad, 
			inventario.codinterno AS RepuestoCodigoInterno, 
			inventario.ID AS RepuestoCodigo, categorias.nombrecategoria AS RepuestoCategoria,
			inventario.descripcion, 
			marcasmaquina.nombremarca AS MaquinaMarca, 
			tiposmaquina.tipo AS MaquinaTipo, 
			maquinas.modelo as MaquinaModelo, 
			maquinas.serieinterna AS MaquinaSerieInterna, 
			reports.fecha as Fecha, 
			inventario.tipo as TipoInventario 
			FROM reports INNER JOIN reportinventario ON reportinventario.idreport = reports.idreport INNER JOIN inventario ON inventario.ID = reportinventario.IDproducto INNER JOIN maquinas ON maquinas.serieinterna = reports.serieinterna INNER JOIN marcasmaquina ON marcasmaquina.ID = maquinas.marca
 			INNER JOIN categorias ON categorias.IDcategoria = inventario.categoria INNER JOIN tiposmaquina ON tiposmaquina.ID = maquinas.tipomaquina
			where 
			inventario.codinterno LIKE '%" . addslashes($buscar) . "%' 
			and maquinas.serieinterna LIKE '%" . addslashes($buscarMaquina) . "%'
			$fechas
			group by
			inventario.codinterno,
			inventario.ID,
			categorias.nombrecategoria,
			inventario.descripcion, 
			marcasmaquina.nombremarca,
			tiposmaquina.tipo, 
			maquinas.modelo, 
			maquinas.serieinterna, 
			reports.fecha, 
			inventario.tipo 
			order by $orden
		");
        if($this->NX_DB->NUM_ROWS() > 0){
            while($_ROW = $this->NX_DB->FETCH_ARRAY()){
                $RESPONSE[] = $_ROW;
            }
        }
        $this->NX_DB->DESCONECTAR();
        return $RESPONSE;
	}	
}



//Obtención de datos

$inventario = new Inventario($_CONF);

$buscar 	   = $_GET['buscar'];
$buscarMaquina = $_GET['buscarMaquina'];
$orden 		   = $_GET['orden'];		
$filtrocat 	   = $_GET['categoria'];	
$filtrotipo    = $_GET['tipo'];	
$fechaDesde 	= $_GET['desde'];
$fechaHasta 	= $_GET['hasta'];
		
$fechas = "";
if($fechaDesde != "" && $fechaHasta != "")
{
	list( $dia, $mes, $anio) = explode( '-', $fechaDesde);
	$fecha1 = "$anio/$mes/$dia"; 
	list( $dia, $mes, $anio) = explode( '-', $fechaHasta);
	$fecha2  = "$anio/$mes/$dia"; 
	$fechas = "AND FECHA BETWEEN '".$fecha1."' AND '".$fecha2."'";	
}		



switch($orden)
{
	default:
	$ordenStr = 'Cantidad DESC';
	$this->orden = 1;
	break;
	case 1:
		$ordenStr = 'Cantidad DESC';
	break;
	case 2:
		$ordenStr = 'Cantidad';
	break;			
	case 3:
		$ordenStr = 'RepuestoCodigoInterno';
	break;
	case 4:
		$ordenStr = 'RepuestoCodigoInterno DESC';
	break;
	case 5:
		$ordenStr = 'RepuestoCategoria';
	break;
	case 6:
		$ordenStr = 'RepuestoCategoria DESC';
	break;
	case 7:
		$ordenStr = 'MaquinaModelo';
	break;	
	case 8:
		$ordenStr = 'MaquinaModelo DESC';
	break;
}

switch($filtrocat)
{
	default:
		$whereCat = 'AND categoria='.$filtrocat;
		break;
	case 0:
		$whereCat = '';
		break;			
}
		
switch($filtrotipo)
{
	default:
		$whereTip = '';
		break;
	case 1: //Insumos
		$whereTip = "AND tipo='Insumo'";
		break;	
	case 2: //Repuestos
		$whereTip = "AND tipo='Repuesto'";
		break;			
}



$whereCant ="";		
$cantidad = $inventario->cantidadCambioRepuesto($buscar, $whereCat, $whereTip, $whereCant);		
$lista = $inventario->listarCambioRepuestoTOEXCEL($buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $buscarMaquina, $fechas);	




// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Lista Repuestos Usados")
							 ->setSubject("")
							 ->setDescription("Lista Repuestos Usados")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:L2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'LISTADO REPUESTOS USADOS');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Fecha');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Repuesto Código Interno');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Repuesto Código');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Repuesto Categoría');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Tipo Inventario');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Cantidad');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Descripción');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Máquina Marca');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Máquina Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Máquina Modelo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Máquina Serie Interna');
$objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);

if(isset($lista) && count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["Fecha"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["RepuestoCodigoInterno"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["RepuestoCodigo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["RepuestoCategoria"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["TipoInventario"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["Cantidad"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["descripcion"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["MaquinaMarca"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["MaquinaTipo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["MaquinaModelo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["MaquinaSerieInterna"]);		
		$c=0;$f++;$count++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('RepuestosUsados');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaRepuestosUsados.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
?>