<?php
/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Reports.php');

//Obtención de datos

$reports = new Reports($_CONF);

$cliente 		= $_GET['cliente'] ?? null;
$maquina 		= $_GET['maquina'] ?? null;
$tecnico 		= $_GET['tecnico'] ??  null;
$numreport		= $_GET['numreport'] ?? null;
$fecha1 		= $_GET['fecha1'] ?? null;
$fecha2 		= $_GET['fecha2'] ?? null;

if($cliente != "" || $maquina != "" || $tecnico != "" || $fecha1 != "" || $numreport != "")
{
    if($fecha1 !="" && $fecha2 !="")
    {
        list( $dia, $mes, $anio) = explode( '-', $fecha1);
        $fecha1 = "$anio/$mes/$dia";
        list( $dia, $mes, $anio) = explode( '-', $fecha2);
        $fecha2 = "$anio/$mes/$dia";
        $fechas= "AND reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
    }

    $cantidad = $reports->cantidadlistar(
        $cliente,
        $maquina,
        $tecnico,
        $fechas ?? null ,
        $numreport)["cantidad"];
    $lista = $reports->listarTOEXCEL(
        $cliente,
        $maquina,
        $tecnico,
        $fechas ?? null ,
        $numreport);
}else
{
    $cantidad = $reports->cantidadlistarTodos();
    $lista = $reports->listarTodosTOEXCEL();
}

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
    ->setLastModifiedBy("CSJ")
    ->setTitle("Lista Reports")
    ->setSubject("")
    ->setDescription("Lista Reports")
    ->setKeywords("")
    ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:P2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'REPORTS');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'ID');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Fecha');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Movimiento');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Detalle');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Cliente');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Técnico');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, "Máquina");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, "Lugar Servicio");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Contador B/N');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Contador Color');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Contador Scanner');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'Hora Despacho');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 3, 'Hora Llegada');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(14,3, 'Hora Salida');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(15, 3, 'Diferencia Horas');
$objPHPExcel->getActiveSheet()->getStyle('A1:P3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:P3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:P3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);

if(count($lista)>0)
{
    $c=0;$f=4;$count=1;
    foreach($lista as $i)
    {
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["idreport"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["fecha"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, utf8_encode($i["nombre"]));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, utf8_decode($i["detalle"]));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, htmlentities($i["razonsocial"], ENT_QUOTES));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["nombretecnico"]. ' '.$i["apellidostecnico"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["serieinterna"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["descripcionlugarservicio"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["contador"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["contadorColor"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["contadorScanner"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, $i["horadespacho"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+13, $f, $i["horallegada"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+14, $f, $i["horasalida"]);
        $c=0;$f++;$count++;
    }
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Reports');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaReports.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');