<?php

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Reportabilidad.php');

//Obtención de datos

$reportabilidad = new Reportabilidad($_CONF);

$idproducto			= $_GET['idproducto'] ?? null;
$fecha1 			= $_GET['fecha1'] ?? null;
$fecha2 			= $_GET['fecha2'] ?? null;
$clausulaIdProducto = "";


if ($idproducto != "")
{
	$clausulaIdProducto = " and inventario.codinterno = '" . $idproducto . "' ";	
}
		

	if($fecha1 !="" && $fecha2 !="")
	{
		list( $dia, $mes, $anio) = explode( '-', $fecha1);
		$fecha1 = "$anio/$mes/$dia"; 
		$fechaInicio = "$dia/$mes/$anio";
		list( $dia, $mes, $anio) = explode( '-', $fecha2);
		$fecha2 = "$anio/$mes/$dia";
		$fechaFin = "$dia/$mes/$anio";
			
		$fechas= " controldevolucioninventario.fechaDevolucionReal BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
	}
	else
	{
		//Obtenemos el Primer Dia del Mes Actual 
		$month = date('m');
    	$year = date('Y');
    	$fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));
		$fechaInicio= date('d/m/Y', mktime(0,0,0, $month, 1, $year));
	
		//Obtenemos el Ultimo Dia del Mes Actual				
		$month = date('m');
      	$year = date('Y');
      	$day = date("d", mktime(0,0,0, $month+1, 0, $year)); 
		$fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));
		$fechaFin= date('d/m/Y', mktime(0,0,0, $month, $day, $year));		
				
		$fechas= " controldevolucioninventario.fechaDevolucion BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";				
	}


//$cantidad = $reportabilidad->cantidadReporteUsoInsumoMensual($fechas, $clausulaIdProducto);
$lista = $reportabilidad->reporteDevolucionInsumoMensualDetalleToExcel($fechas, $clausulaIdProducto);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Reporte Devolucion Insumo Mensual Detalle")
							 ->setSubject("")
							 ->setDescription("Reporte Devolucion Insumo Mensual Detalle")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:Q2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'REPORTE DETALLE DEVOLUCION INSUMO/REPUESTO MENSUAL');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Codigo Interno');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Cantidad');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Modelo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Marca');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, "Descripción");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, "ID Control Salida");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, "Rut Cliente");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, "DV Cliente");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, "Razon Social");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, "Centro de Costo");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, "Tecnico");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 3, "Rut Tecnico");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(14, 3, "Fecha Salida Bodega");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(15, 3, "Fecha Devolucion Real");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(16, 3, 'Periodo');
$objPHPExcel->getActiveSheet()->getStyle('A1:Q3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:Q3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:Q3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);

if(isset($lista) && count($lista) > 0)
{
    $c=0;$f=4;$count=1;
    foreach($lista as $i)
    {
        //echo $i["ID"];
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["codinterno"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["cantidad"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["modelo"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, htmlentities($i["nombremarca"], ENT_QUOTES));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, htmlentities($i["tipo"], ENT_QUOTES));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["descripcion"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["idControl"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["rut"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["dv"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["razonsocial"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["nombreCentroCosto"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, $i["nombrecliente"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+13, $f, $i["rutcliente"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+14, $f, gmdate("d-m-Y",strtotime($i["fechaDevolucion"])));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+15, $f, gmdate("d-m-Y",strtotime($i["fechaDevolucionReal"])));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+16, $f, $fechaInicio . " - " . $fechaFin);
        $c=0;$f++;$count++;
    }
}


// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Reportabilidad');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ReportabilidadDevolucionInsumoMensualDetalle.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output'); 
?>