<?php

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Reportabilidad.php');

//Obtención de datos

$reportabilidad = new Reportabilidad($_CONF);

$idproducto			= $_GET['idproducto'] ?? null;
$fecha1 			= $_GET['fecha1'] ?? null;
$fecha2 			= $_GET['fecha2'] ?? null;
$cliente		 	= $_GET['cliente'] ?? null;
$idcentrocosto 		= $_GET['idcentrocosto'] ?? null;
	
$clausulaIdProducto = "";
$clausulaCliente = "";
$clausulaIdCentroCosto = "";

if ($idproducto != "")
{
    $clausulaIdProducto = " and codinterno like '%" . $idproducto . "%' ";
}

if ($cliente != "")
{
    $clausulaCliente = " and razonsocial like '%" . $cliente . "%' ";
}

if ($idcentrocosto > 0)
{
    $clausulaIdCentroCosto = " and idCentroCosto = '" . $idcentrocosto . "' ";
}

if($fecha1 !="" && $fecha2 !="")
{
    list( $dia, $mes, $anio) = explode( '-', $fecha1);
    $fecha1 = "$anio/$mes/$dia";
    $fechaInicio = "$dia/$mes/$anio";
    list( $dia, $mes, $anio) = explode( '-', $fecha2);
    $fecha2 = "$anio/$mes/$dia";
    $fechaFin = "$dia/$mes/$anio";

    $fechas= " fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
}
else
{
    //Obtenemos el Primer Dia del Mes Actual
    $month = date('m');
    $year = date('Y');
    $fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));
    $fechaInicio= date('d/m/Y', mktime(0,0,0, $month, 1, $year));

    //Obtenemos el Ultimo Dia del Mes Actual
    $month = date('m');
    $year = date('Y');
    $day = date("d", mktime(0,0,0, $month+1, 0, $year));
    $fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));
    $fechaFin= date('d/m/Y', mktime(0,0,0, $month, $day, $year));

    $fechas= " fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
}

$lista = $reportabilidad->reporteCentroCostoInsumoMensualToExcel($fechas, $clausulaIdProducto, $clausulaCliente, $clausulaIdCentroCosto);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
    ->setLastModifiedBy("CSJ")
    ->setTitle("Reporte Centro Costo Insumo Mensual")
    ->setSubject("")
    ->setDescription("Reporte Centro Costo Insumo Mensual")
    ->setKeywords("")
    ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:J2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'REPORTE CENTRO COSTO INSUMO/REPUESTO MENSUAL');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Centro Costo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Cliente');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Recinto');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Codigo Interno');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Descripcion');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, "Cantidad");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, "Precio Compra Unitario");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, "Precio Venta Unitario");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, "Periodo");
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:J3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);

if(count($lista)>0)
{
    $c=0;$f=4;$count=1;
    foreach($lista as $i)
    {
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["nombreCentroCosto"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["razonsocial"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["recinto"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, htmlentities($i["codinterno"], ENT_QUOTES));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, htmlentities($i["descripcion"], ENT_QUOTES));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["cantidad"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["preciocompra"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["precioventa"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $fechaInicio . " - " . $fechaFin);
        $c=0;$f++;$count++;
    }
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Reportabilidad');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ReportabilidadCentroCostoInsumoMensual.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');
?>