<?php
ob_start();
/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/OrdenTrabajo.php');

//Obtención de datos
$OT = new OrdenTrabajo($_CONF);
$fechaDesde 	= $_GET['desde'] ?? "";
$fechaHasta 	= $_GET['hasta'] ?? "";
$buscar = $_GET['buscar'] ?? "";
$idsucursal = isset($_GET['sucursal']) ? $_GET['sucursal'] : 0;
$fechas = "";
$sucursal = "";

if($idsucursal != 0)
{
    $sucursal = " AND ot.idsucursal=".$idsucursal." ";
}

if($fechaDesde != "" && $fechaHasta != "")
{
	list( $dia, $mes, $anio) = explode( '-', $fechaDesde);
	$fecha1 = "$anio/$mes/$dia"; 
	list( $dia, $mes, $anio) = explode( '-', $fechaHasta);
	$fecha2  = "$anio/$mes/$dia"; 
	$fechas = "AND fecha BETWEEN '".$fecha1."' AND '".$fecha2."'";	
}
		
$lista = $OT->listarToExcelOTDetalle($buscar, $fechas, $sucursal);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Lista OT")
							 ->setSubject("")
							 ->setDescription("Lista OT")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

$objPHPExcel->getActiveSheet()->mergeCells('A1:R2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'ORDENES DE TRABAJO CON DETALLE');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'ID OT');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Empresa');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Sucursal');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Nº Boleta');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Nº Factura');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Responsable');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Fecha');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, "Tipo Pago");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, "Total Neto");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'IVA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Total');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'Unidades');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 3, 'Servicio');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(14, 3, 'Familia');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(15, 3, 'Formato');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(16, 3, 'Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(17, 3, 'Gramaje');
$objPHPExcel->getActiveSheet()->getStyle('A1:R3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:R3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:R3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);

if(count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		//echo $i["ID"];
		
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["IDot"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, utf8_encode($i["razonsocial"]));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, utf8_encode($i["nombresucursal"]));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["numboleta"]==""?'s/n':$i["numboleta"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["idfactura"]==""?'s/n':$i["idfactura"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, utf8_encode($i["nombreresp"]));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["fecha"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["descripcion"]);
		if($i["numboleta"]=="")
		{
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, 0);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, 0);
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, 0);
		}	
		else
		{
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, round($i["unidades"]*$i["precio"]));
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, round(($i["unidades"]*$i["precio"])*0.19));
			$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, round(($i["unidades"]*$i["precio"])*1.19));
		}			
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, $i["unidades"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+13, $f, $i["servicio"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+14, $f, $i["familiadesc"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+15, $f, $i["formatodesc"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+16, $f, $i["tipodesc"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+17, $f, $i["gramajedesc"]);
		$c=0;$f++;$count++;		
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('OT');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel;charset=iso-8859-1');
header('Content-Disposition: attachment;filename="ListaOrdenesTrabajoDetalle.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
ob_end_clean();
$objWriter->save('php://output');
?>