<?php
/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Llamados.php');

//Obtención de datos
$Llamados = new Llamados($_CONF);

$buscar 	= $_GET['buscar'] ?? null;
$orden 		= $_GET['orden'] ?? null;

switch($orden)
{
	default:
			$ordenStr = 'serieinterna';
			break;
	case 2:
			$ordenStr = 'serieinterna DESC';
			break;
	case 3:
			$ordenStr = 'prioridad';
			break;
	case 4:
		$ordenStr = 'prioridad DESC';
			break;
}

$lista = $Llamados->listarLlamadosPendientesMaquinasTOEXCEL($buscar, $ordenStr);
// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Llamados Maquinas")
							 ->setSubject("")
							 ->setDescription("Llamados Maquinas")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:N2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'LLAMADOS PENDIENTES');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Serie Interna');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Marca');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Modelo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Cliente');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, "Falla");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Prioridad');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Ubicación');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Ciudad');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Fecha Llamado');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Hora Llamado');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Nombre Tecnico Asignado');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'Nombre Contacto');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 3, 'Telefono Contacto');
$objPHPExcel->getActiveSheet()->getStyle('A1:N3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:N3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:N3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);

if(isset($lista) && count($lista)>0)
{
	$c=0;
	$f=4;
	$count=1;
	foreach($lista as $i)
	{
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["serieinterna"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["nombremarca"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["modelo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i['razonsocial']);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i['idfalla']>0?utf8_encode($i['nombrefalla']):($i['idfalla']==-2?utf8_encode($i['otrafalla']):"Código: ".$i['coderror']));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i['prioridad']==1?'Alta':($i['prioridad']==2?"Media":"Baja"));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["ubicacion"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["ciudad"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["dia"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["hora"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, isset($i["nombretecnicoasignado"]) ? $i["nombretecnicoasignado"] : 'SIN DATO TECNICO ASIGNADO');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, isset($i["nombrecontacto"]) ? $i["nombrecontacto"] : 'SIN DATO CONTACTO');
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+13, $f, isset($i["telefonocontacto"]) ? $i["telefonocontacto"] : 'SIN DATO TELEFONO CONTACTO');
		$c=0;$f++;$count++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Llamados');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaLlamados.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output'); 

?>