<?php
ob_start();

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Servicios.php');

//Obtención de datos
$servicios          = new Servicios($_CONF);
$buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
$rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
$idsucursal = (!isset($_GET['idsucursal']) ? null : $_GET['idsucursal']);
$idfamilia = (!isset($_GET['idfamilia']) ? null : $_GET['idfamilia']);
$idformato = (!isset($_GET['idformato']) ? null : $_GET['idformato']);
$idtipo = (!isset($_GET['idtipo']) ? null :$_GET['idtipo']);
$idgramaje = (!isset($_GET['idgramaje']) ? null : $_GET['idgramaje']);

$sucursal = "";
$familia = "";
$formato = "";
$tipo = "";
$gramaje = "";

if ($idsucursal != 0){
    $sucursal = " AND servicios.idsucursal = " . $idsucursal;
}

if ($idfamilia != 0){
    $familia = " AND servicios.idfamilia = " . $idfamilia;
}

if ($idformato != 0){
    $formato = " AND servicios.idformato = " . $idformato;
}

if ($idtipo != 0){
    $tipo = " AND servicios.idtipo = " . $idtipo;
}

if ($idgramaje != 0){
    $gramaje = " AND servicios.idgramaje = " . $idgramaje;
}

$lista = $servicios->listarServiciosToExcel($buscar, $rut, $sucursal, $familia, $formato, $tipo, $gramaje);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Lista SERVICIOS")
							 ->setSubject("")
							 ->setDescription("Lista SERVICIOS")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

$objPHPExcel->getActiveSheet()->mergeCells('A1:K2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'LISTADO DETALLE SERVICIOS');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'ID SERVICIO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Nombre');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Precio');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Tipo Cambio');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Razon Social');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Sucursal');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Familia');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Formato');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Gramaje');
$objPHPExcel->getActiveSheet()->getStyle('A1:K3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:K3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:K3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);

if(count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		//echo $i["ID"];
		
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["IDservicio"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, utf8_encode($i["servicio"]));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["precio"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["tipocambio"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, utf8_encode($i["razonsocial"]));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, utf8_encode($i["nombresucursal"]));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, utf8_encode($i["familiadesc"]));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, utf8_encode($i["formatodesc"]));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, utf8_encode($i["tipodesc"]));
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, utf8_encode($i["gramajedesc"]));
		$c=0;$f++;$count++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Lista SERVICIOS');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaServicios.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
ob_end_clean();
$objWriter->save('php://output');
?>