<?php

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/SalidaInterna.php');

//Obtención de datos
$salidainterna = new SalidaInterna($_CONF);
$fechaDesde 	= $_GET['fecha1'] ?? null;
$fechaHasta 	= $_GET['fecha2'] ?? null;
$buscar = $_GET['buscar'] ?? null;
$orden 	= $_GET['orden'] ?? null;
$fechas = "";
		
if($fechaDesde != "" && $fechaHasta != "")
{
	list( $dia, $mes, $anio) = explode( '-', $fechaDesde);
	$fecha1 = "$anio/$mes/$dia"; 
	list( $dia, $mes, $anio) = explode( '-', $fechaHasta);
	$fecha2  = "$anio/$mes/$dia"; 
	$fechas = "AND fecha BETWEEN '".$fecha1."' AND '".$fecha2."'";	
}
	
		switch($orden)
		{
			default:
				$ordenStr = 'Fecha';
				$this->orden = 1;
			break;
			case 1:
				$ordenStr = 'Fecha';
			break;
			case 2:
				$ordenStr = 'Fecha DESC';
			break;
		}
	
$lista = $salidainterna->listarTOEXCEL($buscar, $ordenStr, $fechas ?? null);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("DIGITALSERVICE")
							 ->setLastModifiedBy("DIGITALSERVICE")
							 ->setTitle("Lista Consumo Interno Materiales")
							 ->setSubject("")
							 ->setDescription("Lista Consumo Interno Materiales")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:H2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'LISTA CONSUMO INTERNO DE MATERIALES');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'Centro Costo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Fecha');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Tipo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Serie');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Cantidad');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, "Descripcion");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Detalle');
$objPHPExcel->getActiveSheet()->getStyle('A1:H3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:H3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:H3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);

if(count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["nombreCentroCosto"]);
	    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["fecha"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["tipo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["codinterno"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["cantidad"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["descripcion"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["detalle"]);
		$c=0;$f++;$count++;		
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('LISTADO');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaConsumoInternoMateriales.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output');