<?php
ob_start();
require_once '../libs/Classes/PHPExcel.php';
require_once '../libs/Classes/PHPExcel/IOFactory.php';
require("../config/global.php");
include("../modelos/ControladorBD.php");
include '../modelos/Inventario.php';

// Create new PHPExcel object
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("DSPRINT")
    ->setLastModifiedBy("DSPRINT")
    ->setTitle("Lista Inventario")
    ->setSubject(" ")
    ->setDescription("Lista Inventario")
    ->setKeywords(" ")
    ->setCategory(" ");

$inventario = new Inventario($_CONF);

$buscar 	= $_GET['buscar'];
$orden 		= $_GET['orden'];
$filtrocat 	= $_GET['categoria'];
$filtrotipo = $_GET['tipo'];
$modelo 	= $_GET['modelo'];
$perfil     = $_GET['perfil'];
$numparte   = $_GET['numparte'];

$ordenStr = '';
$whereCat = '';
$whereTip = '';
$whereCant ='';

switch($orden)
{
    default:
        $ordenStr = 'modelo';
        $orden = 1;
        break;
    case 2:
        $ordenStr = 'modelo DESC';
        break;
    case 3:
        $ordenStr = 'nombremarca';
        break;
    case 4:
        $ordenStr = 'nombremarca DESC';
        break;
    case 5:
        $ordenStr = 'nombrecategoria';
        break;
    case 6:
        $ordenStr = 'nombrecategoria DESC';
        break;
    case 7:
        $ordenStr = 'contreal';
        break;
    case 8:
        $ordenStr = 'contreal DESC';
        break;
}

switch($filtrocat)
{
    default:
        $whereCat = 'AND categoria='.$filtrocat;
        break;
    case 0:
        $whereCat = '';
        break;
}

switch($filtrotipo)
{
    default:
        $whereTip = '';
        break;
    case 1: //Insumos
        $whereTip = "AND tipo='Insumo'";
        break;
    case 2: //Repuestos
        $whereTip = "AND tipo='Repuesto'";
        break;
}

$lista = $inventario->listarTOEXCEL($buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $modelo, $numparte);

if($perfil==10)
{
    $objPHPExcel->getActiveSheet()->mergeCells('A1:K2');
    $objPHPExcel->getActiveSheet()->setCellValue('A1', 'INVENTARIO');
    $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'ID');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Código');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Categoría');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Modelo');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Num Parte');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, "Stock Teórico");
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Stock Real');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Stock Mínimo');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Stock Crítico');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Cantidad a Comprar');
    $objPHPExcel->getActiveSheet()->getStyle('A1:K3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyle('A1:K3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
    $objPHPExcel->getActiveSheet()->getStyle('A1:K3')->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);

    if(count($lista)>0)
    {
        $c=0;$f=4;$count=1;
        foreach($lista as $i)
        {
            //echo $i["ID"];
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["ID"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["codinterno"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["nombrecategoria"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, iconv ("ISO-8859-1", "UTF-8", $i["modelo"]));
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["numparte"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["contteorico"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["contreal"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["stockminimo"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["stockcritico"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["cantidadacomprar"]);
            $c=0;$f++;$count++;
        }
    }
}
else
{
    $objPHPExcel->getActiveSheet()->mergeCells('A1:L2');
    $objPHPExcel->getActiveSheet()->setCellValue('A1', 'INVENTARIO');
    $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'ID');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Código');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Categoría');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Marca');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Modelo');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Num Parte');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, "Stock Teórico");
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Stock Real');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Stock Mínimo');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Stock Crítico');
    $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Cantidad a Comprar');
    $objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
    $objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
    $objPHPExcel->getActiveSheet()->getStyle('A1:L3')->getFont()->setBold(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
    $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);

    if(count($lista)>0)
    {
        $c=0;$f=4;$count=1;
        foreach($lista as $i)
        {
            //echo $i["ID"];
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["ID"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["codinterno"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["nombrecategoria"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["nombremarca"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, iconv ("ISO-8859-1", "UTF-8", $i["modelo"]));
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["numparte"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["contteorico"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["contreal"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["stockminimo"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["stockcritico"]);
            $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["cantidadacomprar"]);
            $c=0;$f++;$count++;
        }
    }
}
// Rename worksheet
$objPHPExcel->getActiveSheet()->setTitle('Inventario');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);

header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="ListaInventario.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
ob_end_clean();
$objWriter->save('php://output');
?>