<?php
/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/Cotizacion.php');

//Obtención de datos

$cotizacion = new Cotizacion($_CONF);

$buscar 		= $_GET['buscar'];
$filtroorden 	= $_GET['orden'];		
$estado 		= $_GET['estado'];
$idCotizacion	= $_GET['idCotizacion'];

$fechaDesde 	= $_GET['desde'];
$fechaHasta 	= $_GET['hasta'];

switch($filtroorden)
{
    case 1:
        $ordenStr = 'cotizacion.idCotizacion DESC ';
        break;
    case 2:
        $ordenStr = 'cotizacion.idCotizacion ';
        break;
    case 3:
        $ordenStr = 'cotizacion.fechaCotizacion DESC ';
        break;
    case 4:
        $ordenStr = 'cotizacion.fechaCotizacion ';
        break;
}

switch($estado)
{
    default:
        $whereTip = '';
        break;
    case 0: //enviada
        $whereTip = " AND cotizacion.estado=1";
        break;
    case 1: //Aprobada
        $whereTip = " AND cotizacion.estado=2";
        break;
    case 2: //Rechazada
        $whereTip = " AND cotizacion.estado=3";
        break;
    case 3: //Creada
        $whereTip = " AND cotizacion.estado=4";
        break;
    case 4: //Anulada
        $whereTip = " AND cotizacion.estado=5";
        break;
}


$lista = $cotizacion->listarEXCELDETALLE($idCotizacion, $ordenStr, $whereTip, $fechaDesde, $fechaHasta);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Cotizacion Detalle")
							 ->setSubject("")
							 ->setDescription("Cotizacion Detalle")
							 ->setKeywords("")
							 ->setCategory("");

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:AA2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'COTIZACIONES DETALLE');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'N° COTIZACION');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'FECHA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'ESTADO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'TIPO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'VALIDEZ');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'NOMBRE CONTACTO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'RUT EMPRESA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, "EMPRESA");
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'DIRECCION');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'CIUDAD');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'CORREO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'TELEFONO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'RUT VENDEDOR');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(13, 3, 'VENDEDOR');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(14, 3, 'PERIODO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(15, 3, 'TIPO MAQUINA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(16, 3, 'MARCA');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(17, 3, 'MODELO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(18, 3, 'CANTIDAD');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(19, 3, 'bnMinimo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(20, 3, 'colorMinimo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(21, 3,'scannerMinimo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(22, 3, 'bnCosto');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(23, 3,'colorCosto');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(24, 3, 'scannerCosto');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(25, 3, 'CARGO FIJO');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(26, 3, 'TOTAL');

$objPHPExcel->getActiveSheet()->getStyle('A1:AA3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:AA3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:AA3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('X')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Y')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('Z')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('AA')->setAutoSize(true);

if(count($lista)>0)
{
	$textoEstado = "";
	$c=0;$f=4;
	foreach($lista as $i)
	{
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $i["idCotizacion"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["fechaCotizacion"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, $i["descripcionEstado"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, $i["descripcionCotizacion"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["validez"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["nombreContacto"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i["rutClienteAprobado"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i["empresa"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i["direccion"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i["ciudad"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i["correo"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i["telefono"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, $i["idVendedor"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+13, $f, $i["Vendedor"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+14, $f, $i["descripcionPeriodo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+15, $f, $i["tipomaquina"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+16, $f, $i["nombremarca"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+17, $f, $i["modelo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+18, $f, $i["cantidad"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+19, $f, $i["bnMinimo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+20, $f, $i["colorMinimo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+21, $f, $i["scannerMinimo"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+22, $f, $i["bnCosto"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+23, $f, $i["colorCosto"]);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+24, $f, $i["scannerCosto"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+25, $f, $i["cargoFijo"]);
		$valorTotal = $i["cantidad"] * ( ($i["bnMinimo"]*$i["bnCosto"]) + ($i["colorMinimo"]*$i["colorCosto"]) + $i["cargoFijo"] );
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+26, $f, $valorTotal);
		$c=0;$f++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('COTIZACION DETALLE');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel');
header('Content-Disposition: attachment;filename="CotizacionesDetalle.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output'); 
?>

*/