<?php

/** PHPExcel */
require_once '../libs/Classes/PHPExcel.php';
/** PHPExcel_IOFactory */
require_once '../libs/Classes/PHPExcel/IOFactory.php';

require("../config/global.php");
require('../modelos/ControladorBD.php');
require('../modelos/ControlSalida.php');

//Obtención de datos

$ControlSalida = new ControlSalida($_CONF);

$buscar 		= $_GET['buscar'] ?? null;
$orden 			= $_GET['orden'] ?? null;
$fechaDesde 	= $_GET['desde'] ?? null;
$fechaHasta 	= $_GET['hasta'] ?? null;
$idcontrol  	= $_GET['idcontrol'] ?? null;
	
			
switch($orden)
{
	default:
			$ordenStr = 'IDcontrol, Fecha';
			break;
	case 1:
			$ordenStr = 'IDcontrol, Fecha';
			break;
	case 2:
			$ordenStr = 'IDcontrol, Fecha DESC';
			break;
}

if($fechaDesde != "" && $fechaHasta != "")
{
	list( $dia, $mes, $anio) = explode( '-', $fechaDesde);
	$fecha1 = "$anio/$mes/$dia"; 
	list( $dia, $mes, $anio) = explode( '-', $fechaHasta);
	$fecha2  = "$anio/$mes/$dia"; 
	$fechas = "AND fecha BETWEEN '".$fecha1."' AND '".$fecha2."'";	
}

$lista = $ControlSalida->listarTOEXCELDETALLE($buscar, $ordenStr, $fechas ?? null, $idcontrol);

// Create new PHPExcel object
//echo date('H:i:s') . " Create new PHPExcel object\n";
$objPHPExcel = new PHPExcel();

// Set properties
$objPHPExcel->getProperties()->setCreator("CSJ")
							 ->setLastModifiedBy("CSJ")
							 ->setTitle("Controles de Salida")
							 ->setSubject("")
							 ->setDescription("Controles de Salida")
							 ->setKeywords("")
							 ->setCategory("");
// Add some data

//$objPHPExcel->setActiveSheetIndex(0);
$objPHPExcel->getActiveSheet()->mergeCells('A1:M2');
$objPHPExcel->getActiveSheet()->setCellValue('A1', 'CONTROLES DE SALIDA');
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1')->getAlignment()->setVertical(PHPExcel_Style_Alignment::VERTICAL_CENTER);

$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(0, 3, 'Nº');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(1, 3, 'ID');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(2, 3, 'Empresa');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(3, 3, 'Cliente');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(4, 3, 'Centro Costo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(5, 3, 'Fecha');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(6, 3, 'Hora');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(7, 3, 'Recinto');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(8, 3, 'Codigo Interno');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(9, 3, 'Descripcion');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(10, 3, 'Modelo');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(11, 3, 'Maquina');
$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow(12, 3, 'Cantidad');

$objPHPExcel->getActiveSheet()->getStyle('A1:M3')->getAlignment()->setHorizontal(PHPExcel_Style_Alignment::HORIZONTAL_CENTER);
$objPHPExcel->getActiveSheet()->getStyle('A1:M3')->getBorders()->getBottom()->setBorderStyle(PHPExcel_Style_Border::BORDER_THICK);
$objPHPExcel->getActiveSheet()->getStyle('A1:M3')->getFont()->setBold(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
$objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);
if(count($lista)>0)
{
	$c=0;$f=4;$count=1;
	foreach($lista as $i)
	{
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c, $f, $count);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+1, $f, $i["IDcontrol"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+2, $f, utf8_encode($i['razonsocial']));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+3, $f, utf8_encode($i['nombrecliente']));
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+4, $f, $i["nombreCentroCosto"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+5, $f, $i["fecha"]);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+6, $f, $i['hora']);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+7, $f, $i['recinto']);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+8, $f, $i['codinterno']);
		$objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+9, $f, $i['descripcion']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+10, $f, $i['modelo']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+11, $f, $i['maquinas']);
        $objPHPExcel->getActiveSheet()->setCellValueByColumnAndRow($c+12, $f, $i['cantidad']);
		$c=0;$f++;$count++;
	}
}

// Rename sheet
$objPHPExcel->getActiveSheet()->setTitle('Controles');

// Set active sheet index to the first sheet, so Excel opens this as the first sheet
$objPHPExcel->setActiveSheetIndex(0);
		
header('Content-Type: application/vnd.ms-excel;charset=iso-8859-1');
header('Content-Disposition: attachment;filename="ListaControlesSalidas.xls"');
header('Cache-Control: max-age=0');

$objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
$objWriter->save('php://output'); 
