<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("modelos/ControladorBD.php");
require_once("modelos/nx_utils.php");
//</editor-fold>

class UsuariosControlador extends controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $usuario;
    var $configuraciones;
    private $NX_CONFIG;
    private $NX_UTILS;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_UTILS = new NX_UTILS();
        $this->usuario = new Usuarios($this->NX_CONFIG);
        $this->configuraciones = new Configuraciones($this->NX_CONFIG);
    }
    //</editor-fold>
	
	public function menu() 
	{
		//Se cargan los accesos directos de cada tipo de Usuario
		//Dentro de cada acceso directo y pagina de vista se incluye el archivo menu_horizontal.php
		//que segun el area del usuario incluye el menu correspondiente
		if(!isset($_SESSION['usuario'])) 
		{
			header('location: index.php?error=nologin');
			return;
		}	
		//Abastecimiento y Call Center
		if($_SESSION['area']==1)
		{
			$this->contenido = $this->ver('accesos_directos_abas_call');
		}
		//Administracion
		if($_SESSION['area']==2)
		{
			$this->contenido = $this->ver('accesos_directos_administracion');
		}
		//Call Center
		if($_SESSION['area']==3)
		{
			$this->contenido = $this->ver('accesos_directos_callcenter');
		}
		//Centro Fotocopiado
		if($_SESSION['area']==4)
		{
			$this->contenido = $this->ver('accesos_directos_centrocopiado');
		}
		//Gerencia
		if($_SESSION['area']==5)
		{
			$this->contenido = $this->ver('accesos_directos_gerencia');
		}
		//Secretaria
		if($_SESSION['area']==6)
		{
			$this->contenido = $this->ver('accesos_directos_secretaria');
		}
		//Servicio tecnico
		if($_SESSION['area']==7)
		{
			$this->contenido = $this->ver('accesos_directos_serviciotecnico');
		}
		//Supervisor
		if($_SESSION['area']==8)
		{
			$this->contenido = $this->ver('accesos_directos_supervisor');
		}
		//Abastecimiento
		if($_SESSION['area']==9)
		{
			$this->contenido = $this->ver('accesos_directos_abastecimiento');
		}
		//Call Center
		if($_SESSION['area']==10)
		{
			$this->contenido = $this->ver('accesos_directos_callcenter');
		}
        //Abastecimiento
        if($_SESSION['area']==11)
        {
            $this->contenido = $this->ver('accesos_directos_bodega');
        }
        //Venta
        if($_SESSION['area']==12)
        {
            $this->contenido = $this->ver('accesos_directos_venta');
        }
		return $this->ver('index');		
	}
	
	public function login()
	{		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut 		= $_POST['rut'];
			$passCod 	= base64_encode($_POST['pass']);
			$usuario_session = $this->usuario->login($rut, $passCod);

			if(is_array($usuario_session))
			{
				session_start();
				$_SESSION['usuario'] = $usuario_session["nombre"] . " " . $usuario_session["apellidos"];
				$_SESSION['rut'] = $usuario_session["rut"];
				$_SESSION['area'] = $usuario_session["area"];
                $_SESSION['sucursal'] = $usuario_session["sucursal"];
                if($usuario_session["estado"]==0)
				{
					header("location: index.php?controlador=Usuarios&accion=changePass");
				}
				else
				{		
					header("location: index.php?controlador=Usuarios&accion=menu");
				}
			}
			else
			{
				session_destroy();
				header("location: index.php?error=nologin");
			}
		}

        if(isset($_GET["error"]) && $_GET["error"]=="nologin"){
            $this->info_msg  = $this->msglogin(1);
        }

        if(isset($_GET["error"]) && $_GET["error"]=="restringido"){
            $this->contenido = $this->ver('acceso_restringido');
            return $this->ver('index');
        }
		
		$this->contenido = $this->ver('login');
		return $this->ver('index');		
	}
	
	public function logout()
	{
		session_destroy();
		header("location: index.php");
	}
	
	public function changePass()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut 		= $_SESSION['rut'];
			$passA 		= base64_encode(($_POST['pass1']));
			$passN		= base64_encode(($_POST['pass2']));

			$usuario_session = $this->usuario->login($rut, $passA);
			
			if(is_array($usuario_session))
			{
				$this->usuario->changePass($rut, $passN);
				$this->usuario->changeEstado($rut, 1);
				session_start();
				$_SESSION['usuario'] = $usuario_session["nombre"] . " " . $usuario_session["apellidos"];			
				header("location: index.php?controlador=Usuarios&accion=changePass&change=ok");
			}
			else 
			{
				if(session_start())
				{
					header("location: index.php?controlador=Usuarios&accion=changePass&change=error");
				}
			}
		}
		
		if(isset($_GET["change"]) && $_GET["change"] == "ok")
		{
			$this->info_msg  = $this->msglogin(2);		
		}
	
		if(isset($_GET["change"]) && $_GET["change"] == "error")
		{
			$this->info_msg  = $this->msglogin(1);	
		}
			
		$this->contenido = $this->ver('login_cambiar_pass');
		return $this->ver('index');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
	public function seleccionar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}

        $this->filtroarea = (isset($_GET['area']) ? $_GET['area'] : null);
        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
			
		switch($this->orden)
		{
			default:
				$ordenStr = 'apellidos';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'apellidos DESC';
			break;
			case 3:
				$ordenStr = 'rut';
			break;
			case 4:
				$ordenStr = 'rut DESC';
			break;	
		}
		
		switch($this->filtroarea)
		{
			default:
				$whereArea = 'AND area='.$this->filtroarea;
			break;
			case 0:
				$whereArea = '';
			break;			
		}
		
		$this->lista = $this->usuario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereArea );
		$cantidad = $this->usuario->cantidad($this->buscar, $whereArea)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);		
		return $this->ver('seleccionar_usuario');
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=6 and $_SESSION['area']!=8 and $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : "");
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : "");
        $this->filtroarea = (isset($_GET['area']) ? $_GET['area'] : "");

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

		switch($this->orden)
		{
			default:
				$ordenStr = 'apellidos';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'apellidos DESC';
			break;
			case 3:
				$ordenStr = 'CAST(rut as UNSIGNED)';
			break;
			case 4:
				$ordenStr = 'CAST(rut as UNSIGNED) DESC';
			break;	
		}
		
		switch($this->filtroarea)
		{
			default:
				$whereArea = 'AND area='.$this->filtroarea;
			break;
			case 0:
				$whereArea = '';
			break;			
		}
		
		$this->lista = $this->usuario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereArea );	
		$cantidad = $this->usuario->cantidad($this->buscar, $whereArea)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		$this->listaareas = $this->usuario->listarAreas();
		$this->contenido = $this->ver('listar_usuarios');
		return $this->ver('index');				
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=6 and $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut 			= $_POST['rut'];
			$pass			= base64_encode($rut);
			$dv 			= $_POST['dv'];
			$nombre		 	= $_POST['nombre'];
			$apellido		= $_POST['apellido'];
			$telefono 		= $_POST['telefono'];
			$direccion 		= $_POST['direccion'];
            $correo 		= $_POST['correo'];
			$area 			= $_POST['area'];
            $sucursal		= $_POST['sucursal'];
			$cont = $this->usuario->existe($rut);						
			if($cont["cantidad"] > 0) { //error nuevo empleado, ya existe
				 return "<script type=\"text/javascript\">javascript:self.parent.tb_remove();alert('El Personal ya existe');</script>";
			} else { 
				  	$ok = $this->usuario->nuevo($rut, $dv, $nombre, $apellido, $telefono, $direccion, $area, $pass, $correo, $sucursal);
				  if($ok)
				  {
					  return $this->info_msg = $this->msg('popup', 'Personal', 1,0,1);
				  }else{
					  return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Personal, contacte al Administrador.');</script>";
				  }
			}
		}
		$this->listaareas = $this->usuario->listarAreas();
        $this->listasucursales = $this->usuario->listarSucursales();

		return $this->ver('nuevo_usuario');
	}
    //</editor-fold>

	public function eliminar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=6 and $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$rut = $_GET['rut'];
		$this->usuario->eliminar($rut);
		header('location: index.php?controlador=Usuarios&accion=listar');
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : editar">
	public function editar()
	{
		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=6 and $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}	
	
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut 			= $_POST['rut'];
			$nombre		 	= $_POST['nombre'];
			$apellido		= $_POST['apellido'];
			$telefono 		= $_POST['telefono'];
			$direccion 		= $_POST['direccion'];
			$area 			= $_POST['area'];
            $sucursal		= $_POST['sucursal'];
			$correo         = $_POST['correo'];
			$this->usuario->modificar($rut, $nombre, $apellido, $telefono, $direccion, $area, $correo, $sucursal);
			$cambiarPass 	= isset($_POST['newpass']);
			if($cambiarPass == 1)
			{
				$pass		= base64_encode($rut);
				$this->usuario->restablecerPass($rut, $pass);
			}
			return $this->info_msg = $this->msg('popup', 'Personal', 2,0,1);
		}
		$rut = $_GET['rut'];
		$this->listaareas = $this->usuario->listarAreas();
        $this->listasucursales = $this->usuario->listarSucursales();
		$this->datosusuario = $this->usuario->obtenerDatos($rut);
		return $this->ver('editar_usuario');			
	}
    //</editor-fold>
	
	public function panelcontrol() 
	{
		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if(!isset($_SESSION['usuario'])) // || $usuario['nivel']<5 ) 
		{
			header('location: index.php?error=nologin');
		}
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$this->listado = $this->configuraciones->listar();
			foreach($this->listado as $c)
			{
				$valor 				= $_POST['id' . $c['idconfiguracion']];
				$this->configuraciones->editar($c['idconfiguracion'], $valor);
				$this->info_msg  = $this->msg('completa', 'Configuraci&oacute;n', 2, 1, 1);
			}			
		}
		$this->listado = $this->configuraciones->listar();
		$this->contenido = $this->ver('panel_control');
		return $this->ver('index');		
	}
}
?>