<?php

require_once("modelos/nx_utils.php");

class ServiciosControlador extends Controlador {

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $servicios;
    var $usuario;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->servicios = new Servicios($this->NX_CONFIG);
        $this->usuario = new Usuarios($this->NX_CONFIG);
        $this->configuraciones	= new Configuraciones($this->NX_CONFIG);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    public function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5 and $_SESSION['area']!=9)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $servicio 	    = utf8_encode($_POST['servicio']);
            $precio 	    = $_POST['precio'];
            $tipocambio     = $_POST['tipocambio'];
            $idsucursal     = $_POST['sucursal'];
            $familia        = $_POST['familia'];
            $formato        = $_POST['formato'];
            $tipo           = $_POST['tipo'];
            $gramaje        = $_POST['gramaje'];

            if($familia == -1)
            {
                $nuevafamilia = $_POST['nuevafamilia'];
                $existe = $this->servicios->buscarFamilia($nuevafamilia)["idserviciofamilia"];

                if(is_numeric($existe))
                {
                    $familia = $existe;//se le da la ID que ya estaba ingresada
                }else{
                    $familia = $this->servicios->nuevaFamilia($nuevafamilia);
                    $familia = $this->servicios->buscarFamilia($nuevafamilia)["idserviciofamilia"];
                }
            }

            if($formato == -1)
            {
                $nuevaformato = $_POST['nuevoformato'];
                $existe = $this->servicios->buscarFormato($nuevaformato)["idformato"];
                if(is_numeric($existe))
                {
                    $formato = $existe;//se le da la ID que ya estaba ingresada
                }else{
                    $formato = $this->servicios->nuevoFormato($nuevaformato);
                    $formato = $this->servicios->buscarFormato($nuevaformato)["idformato"];
                }
            }

            if($tipo == -1)
            {
                $nuevotipo = $_POST['nuevotipo'];
                $existe = $this->servicios->buscarTipo($nuevotipo)["idtipo"];
                if(is_numeric($existe))
                {
                    $tipo = $existe;//se le da la ID que ya estaba ingresada
                }else{
                    $tipo = $this->servicios->nuevoTipo($nuevotipo);
                    $tipo = $this->servicios->buscarTipo($nuevotipo)["idtipo"];
                }
            }

            if($gramaje == -1)
            {
                $nuevogramaje = $_POST['nuevogramaje'];
                $existe = $this->servicios->buscarGramaje($nuevogramaje)["idgramaje"];
                if(is_numeric($existe))
                {
                    $gramaje = $existe;//se le da la ID que ya estaba ingresada
                }else{
                    $gramaje = $this->servicios->nuevoGramaje($nuevogramaje);
                    $gramaje = $this->servicios->buscarGramaje($nuevogramaje)["idgramaje"];
                }
            }



            $rutcsj     = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
            $ok         = $this->servicios->nuevo($servicio, $precio, $tipocambio, $rutcsj, $idsucursal, $familia, $formato, $tipo, $gramaje);

            if($ok)
            {
                return $this->info_msg = $this->msg('popup', 'Servicio', 1,0,1);
            }else{
                return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Servicio, contacte al Administrador.');</script>";
            }
        }
        $this->listasucursales = $this->usuario->listarSucursales();
        $this->listafamilias = $this->servicios->listarFamilias();
        $this->listaformato = $this->servicios->listarFormato();
        $this->listatipo = $this->servicios->listarTipo();
        $this->listagramaje = $this->servicios->listarGramaje();
        return $this->ver('nuevo_servicio');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoPorCliente">
    public function nuevoPorCliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5 and $_SESSION['area']!=9)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $servicio 			= utf8_encode($_POST['servicio']);
            $precio 			= $_POST['precio'];
            $tipocambio 		= $_POST['tipocambio'];
            $idCliente          = $_POST['rut'];
            $idsucursal         = $_POST['sucursal'];
            $ok = $this->servicios->nuevoPorCliente($servicio, $precio, $tipocambio,$idCliente, $idsucursal);
            if($ok)
            {
                return $this->info_msg = $this->msg('popup', 'Servicio', 1,0,1);
            }else{
                return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Servicio, contacte al Administrador.');</script>";
            }
        }
        $this->listasucursales = $this->usuario->listarSucursales();
        return $this->ver('nuevo_servicio');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
    public function seleccionar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina 		= 1;
        $this->resultados 	= 20;
        $this->buscar 		= (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden 		= (!isset($_GET['orden']) ? null : $_GET['orden']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'servicio';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'servicio DESC';
                break;
        }

        $cantidad = $this->servicios->cantidad($this->buscar);
        $this->lista = $this->servicios->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $this->nPaginas = ceil($cantidad / $this->resultados);

        return $this->ver('seleccionar_servicio');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : editar">
    public function editar()
    {

        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2 and $_SESSION['area']!=9 )
        {
            header('location: index.php?error=restringido');
            return;
        }

        if(!isset($_SESSION['usuario']))
        {
            header('location: index.php?error=nologin');
        }
        $servicios = new Servicios($this->NX_CONFIG);
        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $idservicio		= $_POST['servicio'];
            $nombreservicio	= $_POST['nombreservicio'];
            $precios		= $_POST['precio'];
            $tipocambio		= $_POST['tipocambio'];
            $idsucursal     = $_POST['sucursal'];
            $idfamilia      = $_POST['familiadd'];
            $idformato      = $_POST['formatodd'];
            $idtipo         = $_POST['tipodd'];
            $idgramaje      = $_POST['gramajedd'];
            $n = count($precios);

            $i = 0;
            while ($i < $n){
                //echo "<p>idfamilia: ";
                //echo $idfamilia[$i];
                //echo "-- idformato: ";
                //echo $idformato[$i];
                //echo "-- idtipo: ";
                //echo $idtipo[$i];
                //echo "-- idgramaje: ";
                //echo $idgramaje[$i];
                $servicios->editar($idservicio[$i], utf8_encode($nombreservicio[$i]), $precios[$i], $tipocambio[$i], $idfamilia[$i], $idformato[$i], $idtipo[$i], $idgramaje[$i]);
                $i++;
            }
            header("Location: index.php?controlador=Servicios&accion=editar&infomsg=ok");
            return;

        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"] == "ok")
        {
            $this->info_msg  = $this->msg('completa', 'Listado de servicios', 2, 0, 1);
        }

        $this->idfamilia        = (!isset($_GET['idfamilia']) ? 0 : $_GET['idfamilia']);
        $this->idformato        = (!isset($_GET['idformato']) ? 0 : $_GET['idformato']);
        $this->idtipo           = (!isset($_GET['idtipo']) ? 0 : $_GET['idtipo']);
        $this->idgramaje        = (!isset($_GET['idgramaje']) ? 0 : $_GET['idgramaje']);
        $this->idsucursal       = (!isset($_GET['idsucursal']) ? 0 : $_GET['idsucursal']);
        $this->buscar           = (!isset($_GET['buscar']) ? null: $_GET['buscar']);
        $this->rut			    = (!isset($_GET['rut']) ? null : $_GET['rut']);

        $whereidfamilia = '';
        $whereidformato = '';
        $whereidtipo = '';
        $whereidgramaje = '';
        $whereidsucursal = '';

        /*        echo "<p>familia: ";
                echo $whereidfamilia;
                echo "<p>formato: ";
                echo       $whereidformato;
                echo "<p>tipo: ";
                echo  $whereidtipo;
                echo "<p>gramaje: ";
                echo $whereidgramaje;
                echo "<p>";

        echo "<p>buscar: ";
        echo $this->buscar;*/

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        if($this->idfamilia != 0) {
            $whereidfamilia = " AND serviciosfamilia.idserviciofamilia = ". $this->idfamilia;
        }

        if($this->idformato != 0) {
            $whereidformato = " AND serviciosformato.idformato = ". $this->idformato;
        }

        if($this->idtipo != 0) {
            $whereidtipo = " AND serviciostipo.idtipo = ". $this->idtipo;
        }

        if($this->idgramaje != 0) {
            $whereidgramaje = " AND serviciosgramaje.idgramaje = ". $this->idgramaje;
        }

        if($this->idsucursal != 0) {
            $whereidsucursal = " AND sucursal.idsucursal = ". $this->idsucursal;
        }

        $this->rutcsj           = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->listado          = $servicios->listarTodos($this->rutcsj, $this->buscar, $whereidsucursal, $whereidfamilia, $whereidformato, $whereidtipo, $whereidgramaje);
        $this->listafamilias    = $this->servicios->listarFamilias();
        $this->listaformato     = $this->servicios->listarFormato();
        $this->listatipo        = $this->servicios->listarTipo();
        $this->listagramaje     = $this->servicios->listarGramaje();
        $this->listasucursales  = $this->usuario->listarSucursales();
        $this->contenido        = $this->ver('editar_servicio');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : editarclienteServicios">
    public function editarclienteServicios()
    {

        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5 and $_SESSION['area']!=8 && $_SESSION['area']!=9)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if(!isset($_SESSION['usuario']))
        {
            header('location: index.php?error=nologin');
        }
        $servicios = new Servicios($this->NX_CONFIG);
        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $idservicio		= $_POST['servicio'];
            $nombreservicio	= $_POST['nombreservicio'];
            $precios		= $_POST['precio'];
            $tipocambio		= $_POST['tipocambio'];
            $rut            = $_POST['rut'];
            $n = count($precios);
            $i = 0;
            while ($i < $n){
                $servicios->editar($idservicio[$i], utf8_encode($nombreservicio[$i]), $precios[$i], $tipocambio[$i]);
                $i++;
            }
            header("Location: index.php?controlador=Servicios&accion=editarclienteServicios&infomsg=ok&rut=".$rut);
            return;
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="ok")
        {
            $this->info_msg  = $this->msg('completa', 'Listado de servicios', 2, 0, 1);
        }

        $this->listado = $servicios->listarTodosPorCliente($_GET["rut"]);
        return $this->ver('editar_clienteServicios');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminar">
    public function eliminar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idservicio = $_GET['idservicio'];
        $this->servicios->eliminar($idservicio);
        header('location: index.php?controlador=Servicios&accion=editar');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : eliminarclienteServicios">
    public function eliminarclienteServicios()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idservicio = $_GET['idservicio'];
        $this->servicios->eliminar($idservicio);
        header('location: index.php?controlador=Servicios&accion=editarclienteServicios');
    }
    //</editor-fold>
}
?>