<?php

require_once("modelos/nx_utils.php");

class ServicioExternoControlador extends Controlador
{
	var $orden;
	var $maquinas;
    private $NX_CONFIG;
    private $NX_UTILS;

    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_UTILS = new NX_UTILS();
        $this->cotizacion = new Cotizacion($this->NX_CONFIG);
        $this->maquinas = new Maquinas($this->NX_CONFIG);
    }

	/*****************************************************************************************************************/
	/*****************************************  OBTENER N�MERO  *************************************************/
	/*****************************************************************************************************************/
	
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->numero = $this->cotizacion->obtenernumero()["numero"];
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}
	
	/*****************************************************************************************************************/ 
	/*****************************************  NUEVO  *************************************************/
	/*****************************************************************************************************************/
	
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo[0]);
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";

        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nuevo_servicio_externo');
		return $this->ver('index');
	}
	
	public function arriendoMaquinas()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo[0]);
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_arriendo_maquina');
		return $this->ver('index');
	}

	public function ventaMaquinas()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo[0]);
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_venta_maquina');
		return $this->ver('index');
	}

	public function centroCopiado()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo[0]);
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_centro_copiado');
		return $this->ver('index');
	}

	public function ventaInsumos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo[0]);
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_venta_insumo');
		return $this->ver('index');
	}

	public function mantencionesExternas()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerooc		= $_POST['numerooc'];
			$rutp 			= $_POST['rut'];
			$fecha 			= $_POST['fecha'];			
			$sumatotal 		= $_POST['sumatotal'];
			$rutproveedor	= $_POST['rut'];
			//Productos de inventario
			$itemid		= $_POST['itemid'];
			$itemcant		= $_POST['itemcant'];
			$itemprec		= $_POST['itemprec'];
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'];
			$nprodcant		= $_POST['nprodcant'];
			$nprodprecio	= $_POST['nprodprecio'];
			$datosprod		= $_POST['datosprod'];
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid']; //id = descripcion
			$maqservcant		= $_POST['maqservcant'];
			$maqservprecio		= $_POST['maqservprecio'];
			$datosmaqserv		= $_POST['datosmaqserv']; // = descripcion
			
			$ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal); //Estado = 2
			
			if($ok)
			{ 
			$inventario = new Inventario();
//---------> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

				$n        = count($itemid);
				$i        = 0;
				while ($i < $n){
					$this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
					/* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
					//$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
					$i++;
				}
				
//****************************************************************
				
				$proveedor = new Proveedor();
//---------> Ingreso de Nuevos Productos
				$cat 		= new Categorias();
				$n        	= count($nproductoid);
				$i        	= 0;
				while ($i < $n){
					
				list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    			$corr = $inventario->obtenerCorrelativo($tipo[0]);
				$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);

			//nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

			$this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			//asociar al proveedor
			$proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
					
//****************************************************************
					$i++;
				}
				
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************

				header("Location: index.php?controlador=Cotizacion&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
			}
			
		}
		$this->info_msg = "";
		
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);	
		}
		
		$this->contenido = $this->ver('nueva_cotizacion_mantencion_externa');
		return $this->ver('index');
	}
	
	/*****************************************************************************************************************/ 
	/*****************************************  INICIO LISTAR  *************************************************/
	/*****************************************************************************************************************/
	
	public function iniciolistar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->anios = $this->orden->aniosDesc();
		$this->contenido = $this->ver('inicio_listar_oc');
		return $this->ver('index');	
	}	
	
	/*****************************************************************************************************************/ 
	/*****************************************  LISTAR    *************************************************/
	/*****************************************************************************************************************/
	
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada pagina
		$this->pagVisible = 8; //paginas a mostrar en la paginacion
		
		$this->buscar 		= isset($_GET['buscar']) ? $_GET['buscar'] : null;
		$this->filtroorden 	= isset($_GET['orden']) ? $_GET['orden'] : null;
		$this->estado 		= isset($_GET['estado']) ? $_GET['estado'] : null;
		
		$this->fechaDesde 	= isset($_GET['desde']) ? $_GET['desde'] : null;
		$this->fechaHasta 	= isset($_GET['hasta']) ? $_GET['hasta'] : null;

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
			
		switch($this->filtroorden)
		{
			default:
				$ordenStr = 'IDoc';
				$this->filtroorden = 1;
			break;
			case 2:
				$ordenStr = 'IDoc DESC';
			break;
			case 3:
				$ordenStr = 'total';
			break;
			case 4:
				$ordenStr = 'total DESC';
			break;
			case 5:
				$ordenStr = 'fecha';
			break;
			case 6:
				$ordenStr = 'fecha DESC';
			break;	
		}

		switch($this->estado)
		{
			default:
			   $whereTip = '';
			break;
			case 0: //completa
				$whereTip = "AND estado=0";
			break;
			case 1: //Pendientes Recibo conforme
				$whereTip = "AND estado=1";
			break;	
			case 2: //Pendientes de Pago y Recibo Conforme
				$whereTip = "AND estado=2";
			break;		
			case 3: //Anuladas
				$whereTip = "AND estado=3";
			break;	
		}

	$cantidads = $this->orden->cantidad($this->buscar, $whereTip, $this->fechaDesde, $this->fechaHasta); 
	$this->lista = $this->orden->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereTip, $this->fechaDesde, $this->fechaHasta);		
	$this->nPaginas = ceil($cantidads / $this->resultados);	
	return $this->ver('listar_oc');
	}	

	/*****************************************************************************************************************/ 
	/*****************************************  EDITAR ORDEN COMPRA  *************************************************/
	/*****************************************************************************************************************/
	
	
	
	
	
	public function listarmaquinasarriendo() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina 			= 1;
		$this->resultados 		= 20;
		$this->codinterno 		= $_GET['codigointerno'];
		$this->rutp 			= $_GET['rutp'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];
			
		$cantidad = $this->maquinas->cantidadMaquinasCotizacion($this->codinterno, $this->rutp);		
	    $this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->rutp, $this->codinterno); 
		$this->nPaginas = ceil($cantidad / $this->resultados);	
		return $this->ver('seleccionar_cotizacion_maquinas');	
	}
	
	public function listarmaquinasventa() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina 			= 1;
		$this->resultados 		= 20;
		$this->codinterno 		= $_GET['codigointerno'];
		$this->rutp 			= $_GET['rutp'];

		if(is_numeric($_GET['pagina']))
			$this->pagina = $_GET['pagina'];
			
		$cantidad = $this->maquinas->cantidadMaquinasCotizacion($this->codinterno, $this->rutp);		
	    $this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->rutp, $this->codinterno); 
		$this->nPaginas = ceil($cantidad / $this->resultados);	
		return $this->ver('seleccionar_cotizacion_maquinas_venta');	
	}	
	
	function editar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$idoc			= $_POST['numerooc'];
			$total			= $_POST['totalisimo'];
			$numfactura		= $_POST['numfactura']; 
			$ok = $this->orden->actualizarOC($idoc, $total, "total");
			if($ok)
			{
				$this->orden->actualizarOC($idoc, 1, "estado"); //Estado = Pendiente de factura (1)
				if(is_numeric($numfactura))
				{
					$this->orden->actualizarOC($idoc, $numfactura, "numfactura"); //Ingresar numero factura
					$this->orden->actualizarOC($idoc, 0, "estado"); //Estado = Completado (0)
				}
				$borrados	= $_POST['totales'];			
				$n        = count($borrados);
				$i        = 0;
				while ($i < $n){
					$this->orden->borrarinventarioOC($idoc, $borrados[$i]);
					$i++;
				}
					
				$this->info_msg  = $this->msg('completa', 'Orden de Compra', 2, 1, 1);
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al guardar la Orden de Compra, contacte al Administrador.');</script>";
			}
		}				
		$idoc = $_GET['idoc'];
		$this->oc = $this->orden->obtenerdatosOC($idoc);
		$this->listainventario = $this->orden->obtenerItemsInventarioOC($idoc);
		$this->listamaquinas = $this->orden->obtenerItemsMaqServOC($idoc);
		$this->contenido = $this->ver('editar_oc');
		return $this->ver('index');
	}

	/*****************************************************************************************************************/ 
	/*****************************************  DETALLE ORDEN COMPRA  *************************************************/
	/*****************************************************************************************************************/
	
	function detalle()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}		
		
		$idoc = $_GET['idoc'];
		$this->oc = $this->orden->obtenerdatosOC($idoc);
		$this->listainventario = $this->orden->obtenerItemsInventarioOC($idoc);
		$this->listamaqserv = $this->orden->obtenerItemsMaqServOC($idoc);
		$this->info_msg = "";
		$this->contenido = $this->ver('ver_oc');		
		return $this->ver('index');
	}
	
	/*****************************************************************************************************************/ 
	/*****************************************  DAR POR PAGADA ORDEN COMPRA  *************************************************/
	/*****************************************************************************************************************/
	
	function OCpagada()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc		= $_GET['idOC'];
		$this->orden->actualizarOC($idoc, 1, "estado"); // Cambiar a ESTADO = 1;
	}
	
	//Actualizar Stock
	function OCconfirmada()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc			= $_GET['idOC'];
		$numfactura		= $_GET['numfactura'];
		$this->orden->actualizarOC($idoc, 0, "estado"); // Cambiar a ESTADO = 0;		
		$this->orden->actualizarOC($idoc, $numfactura, "numfactura"); // Actualizar factura
		//Actualizar inventario
		$inventario = new Inventario();		
		$listainventario = $this->orden->obtenerProductosOC($idoc);
		if(count($listainventario )>0){
			foreach($listainventario as $li){
				$inventario->actualizarStock($li["IDproducto"], $li["cantidad"], '+', 'contteorico');
				$inventario->actualizarStock($li["IDproducto"], $li["cantidad"], '+', 'contreal');
			}
		}
	}
	
	function anular()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}		

		$idoc		= $_GET['idOC'];
		$this->orden->actualizarOC($idoc, 3, "estado"); // Cambiar a ESTADO = 3;
	}
	
	/* ORDEN COMPRA NUEVA MAQ o SERV */
	public function nuevoMaqServ()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		return $this->ver('nuevo_maqserv');
	}
}