﻿<?php
class SalidaInternaControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $salidainterna;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->salidainterna = new SalidaInterna($this->NX_CONFIG);
		$this->centroCosto = new CentroCosto($this->NX_CONFIG);
	}
    //</editor-fold>
	
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->numero = $this->salidainterna->obtenernumero()["numero"];
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}
	
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerosalidainterna  = $_POST["numerosalidainterna"] ?? null;
			
			$productoid		= $_POST['productoid'] ?? null;
			$prodcant		= $_POST['prodcant'] ?? null;
			$idCentroCosto          = $_POST['cencosto'] ?? null;
            $detalle                = $_POST['detalle'] ?? null;
		
			//Ingreso nuevo salidainterna salida
			$ok = $this->salidainterna->nuevo($numerosalidainterna, $idCentroCosto, $detalle);
			if($ok)
			{
				$inventario = new Inventario($this->NX_CONFIG);
				
				//Insumos y respuestos
				$n        = count($productoid);
				$i        = 0;
				while ($i < $n){
					$this->salidainterna->ingresarinventario($numerosalidainterna, $productoid[$i], $prodcant[$i]);
					//$inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contreal');
					$inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');
					$i++;
				}		 	
				
			header("Location: index.php?controlador=SalidaInterna&accion=nuevo&infomsg=si");
				return;		
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar Salida Interna, contacte al Administrador.');</script>";
			}
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'Salida Interna', 1, 0, 1);	
		}
		$this->listaresponsables = $this->salidainterna->listarResponsables();
		$this->listaCentroCosto = $this->centroCosto->listar();
		$this->contenido = $this->ver('nueva_salida_interna');
		return $this->ver('index');
	}

	public function seleccionar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}

		$this->pagina = 1;
		$this->resultados = 20;
		$this->buscar = $_GET['buscar'] ?? null;
		$this->orden = $_GET['orden'] ?? null;
		$this->rut = $_GET['rut'] ?? null;

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'IDsalidainterna';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'IDsalidainterna DESC';
			break;
			case 3:
				$ordenStr = 'Fecha';
			break;
			case 4:
				$ordenStr = 'Fecha DESC';
			break;	
		}
		
	$this->lista = $this->salidainterna->listar_salidainterna_cliente($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->rut, $ordenStr);	
	$cantidad = $this->salidainterna->cantidad_salidainterna_cliente($this->buscar, $this->rut)["cantidad"];
	$this->nPaginas = ceil($cantidad / $this->resultados);	
    return $this->ver('seleccionar_salidainterna');
	}
	
	public function ver_salidainterna_cliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$idsalidainterna = $_GET['idsalidainterna'] ?? null;
		$this->salidainternasalida = $this->salidainterna->obtenerdatossalidainterna($idsalidainterna);
		$this->listainventario = $this->salidainterna->obtenerInventariosalidainterna($idsalidainterna);
		$this->listamaquinas = $this->salidainterna->obtenerMaquinassalidainterna($idsalidainterna);
		$this->contenido = $this->ver('ver_salidainterna_cliente');
		return $this->ver('index');	
	}
	
	public function listar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->buscar 	= $_GET['buscar'] ?? null;
		$this->orden 	= $_GET['orden'] ?? null;
		$this->fecha1 	= $_GET['fecha1'] ?? null;
		$this->fecha2 	= $_GET['fecha2'] ?? null;

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'Fecha';
				$this->orden = 1;
			break;
			case 1:
				$ordenStr = 'Fecha';
			break;
			case 2:
				$ordenStr = 'Fecha DESC';
			break;
		}
		
		if($this->fecha1 !="" && $this->fecha2 !="")
		{
			list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
			$fecha2 = "$anio/$mes/$dia"; 
			
			$fechas= "and fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
		}
		
	$this->lista = $this->salidainterna->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null);
	$cantidad = $this->salidainterna->cantidad($this->buscar, $fechas ?? null);
	$this->nPaginas = ceil($cantidad / $this->resultados);	
    $this->contenido = $this->ver('listar_salidainterna');
	return $this->ver('index');	
	}

	public function listarParaDevolucionInsumos()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}

		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->buscar 		= $_GET['buscar'] ?? null;
		$this->idsalidainterna	= $_GET['idsalidainterna'] ?? null;
		$this->orden 		= $_GET['orden'] ?? null;

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'Fecha';
				$this->orden = 1;
			break;
			case 1:
				$ordenStr = 'Fecha';
			break;
			case 2:
				$ordenStr = 'Fecha DESC';
			break;
		}
		
	$this->lista = $this->salidainterna->listarPorId($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->idsalidainterna);	
	$cantidad = $this->salidainterna->cantidadPorID($this->buscar, $this->idsalidainterna)["cantidad"];
	$this->nPaginas = ceil($cantidad / $this->resultados);	
	return $this->ver('listar_salidainternaesSalidaParaDevolucionInsumos');	
	}
	
	
	}
?>