<?php
class ReportsControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $reports;
    var $clientes;
    var $maquinas;
    var $contadores;
    var $configuraciones;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->reports 			= new Reports($this->NX_CONFIG);
        $this->clientes			= new Clientes($this->NX_CONFIG);
        $this->maquinas			= new Maquinas($this->NX_CONFIG);
        $this->contadores		= new Contadores($this->NX_CONFIG);
        $this->configuraciones	= new Configuraciones($this->NX_CONFIG);
    }
    //</editor-fold>

    /************************      NUEVO REPORT         ************************/
    public function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->rutTaller = $this->configuraciones->getValor(IDCONFIG_RUT_TALLER);

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $idReport 				= $_POST['numeroreport'] ?? null;
            $rut 					= $_POST['rut'] ?? null; //cliente
            $serieInterna 			= $_POST['serieinterna'] ?? null; //DATOS DE LA MAQUINA
            $correlativo 			= $_POST['correlativo'] ?? null;
            $movimiento 			= $_POST['movimiento'] ?? null; //radio button seleccionado(número)
            $idreportlugarservicio  = $_POST['lugar'] ?? null; //radio button seleccionado(número) lugar donde se realiza el servicio
            $fecha 					= $_POST['fecha'] ?? null; //DATOS DEL REPORT
            $ubicacion 				= $_POST['ubicacion'] ?? null; //UBICACION
            $horaDespacho 			= $_POST['horadespacho'] ?? null;//DATOS DEL REPORT
            $horaLlegada	 		= $_POST['horallegada'] ?? null;//DATOS DEL REPORT
            $horaSalida 			= $_POST['horasalida'] ?? null;//DATOS DEL REPORT
            $ruttecnico 			= $_POST['ruttecnico'] ?? null;//DATOS DEL REPORT
            $contador 				= $_POST['contador'] ?? null;//DATOS DEL REPORT
            $contadorColor			= $_POST['contadorColor'] ?? null;//DATOS DEL REPORT
            $contadorScanner        = $_POST['contadorScanner'] ?? null;//DATOS DEL REPORT
            $detalle 				= $_POST['detalle'];//DATOS DEL REPORT
            $tipoServicioMaquina	= $_POST['tipoServicioMaquina'] ?? null;//DATOS DEL REPORT

            //PRODUCTOS UTILIZADOS
            $productoid		= $_POST['productoid'] ?? null;
            $prodcant		= $_POST['prodcant'] ?? null;

            $estadoretiro		= $_POST['estadoretiro'] ?? null;//RETIRO DE LA MAQUINA
            $observacionretiro	= $_POST['observacionretiro'] ?? null;//RETIRO DE LA MAQUINA
            $observacionmaqext	= $_POST['observacionmaqext'] ?? null;//SERVICIO MAQ EXTERNA
            $solucion			= $_POST['solucion'] ?? null;
            $falla				= $_POST['falla'] ?? null;
            $actTalonario = false;
            $inventario = new Inventario($this->NX_CONFIG);
            $llamado = new Llamados($this->NX_CONFIG);

            //Instalacion
            if($movimiento==1)
            {
                /*
                1. (REPORT)Se ingresa el report - tabla 'reports'
                2. (CLIENTE) Se obtiene un correlativo (numero de veces que posee la maquina el cliente) - tabla 'clientemaquina'
                3. (MAQUINAS) actualizar el estado de la maquina con el cliente actual a 0 - tabla 'clientemaquina'
                4. (CLIENTE) Asociar maquina al cliente - tabla 'clientemaquina' (estado = 1)
                6. (REPORT) se agregan los insumos utilizados - tabla 'reportinventario'
                7. (INVENTARIO) se actualiza el stock - tabla 'inventario'
                */

                //Se ingresa el REPORT
                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna,
                    $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento,
                    $detalle, -1, "", "",$tipoServicioMaquina,
                    $contadorColor, $contadorScanner, $idreportlugarservicio);
                $correlativo = $this->clientes->nextCorrelativoClienteMaquina($rut, $serieInterna)["correlativo"];

                if($ok)
                {
                    $this->maquinas->setEstadoHistorial($serieInterna); //Al antiguo due�o se le asigna un estado 0 (clientemaquina)
                    $this->clientes->agregarMaquina($rut, $serieInterna, $correlativo, $ubicacion); //Se le ingresa la maquina al nuevo cliente (clientemaquina)

                    //Agrega automaticamente a la tabla contadores 10/01/11
                    //$this->contadores->nuevo($rut, $serieInterna, $correlativo, 1, $fecha, $contador, 0, 0, $fecha, 1, "NULL", $idReport);

                    //Agregar los productos al report
                    $n        = count($productoid);
                    $i        = 0;
                    while ($i < $n){
                        $this->reports->agregarProducto($idReport , $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
                        $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                        $i++;
                    }

                    //Modificar los Llamados
                    for($i=0 ; $i<count($solucion) ; $i++)
                    {
                        if($solucion[$i]==1)
                        {
                            $llamado->cambiarestadollamado($falla[$i], $idReport);
                        }
                    }

                    $actTalonario = true;

                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
                }

            }

            //Retiro
            if($movimiento==2)
            {
                /*
                1. (REPORT)Se ingresa el report - tabla 'reports'
                2. (LLAMADOS) Llamados de la m�quina a pendiente = NO
                2. (CLIENTE) Se obtiene un correlativo (numero de veces que posee la maquina el cliente) - tabla 'clientemaquina'
                3. (MAQUINAS) actualizar el estado de la maquina con el cliente actual a 0 - tabla 'clientemaquina'
                4. (MAQUINAS) Si es facturada se actualiza el campo 'facturada' en 'clientemaquina'
                5. (CLIENTE) Asociar maquina a CSJ - tabla 'clientemaquina' (estado = 1)
                */

                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna,
                    $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento, $detalle, $estadoretiro,
                    $observacionretiro, $observacionmaqext,$tipoServicioMaquina,
                    $contadorColor, $contadorScanner, $idreportlugarservicio);

                if($ok)
                {
                    //Modificar los llamados a pendiente = NO
                    $llamados = new Llamados($this->NX_CONFIG);
                    $llamados->cambiarestado($rut, $serieInterna, $correlativo);

                    $correlativo = $this->clientes->nextCorrelativoClienteMaquina($this->rutTaller, $serieInterna)["correlativo"];	//Nuevo correlativo
                    $this->maquinas->setEstadoHistorial($serieInterna);//Al antiguo due�o se le asigna un estado 0 (clientemaquina)

                    //Colocar si es facturada o no
                    $this->maquinas->setEstadoFacturada($rut, $serieInterna, 0);

                    //Se le ingresa la maquina a CSJ (clientemaquina)
                    $this->clientes->agregarMaquina($this->rutTaller , $serieInterna, $correlativo, 'CSJ');

                    //Modificar los Llamados
                    for($i=0 ; $i<count($solucion) ; $i++)
                    {
                        if($solucion[$i]==1)
                        {
                            $llamado->cambiarestadollamado($falla[$i], $idReport);
                        }
                    }

                    $actTalonario = true; //Actualizar Talonario

                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al realizar el Retiro, contacte al Administrador.');</script>";
                }
            }

            //Mantenciones
            if($movimiento>=3 && $movimiento<=6)
            {
                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo,
                    $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento,
                    $detalle, -1, "", "",
                    $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);

                if($ok)
                {
                    //Agregar los productos al report
                    $n        = count($productoid);
                    $i        = 0;
                    while ($i < $n){
                        $this->reports->agregarProducto($idReport, $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
                        $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                        $i++;
                    }

                    //Modificar los Llamados
                    for($i=0 ; $i<count($solucion) ; $i++)
                    {
                        if($solucion[$i]==1)
                        {
                            $llamado->cambiarestadollamado($falla[$i], $idReport);
                        }
                    }

                    $actTalonario = true;

                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
                }
            }

            //Otros movimientos
            if($movimiento>=7 && $movimiento<=9)
            {
                if($movimiento == 7)//----> Entrega de Facturas
                {
                    $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico,
                        $contador, $fecha, $horaDespacho, $horaLlegada, $horaSalida, $movimiento,
                        $detalle, -1, "", "",
                        $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);
                }
                if($movimiento == 8)//-----> Servicio Maquina Externa (No hay serie interna por ser maquina externa)
                {
                    $ok = $this->reports->nuevo($idReport, $rut, "", 0, $ruttecnico, 0, $fecha,
                        $horaDespacho, $horaLlegada, $horaSalida, $movimiento,
                        $detalle, -1, "", $observacionmaqext,
                        $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);

                    // Agregado para crear salidas de insumos
                    if($ok)
                    {
                        //Agregar los productos al report
                        $n        = count($productoid);
                        $i        = 0;
                        while ($i < $n){
                            $this->reports->agregarProducto($idReport, $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
                            $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                            $i++;
                        }

                        //Modificar los Llamados
                        for($i=0 ; $i<count($solucion) ; $i++)
                        {
                            if($solucion[$i]==1)
                            {
                                $llamado->cambiarestadollamado($falla[$i], $idReport);
                            }
                        }

                        $actTalonario = true;

                    }else{//modificar el info msg
                        $this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
                    }
                    //Hasta aca para crear salidas de insumos
                }
                if($movimiento == 9)//---> Toma de Contador
                {
                    $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho,
                        $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", "",
                        $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);
                }

                //Modificar los Llamados
                for($i=0 ; $i<count($solucion) ; $i++)
                {
                    if($solucion[$i]==1)
                    {
                        $llamado->cambiarestadollamado($falla[$i], $idReport);
                    }
                }

                $actTalonario = true;

                if($ok)
                {
                    //$actTalonario = true; //Actualizar Talonario
                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
                }
            }

            //Mantenciones - Entrega de Insumos
            if($movimiento == 10) //------> Entrega de Insumos
            {
                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", "",
                    $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);

                if($ok)
                {
                    //Agregar los productos al report
                    $n        = count($productoid);
                    $i        = 0;
                    while ($i < $n){
                        $this->reports->agregarProducto($idReport, $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
                        $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                        $i++;
                    }

                    //Modificar los Llamados
                    for($i=0 ; $i<count($solucion) ; $i++)
                    {
                        if($solucion[$i]==1)
                        {
                            $llamado->cambiarestadollamado($falla[$i], $idReport);
                        }
                    }

                    $actTalonario = true;

                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
                }
            }

            //Retiro Maquina a Taller
            if($movimiento==11)
            {
                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento, $detalle, $estadoretiro, $observacionretiro, $observacionmaqext,
                    $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);

                if($ok)
                {
                    //Modificar los llamados a pendiente = NO
                    $llamados = new Llamados();
                    $llamados->cambiarestado($rut, $serieInterna, $correlativo);

                    $this->maquinas->actualizarUbicacionClienteMaquina($rut, $serieInterna, 'CSJ TALLER MANTENCION');

                    //Modificar los Llamados
                    for($i=0 ; $i<count($solucion) ; $i++)
                    {
                        if($solucion[$i]==1)
                        {
                            $llamado->cambiarestadollamado($falla[$i], $idReport);
                        }
                    }

                    $actTalonario = true; //Actualizar Talonario

                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al realizar el Retiro a Taller Mantención, contacte al Administrador.');</script>";
                }
            }

            //Devolucion Maquina de Taller a Cliente
            if($movimiento==12)
            {
                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento, $detalle, $estadoretiro, $observacionretiro, $observacionmaqext,
                    $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);

                if($ok)
                {
                    //Modificar los llamados a pendiente = NO
                    $llamados = new Llamados();
                    $llamados->cambiarestado($rut, $serieInterna, $correlativo);

                    $this->maquinas->actualizarUbicacionClienteMaquina($rut, $serieInterna, $ubicacion);

                    //Agregar los productos al report
                    $n        = count($productoid);
                    $i        = 0;
                    while ($i < $n){
                        $this->reports->agregarProducto($idReport, $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
                        $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                        $i++;
                    }

                    //Modificar los Llamados
                    for($i=0 ; $i<count($solucion) ; $i++)
                    {
                        if($solucion[$i]==1)
                        {
                            $llamado->cambiarestadollamado($falla[$i], $idReport);
                        }
                    }

                    $actTalonario = true; //Actualizar Talonario

                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al realizar la Devolución de la Máquina, contacte al Administrador.');</script>";
                }
            }

            //Configuracion
            if($movimiento==13)
            {
                //Se ingresa el REPORT
                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", "",
                    $tipoServicioMaquina,$contadorColor, $contadorScanner, $idreportlugarservicio);

                if($ok)
                {
                    //Agrega automaticamente a la tabla contadores 10/01/11
                    //$this->contadores->nuevo($rut, $serieInterna, $correlativo, 1, $fecha, $contador, 0, 0, $fecha, 1, "NULL", $idReport);

                    //Agregar los productos al report
                    $n        = count($productoid);
                    $i        = 0;
                    while ($i < $n){
                        $this->reports->agregarProducto($idReport , $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
                        $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                        $i++;
                    }

                    //Modificar los Llamados
                    for($i=0 ; $i<count($solucion) ; $i++)
                    {
                        if($solucion[$i]==1)
                        {
                            $llamado->cambiarestadollamado($falla[$i], $idReport);
                        }
                    }

                    $actTalonario = true;
                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
                }
            }

            //Asistencia Remota Conex Comp Visita Cortesia
            if($movimiento>=14 AND $movimiento<=16)
            {
                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo, $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento, $detalle, -1, "", "",
                    $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);

                if($ok)
                {
                    //Agregar los productos al report
                    $n        = count($productoid);
                    $i        = 0;
                    while ($i < $n){
                        $this->reports->agregarProducto($idReport, $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
                        $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                        $i++;
                    }

                    //Modificar los Llamados
                    for($i=0 ; $i<count($solucion) ; $i++)
                    {
                        if($solucion[$i]==1)
                        {
                            $llamado->cambiarestadollamado($falla[$i], $idReport);
                        }
                    }

                    $actTalonario = true;

                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
                }
            }

            //Reubicacion en Cliente
            if($movimiento==17)
            {
                $ok = $this->reports->nuevo($idReport, $rut, $serieInterna, $correlativo,
                    $ruttecnico, $contador, $fecha, $horaDespacho,
                    $horaLlegada, $horaSalida, $movimiento,
                    $detalle, -1, "", "",
                    $tipoServicioMaquina, $contadorColor, $contadorScanner, $idreportlugarservicio);

                if($ok)
                {
                    //Agregar los productos al report
                    $n = 0;
                    if(isset($productoid) && count($productoid)>0)
                    {
                        $n        = count($productoid);
                    }

                    $i        = 0;

                    while ($i < $n){
                        $this->reports->agregarProducto($idReport, $productoid[$i], $prodcant[$i]);//REPORTINVENTARIO
                        $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                        $i++;
                    }

                    $this->maquinas->actualizarUbicacionClienteMaquina($rut, $serieInterna, $ubicacion);

                    //Modificar los Llamados
                    if(isset($solucion) && count($solucion)>0)
                    {
                        for($i=0 ; $i<count($solucion) ; $i++)
                        {
                            if($solucion[$i]==1)
                            {
                                $llamado->cambiarestadollamado($falla[$i], $idReport);
                            }
                        }
                    }

                    $actTalonario = true;

                }else{//modificar el info msg
                    $this->info_msg = "<script>alert('Error al ingresar el Report, contacte al Administrador.');</script>";
                }
            }

            //ACTUALIZAR TALONARIO
            $talonarioactual = new ReportTalonario($this->NX_CONFIG);
            $talonarionuevo = new ReportTalonario($this->NX_CONFIG);
            $talonario = new ReportTalonario($this->NX_CONFIG);
            if($actTalonario)
            {
                $talonarioactual = $talonario->obtenertalonarioactual($ruttecnico);
                if($idReport == $talonarioactual["numfinal"])
                {
                    //nuevo numero actual es igual al numero final del talonario
                    $talonario->cambiarestado($talonarioactual["IDtalonario"], 3); //talonario actual se acabo (estado 3: usado)
                    $talonarionuevo = $talonario->obtenernuevotalonario($ruttecnico)["numero_talonario"];
                    if(isset($talonarionuevo))
                    {
                        $talonario->cambiarestado($talonarionuevo, 1); //talonario en cola pasa a ser actual
                    }else{
                        //echo "no hay talonarios 2";
                    }
                }else{//nuevo numero actual dentro del rango
                    $talonario->cambiarnumeroactual($talonarioactual["IDtalonario"], $idReport+1);
                }
                header("Location: index.php?controlador=Reports&accion=inicio&infomsg=yes");
                return;
            }
        }

        $rut  = $_GET['rut'];
        $user = new Usuarios($this->NX_CONFIG);
        $this->datostecnico = $user->obtenerDatos($rut);
        $rtalonario = new ReportTalonario($this->NX_CONFIG);
        $talact = $rtalonario->obtenertalonarioactual($rut);
        $this->number = $talact["numactual"] ?? 0;
        $this->contenido = $this->ver('nuevo_report');
        return $this->ver('index');
    }

    /************************      INICIO         ************************/
    public function inicio()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=7 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            //Entra a esta secci�n de codigo si se anular� el Report (sea uno o el talonario completo)
            $rut 		= $_POST['rut'] ?? null;
            $razon 		= $_POST['detalle'] ?? null;
            $numactual 	= $_POST['numeroreport'] ?? null;
            $tipo		= $_POST['tipo'] ?? null; // 1:solo el report, 0:Todo el talonario

            $talonario = new ReportTalonario($this->NX_CONFIG);
            $actual = $talonario->obtenertalonarioactual($rut);

            if($tipo==0)//Anular Talonario
            {
                $ok = $talonario->ingresaranulado($actual["IDtalonario"],$actual["numactual"]."-".$actual["numfinal"],$razon);//Insert Anulado
                if($ok)
                {
                    $talonario->cambiarestado($actual["IDtalonario"],4);//talonario actual a estado anulado (4)
                    $talonarionuevo = $talonario->obtenernuevotalonario($rut)["numero_talonario"];//Obtener talonario en cola, si corresponde
                    if(isset($talonarionuevo))
                    {
                        $talonario->cambiarestado($talonarionuevo, 1); //talonario en cola pasa a ser actual
                    }else{
                        //T�cnico no posee talonarios en cola
                    }
                    header("Location: index.php?controlador=Reports&accion=inicio&infomsg=si&key=Talonario");
                    return;
                }
            }

            if($tipo==1)//Anular Report
            {
                $ok = $talonario->ingresaranulado($actual["IDtalonario"],$actual["numactual"],$razon);//Insert Anulado
                if($ok)
                {
                    if($numactual==$actual["numfinal"])
                    {
                        $talonario->cambiarestado($actual["IDtalonario"],3);//talonario actual a estado anulado (4)
                        $talonarionuevo = $talonario->obtenernuevotalonario($rut)["numero_talonario"];//Obtener talonario en cola, si corresponde
                        if(isset($talonarionuevo))
                        {
                            $talonario->cambiarestado($talonarionuevo, 1); //talonario en cola pasa a ser actual
                        }else{
                            //tecnico sin talonarios
                        }
                    }else{
                        $talonario->cambiarnumeroactual($actual["IDtalonario"], $numactual+1);
                    }
                    header("Location: index.php?controlador=Reports&accion=inicio&infomsg=si&key=Report");
                    return;
                }
            }
        }

        if(isset($_GET["infomsg"]) &&  $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', $_GET["key"], 4, 0, 1);
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="yes")
        {
            $this->info_msg  = $this->msg('completa', 'Report', 1, 0, 1);
        }

        $this->contenido = $this->ver('inicio_report');
        return $this->ver('index');
    }

    /************************      SELECCIONAR POR CLIENTE MAQUINA         ************************/
    //Al seleccionar IngresarContador -> Report
    public function seleccionarByClienteMaquina()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->rut 					= $_GET['rut'] ?? null;
        $this->serieInterna 		= $_GET['serieinterna'] ?? null;
        $this->correlativo 			= $_GET['correlativo'] ?? null;
        $this->tipoServicioMaquina	= $_GET['tipoServicioMaquina'] ?? null;

        $this->lista 		= $this->reports->getByClienteMaquina($this->rut, $this->serieInterna, $this->correlativo);

        return $this->ver('seleccionar_report_contador');
    }

    /************************      LISTAR         ************************/
    public function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=2 && $_SESSION['area']!=7 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n


        //$this->buscar = (!isset($_GET['']) ? "" : $_GET['']);
        $this->cliente 		= (!isset($_GET['cliente']) ? "" : $_GET['cliente']);
        $this->maquina 		= (!isset($_GET['maquina']) ? "" : $_GET['maquina']);
        $this->tecnico 		= (!isset($_GET['tecnico']) ? "" : $_GET['tecnico']);
        $this->numreport	= (!isset($_GET['numreport']) ? "" : $_GET['numreport']);
        $this->fecha1 		= (!isset($_GET['fecha1']) ? "" : $_GET['fecha1']);
        $this->fecha2 		= (!isset($_GET['fecha2']) ? "" : $_GET['fecha2']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        if($this->cliente != "" || $this->maquina != "" || $this->tecnico !="" || $this->fecha1 !="" || $this->numreport != "")
        {
            if($this->fecha1 !="" && $this->fecha2 !="")
            {
                list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
                $fecha1 = "$anio/$mes/$dia";
                list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
                $fecha2 = "$anio/$mes/$dia";

                $fechas= "AND reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
            }

            $this->cantidad = $this->reports->cantidadlistar(
                $this->cliente,
                $this->maquina,
                $this->tecnico,
                $fechas ?? null ,
                $this->numreport)["cantidad"];
            $this->lista = $this->reports->listar(
                $this->resultados * ($this->pagina-1),
                $this->resultados,
                $this->cliente,
                $this->maquina,
                $this->tecnico,
                $fechas?? null,
                $this->numreport);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }else
        {
            $this->cantidad = $this->reports->cantidadlistarTodos()["cantidad"];
            $this->lista = $this->reports->listarTodos($this->resultados * ($this->pagina-1), $this->resultados);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }

        $this->contenido = $this->ver('listar_reports');
        return $this->ver('index');
    }

    /************************      DETALLE         ************************/
    public function detalle()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=2 && $_SESSION['area']!=7 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idreport	= $_GET['idreport'];
        $this->detalles = $this->reports->detalle($idreport);
        $this->cliente = $this->clientes->obtenerDatos($this->detalles["rut"]);
        $usuario = new Usuarios($this->NX_CONFIG);
        $this->tecnico = $usuario->obtenerDatos($this->detalles["tecnico"]);
        $this->maquina = $this->maquinas->obtenerDatos($this->detalles["serieinterna"]);
        $llamado = new Llamados($this->NX_CONFIG);
        $this->listallamadosresueltos = $llamado->listarLlamadosResueltos($idreport);
        $this->productos = $this->reports->productosReport($idreport);
        return $this->ver('ver_detalle_reports');
    }

    // 20/01/11
    public function editar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5 and $_SESSION['area']!=8)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numeroot		= $_POST['numeroot'] ?? null;
            $numerobol		= $_POST['numerobol'] ?? null;
            $rut			= $_POST['rut'] ?? null;
            $totalneto		= $_POST['totalnetosf'] ?? null;
            $responsable	= $_POST['resp'] ?? null;

            $this->OT->actualizarOT($numeroot, $rut, $numerobol, $totalneto, $responsable);

            $filas			= $_POST['pos'] ?? null;
            $servicios		= $_POST['desc'] ?? null;
            $cantorig		= $_POST['cantorig'] ?? null;
            $coporig		= $_POST['coporig'] ?? null;
            $unidades		= $_POST['unidades'] ?? null;
            $precios		= $_POST['preciosf'] ?? null;

            $n = count($filas);
            $i = 0;
            while ($i < $n){
                $this->OT->actualizarServicios($filas[$i], $servicios[$i], $cantorig[$i], $coporig[$i], $unidades[$i], $precios[$i]);
                $i++;
            }
            header("Location: index.php?controlador=OT&accion=iniciolistar&infomsg=si");
            return;
        }
        $idreport = $_GET['idreport'];
        $this->detalles = $this->reports->detalle($idreport);
        $this->cliente = $this->clientes->obtenerDatos($this->detalles["rut"]);
        $usuario = new Usuarios();
        $this->tecnico = $usuario->obtenerDatos($this->detalles["tecnico"]);
        $this->maquina = $this->maquinas->obtenerDatos($this->detalles["serieinterna"]);
        $llamado = new Llamados();
        $this->listallamadosresueltos = $llamado->listarLlamadosResueltos($idreport);
        $this->productos = $this->reports->productosReport($idreport);
        $this->ubicacion = $this->reports->ubicacionMaquina($this->detalles["rut"], $this->detalles["serieinterna"]);

        $this->contenido = $this->ver('editar_report');
        return $this->ver('index');
    }

    /********************* LISTAR REPORTS REPETIDOS *********************/
    public function listarReportsRepetidos()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=2 && $_SESSION['area']!=7 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->cliente 		= $_GET['cliente'] ?? null ;
        $this->maquina 		= $_GET['maquina'] ?? null ;
        $this->fecha1 		= $_GET['fecha1'] ?? null;
        $this->fecha2 		= $_GET['fecha2'] ?? null;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        if($this->cliente != "" || $this->maquina != "" || $this->fecha1 !="")
        {
            if($this->fecha1 !="" && $this->fecha2 !="")
            {
                list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
                $fecha1 = "$anio/$mes/$dia";
                list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
                $fecha2 = "$anio/$mes/$dia";

                $fechas= "AND reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
            }

            $this->cantidad = $this->reports->cantidadlistarReportsRepetidos(
                $this->cliente,
                $this->maquina,
                $fechas ?? null
            );

            $this->cantidad = 1;

            $this->listaClaves = $this->reports->listarReportsRepetidosClaves(
                $this->cliente,
                $this->maquina,
                $fechas ?? null
            );

            foreach($this->listaClaves as $r):

                $this->listaTemporal = $this->reports->listarReportsRepetidos(
                    $this->resultados * ($this->pagina-1),
                    $this->resultados,
                    $r["rut"],
                    $r["serieinterna"],
                    $fechas
                );

                array_push($this->listaTemporal2,$this->listaTemporal);
            endforeach;
            $this->lista = $this->listaTemporal2;

            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }else
        {
            $this->cantidad = $this->reports->cantidadlistarTodosReportsRepetidos();
            $this->lista = $this->reports->listarTodosReportsRepetidos($this->resultados * ($this->pagina-1), $this->resultados);

            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }

        $this->contenido = $this->ver('listar_reports_repetidos');
        return $this->ver('index');
    }

}
?>