<?php
class ReportabilidadControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $reportabilidad;
    var $configuraciones;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->reportabilidad   = new Reportabilidad($this->NX_CONFIG);
        $this->configuraciones	= new Configuraciones($this->NX_CONFIG);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteUsoInsumoMensual">
    function reporteUsoInsumoMensual()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $clausulaIdProducto = "";
        $fechas = "";

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->idproducto	= (!isset($_GET['idproducto']) ? null : $_GET['idproducto']);
        $this->codinterno   = (!isset($_GET['idproducto']) ? null : $_GET['idproducto']);
        $this->fecha1 		= (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 		= (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        if ($this->idproducto != "")
        {
            $clausulaIdProducto = " and inventario.codinterno = '" . $this->idproducto . "' ";
        }

        if($this->fecha1 !="" )
        {
            if($this->fecha1 !="" && $this->fecha2 !="")
            {
                list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
                $fecha1 = "$anio/$mes/$dia";
                list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
                $fecha2 = "$anio/$mes/$dia";

                $fechas= "WHERE reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
            }

            $this->cantidad = $this->reportabilidad->cantidadReporteUsoInsumoMensual($fechas, $clausulaIdProducto)["cantidad"];
            $this->lista = $this->reportabilidad->reporteUsoInsumoMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdProducto);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }
        else
        {
            //Obtenemos el Primer Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));

            //Obtenemos el Ultimo Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $day = date("d", mktime(0,0,0, $month+1, 0, $year));
            $fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));

            $fechas= "WHERE reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";

            $this->cantidad = $this->reportabilidad->cantidadReporteUsoInsumoMensual($fechas, $clausulaIdProducto)["cantidad"];
            $this->lista = $this->reportabilidad->reporteUsoInsumoMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdProducto);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }

        $this->contenido = $this->ver('reportabilidadUsoInsumoMensual');
        return $this->ver('index');

    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteCantidadMaquinaMensual">
    function reporteCantidadMaquinaMensual()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $clausulaIdMaquina = "";
        $fechas = "";

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada pagina
        $this->pagVisible = 8; //paginas a mostrar en la paginacion

        $this->idmaquina	= (!isset($_GET['idmaquina']) ? null : $_GET['idmaquina']);
        $this->codinterno   = (!isset($_GET['idmaquina']) ? null : $_GET['idmaquina']);
        $this->fecha1 		= (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 		= (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        if ($this->idmaquina != "")
        {
            $clausulaIdMaquina = " and maquinas.serieinterna = '" . $this->idmaquina . "' ";
        }

        if($this->fecha1 !="" )
        {
            if($this->fecha1 !="" && $this->fecha2 !="")
            {
                list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
                $fecha1 = "$anio/$mes/$dia";
                list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
                $fecha2 = "$anio/$mes/$dia";
                $fechas= " and fechacompra BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
            }

            $this->cantidad = count($this->reportabilidad->cantidadReporteCantidadMaquinaMensual($fechas ?? null, $clausulaIdMaquina ?? null) ?? []);
            $this->lista = $this->reportabilidad->reporteCantidadMaquinaMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas ?? null, $clausulaIdMaquina ?? null);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }
        else
        {
            //Obtenemos el Primer Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));

            //Obtenemos el Ultimo Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $day = date("d", mktime(0,0,0, $month+1, 0, $year));
            $fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));

            $fechas= " and fechacompra BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";

            $this->cantidad = count($this->reportabilidad->cantidadReporteCantidadMaquinaMensual($fechas, $clausulaIdMaquina ?? null));
            $this->lista = $this->reportabilidad->reporteCantidadMaquinaMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdMaquina ?? null);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }

        $this->contenido = $this->ver('reportabilidadCantidadMaquinaMensual');
        return $this->ver('index');

    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteComprasCategoriaMensual">
    function reporteComprasCategoriaMensual()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $clausulaIdProducto = "";
        $fechas = "";
        $whereCat = "";
        $whereTip = "";

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada pagina
        $this->pagVisible = 8; //paginas a mostrar en la paginacion

        $this->idproducto	= (!isset($_GET['idproducto']) ? null : $_GET['idproducto']);
        $this->codinterno   = (!isset($_GET['idproducto']) ? null : $_GET['idproducto']);
        $this->fecha1 		= (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 		= (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->filtrocat = (!isset($_GET['categoria']) ? null : $_GET['categoria']);
        $this->filtrotipo = (!isset($_GET['tipo']) ? null : $_GET['tipo']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        if ($this->idproducto != "")
        {
            $clausulaIdProducto = " and ocitems.idproducto = '" . $this->idproducto . "' ";
        }

        switch($this->filtrocat)
        {
            default:
                $whereCat = ' AND inventario.categoria='.$this->filtrocat;
                break;
            case 0:
                $whereCat = '';
                break;
        }

        switch($this->filtrotipo)
        {
            default:
                $whereTip = '';
                break;
            case 1: //Insumos
                $whereTip = " AND inventario.tipo='Insumo'";
                break;
            case 2: //Repuestos
                $whereTip = " AND inventario.tipo='Repuesto'";
                break;
        }

        if($this->fecha1 !="" )
        {
            if($this->fecha1 !="" && $this->fecha2 !="")
            {
                list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
                $fecha1 = "$anio/$mes/$dia";
                list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
                $fecha2 = "$anio/$mes/$dia";
                $fechas= " and oc.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
            }

            $this->cantidad = count($this->reportabilidad->cantidadComprasCategoriaMensual($fechas, $clausulaIdProducto, $whereCat, $whereTip) ?? []);
            $this->lista = $this->reportabilidad->reporteComprasCategoriaMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdProducto, $whereCat, $whereTip);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }
        else
        {
            //Obtenemos el Primer Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));

            //Obtenemos el Ultimo Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $day = date("d", mktime(0,0,0, $month+1, 0, $year));
            $fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));

            $fechas= " and oc.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";

            $this->cantidad = count($this->reportabilidad->cantidadComprasCategoriaMensual($fechas, $clausulaIdProducto, $whereCat, $whereTip));
            $this->lista = $this->reportabilidad->reporteComprasCategoriaMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdProducto, $whereCat, $whereTip);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }

        $categoriasInv = new Categorias($this->NX_CONFIG);
        $this->categorias = $categoriasInv->listar();

        $this->contenido = $this->ver('reportabilidadComprasCategoriaMensual');
        return $this->ver('index');

    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteDevolucionInsumoMensual">
    function reporteDevolucionInsumoMensual()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->rutTaller = $this->configuraciones->getValor(IDCONFIG_RUT_TALLER);
        $clausulaIdProducto = "";

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->idproducto	= (!isset($_GET['idproducto']) ? null : $_GET['idproducto']);
        $this->codinterno   = (!isset($_GET['idproducto']) ? null : $_GET['idproducto']);
        $this->fecha1 		= (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 		= (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada pagina
        $this->pagVisible = 8; //paginas a mostrar en la paginacion

        $this->idproducto	= $_GET['idproducto'] ?? null;
        $this->codinterno   = $_GET['idproducto'] ?? null;
        $this->fecha1 		= $_GET['fecha1'] ?? null;
        $this->fecha2 		= $_GET['fecha2'] ?? null;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        if ($this->idproducto != "")
        {
            $clausulaIdProducto = " and inventario.codinterno = '" . $this->idproducto . "' ";
        }

        if($this->fecha1 !="" )
        {
            if($this->fecha1 !="" && $this->fecha2 !="")
            {
                list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
                $fecha1 = "$anio/$mes/$dia";
                list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
                $fecha2 = "$anio/$mes/$dia";

                $fechas= " controldevolucioninventario.fechaDevolucionReal BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
            }

            $this->cantidad = $this->reportabilidad->cantidadReporteDevolucionInsumoMensual($fechas ?? null, $clausulaIdProducto)["cantidad"];
            $this->lista = $this->reportabilidad->reporteDevolucionInsumoMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdProducto);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }
        else
        {
            //Obtenemos el Primer Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));

            //Obtenemos el Ultimo Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $day = date("d", mktime(0,0,0, $month+1, 0, $year));
            $fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));

            $fechas= " controldevolucioninventario.fechaDevolucion BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";

            $this->cantidad = $this->reportabilidad->cantidadReporteDevolucionInsumoMensual($fechas, $clausulaIdProducto)["cantidad"];
            $this->lista = $this->reportabilidad->reporteDevolucionInsumoMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdProducto);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }

        $this->contenido = $this->ver('reportabilidadDevolucionInsumoMensual');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteCentroCostoInsumoMensual">
    function reporteCentroCostoInsumoMensual()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $clausulaIdProducto = "";
        $clausulaCliente = "";
        $clausulaIdCentroCosto = "";

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->idproducto	 = (!isset($_GET['idproducto']) ? null : $_GET['idproducto']);
        $this->codinterno    = (!isset($_GET['idproducto']) ? null : $_GET['idproducto']);
        $this->fecha1 		 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 		 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);
        $this->cliente		 = (!isset($_GET['cliente']) ? null : $_GET['cliente']);
        $this->idcentrocosto = (!isset($_GET['idcentrocosto']) ? null : $_GET['idcentrocosto']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        if ($this->idproducto != "")
        {
            $clausulaIdProducto = " and codinterno like '%" . $this->idproducto . "%' ";
        }

        if ($this->cliente != "")
        {
            $clausulaCliente = " and razonsocial like '%" . $this->cliente . "%' ";
        }

        if ($this->idcentrocosto > 0)
        {
            $clausulaIdCentroCosto = " and idCentroCosto = '" . $this->idcentrocosto . "' ";
        }

        if($this->fecha1 !="" )
        {
            if($this->fecha1 !="" && $this->fecha2 !="")
            {
                list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
                $fecha1 = "$anio/$mes/$dia";
                list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
                $fecha2 = "$anio/$mes/$dia";

                $fechas= " fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
            }

            $this->cantidad = $this->reportabilidad->cantidadReporteCentroCostoInsumoMensual($fechas ?? null, $clausulaIdProducto, $clausulaCliente ?? null, $clausulaIdCentroCosto ?? null);
            $this->lista = $this->reportabilidad->reporteCentroCostoInsumoMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas ?? null, $clausulaIdProducto, $clausulaCliente ?? null, $clausulaIdCentroCosto ?? null);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }
        else
        {
            //Obtenemos el Primer Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $fecha1= date('Y/m/d', mktime(0,0,0, $month, 1, $year));

            //Obtenemos el Ultimo Dia del Mes Actual
            $month = date('m');
            $year = date('Y');
            $day = date("d", mktime(0,0,0, $month+1, 0, $year));
            $fecha2= date('Y/m/d', mktime(0,0,0, $month, $day, $year));

            $fechas= " fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";

            $this->cantidad = $this->reportabilidad->cantidadReporteCentroCostoInsumoMensual($fechas, $clausulaIdProducto, $clausulaCliente, $clausulaIdCentroCosto ?? null);
            $this->lista = $this->reportabilidad->reporteCentroCostoInsumoMensual($this->resultados * ($this->pagina-1), $this->resultados, $fechas, $clausulaIdProducto, $clausulaCliente, $clausulaIdCentroCosto ?? null);
            $this->nPaginas = ceil( $this->cantidad / $this->resultados);
        }

        $this->contenido = $this->ver('reportabilidadCentroCostoInsumoMensual');
        return $this->ver('index');

    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteServiciosCliente">
    function reporteServiciosCliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $cliente = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada pagina
        $this->pagVisible = 8; //paginas a mostrar en la paginacion

        $this->cliente	= (!isset($_GET['cliente']) ? null : $_GET['cliente']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        if (strlen($this->cliente) == 0)
        {
            $this->cliente = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        }
        else
        {
            $cliente = $this->cliente;
        }

        $this->cantidad = count($this->reportabilidad->cantidadReporteServiciosCliente($cliente) ?? []);
        $this->lista = $this->reportabilidad->reporteServiciosCliente($this->resultados * ($this->pagina-1), $this->resultados, $cliente);
        $this->nPaginas = ceil( $this->cantidad / $this->resultados);

        $this->contenido = $this->ver('reportabilidadServiciosCliente');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : reporteGestionHorasLlamadoReporte">
    function reporteGestionHorasLlamadoReporte()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $cliente = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->cliente	= (!isset($_GET['cliente']) ? null : $_GET['cliente']);

        $this->fecha1 		= (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 		= (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        $this->idReport = (!isset($_GET['idReport']) ? null : $_GET['idReport']);
        $this->idllamado = (!isset($_GET['idllamado']) ? null : $_GET['idllamado']);

        $idllamadoWhere = "";
        $idReportWhere = "";
        $ordenStr = "";
        $fechas = "";

        if($this->idllamado != "")
        {
            $idllamadoWhere = " AND llamados.idllamado = ".$this->idllamado." ";
        }

        if($this->idReport != "")
        {
            $idReportWhere = " AND llamados.report = ".$this->idReport." ";
        }

        if($this->fecha1 != "" && $this->fecha2 != "")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
            $fecha2 = "$anio/$mes/$dia";
            $fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
        }

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        if ( $this->cliente != "")
        {
            $cliente = $this->cliente;
        }

        $this->lista = $this->reportabilidad->reporteGestionHorasLlamadoReporte($this->resultados * ($this->pagina-1), $this->resultados, $this->cliente, $ordenStr ?? null, $fechas ?? null, $idReportWhere, $idllamadoWhere);
        $this->cantidad = $this->reportabilidad->cantidadReporteGestionHorasLlamadoReporte($this->cliente, $fechas ?? null, $idReportWhere, $idllamadoWhere);
        $this->nPaginas = ceil( $this->cantidad / $this->resultados);

        $this->contenido = $this->ver('reportabilidadGestionHorasLlamadoReporte');
        return $this->ver('index');
    }
    //</editor-fold>
}
?>