<?php
class RebajaInsumoControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $rebajainsumo;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->rebajainsumo = new RebajaInsumo($this->NX_CONFIG);
        $this->centroCosto = new CentroCosto($this->NX_CONFIG);
    }
    //</editor-fold>

    public function obtenernumero()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }
        $this->numero = $this->rebajainsumo->obtenernumero()["numero"];
        return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
    }

    public function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerorebajainsumo  = $_POST["numerorebajainsumo"] ?? null;

            $productoid		= $_POST['productoid'] ?? null;
            $prodcant		= $_POST['prodcant'] ?? null;
            $idCentroCosto  = $_POST['cencosto'] ?? null;

            //Ingreso nuevo rebajainsumo salida
            $ok = $this->rebajainsumo->nuevo($numerorebajainsumo, $idCentroCosto, null);
            if($ok)
            {
                $inventario = new Inventario($this->NX_CONFIG);

                //Insumos y respuestos
                $n        = count($productoid);
                $i        = 0;
                while ($i < $n){
                    $this->rebajainsumo->ingresarinventario($numerorebajainsumo, $productoid[$i], $prodcant[$i]);
                    $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contreal');
                    $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');
                    $i++;
                }

                header("Location: index.php?controlador=rebajainsumo&accion=nuevo&infomsg=si");
                return;

            }else{//modificar el info msg
                $this->info_msg = "<script>alert('Error al ingresar Rebaja Insumo, contacte al Administrador.');</script>";
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Rebaja Insumo', 1, 0, 1);
        }
        $this->listaresponsables = $this->rebajainsumo->listarResponsables();
        $this->listaCentroCosto = $this->centroCosto->listar();
        $this->contenido = $this->ver('nueva_rebajainsumo');
        return $this->ver('index');
    }

    public function seleccionar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->rut = (!isset($_GET['rut']) ? null : $_GET['rut']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'IDsalidainterna';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'IDsalidainterna DESC';
                break;
            case 3:
                $ordenStr = 'Fecha';
                break;
            case 4:
                $ordenStr = 'Fecha DESC';
                break;
        }

        $this->lista = $this->rebajainsumo->listar_salidainterna_cliente($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->rut, $ordenStr);
        $cantidad = $this->rebajainsumo->cantidad_salidainterna_cliente($this->buscar, $this->rut)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_salidainterna');
    }

    public function ver_salidainterna_cliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $idsalidainterna = $_GET['idsalidainterna'];
        $this->salidainternasalida = $this->rebajainsumo->obtenerdatossalidainterna($idsalidainterna);
        $this->listainventario = $this->rebajainsumo->obtenerInventariosalidainterna($idsalidainterna);
        $this->listamaquinas = $this->rebajainsumo->obtenerMaquinassalidainterna($idsalidainterna);
        $this->contenido = $this->ver('ver_salidainterna_cliente');
        return $this->ver('index');
    }

    public function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->fecha1 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        $fechas = "";

        switch($this->orden)
        {
            default:
                $ordenStr = 'Fecha';
                $this->orden = 1;
                break;
            case 1:
                $ordenStr = 'Fecha';
                break;
            case 2:
                $ordenStr = 'Fecha DESC';
                break;
        }

        if($this->fecha1 !="" && $this->fecha2 !="")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
            $fecha2 = "$anio/$mes/$dia";

            $fechas= "and fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
        }
        $this->lista = $this->rebajainsumo->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null);
        $cantidad = $this->rebajainsumo->cantidad($this->buscar, $fechas ?? null);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_rebajainsumo');
        return $this->ver('index');
    }

    public function listarParaDevolucionInsumos()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->idsalidainterna = (!isset($_GET['idsalidainterna']) ? null : $_GET['idsalidainterna']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        switch($this->orden)
        {
            default:
                $ordenStr = 'Fecha';
                $this->orden = 1;
                break;
            case 1:
                $ordenStr = 'Fecha';
                break;
            case 2:
                $ordenStr = 'Fecha DESC';
                break;
        }

        $this->lista = $this->rebajainsumo->listarPorId($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->idsalidainterna);
        $cantidad = $this->rebajainsumo->cantidadPorID($this->buscar, $this->idsalidainterna)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_salidainternaesSalidaParaDevolucionInsumos');
    }
}
?>