<?php

class ProveedorControlador extends controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $proveedor;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->proveedor = new Proveedor($this->NX_CONFIG);
    }
    //</editor-fold>
	
    public function listarproductos() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina 			= 1;
		$this->resultados 		= 20;
		$this->codinterno 		= $_GET['codigointerno'] ?? null;
		$this->rutp 			= $_GET['rutp'] ?? null;

		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$cantidad = $this->proveedor->cantidadproductos($this->codinterno, $this->rutp);
	    $this->lista = $this->proveedor->listarproductos($this->resultados * ($this->pagina-1), $this->resultados, $this->rutp, $this->codinterno); 
		$this->nPaginas = ceil($cantidad / $this->resultados);	
		return $this->ver('seleccionar_items');	
	}

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
	public function seleccionar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->orden)
		{
			default:
				$ordenStr = 'razonsocial';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'razonsocial DESC';
			break;
			case 3:
				$ordenStr = 'rut';
			break;
			case 4:
				$ordenStr = 'rut DESC';
			break;	
		}
		
		$this->lista = $this->proveedor->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		$cantidad = $this->proveedor->cantidad($this->buscar)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);		
		return $this->ver('seleccionar_proveedor');	
	}
    //</editor-fold>
	
	/* 04/01/2010 */
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		$this->pagina = 1;
		$this->resultados = 20;
        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

		switch($this->orden)
		{
			default:
				$ordenStr = 'razonsocial';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'razonsocial DESC';
			break;
			case 3:
				$ordenStr = 'CAST(rut as UNSIGNED)';
			break;
			case 4:
				$ordenStr = 'CAST(rut as UNSIGNED) DESC';
			break;	
		}
		$this->lista = $this->proveedor->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		$cantidad = $this->proveedor->cantidad($this->buscar)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		
		$this->contenido = $this->ver('listar_proveedores');
		return $this->ver('index');				
	}
	
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$proveedor = new Proveedor($this->NX_CONFIG);
			$rut 			= $_POST['rut'];
			$dv 			= $_POST['dv'];
			$rut = $rut.'-'.$dv;
			$razonSocial 	= $_POST['razonsocial'];
			$nombre		 	= $_POST['nombre'];
			$telefono 		= $_POST['telefono'];
			$direccion 		= $_POST['direccion'];
			$ciudad 		= $_POST['ciudad'];
			$giro 			= $_POST['giro'];
			$cont = $proveedor->existe($rut);						
			if(isset($cont["cantidad"]) && $cont["cantidad"] > 0) { //error nuevo cliente, ya existe
				  return "<script type=\"text/javascript\">javascript:self.parent.tb_remove();alert('El Proveedor ya existe');</script>";
			} else { 
				  $ok = $proveedor->nuevo($rut, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro);
				  if($ok)
				  {
					  return $this->info_msg = $this->msg('popup', 'Proveedor', 1,0,1);
				  }else{
					  return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Proveedor, contacte al Administrador.');</script>";
				  }
			}
		}
		return $this->ver('nuevo_proveedor');
	}
	
	public function eliminar()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}

		$rut = $_GET['rut'];
		$this->proveedor->eliminar($rut);
		header('location: index.php?controlador=Proveedor&accion=listar');
	}
	
	public function editar()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5 && $_SESSION['area']!=8) 
		{
			header('location: index.php?error=restringido');
			return;
		}	

		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut = $_POST['rut'];
			$razonSocial = $_POST['razonsocial'];
			$nombre = $_POST['nombre'];
			$telefono = $_POST['telefono'];
			$direccion = $_POST['direccion'];
			$ciudad = $_POST['ciudad'];
			$giro = $_POST['giro'];
			$this->proveedor->modificar($rut, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro);
			return $this->info_msg = $this->msg('popup', 'proveedor', 2,0,1);
		}
		$rut = $_GET['rut'];
		$this->datosproveedor = $this->proveedor->obtenerDatos($rut);
		return $this->ver('editar_proveedor');			
	}
	
}