<?php

//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("modelos/ControladorBD.php");
require_once("modelos/nx_utils.php");
//</editor-fold>

class OrdenCompraControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $orden;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->orden = new OrdenCompra($this->NX_CONFIG);
    }
    //</editor-fold>

    /*****************************************************************************************************************/
    /*****************************************  OBTENER NÚMERO  *************************************************/
    /*****************************************************************************************************************/

    public function obtenernumero()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->numero = $this->orden->obtenernumero()["numero"];
        return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
    }

    /*****************************************************************************************************************/
    /*****************************************  NUEVO  *************************************************/
    /*****************************************************************************************************************/

    public function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerooc		        = $_POST['numerooc'];
            $rutp 			        = $_POST['rut'];
            $fecha 			        = $_POST['fecha'];
            $sumatotal 		        = $_POST['sumatotal'];
            $rutproveedor	        = $_POST['rut'];
            $formadepago	        = $_POST['formadepago'];
            $despacharpor	        = $_POST['despacharpor'];
            $direcciondespacharpor	= $_POST['direcciondespacharpor'];

            //Productos de inventario
            $itemid		    = $_POST['itemid'] ?? null;
            $itemcant		= $_POST['itemcant'] ?? null;
            $itemprec		= $_POST['itemprec'] ?? null;
            //Nuevo Producto
            $nproductoid	= $_POST['nproductoid'] ?? null;
            $nprodcant		= $_POST['nprodcant'] ?? null;
            $nprodprecio	= $_POST['nprodprecio'] ?? null;
            $datosprod		= $_POST['datosprod'] ?? null;
            $codinterno     = $_POST['codinterno'] ?? null;

            //Nueva maquina o servicio
            $maqservid			= $_POST['maqservid'] ?? null; //id = descripcion
            $maqservcant		= $_POST['maqservcant'] ?? null;
            $maqservprecio		= $_POST['maqservprecio'] ?? null;
            $datosmaqserv		= $_POST['datosmaqserv'] ?? null; // = descripcion

            $ok =  $this->orden->nuevo($numerooc, $rutp, $fecha, $sumatotal, $formadepago, $despacharpor, $direcciondespacharpor); //Estado = 2

            if($ok)
            {

                $inventario = new Inventario($this->NX_CONFIG);
                //--> Ingreso de Insumos y respuestos del Proveedor a inventario (Tipo=> 1: inventario, 0:maquinas)

                $n        = count($itemid) ?? 0;
                $i        = 0;
                while ($i < $n){
                    $this->orden->ingresaritems($numerooc, $itemid[$i], $itemcant[$i], $itemprec[$i],1);
                    /* 28/01/2011 ESTADO = 2 (orden creada) no se actualiza stock */
                    //$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contteorico');
                    //$inventario->actualizarStock($itemid[$i], $itemcant[$i], '+', 'contreal');
                    $inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
                    $inventario->actualizarPcompraProveedorItems($itemid[$i], $itemprec[$i], $rutproveedor);
                    $i++;
                }

                //****************************************************************

                $proveedor = new Proveedor($this->NX_CONFIG);
                //--> Ingreso de Nuevos Productos
                $cat 		= new Categorias($this->NX_CONFIG);
                $n        	= count($nproductoid);
                $i        	= 0;
                while ($i < $n){

                    list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = explode( '%', $datosprod[$i] );

                    if($categoria == -1)
                    {
                        $existe = $cat->buscar(strtoupper($nombrecategoria));
                        if(is_numeric($existe))
                        {
                            $categoria = $existe;//se le da la ID que ya estaba ingresada
                        }else{
                            $categoria = $cat->nuevo(strtoupper($nombrecategoria));
                        }
                    }

                    if($marca == -1)
                    {
                        $existe = $marcamaq->buscar(strtoupper($nombremarca));
                        if(is_numeric($existe))
                        {
                            $marca = $existe;//se le da la ID que ya estaba ingresada
                        }else{
                            $marca = $marcamaq->nuevo(strtoupper($nombremarca));
                        }
                    }

                    $corr = $inventario->obtenerCorrelativo($tipo[0])["correlativo"];
                    $idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);

                    //nprodcant se le da a todos los valores (contteorico, contreal, stockminimo, stockcritico)
                    //$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno[$i], $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], 0, 1, '');

                    //Se solicita ingresar valor 0 a contadores cuando se crea un insumo/repuesto nuevo
                    $inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno[$i], $numparte, $descripcion, 0,0,0,0,0, 1, '');

                    $this->orden->ingresaritems($numerooc, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
                    $inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
                    $inventario->actualizarPcompraProveedorItems($itemid[$i], $itemprec[$i], $rutproveedor);

                    //asociar al proveedor
                    $proveedor->asociarProducto($rutproveedor, $idproducto, $nprodprecio[$i], "");
                    $i++;
                }

                //****************************************************************

                //---------> Ingreso de Nuevas Máquinas o SERVICIO
                $n        = count($maqservid) ?? 0;
                $i        = 0;
                while ($i < $n){
                    //En inventario existe un producto con id = ESPECIAL
                    $this->orden->ingresarMaqServ($numerooc, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
                    $i++;
                }
                //****************************************************************

                $this->orden->guardarFormaPagoOC($numerooc, 1, "", "", "", "", "", "", "", "", "", "", Date("d-m-Y" , strtotime("+1 month")), "", "", "", "", "");
                $this->orden->actualizarOC($numerooc, 1, "estado"); // Cambiar a ESTADO = 1 FORMA DE PAGO REALIZADA. DEBE LLEVAR A PEDIDO OK;



                header("Location: index.php?controlador=OrdenCompra&accion=nuevo&infomsg=si");
                return;

            }else{//modificar el info msg
                $this->info_msg = "<script>alert('Error al ingresar la Orden de Compra, contacte al Administrador.');</script>";
            }

        }
        $this->info_msg = "";

        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);
        }

        $this->direcciones = $this->orden->direcciones();
        $this->contenido = $this->ver('nueva_oc');
        return $this->ver('index');
    }

    /*****************************************************************************************************************/
    /*****************************************  INICIO LISTAR  *************************************************/
    /*****************************************************************************************************************/

    public function iniciolistar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->anios = $this->orden->aniosDesc();
        $this->contenido = $this->ver('inicio_listar_oc');
        return $this->ver('index');
    }

    /*****************************************************************************************************************/
    /*****************************************  LISTAR    *************************************************/
    /*****************************************************************************************************************/

    public function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada página
        $this->pagVisible = 8; //paginas a mostrar en la paginación

        $this->buscar 		= $_GET['buscar'] ?? null;
        $this->numoc        = $_GET['numoc'] ?? null;
        $this->filtroorden 	= $_GET['orden'] ?? null;
        $this->estado 		= $_GET['estado'] ?? null;

        $this->fechaDesde 	= $_GET['desde'] ?? null;
        $this->fechaHasta 	= $_GET['hasta'] ?? null;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        switch($this->filtroorden)
        {
            default:
                $ordenStr = 'IDoc';
                $this->filtroorden = 1;
                break;
            case 2:
                $ordenStr = 'IDoc DESC';
                break;
            case 3:
                $ordenStr = 'total';
                break;
            case 4:
                $ordenStr = 'total DESC';
                break;
            case 5:
                $ordenStr = 'fecha';
                break;
            case 6:
                $ordenStr = 'fecha DESC';
                break;
        }

        switch($this->estado)
        {
            default:
                $whereTip = '';
                break;
            case 0: //completa
                $whereTip = "AND estado=0";
                break;
            case 1: //Pendientes Recibo conforme
                $whereTip = "AND estado=1";
                break;
            case 2: //Pendientes de Pago y Recibo Conforme
                $whereTip = "AND estado=2";
                break;
            case 3: //Anuladas
                $whereTip = "AND estado=3";
                break;
        }
        $cantidads = $this->orden->cantidad($this->buscar, $this->numoc, $whereTip, $this->fechaDesde, $this->fechaHasta)["cantidad"];
        $this->lista = $this->orden->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->numoc, $ordenStr, $whereTip, $this->fechaDesde, $this->fechaHasta);
        $this->nPaginas = ceil($cantidads / $this->resultados);
        return $this->ver('listar_oc');
    }

    /*****************************************************************************************************************/
    /*****************************************  EDITAR ORDEN COMPRA  *************************************************/
    /*****************************************************************************************************************/

    function editar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=9)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $idoc				 = $_POST['numerooc'];
            $rutp 				 = $_POST['rut'];
            $total				 = $_POST['totalisimo'];
            $numfactura		     = $_POST['numfactura'];
            $numguia		     = $_POST['numguia'];
            $itemid		     	 = $_POST['itemid'];
            $idocitem	    	 = $_POST['idocitem'];
            $itemcant			 = $_POST['itemcant'];
            $itemprec  			 = $_POST['itemprec'];
            $idOCItemBorrar	     = $_POST['idOCItemBorrar'];
            $idOCItemBorrarID    = $_POST['idOCItemBorrarID'];

            $idocitemmaq         = $_POST['idocitemmaq'];
            $maqservid			 = $_POST['maqservid'];
            $maqservcant         = $_POST['maqservcant'];
            $maqservprecio       = $_POST['maqservprecio'];
            $idOCItemMaqBorrar	 = $_POST['idOCItemMaqBorrar'];
            $idOCItemMaqBorrarID = $_POST['idOCItemMaqBorrarID'];

            $ok 				 = $this->orden->actualizarOC($idoc, $total, "total");

            $inventario = new Inventario();

            $n        = count($idOCItemBorrarID);
            $i        = 0;
            while ($i < $n)
            {
                if ($idOCItemBorrar[$i] == 'SI')
                {
                    $this->orden->borrarItemOC($idOCItemBorrarID[$i]);
                }
                $i++;
            }

            $n        = count($idOCItemMaqBorrarID);
            $i        = 0;
            while ($i < $n)
            {
                if ($idOCItemMaqBorrar[$i] == 'SI')
                {
                    $this->orden->borrarItemOC($idOCItemMaqBorrarID[$i]);
                }
                $i++;
            }

            //ACTUALIZACION DE DATOS OCITEMS
            $n        = count($itemid);
            $i        = 0;

            while ($i < $n)
            {
                $this->orden->actualizarItemOC($idocitem[$i], $itemcant[$i], "cantidad");
                $this->orden->actualizarItemOC($idocitem[$i], $itemprec[$i], "precio");
                $inventario->actualizarPcompra($itemid[$i], $itemprec[$i]);
                $inventario->actualizarPcompraProveedorItems($itemid[$i], $itemprec[$i], $rutp);
                $i++;
            }

            $n        = count($maqservid);
            $i        = 0;

            while ($i < $n)
            {
                $this->orden->actualizarItemOC($idocitemmaq[$i], $maqservcant[$i], "cantidad");
                $this->orden->actualizarItemOC($idocitemmaq[$i], $maqservprecio[$i], "precio");
                $i++;
            }

            if($ok)
            {
                $this->orden->actualizarOC($idoc, 1, "estado"); //Estado = Pendiente de factura (1)
                if(isset($numfactura) || isset($numguia))
                {
                    $this->orden->actualizarOCFacturaGuia($idoc, $numfactura, "numfactura"); //Ingresar numero factura
                    $this->orden->actualizarOCFacturaGuia($idoc, $numguia,"numguia"); // Actualizar guia de despacho, tipo texto
                    $this->orden->actualizarOC($idoc, 0, "estado"); //Estado = Completado (0)
                }
                $borrados	= $_POST['totales'];
                $n        = count($borrados);
                $i        = 0;
                while ($i < $n){
                    $this->orden->borrarinventarioOC($idoc, $borrados[$i]);
                    $i++;
                }

                $this->info_msg  = $this->msg('completa', 'Orden de Compra', 2, 1, 1);
            }else{//modificar el info msg
                $this->info_msg = "<script>alert('Error al guardar la Orden de Compra, contacte al Administrador.');</script>";
            }
        }
        $idoc = $_GET['idoc'];
        $this->oc = $this->orden->obtenerdatosOC($idoc);
        $this->listainventario = $this->orden->obtenerItemsInventarioOC($idoc);
        $this->listamaquinas = $this->orden->obtenerItemsMaqServOC($idoc);
        $this->contenido = $this->ver('editar_oc');
        return $this->ver('index');
    }

    /*****************************************************************************************************************/
    /*****************************************  DETALLE ORDEN COMPRA  *************************************************/
    /*****************************************************************************************************************/

    function detalle()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idoc = $_GET['idoc'];
        $this->oc = $this->orden->obtenerdatosOC($idoc);
        $this->listainventario = $this->orden->obtenerItemsInventarioOC($idoc);
        $this->listamaqserv = $this->orden->obtenerItemsMaqServOC($idoc);
        $this->info_msg = "";
        $this->contenido = $this->ver('ver_oc');
        return $this->ver('index');
    }

    /*****************************************************************************************************************/
    /*****************************************  DAR POR PAGADA ORDEN COMPRA  *************************************************/
    /*****************************************************************************************************************/

    function OCpagada()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $idoc		= $_GET['idOC'];
        $this->orden->actualizarOC($idoc, 1, "estado"); // Cambiar a ESTADO = 1;
    }

    //Actualizar Stock
    function OCconfirmada()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $idoc			= $_GET['idOC'];
        $numfactura		= $_GET['numfactura'];
        $numguia		= $_GET['numguia'];
        $this->orden->actualizarOC($idoc, 0, "estado"); // Cambiar a ESTADO = 0;
        $this->orden->actualizarOCFacturaGuia($idoc, $numfactura, "numfactura"); // Actualizar factura, tipo texto
        $this->orden->actualizarOCFacturaGuia($idoc, $numguia,"numguia"); // Actualizar guia de despacho, tipo texto
        $this->orden->actualizarOCFechaPedidoOK($idoc); // Actualizar Fecha Pedido OK
        //Actualizar inventario
        $inventario = new Inventario();
        $listainventario = $this->orden->obtenerProductosOC($idoc);
        if(count($listainventario )>0){
            foreach($listainventario as $li){
                $inventario->actualizarStock($li["IDproducto"], $li["cantidad"], '+', 'contteorico');
                $inventario->actualizarStock($li["IDproducto"], $li["cantidad"], '+', 'contreal');
            }
        }
    }

    function anular()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $idoc		= $_GET['idOC'];
        $this->orden->actualizarOC($idoc, 3, "estado"); // Cambiar a ESTADO = 3;
    }

    /* ORDEN COMPRA NUEVA MAQ o SERV */
    function nuevoMaqServ()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10)
        {
            header('location: index.php?error=restringido');
            return;
        }

        return $this->ver('nuevo_maqserv');
    }

    function seleccionarformadepago()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = $_GET['buscar'];
        $this->orden = $_GET['orden'];

        if(is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'rut';
                break;
            case 4:
                $ordenStr = 'rut DESC';
                break;
        }

        //$this->lista = $this->proveedor->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        //$cantidad = $this->proveedor->cantidad($this->buscar);
        //$this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_formadepago');
    }

    function guardarformadepago()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $idoc				= $_GET['idOC'];
        $tipopago			= $_GET['tipopago'];
        $numcheque30dias	= $_GET['numcheque30dias'];
        $monto30dias		= $_GET['monto30dias'];
        $numcheque60dias	= $_GET['numcheque60dias'];
        $monto60dias		= $_GET['monto60dias'];
        $numcheque90dias	= $_GET['numcheque90dias'];
        $monto90dias		= $_GET['monto90dias'];
        $numcheque120dias	= $_GET['numcheque120dias'];
        $monto120dias		= $_GET['monto120dias'];
        $numtransferencia	= $_GET['numtransferencia'];

        switch ($tipopago) {
            case "1":  //CREDITO
                $numcheque30dias	= "";
                $monto30dias		= "";
                $numcheque60dias	= "";
                $monto60dias		= "";
                $numcheque90dias	= "";
                $monto90dias		= "";
                $numcheque120dias	= "";
                $monto120dias		= "";
                $numtransferencia	= "";
                break;
            case "2":   //CHEQUE
                $numtransferencia	= "";
                break;
            case "3":   //TRANSFERENCIA
                $numcheque30dias	= "";
                $monto30dias		= "";
                $numcheque60dias	= "";
                $monto60dias		= "";
                $numcheque90dias	= "";
                $monto90dias		= "";
                $numcheque120dias	= "";
                $monto120dias		= "";
                break;
            default:
                $numcheque30dias	= "";
                $monto30dias		= "";
                $numcheque60dias	= "";
                $monto60dias		= "";
                $numcheque90dias	= "";
                $monto90dias		= "";
                $numcheque120dias	= "";
                $monto120dias		= "";
                $numtransferencia	= "";
        }

        $this->orden->guardarFormaPagoOC($idoc, $tipopago, $numcheque30dias, $monto30dias, $numcheque60dias, $monto60dias, $numcheque90dias, $monto90dias, $numcheque120dias, $monto120dias, $numtransferencia);
        $this->orden->actualizarOC($idoc, 1, "estado"); // Cambiar a ESTADO = 1 FORMA DE PAGO REALIZADA. DEBE LLEVAR A PEDIDO OK;
        //$this->orden->actualizarOC($idoc, 3, "estado"); // Cambiar a ESTADO = 3;
    }

    function actualizarformadepago()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $idoc			= $_GET['idOC'];

        $this->lista = $this->orden->obtenerdatospagoOC($idoc);
        $this->orden = $idoc;

        //$this->lista = $this->proveedor->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        //$cantidad = $this->proveedor->cantidad($this->buscar);
        //$this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('actualizar_formadepago');
    }

    function guardaractualizarformadepago()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $idoc				= $_GET['idOC'];
        $tipopago			= $_GET['tipopago'];
        $numcheque30dias	= $_GET['numcheque30dias'];
        $monto30dias		= $_GET['monto30dias'];
        $numcheque60dias	= $_GET['numcheque60dias'];
        $monto60dias		= $_GET['monto60dias'];
        $numcheque90dias	= $_GET['numcheque90dias'];
        $monto90dias		= $_GET['monto90dias'];
        $numcheque120dias	= $_GET['numcheque120dias'];
        $monto120dias		= $_GET['monto120dias'];
        $numtransferencia	= $_GET['numtransferencia'];
        $fechacredito		= $_GET['fechacredito'];
        $fecha30dias		= $_GET['fecha30dias'];
        $fecha60dias		= $_GET['fecha60dias'];
        $fecha90dias		= $_GET['fecha90dias'];
        $fecha120dias		= $_GET['fecha120dias'];
        $montotransferencia	= $_GET['montotransferencia'];
        $fechatransferencia	= $_GET['fechatransferencia'];

        switch ($tipopago) {
            case "1":  //CREDITO
                $numcheque30dias	= "";
                $monto30dias		= "";
                $numcheque60dias	= "";
                $monto60dias		= "";
                $numcheque90dias	= "";
                $monto90dias		= "";
                $numcheque120dias	= "";
                $monto120dias		= "";
                $numtransferencia	= "";
                $fecha30dias		= "";
                $fecha60dias		= "";
                $fecha90dias		= "";
                $fecha120dias		= "";
                $montotransferencia	= "";
                $fechatransferencia	= "";
                break;
            case "2":   //CHEQUE
                $numtransferencia	= "";
                $montotransferencia	= "";
                $fechatransferencia	= "";
                $fechacredito       = "";
                break;
            case "3":   //TRANSFERENCIA
                $numcheque30dias	= "";
                $monto30dias		= "";
                $numcheque60dias	= "";
                $monto60dias		= "";
                $numcheque90dias	= "";
                $monto90dias		= "";
                $numcheque120dias	= "";
                $monto120dias		= "";
                $fecha30dias		= "";
                $fecha60dias		= "";
                $fecha90dias		= "";
                $fecha120dias		= "";
                $fechacredito       = "";
                break;
            default:
                $numcheque30dias	= "";
                $monto30dias		= "";
                $numcheque60dias	= "";
                $monto60dias		= "";
                $numcheque90dias	= "";
                $monto90dias		= "";
                $numcheque120dias	= "";
                $monto120dias		= "";
                $numtransferencia	= "";
        }

        $this->orden->actualizarFormaPagoOC(
            $idoc,
            $tipopago,
            $numcheque30dias,
            $monto30dias,
            $numcheque60dias,
            $monto60dias,
            $numcheque90dias,
            $monto90dias,
            $numcheque120dias,
            $monto120dias,
            $numtransferencia,
            $fechacredito,
            $fecha30dias,
            $fecha60dias,
            $fecha90dias,
            $fecha120dias,
            $montotransferencia,
            $fechatransferencia
        );
        //$this->orden->actualizarOC($idoc, 1, "estado"); // Cambiar a ESTADO = 1 FORMA DE PAGO REALIZADA. DEBE LLEVAR A PEDIDO OK;
        //$this->orden->actualizarOC($idoc, 3, "estado"); // Cambiar a ESTADO = 3;
    }
}
?>