<?php
class OTControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $OT;
    var $clientes;
    var $facturas;
    var $usuario;
    var $servicios;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->clientes = new Clientes($this->NX_CONFIG);
        $this->OT = new OrdenTrabajo($this->NX_CONFIG);
        $this->configuraciones	= new Configuraciones($this->NX_CONFIG);
        $this->facturas = new Facturas($this->NX_CONFIG);
        $this->funcionesMatematicas = new FuncionesMatematicas($this->NX_CONFIG);
        $this->usuario = new Usuarios($this->NX_CONFIG);
        $this->servicios = new Servicios($this->NX_CONFIG);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=4 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numeroot		= $_POST['numeroot'];
            $newnumeroactual = $numeroot + 1;
            $rut			= $_POST['rut'] ?? null;
            $responsable	= $_POST['responsable'] ?? null;
            $fecha			= $_POST['fecha'] ?? null;
            $servicios		= $_POST['servicioClientesId'] ?? null;
            $cantorig		= $_POST['cantorig'] ?? null;
            $coporig		= $_POST['coporig'] ?? null;
            $unidades		= $_POST['unidades'] ?? null;
            $precios		= $_POST['precioServicioClientes'] ?? null;
            $totalneto		= $_POST['totalnetosf'] ?? null;
            $tipopago      	= $_POST['tipopago'] ?? null;
            $idsucursal       = $_POST['sucursal'] ?? null;

            if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

            $talonarios = new OTTalonario($this->NX_CONFIG);
            $talonarionuevo = new OTTalonario($this->NX_CONFIG);
            $talonario = $talonarios->obtenertalonario($rut, 1, $idsucursal);
            foreach($talonario as $t)
            {
                $ok= $this->OT->nuevo($numeroot, $rut, $t["IDtalonario"], $responsable, $fecha, $totalneto, $tipopago, $idsucursal);
                //echo $ok;
                if($ok){
                    if($numeroot == $t["numfinal"])
                    {
                        //nuevo numero actual es igual al numero final del talonario
                        $talonarios->cambiarestado($t["IDtalonario"], 3); //talonario actual se acabo (estado 3: usado)
                        $talonarionuevo = $talonarios->obtenernuevotalonario($rut, $idsucursal)["numero_talonario"];
                        if(isset($talonarionuevo))
                        {
                            $talonarios->cambiarestado($talonarionuevo, 1); //talonario en cola pasa a ser actual
                        }else{
                            //echo "no hay talonarios 2";
                            //retornar un aviso colocando un div en la pagina u otra idea
                            /*return "<script>alert('Cliente ah terminado su talonario, no posee en cola.');</script>";*/
                        }
                    }else{//nuevo numero actual dentro del rango
                        $talonarios->cambiarnumeroactual($t["IDtalonario"], $newnumeroactual);
                    }
                }
            }

            if($ok){
                //ingreso de servicios
                $n        = count($servicios);
                $i        = 0;
                while ($i < $n){
                    $this->OT->ingresarservicios($numeroot, $rut, $servicios[$i], $cantorig[$i], $coporig[$i], $unidades[$i], $precios[$i], $idsucursal);
                    $i++;
                }
                header("Location: index.php?controlador=OT&accion=nuevo&infomsg=si");
                return;
            }else{
                $this->info_msg = "<script>alert('Error al ingresar la Orden de Trabajo, contacte al Administrador.');</script>";
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Orden de trabajo', 1, 1, 1);
        }
        $rut        = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
        $this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->listasucursales = $this->usuario->listarSucursales();
        $this->servicios = $this->OT->obtenerservicios($rut, 1," "," "," "," ");
        $this->contenido = $this->ver('nueva_ot');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
    function seleccionar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->sucursal = (!isset($_GET['sucursal']) ? $_SESSION['sucursal'] : $_GET['sucursal']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'IDot DESC';
                $this->orden = 2;
                break;
            case 1:
                $ordenStr = 'IDot';
                break;
            case 2:
                $ordenStr = 'IDot DESC';
                break;
            case 3:
                $ordenStr = 'Fecha';
                break;
            case 4:
                $ordenStr = 'Fecha DESC';
                break;
        }

        switch($this->sucursal)
        {
            default:
                $sucursalStr = ' ot.idsucursal = '.$_SESSION['sucursal'].' AND ';
                $this->orden = 2;
                break;
            case 1:
                $sucursalStr = ' ot.idsucursal = 1 AND ';
                break;
            case 2:
                $sucursalStr = ' ot.idsucursal = 2 AND ';
                break;
            case 3:
                $sucursalStr = ' ot.idsucursal = 3 AND ';
                break;
            case 9:
                $sucursalStr = ' ';
                break;
        }

        $this->lista = $this->OT->listar_ot_cliente($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->rut, $ordenStr, $sucursalStr);
        $cantidad = $this->OT->cantidad_ot_cliente($this->buscar, $this->rut, $sucursalStr)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_ot');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : ver_ot_cliente">
    function ver_ot_cliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idot = (!isset($_GET['idot']) ? null : $_GET['idot']);
        $rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $idsucursal = (!isset($_GET['idsucursal']) ? null : $_GET['idsucursal']);
        $this->UF = $this->configuraciones->getValor(IDCONFIG_UF);
        $this->ordentrabajo = $this->OT->obtenerdatosOT($idot, $rut, $idsucursal);
        $this->listaservicios = $this->OT->obtenerServiciosOT($idot, $rut, $idsucursal);
        $this->info_msg = "";
        if($rut==$this->configuraciones->getValor(IDCONFIG_RUT_CSJ))
        {
            $this->contenido = $this->ver('ver_otinterna_cliente');
        }else
        {
            $this->contenido = $this->ver('ver_ot_cliente');
        }
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : asignarboleta">
    function asignarboleta()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idot			= $_GET['ot'];
        $rut			= (!isset($_GET['rut']) ? null : $_GET['rut']);
        $numboleta		= (!isset($_GET['boleta']) ? null : $_GET['boleta']);
        $tipopago   	= (!isset($_GET['tipopago']) ? null : $_GET['tipopago']);
        $ajuste   		= (!isset($_GET['ajuste']) ? null : $_GET['ajuste']);
        $totalapagar	= (!isset($_GET['totalapagar']) ? null : $_GET['totalapagar']);

        $this->OT->asignarboleta($idot, $rut, $numboleta, $tipopago, $ajuste, $totalapagar);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : asignarfactura">
    function asignarfactura()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idot			= $_GET['ot'];
        $rut			= (!isset($_GET['rut']) ? null : $_GET['rut']);
        $numfactura		= (!isset($_GET['factura']) ? null : $_GET['factura']);
        $tipopago   	= (!isset($_GET['tipopago']) ? null : $_GET['tipopago']);
        $ajuste   		= (!isset($_GET['ajuste']) ? null : $_GET['ajuste']);
        $totalapagar	= (!isset($_GET['totalapagar']) ? null : $_GET['totalapagar']);

        $this->OT->asignarfactura($idot, $rut, $numfactura, $tipopago, $ajuste, $totalapagar);
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2 and $_SESSION['area']!=9)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];
        $this->resultados = 20; //Registros a mostrar por cada pagina
        $this->pagVisible = 8; //paginas a mostrar en la paginacion

        $this->fechaDesde 	= isset($_GET['desde']) ? $_GET['desde'] : null;
        $this->fechaHasta 	= isset($_GET['hasta']) ? $_GET['hasta'] : null;
        $this->buscar = isset($_GET['buscar']) ? $_GET['buscar'] : null;
        $this->idsucursal = isset($_GET['sucursal']) ? $_GET['sucursal'] : 0;

        $fechas = "";
        $sucursal = "";

        if($this->fechaDesde != "" && $this->fechaHasta != "")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fechaDesde);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fechaHasta);
            $fecha2  = "$anio/$mes/$dia";
            $fechas = " AND fecha BETWEEN '".$fecha1."' AND '".$fecha2."' ";
        }

        if($this->idsucursal != 0)
        {
            $sucursal = " AND ot.idsucursal=".$this->idsucursal." ";
        }

        $cantidads = $this->OT->cantidad($this->buscar, $fechas, $sucursal)["cantidad"];
        $this->lista = $this->OT->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $fechas ?? null, $sucursal);
        $this->nPaginas = ceil($cantidads / $this->resultados);
        $this->listasucursales = $this->usuario->listarSucursales();
        $this->total = $this->OT->precioTotalLista($this->buscar, $fechas, $sucursal)["total"];
        $this->contenido = $this->ver('listar_ot');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : detalle">
    function detalle()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=2 and $_SESSION['area']!=9)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idot = (!isset($_GET['idot']) ? null : $_GET['idot']);
        $rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $idsucursal = (!isset($_GET['idsucursal']) ? null : $_GET['idsucursal']);
        $this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->UF = $this->configuraciones->getValor(IDCONFIG_UF);
        $this->ordentrabajo = $this->OT->obtenerdatosOT($idot, $rut, $idsucursal);
        $this->listaservicios = $this->OT->obtenerServiciosOT($idot, $rut, $idsucursal);
        return $this->ver('ver_detalle_ot');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : editarOT">
    function editarOT()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=5 and $_SESSION['area']!=8)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numeroot		= $_POST['numeroot'];
            $numerobol		= $_POST['numerobol'];
            $rut			= $_POST['rut'];
            $totalneto		= $_POST['totalnetosf'];
            $responsable	= $_POST['resp'];


            $this->OT->actualizarOT($numeroot, $rut, $numerobol, $totalneto, $responsable);

            $filas			= $_POST['pos'];
            $servicios		= $_POST['servicioClientesId'];
            $cantorig		= $_POST['cantorig'];
            $coporig		= $_POST['coporig'];
            $unidades		= $_POST['unidades'];
            $precios		= $_POST['preciosf'];

            $n = count($filas);

            $i = 0;
            while ($i < $n){
                $this->OT->actualizarServicios($filas[$i], $servicios[$i], $cantorig[$i], $coporig[$i], $unidades[$i], $precios[$i]);
                $i++;
            }

            header("Location: index.php?controlador=OT&accion=listar&infomsg=si");
            return;
        }

        $idot = (!isset($_GET['idot']) ? null : $_GET['idot']);
        $rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->idsucursal = (!isset($_GET['idsucursal']) ? null : $_GET['idsucursal']);
        $this->UF = $this->configuraciones->getValor(IDCONFIG_UF);
        $this->ordentrabajo = $this->OT->obtenerdatosOT($idot, $rut, $this->idsucursal);
        $this->listaservicios = $this->OT->obtenerServiciosOT($idot, $rut, $this->idsucursal);
        $this->servicios = $this->OT->obtenerservicios($rut, $this->idsucursal, " ", " ", " "," ");
        $this->contenido = $this->ver('editar_ot');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionPorClienteCentroCopiado">
    function listarFacturacionPorClienteCentroCopiado()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)//Solo secretaria no puede ver la informaci�n del cliente
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = !isset($_GET['buscar']) ? null : $_GET['buscar'];
        $this->rutc = !isset($_GET['rut']) ? null : $_GET['rut'];
        $this->anio = !isset($_GET['anio']) ? null : $_GET['anio'];
        if(isset($_GET['anio']) && !is_numeric($_GET['anio'])) {
            $this->anio = date("Y");
        }
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->lista = $this->OT->listar_ot_cliente_anual($this->rutc, $this->anio);
        $cantidad = 12;
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_centro_copiado_facturacion_cliente');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : detalleClienteCentroCopiado">
    function detalleClienteCentroCopiado()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerofactura			= $_POST['numfactura'];
            $rut					= $_POST['rut'];
            $fecha					= $_POST['fecha'];
            $fechavencimiento		= $_POST['fechavencimiento'];
            $referencias			= $_POST['referencias'];
            $formapago				= $_POST['formaPago'];
            $centrocosto			= $_POST['idcentrocosto'];
            $copias		    		= $_POST['cantorig'];
            $servicio				= $_POST['servicio'];
            $precio         		= $_POST['precioUnitario'];
            $listaOT		 		= $_POST['listaCodigoOT'];
            $this->mes				= $_POST['mes'];
            $this->anio				= $_POST['anio'];
            $this->razonsocial      = $_POST['razonsocial'];
            $porcdescuento 			= $_POST['porcdescuento'];

            if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

            $this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias, $porcdescuento); //Aplica el mismo procedimiento de Venta General. Pues solo guarda fecha, cliente y numero de factura
            $this->OT->grabarFactura($rut,$this->mes,$this->anio,$numerofactura);

            $ok = false;

            for ($i = 0; $i < count($copias); $i++) {
                $ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $servicio[$i], $copias[$i], $precio[$i], $centrocosto);
            }

            for ($i = 0; $i < count($listaOT); $i++) {
                $ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $listaOT[$i], 0, 0, $centrocosto);
            }

            if($ok){
                $this->factura = $numerofactura;
                $this->rut = $rut;
                $this->padre = "index.php?controlador=Clientes&accion=listarClientesCentroCopiado";
                $this->contenido = $this->ver('factura_procesada');
                return $this->ver('index');
            }else{
                $this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
            }
        }

        $rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->anio = (!isset($_GET['anio']) ? null : $_GET['anio']);
        $this->mes = (!isset($_GET['mes']) ? null : $_GET['mes']);

        $this->lista 	= $this->OT->obtenerDatosFacturacionMensualPorCliente($rut, $this->anio, $this->mes);
        $this->listaOT 	= $this->OT->obtenerDatosFacturacionMensualPorClienteSoloIdOt($rut, $this->anio, $this->mes);

        //		$this->listaCargoFijo = $this->OT->obtenerDatosFacturacionMensualPorClienteCargoFijo($rut, $anio, $mes);

        $this->cliente 	= $this->clientes->obtenerDatos($rut);

        $this->ultimaFactura 	= $this->facturas->obtenerUltimaFactura();
        $this->contenido 		= $this->ver('ver_centro_copiado_cliente_factura');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionarServiciosCliente">
    function seleccionarServiciosCliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina           = 1;
        $this->resultados       = 20;
        $this->buscar           = isset($_GET['buscar']) ? $_GET['buscar'] : null;
        $this->orden            = isset($_GET['orden']) ? $_GET['orden'] : null;
        $this->idsucursal       = (!isset($_GET['idsucursal']) ? null : $_GET['idsucursal']);
        $this->idfamilia        = (!isset($_GET['idfamilia']) ? 0 : $_GET['idfamilia']);
        $this->idformato        = (!isset($_GET['idformato']) ? 0 : $_GET['idformato']);
        $this->idtipo           = (!isset($_GET['idtipo']) ? 0 : $_GET['idtipo']);
        $this->idgramaje        = (!isset($_GET['idgramaje']) ? 0 : $_GET['idgramaje']);
        $this->rut			    = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->idcontrolador    = (!isset($_GET['idcontrolador']) ? 1 : $_GET['idcontrolador']);

/*        echo "<p>idfamilia: ";
        echo $this->idfamilia;
        echo "<p>idformato: ";
        echo   $this->idformato;
        echo "<p>idtipo: ";
        echo  $this->idtipo ;
        echo "<p>idgramaje: ";
        echo $this->idgramaje ;
        echo "<p>";*/

        $whereidfamilia = " ";
        $whereidformato = " ";
        $whereidtipo = " ";
        $whereidgramaje = " ";

/*        echo "<p>familia: ";
        echo $whereidfamilia;
        echo "<p>formato: ";
        echo       $whereidformato;
        echo "<p>tipo: ";
        echo  $whereidtipo;
        echo "<p>gramaje: ";
        echo $whereidgramaje;
        echo "<p>";*/

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        if($this->idfamilia != 0) {
            $whereidfamilia = " AND serviciosfamilia.idserviciofamilia = ". $this->idfamilia;
        }

        if($this->idformato != 0) {
            $whereidformato = " AND serviciosformato.idformato = ". $this->idformato;
        }

        if($this->idtipo != 0) {
            $whereidtipo = " AND serviciostipo.idtipo = ". $this->idtipo;
        }

        if($this->idgramaje != 0) {
            $whereidgramaje = " AND serviciosgramaje.idgramaje = ". $this->idgramaje;
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);

        /*echo "<p>familia: ";
        echo $whereidfamilia;
        echo "<p>formato: ";
        echo       $whereidformato;
        echo "<p>tipo: ";
       echo  $whereidtipo;
        echo "<p>gramaje: ";
        echo $whereidgramaje;
        echo "<p>";*/

        $this->nPaginas          = 1;
        $this->lista            = $this->OT->obtenerservicios($this->rut, $this->idsucursal, $whereidfamilia, $whereidformato, $whereidtipo, $whereidgramaje);
        $this->listafamilias    = $this->servicios->listarFamilias();
        $this->listaformato     = $this->servicios->listarFormato();
        $this->listatipo        = $this->servicios->listarTipo();
        $this->listagramaje     = $this->servicios->listarGramaje();
        return $this->ver('seleccionar_servicios_cliente');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionarServiciosClienteCotizacion">
    function seleccionarServiciosClienteCotizacion()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 12;

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);

        $this->rutCliente			= $_GET['rutCliente'];
        $this->lista = $this->OT->obtenerserviciosCotizacion($this->resultados * ($this->pagina-1), $this->resultados,$this->buscar,$this->rutCliente);
        $cantidad = $this->OT->cantidaderviciosCotizacion($this->buscar,$this->rutCliente);
        $this->nPaginas = ceil($cantidad / $this->resultados);


        return $this->ver('seleccionar_servicios_cliente_cotizacion');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionarServiciosClienteBuscar">
    function seleccionarServiciosClienteBuscar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina           = 1;
        $this->resultados       = 20;
        $this->buscar           = isset($_GET['buscar']) ? $_GET['buscar'] : null;
        $this->orden            = isset($_GET['orden']) ? $_GET['orden'] : null;
        $this->idsucursal       = (!isset($_GET['idsucursal']) ? null : $_GET['idsucursal']);
        $this->idfamilia        = (!isset($_GET['idfamilia']) ? 0 : $_GET['idfamilia']);
        $this->idfamilia        = (!isset($_GET['idfamilia']) ? 0 : $_GET['idfamilia']);
        $this->idformato        = (!isset($_GET['idformato']) ? 0 : $_GET['idformato']);
        $this->idtipo           = (!isset($_GET['idtipo']) ? 0 : $_GET['idtipo']);
        $this->idgramaje        = (!isset($_GET['idgramaje']) ? 0 : $_GET['idgramaje']);
        $this->rut			    = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->idcontrolador    = (!isset($_GET['idcontrolador']) ? 1 : $_GET['idcontrolador']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        $whereidfamilia = " ";
        $whereidformato = " ";
        $whereidtipo = " ";
        $whereidgramaje = " ";

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        if($this->idfamilia != 0) {
            $whereidfamilia = " AND serviciosfamilia.idserviciofamilia = ". $this->idfamilia;
        }

        if($this->idformato != 0) {
            $whereidformato = " AND serviciosformato.idformato = ". $this->idformato;
        }

        if($this->idtipo != 0) {
            $whereidtipo = " AND serviciostipo.idtipo = ". $this->idtipo;
        }

        if($this->idgramaje != 0) {
            $whereidgramaje = " AND serviciosgramaje.idgramaje = ". $this->idgramaje;
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);

        $this->nPaginas         = 1;
        //$this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
        //$this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista            = $this->OT->obtenerserviciosBuscar($this->rut,$this->buscar, $this->idsucursal, $whereidfamilia, $whereidformato, $whereidtipo, $whereidgramaje);
        $this->listafamilias    = $this->servicios->listarFamilias();
        $this->listaformato     = $this->servicios->listarFormato();
        $this->listatipo        = $this->servicios->listarTipo();
        $this->listagramaje     = $this->servicios->listarGramaje();
        return $this->ver('seleccionar_servicios_cliente');
    }
    //</editor-fold>
}
?>