<?php
class MaquinasControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $maquinas;
    var $clientes;
    var $configuraciones;
    var $facturas;
    var $contadores;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->clientes = new Clientes($this->NX_CONFIG);
        $this->maquinas = new Maquinas($this->NX_CONFIG);
        $this->configuraciones	= new Configuraciones($this->NX_CONFIG);
        $this->facturas = new Facturas($this->NX_CONFIG);
        $this->contadores = new Contadores($this->NX_CONFIG);
        $this->cotizaciones = new Cotizacion($this->NX_CONFIG);
    }
    //</editor-fold>

    function menu()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->serieinterna		= $_GET['serieinterna'];
        return $this->ver('menu_maquinas');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $serieinterna = $_POST['serieinterna'];
            $seriemaquina = $_POST['seriemaquina'];
            $tipomaquina  = $_POST['tipomaquina'];
            $marca        = $_POST['marca'];
            $modelo       = $_POST['modelo'];
            $fechacompra  = $_POST['fechacompra'];
            $formato      = $_POST['formato'];
            $conectividad = $_POST['conectividad'];

            $rutprov		= $_POST['rutproveedor'];
            $pcompra		= $_POST['pcompra'];
            $pventa         = isset($_POST['pventa']) ?? $_POST['pventa'];
            $codprov		= $_POST['codprov'];

            $cont = $this->maquinas->existe($serieinterna);

            if($cont["cantidad"] > 0) //máquina ya existe
            {
                $this->info_msg = "<script>javascript:alert('Serie Interna ya existe.');</script>";
            }
            else
            {
                if($tipomaquina == -1)
                {
                    $nombretipo = $_POST['nombretipo'];
                    $tipomaq = new TipoMaquina($this->NX_CONFIG);
                    $existe = $tipomaq->buscar(strtoupper($nombretipo));
                    if(is_numeric($existe))
                    {
                        $tipomaquina = $existe;//se le da la ID que ya estaba ingresada
                    }else{
                        $tipomaquina = $tipomaq->nuevo(strtoupper($nombretipo));
                    }
                }
                if($marca == -1)
                {
                    $nombremarca = $_POST['nombremarca'];
                    $marcas = new MarcaMaquina($this->NX_CONFIG);
                    $existe = $marcas->buscar(strtoupper($nombremarca));
                    if(is_numeric($existe))
                    {
                        $marca = $existe;//se le da la ID que ya estaba ingresada
                    }else{
                        $marca = $marcas->nuevo(strtoupper($nombremarca));
                    }
                }
                // 1 porque existe, NULL por que no tiene idfactura
                $ok = $this->maquinas->nuevo($serieinterna, $seriemaquina, $tipomaquina, $marca, $modelo, $fechacompra, $formato, 		$conectividad, 1, "NULL",0);

                if ($ok)
                {//asociar a taller
                    $rutTaller = $this->configuraciones->getValor(IDCONFIG_RUT_TALLER);
                    $this->clientes->agregarMaquina($rutTaller, $serieinterna, 1, "CSJ");

                    //asociar la máquina a los proveedores
                    $proveedor = new Proveedor($this->NX_CONFIG);
                    $n        = count($rutprov);
                    $i        = 0;
                    while ($i < $n){
                        $proveedor->asociarProducto($rutprov[$i], $serieinterna, $pcompra[$i], $codprov[$i]);
                        $i++;
                    }

                    header("Location: index.php?controlador=Maquinas&accion=nuevo&infomsg=si");
                    return;

                }else{//modificar el info msg
                    $this->info_msg = "<script>javascript:alert('Error al ingresar nueva Máquina, contacte al Administrador.');</script>";
                }
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Máquina', 1, 1, 1);
        }
        $tipomaquina = new TipoMaquina($this->NX_CONFIG);
        $this->tiposmaquina = $tipomaquina->listar();
        $marcamaquina = new MarcaMaquina($this->NX_CONFIG);
        $this->marcasmaquina = $marcamaquina->listar();
        $this->contenido = $this->ver('nueva_maquina');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : comprar">
    function comprar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $tipomaquina = new TipoMaquina($this->NX_CONFIG);
        $this->tiposmaquina = $tipomaquina->listar();
        $marcamaquina = new MarcaMaquina($this->NX_CONFIG);
        $this->marcasmaquina = $marcamaquina->listar();
        return $this->ver('nueva_maquina_compra');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : editar">
    function editar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $serieinterna 	= $_POST['serieinterna'];
            $seriemaquina 	= $_POST['seriemaquina'];

            $modelo 		= $_POST['modelo'];
            $formato 		= $_POST['formato'];
            $conectividad 	= $_POST['conectividad'];

            $rutprov		= $_POST['rutproveedor'];
            $pcompra		= $_POST['pcompra'];
            $pventa  		= isset($_POST['pventa']) ?? $_POST['pventa'] ;
            $codprov		= $_POST['codprov'];

            $ok = $this->maquinas->modificar($serieinterna, $seriemaquina, $modelo, $formato, $conectividad, 0);
            if($ok)
            {
                $proveedor = new Proveedor($this->NX_CONFIG);
                $proveedores = $proveedor->obtenerProveedores($serieinterna);
                if(isset($proveedores))//antiguos proveedores
                {
                    foreach($proveedores as $p)
                    {
                        $proveedor->borrarProducto($p["rut"], $serieinterna);
                    }
                }

                $n  = count($rutprov); //nuevos proveedores
                $i  = 0;
                while ($i < $n){
                    $proveedor->asociarProducto($rutprov[$i], $serieinterna, $pcompra[$i], $codprov[$i]);
                    $i++;
                }

                header('Location: index.php?controlador=Maquinas&accion=editar&infomsg=si&serieinterna='.$serieinterna);
                return;
            }else{
                $this->info_msg = "<script>alert('Error al actualizar la Máquina, contacte al Administrador.');</script>";
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Máquina', 2, 1, 1);
        }
        $serieinterna = $_GET['serieinterna'];
        $this->datosmaquina = $this->maquinas->obtenerDatos($serieinterna);
        $proveedor = new Proveedor($this->NX_CONFIG);
        $this->proveedoresmaquina = $proveedor->obtenerProveedores($serieinterna);
        $this->contenido = $this->ver('editar_maquina');
        return $this->ver('index');
    }
    //</editor-fold>

    function eliminar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $serieinterna = $_GET['serieinterna'];
        $this->maquinas->eliminar($serieinterna);
        header('location: index.php?controlador=Maquinas&accion=listar');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=6
            and $_SESSION['area']!=7 and $_SESSION['area']!=8 and $_SESSION['area']!=9 and $_SESSION['area']!=10  && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 20; //Registros a mostrar por cada página
        $this->pagVisible = 8; //paginas a mostrar en la paginación


        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->marca = (!isset($_GET['filtromarca']) ? null : $_GET['filtromarca']);
        $this->tipo = (!isset($_GET['filtrotipo']) ? null : $_GET['filtrotipo']);
        $this->existe = (!isset($_GET['filtroexiste']) ? null : $_GET['filtroexiste']);

        switch($this->orden)
        {
            default:
                $ordenStr = 'serieinterna';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'serieinterna DESC';
                break;
            case 3:
                $ordenStr = 'seriemaquina';
                break;
            case 4:
                $ordenStr = 'seriemaquina DESC';
                break;
        }

        switch($this->marca)
        {
            default:
                $whereMar = 'AND marca='.$this->marca;
                break;
            case 0:
                $whereMar = '';
                break;
        }

        switch($this->tipo)
        {
            default:
                $whereTip = 'AND tipomaquina='.$this->tipo;
                break;
            case 0:
                $whereTip = '';
                break;
        }

        switch($this->existe)
        {
            default:
                $whereExis = '';
                break;
            case 1:
                $whereExis = 'AND existe=1';
                break;
            case 2:
                $whereExis = 'AND existe=0 AND idfactura>0';
                break;
        }

        $cantidad = $this->maquinas->cantidad($this->buscar, $whereMar, $whereTip, $whereExis)["cantidad"];
        $this->lista = $this->maquinas->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereMar, $whereTip, $whereExis);
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $marcasmaq = new MarcaMaquina($this->NX_CONFIG);
        $this->marcas = $marcasmaq->listar();

        $tiposmaq = new TipoMaquina($this->NX_CONFIG);
        $this->tipos = $tiposmaq->listar();

        $this->contenido = $this->ver('listar_maquinas');
        return $this->ver('index');
    }
    //</editor-fold>

    function listarHistorial()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina 		= 1;
        $this->resultados 	= 20;

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->serieint = (!isset($_GET['serieinterna']) ? null : $_GET['serieinterna']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'fecha DESC';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'fecha ASC';
                break;
        }

        $this->lista = $this->maquinas->listarClientes($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->serieint);
        $cantidad = $this->maquinas->cantidadClientes($this->buscar, $this->serieint)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $this->contenido = $this->ver('historial_maquina');
        return $this->ver('index');
    }

    /************************      LISTAR MAQUINAS DE UN CLIENTE (MENU CLIENTES)         ************************/
    function listarPorCliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
        $this->ubicacion = (isset($_GET['ubicacion']) ? $_GET['ubicacion'] : null);
        $this->rutc = $_GET['rut'];

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'serieinterna';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'serieinterna DESC';
                break;
            case 3:
                $ordenStr = 'seriemaquina';
                break;
            case 4:
                $ordenStr = 'seriemaquina DESC';
                break;
            case 5:
                $ordenStr = 'ubicacion ';
                break;
            case 6:
                $ordenStr = 'ubicacion DESC';
                break;
        }

        $this->lista = $this->maquinas->listarPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->ubicacion);
        $cantidad = $this->maquinas->cantidadPorCliente($this->buscar, $this->rutc, $this->ubicacion)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_maquinas_cliente');
    }

    /************************      LISTAR MAQUINAS RETIRADAS DE UN CLIENTE (MENU CLIENTES)         ************************/
    function listarRetiradasPorCliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->rutc = $_GET['rut'];

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];

        switch($this->orden)
        {
            default:
                $ordenStr = 'serieinterna';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'serieinterna DESC';
                break;
            case 3:
                $ordenStr = 'seriemaquina';
                break;
            case 4:
                $ordenStr = 'seriemaquina DESC';
                break;
        }

        $this->lista = $this->maquinas->listarRetiradasPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->maquinas->cantidadRetiradasPorCliente($this->buscar, $this->rutc)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_maquinas_retiradas_cliente');
    }

    function darPorFacturada()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $rut 			= $_GET['rut'];
        $serieinterna 	= $_GET['serieinterna'];
        $this->maquinas->setEstadoFacturada($rut, $serieinterna, 1);
        header('location: index.php?controlador=Clientes&accion=listar');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
    function seleccionar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->rutc = $_GET['rut'];
        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->ubicacion = (isset($_GET['ubicacion']) ? $_GET['ubicacion'] : null);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'serieinterna';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'serieinterna DESC';
                break;
            case 3:
                $ordenStr = 'seriemaquina';
                break;
            case 4:
                $ordenStr = 'seriemaquina DESC ';
                break;
            case 5:
                $ordenStr = 'ubicacion ';
                break;
            case 6:
                $ordenStr = 'ubicacion DESC ';
                break;
        }

        $this->lista = $this->maquinas->listarPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->ubicacion);
        $cantidad = $this->maquinas->cantidadPorCliente($this->buscar, $this->rutc, $this->ubicacion)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_maquina_de_cliente');
    }
    //</editor-fold>

    /*****************************************************************************************************************/
    /************************************      MUESTRA TODAS LAS MAQUINAS         ************************************/
    /*****************************************************************************************************************/
    function seleccionarTodos()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        switch($this->orden)
        {
            default:
                $ordenStr = 'serieinterna';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'serieinterna DESC';
                break;
            case 3:
                $ordenStr = 'seriemaquina';
                break;
            case 4:
                $ordenStr = 'seriemaquina DESC';
                break;
        }

        $whereMar = "";
        $whereTip = "";
        $whereExis = "AND existe=1";

        $this->lista = $this->maquinas->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereMar, $whereTip, $whereExis);
        $cantidad = $this->maquinas->cantidad($this->buscar, $whereMar, $whereTip, $whereExis)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_maquina');
    }

    /*****************************************************************************************************************/
    /******************      LISTAR MAQUINAS DE UN CLIENTE PARA FACTURACION (MENU CLIENTES)         ******************/
    /*****************************************************************************************************************/
    function listarFacturacionPorCliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        $this->rutc = $_GET['rut'];
        $this->anio = $_GET['anio'];

        if(!is_numeric($_GET['anio']))
            //$this->anio = getdate()[year];
            $this->anio = date("Y");

        $this->resultados = 20;
        $this->buscar = $_GET['buscar'];
        if(is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];

        $this->lista = $this->maquinas->listarFacturacionAnualPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->anio);
        $cantidad = $this->maquinas->cantidadPorCliente($this->buscar, $this->rutc);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_maquinas_facturacion_cliente');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarFacturacionTotalPorCliente">
    /*****************************************************************************************************************/
    /**********************  LISTAR TODAS MAQUINAS DE UN CLIENTE PARA FACTURACION (MENU CLIENTES)  *******************/
    /*****************************************************************************************************************/
    function listarFacturacionTotalPorCliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        $this->rutc = (isset($_GET['rut']) ? $_GET['rut'] : null);
        $this->anio = (isset($_GET['anio']) ? $_GET['anio'] : null);
        $this->mes = (isset($_GET['mes']) ? $_GET['mes'] : null);
        $this->idmaquina = (isset($_GET['idmaquina']) ? $_GET['idmaquina'] : null);
        $this->posicion = (isset($_GET['posicion']) ? $_GET['posicion'] : null);

        if(isset($_GET['anio']) && !is_numeric($_GET['anio'])) {
            $this->anio = date("Y");
        }
        if(isset($_GET['mes']) && !is_numeric($_GET['mes'])) {
            $this->mes = "0";
        }
        $this->clausulaMes = "";

        if($this->mes > 0)
        {
            $this->clausulaMes = "and month(contadores.fechafacturacion) = " . $this->mes;
        }

        $this->resultados = 15;
        $this->buscar = isset($_GET['buscar']) ? $_GET['buscar'] : null;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->lista = $this->maquinas->listarFacturacionTotalPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->idmaquina, $this->anio, $this->clausulaMes, $this->buscar);
        $cantidad = $this->maquinas->cantidadFacturacionTotalPorCliente($this->rutc, $this->idmaquina, $this->anio, $this->clausulaMes, $this->buscar);

        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_maquinas_facturacion_total_cliente');
    }
    //</editor-fold>

    /*****************************************************************************************************************/
    /*******************  LISTAR TODAS MAQUINAS DE UN CLIENTE PARA FACTURACION MINIMO COPIADO GLOBAL  ****************/
    /*****************************************************************************************************************/
    function listarFacturacionTotalPorClienteMinimoCopiadoGlobal()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina 		= 1;

        $this->rutc = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->anio = (!isset($_GET['anio']) ? null : $_GET['anio']);
        $this->mes = (!isset($_GET['mes']) ? null : $_GET['mes']);
        $this->idmaquina = (!isset($_GET['idmaquina']) ? null : $_GET['idmaquina']);
        $this->posicion = (!isset($_GET['posicion']) ? null : $_GET['posicion']);
        $this->tiposervicio = (!isset($_GET['tiposervicio']) ? null : $_GET['tiposervicio']);

        if(isset($_GET['anio']) && is_numeric($_GET['anio']))
            $this->anio = date("Y");

        if(isset($_GET['mes']) && is_numeric($_GET['mes']))
            $this->mes = "0";

        $this->clausulaMes = "";
        $this->clausulatiposervicio = "";

        if($this->mes > 0)
        {
            $this->clausulaMes = " and month(contadores.fechafacturacion) = " . $this->mes;
        }

        if($this->tiposervicio > 0)
        {
            $this->clausulatiposervicio = " and copiascliente.idTipoServicioMaquina = " . $this->tiposervicio;
        }

        $this->resultados = 15;

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        $this->lista = $this->maquinas->listarFacturacionTotalPorClienteMinimoCopiadoGlobal($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->idmaquina, $this->anio, $this->clausulaMes, $this->buscar, $this->clausulatiposervicio);
        $cantidad = $this->maquinas->cantidadFacturacionTotalPorClienteMinimoCopiadoGlobal($this->rutc, $this->idmaquina, $this->anio, $this->clausulaMes, $this->buscar, $this->clausulatiposervicio);

        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_maquinas_facturacion_total_cliente_minimo_copiado_global');
    }

    /*****************************************************************************************************************/
    /***********************************  DETALLE FACTURA POR MAQUINAS  **********************************************/
    /*****************************************************************************************************************/
    function detalleMaquinaFactura()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerofactura			= $_POST['numfactura'];
            //$newnumeroactual 		= $numeroot + 1;
            $rut					= $_POST['rut'];
            $fecha					= $_POST['fecha'];
            $copias		    		= $_POST['copias'];
            $servicio				= $_POST['servicio'];
            $precio         		= $_POST['precioUnitario'];
            //$totalneto				= $_POST['totalItem'];
            $cantidadCargoFijo 		= $_POST['cantidadCargoFijo'];
            $descripcionCargoFijo	= $_POST['descripcionCargoFijo'];
            $valorCargoFijo			= $_POST['valorCargoFijo'];
            $this->mes				= $_POST['mes'];
            $this->anio				= $_POST['anio'];
            $this->razonsocial      = $_POST['razonsocial'];

            $fechavencimiento	= $_POST['fechavencimiento'];
            $formapago          = $_POST['formapago'];
            $referencias  		= $_POST['referencias'];
            $centrocosto        = $_POST['idcentrocosto'];

            if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

            $this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias); //Aplica el mismo procedimiento de Venta General. Pues solo guarda fecha, cliente y numero de factura
            $this->contadores->grabarFactura($rut,$this->mes,$this->anio,$numerofactura);

            $ok = false;
            $precioItem = 0;

            for ($i = 0; $i < count($copias); $i++) {
                if ( is_numeric($precio[$i]))
                {
                    $precioItem = $precio[$i];
                }

                $ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $servicio[$i], $copias[$i], $precioItem, $centrocosto);
                $precioItem = 0;
            }

            for ($i = 0; $i < count($descripcionCargoFijo); $i++) {
                if ( $valorCargoFijo[$i] > 0 )
                {
                    $ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $descripcionCargoFijo[$i], $cantidadCargoFijo[$i], $valorCargoFijo[$i], $centrocosto);
                }
                else
                {
                    $ok = true;
                }
            }

            if($ok){
                //$url = "excel/generarFactura.php?idFactura=" + $numerofactura	;
                //header("Location: $url");
                //header("Location: index.php?controlador=Clientes&accion=listarClientesArriendo&infomsg=si");
                //return;
                $this->factura = $numerofactura;
                $this->rut = $rut;
                $this->padre = "index.php?controlador=Clientes&accion=listarClientesArriendo";
                $this->contenido = $this->ver('factura_procesada');
                return $this->ver('index');
            }else{
                $this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
            }
        }

        $this->rut  = $_GET['rut'];
        $this->anio = $_GET['anio'];
        $this->mes  = $_GET['mes'];

        $this->lista = $this->maquinas->obtenerDatosFacturacionMensualPorCliente($this->rut, $this->anio, $this->mes);

        $this->listaCargoFijo = $this->maquinas->obtenerDatosFacturacionMensualPorClienteCargoFijo($this->rut, $this->anio, $this->mes);

        $this->cliente = $this->clientes->obtenerDatos($this->rut);
        $this->ultimaFactura = $this->facturas->obtenerUltimaFactura();
        $this->contenido = $this->ver('ver_maquina_factura');
        return $this->ver('index');
    }

    /*****************************************************************************************************************/
    /**********************************  DETALLE FACTURA POR MAQUINAS VERSION 2 **************************************/
    /*****************************************************************************************************************/
    function detalleMaquinaFacturaV2()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerofactura			= $_POST['numfactura'];
            //$newnumeroactual 		= $numeroot + 1;
            $rut					= $_POST['rut'];
            $fecha					= $_POST['fecha'];
            $copias		    		= $_POST['copias'];
            $servicio				= $_POST['servicio'];
            $precio         		= $_POST['precioUnitario'];
            //$totalneto				= $_POST['totalItem'];
            $cantidadCargoFijo 		= $_POST['cantidadCargoFijo'];
            $descripcionCargoFijo	= $_POST['descripcionCargoFijo'];
            $valorCargoFijo			= $_POST['valorCargoFijo'];
            $this->mes				= $_POST['mes'];
            $this->anio				= $_POST['anio'];
            $this->razonsocial      = $_POST['razonsocial'];

            $fechavencimiento	= $_POST['fechavencimiento'];
            $formapago          = $_POST['formapago'];
            $referencias  		= $_POST['referencias'];
            $centrocosto        = $_POST['idcentrocosto'];


            if($rut != $this->configuraciones->getValor(IDCONFIG_RUT_CSJ)){$totalneto=0;}//Si es cliente, la OT no tiene precio

            $this->facturas->nuevoVentaGeneral($numerofactura, $fecha, $rut, $fechavencimiento, $formapago, $referencias); //Aplica el mismo procedimiento de Venta General. Pues solo guarda fecha, cliente y numero de factura
            $this->contadores->grabarFactura($rut,$this->mes,$this->anio,$numerofactura);

            $ok = false;
            $precioItem = 0;

            for ($i = 0; $i < count($copias); $i++) {
                if ( is_numeric($precio[$i]))
                {
                    $precioItem = $precio[$i];
                }

                $ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $servicio[$i], $copias[$i], $precioItem);
                $precioItem = 0;
            }

            for ($i = 0; $i < count($descripcionCargoFijo); $i++) {
                if ( $valorCargoFijo[$i] > 0 )
                {
                    $ok = $this->facturas->nuevoItemVentaGeneral($numerofactura, $descripcionCargoFijo[$i], $cantidadCargoFijo[$i], $valorCargoFijo[$i], $centrocosto);
                }
                else
                {
                    $ok = true;
                }
            }

            if($ok){
                //$url = "excel/generarFactura.php?idFactura=" + $numerofactura	;
                //header("Location: $url");
                //header("Location: index.php?controlador=Clientes&accion=listarClientesArriendo&infomsg=si");
                //return;
                $this->factura = $numerofactura;
                $this->rut = $rut;
                $this->padre = "index.php?controlador=Clientes&accion=listarClientesArriendo";
                $this->contenido = $this->ver('factura_procesada');
                return $this->ver('index');
            }else{
                $this->info_msg = "<script>alert('Error al ingresar la Factura de Venta de Insumos/Repuestos, contacte al Administrador.');</script>";
            }
        }

        $this->rut  = $_GET['rut'];
        $this->anio = $_GET['anio'];
        $this->mes  = $_GET['mes'];

        $this->lista = $this->maquinas->obtenerDatosFacturacionMensualPorCliente($this->rut, $this->anio, $this->mes);

        $this->listaCargoFijo = $this->maquinas->obtenerDatosFacturacionMensualPorClienteCargoFijo($this->rut, $this->anio, $this->mes);

        $this->cliente = $this->clientes->obtenerDatos($this->rut);
        $this->ultimaFactura = $this->facturas->obtenerUltimaFactura();
        $this->contenido = $this->ver('ver_maquina_facturaV2');
        return $this->ver('index');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarMaquinasParaCotizacion">
    function listarMaquinasParaCotizacion()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=6
            and $_SESSION['area']!=7 and $_SESSION['area']!=8 and $_SESSION['area']!=9 and $_SESSION['area']!=10  && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada página
        $this->pagVisible = 8; //paginas a mostrar en la paginación

        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
        $this->marca = (isset($_GET['filtromarca']) ? $_GET['filtromarca'] : null);
        $this->tipo = (isset($_GET['filtrotipo']) ? $_GET['filtrotipo'] : null);

        switch($this->orden)
        {
            default:
                $ordenStr = 'modelo';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'modelo DESC';
                break;
            case 3:
                $ordenStr = 'nombremarca';
                break;
            case 4:
                $ordenStr = 'nombremarca DESC';
                break;
        }

        switch($this->marca)
        {
            default:
                $whereMar = 'AND marca='.$this->marca;
                break;
            case 0:
                $whereMar = '';
                break;
        }

        switch($this->tipo)
        {
            default:
                $whereTip = 'AND tipomaquina='.$this->tipo;
                break;
            case 0:
                $whereTip = '';
                break;
        }

        $cantidad = $this->maquinas->cantidadMaquinasParaCotizacion($this->buscar, $whereMar, $whereTip);
        $this->lista = $this->maquinas->listarMaquinasParaCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereMar, $whereTip);
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $marcasmaq = new MarcaMaquina($this->NX_CONFIG);
        $this->marcas = $marcasmaq->listar();

        $tiposmaq = new TipoMaquina($this->NX_CONFIG);
        $this->tipos = $tiposmaq->listar();

        $this->contenido = $this->ver('listar_maquinas_cotizacion');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoMaquinaParaCotizacion">
    function nuevoMaquinaParaCotizacion()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=9 )
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $tipomaquina    = $_POST['tipomaquina'];
            $marca          = $_POST['marca'];
            $modelo         = $_POST['modelo'];
            $formato        = $_POST['formato'];
            $conectividad   = $_POST['conectividad'];
            $condiciones    = $_POST['condiciones'];

            $periodo        = $_POST['periodo'];
            $bnMinimo       = $_POST['bnMinimo'];
            $colorMinimo    = $_POST['colorMinimo'];
            $scannerMinimo  = $_POST['scannerMinimo'];
            $bnCosto        = $_POST['bnCosto'];
            $colorCosto     = $_POST['colorCosto'];
            $scannerCosto   = $_POST['scannerCosto'];
            $cargoFijo      = $_POST['cargoFijo'];
            $stockarriendo  = $_POST['stockarriendo'];

            if($tipomaquina == -1)
            {
                $nombretipo = $_POST['nombretipo'];
                $tipomaq = new TipoMaquina($this->NX_CONFIG);
                $existe = $tipomaq->buscar(strtoupper($nombretipo));
                if(is_numeric($existe))
                {
                    $tipomaquina = $existe;//se le da la ID que ya estaba ingresada
                }else{
                    $tipomaquina = $tipomaq->nuevo(strtoupper($nombretipo));
                }
            }
            if($marca == -1)
            {
                $nombremarca = $_POST['nombremarca'];
                $marcas = new MarcaMaquina($this->NX_CONFIG);
                $existe = $marcas->buscar(strtoupper($nombremarca));
                if(is_numeric($existe))
                {
                    $marca = $existe;//se le da la ID que ya estaba ingresada
                }else{
                    $marca = $marcas->nuevo(strtoupper($nombremarca));
                }
            }
            $ultimoIdMaquinaCotizacion = $this->maquinas->ultimoIdMaquinaCotizacion()["id"] + 1;
            $ok = $this->maquinas->nuevoMaquinasParaCotizacion($ultimoIdMaquinaCotizacion, $tipomaquina, $marca, $modelo, $formato, $conectividad, 1,$condiciones, $stockarriendo);

            if ($ok)
            {
                $n        = count($bnMinimo);
                $i        = 0;
                while ($i < $n){
                    $this->maquinas->nuevoMaquinasParaCotizacionValores($ultimoIdMaquinaCotizacion,$periodo[$i],$bnMinimo[$i], $colorMinimo[$i], $scannerMinimo[$i],$bnCosto[$i], $colorCosto[$i], $scannerCosto[$i], $cargoFijo[$i]);
                    $i++;
                }

                header("Location: index.php?controlador=Maquinas&accion=editarMaquinaParaCotizacion&idmaquinacotizacion=" . $ultimoIdMaquinaCotizacion);
                return;
            }else{//modificar el info msg
                $this->info_msg = "<script>javascript:alert('Error al ingresar nueva Máquina, contacte al Administrador.');</script>";
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Máquina', 1, 1, 1);
        }

        $tipomaquina = new TipoMaquina($this->NX_CONFIG);
        $this->tiposmaquina = $tipomaquina->listar();
        $marcamaquina = new MarcaMaquina($this->NX_CONFIG);
        $this->marcasmaquina = $marcamaquina->listar();
        $cotizaciones = new Cotizacion($this->NX_CONFIG);
        $this->datosperiodos = $cotizaciones->obtenerDatosPeriodos();
        $this->contenido = $this->ver('nueva_maquina_para_cotizacion');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : editarMaquinaParaCotizacion">
    function editarMaquinaParaCotizacion()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=9 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $idmaquinacotizacion 	= $_POST['idmaquinacotizacion'];

            $modelo 		= $_POST['modelo'];
            $formato 		= $_POST['formato'];
            $conectividad 	= $_POST['conectividad'];
            $condiciones 	= $_POST['condiciones'];

            $periodo        = $_POST['periodo'];
            $bnMinimo       = $_POST['bnMinimo'];
            $colorMinimo    = $_POST['colorMinimo'];
            $scannerMinimo  = $_POST['scannerMinimo'];
            $bnCosto        = $_POST['bnCosto'];
            $colorCosto     = $_POST['colorCosto'];
            $scannerCosto   = $_POST['scannerCosto'];
            $cargoFijo      = $_POST['cargoFijo'];
            $idValor        = $_POST['idValor'];
            $idValorBorrar  = $_POST['idValorBorrar'];
            $stockarriendo  = $_POST['stockarriendo'];

            $idValorBorrarArray = explode(',', $idValorBorrar);

            $ok = $this->maquinas->modificarMaquinasCotizacion($idmaquinacotizacion, $modelo, $formato, $conectividad, $condiciones, $stockarriendo);
            if($ok)
            {
                $n        = count($bnMinimo);
                $i        = 0;
                while ($i < $n){
                    if (empty($idValor[$i])) {
                        $this->maquinas->nuevoMaquinasParaCotizacionValores($idmaquinacotizacion, $periodo[$i], $bnMinimo[$i], $colorMinimo[$i], $scannerMinimo[$i], $bnCosto[$i], $colorCosto[$i], $scannerCosto[$i], $cargoFijo[$i]);
                    }
                    else
                    {
                        $this->maquinas->modificarMaquinasParaCotizacionValores($idValor[$i], $periodo[$i], $bnMinimo[$i], $colorMinimo[$i], $scannerMinimo[$i], $bnCosto[$i], $colorCosto[$i], $scannerCosto[$i], $cargoFijo[$i]);
                    }
                    $i++;
                }

                //BLOQUE PARA ELIMINAR LINEA DE VALORES PARA EL PERIODO Y LA MAQUINA ESPECIFICA
                //SE DEBEN BORRAR LAS OPCIONES TAMBIEN DADO EL IDVALOR ENVIADO
                $m       = count($idValorBorrarArray);
                $j       = 0;
                while ($j < $m){
                    $this->maquinas->eliminarMaquinasParaCotizacionValoresporIdValor($idValorBorrarArray[$j]);
                    $this->maquinas->eliminarMaquinasParaCotizacionOpcionesporIdValor($idValorBorrarArray[$j]);
                    $j++;
                }

                header('Location: index.php?controlador=Maquinas&accion=editarMaquinaParaCotizacion&infomsg=si&idmaquinacotizacion='.$idmaquinacotizacion);
                return;
            }else{
                $this->info_msg = "<script>alert('Error al actualizar la Máquina, contacte al Administrador.');</script>";
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Máquina', 2, 1, 1);
        }

        $idmaquinacotizacion = $_GET['idmaquinacotizacion'];
        $this->datosmaquina = $this->maquinas->obtenerDatosMaquinasCotizacion($idmaquinacotizacion);
        $this->datosvalores = $this->maquinas->obtenerDatosMaquinasCotizacionValores($idmaquinacotizacion);
        $cotizaciones = new Cotizacion($this->NX_CONFIG);
        $this->datosperiodos = $cotizaciones->obtenerDatosPeriodos();
        $this->contenido = $this->ver('editar_maquina_para_cotizacion');
        return $this->ver('index');
    }
    //</editor-fold>

    function eliminarMaquinaParaCotizacion()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 and $_SESSION['area']!=9 and $_SESSION['area']!=10 && $_SESSION['area']!=11) {
            header('location: index.php?error=restringido');
            return;
        }
        $idmaquinacotizacion = $_GET['idmaquinacotizacion'];
        $this->maquinas->eliminarMaquinasCotizacion($idmaquinacotizacion);
        header('location: index.php?controlador=Maquinas&accion=listarMaquinasParaCotizacion');
    }

    function nuevoPeriodoMaquinaParaCotizacion()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        if ($_SESSION['area'] != 2 and $_SESSION['area'] != 5 and $_SESSION['area'] != 9 and $_SESSION['area'] != 8) {
            header('location: index.php?error=restringido');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $nuevoperiodo = $_POST['nuevoperiodo'];

            $ok = $this->cotizaciones->nuevoPeriodoCotizacion($nuevoperiodo);
            if ($ok) {
                return $this->info_msg = $this->msg('popup', 'Periodo Cotizacion', 1, 0, 1);
            } else {
                return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Periodoperpo, contacte al Administrador.');</script>";
            }

        }
        return $this->ver('nuevo_periodo_maquina_cotizacion');
    }

    function nuevoOpcionesPeriodoMaquinaParaCotizacion()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        if ($_SESSION['area'] != 2 and $_SESSION['area'] != 5 and $_SESSION['area'] != 9 and $_SESSION['area'] != 8) {
            header('location: index.php?error=restringido');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $nuevoperiodo = $_POST['nuevoperiodo'];

            $ok = $this->cotizaciones->nuevoPeriodoCotizacion($nuevoperiodo);
            if ($ok) {
                return $this->info_msg = $this->msg('popup', 'Periodo Cotizacion', 1, 0, 1);
            } else {
                return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Periodoperpo, contacte al Administrador.');</script>";
            }

        }
        $this->idValorPeriodoMaquina = $_GET['idValorPeriodoMaquina'];
        return $this->ver('nuevo_opciones_periodo_maquina_cotizacion');
    }

    function editarOpcionesPeriodoMaquinaParaCotizacion()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        if ($_SESSION['area'] != 2 and $_SESSION['area'] != 5 and $_SESSION['area'] != 9 and $_SESSION['area'] != 8) {
            header('location: index.php?error=restringido');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {
            $opcionDescripcion = $_POST['opcionDescripcion'];
            $valorDescripcion = $_POST['valorDescripcion'];
            $idValor = $_POST['idValor'];

            //Borrar los datos con IDValor

            $this->maquinas->eliminarDatosMaquinasCotizacionValoresOpciones($idValor);

            //Crear datos nuevos con IDValor
            $n        = count($opcionDescripcion);
            $op        = 0;

            while ($op < $n){
                $ok = $this->maquinas->ingresarDatosMaquinasCotizacionValoresOpciones($idValor, $opcionDescripcion[$op], $valorDescripcion[$op]);
                $op++;
            }

            if ($ok) {
                return $this->info_msg = $this->msg('popup', 'Opciones Maquina', 1, 0, 1);
            } else {
                return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Opciones, contacte al Administrador.');</script>";
            }

        }
        $this->idPeriodo = $_GET['idPeriodo'];
        $this->idMaquinaCotizacion = $_GET['idMaquinaCotizacion'];

        $this->idValor = $this->maquinas->obteneriDValorPeriodoMaquinaOpciones($this->idPeriodo,$this->idMaquinaCotizacion);
        $this->datosopciones = $this->maquinas->obtenerDatosMaquinasCotizacionValoresOpciones($this->idValor);

        return $this->ver('editar_opciones_periodo_maquina_cotizacion');
    }

    function listarMaquinasParaCotizacionVentas()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=6
            and $_SESSION['area']!=7 and $_SESSION['area']!=8 and $_SESSION['area']!=9 and $_SESSION['area']!=10  && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada página
        $this->pagVisible = 8; //paginas a mostrar en la paginación

        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
        $this->marca = (isset($_GET['filtromarca']) ? $_GET['filtromarca'] : null);
        $this->tipo = (isset($_GET['filtrotipo']) ? $_GET['filtrotipo'] : null);

        switch($this->orden)
        {
            default:
                $ordenStr = 'modelo';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'modelo DESC';
                break;
            case 3:
                $ordenStr = 'nombremarca';
                break;
            case 4:
                $ordenStr = 'nombremarca DESC';
                break;
        }

        switch($this->marca)
        {
            default:
                $whereMar = 'AND marca='.$this->marca;
                break;
            case 0:
                $whereMar = '';
                break;
        }

        switch($this->tipo)
        {
            default:
                $whereTip = 'AND tipomaquina='.$this->tipo;
                break;
            case 0:
                $whereTip = '';
                break;
        }

        $cantidad = $this->maquinas->cantidadMaquinasParaCotizacionVentas($this->buscar, $whereMar, $whereTip);
        $this->lista = $this->maquinas->listarMaquinasParaCotizacionVentas($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereMar, $whereTip);
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $marcasmaq = new MarcaMaquina($this->NX_CONFIG);
        $this->marcas = $marcasmaq->listar();

        $tiposmaq = new TipoMaquina($this->NX_CONFIG);
        $this->tipos = $tiposmaq->listar();

        $this->contenido = $this->ver('listar_maquinas_cotizacion_ventas');
        return $this->ver('index');
    }

    function nuevoMaquinaParaCotizacionVentas()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=9 )
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $tipomaquina    = $_POST['tipomaquina'];
            $marca          = $_POST['marca'];
            $modelo         = $_POST['modelo'];
            $formato        = $_POST['formato'];
            $conectividad   = $_POST['conectividad'];
            $instalacion   = $_POST['instalacion'];
            $descripcion    = $_POST['descripcion'];
            $preciocompra = $_POST['preciocompra'];
            $precioventa = $_POST['precioventa'];
            $ganancia = $_POST['ganancia'];
            $fleteproveedor = $_POST['fleteproveedor'];
            $fletecliente = $_POST['fletecliente'];
            $descripcion = $_POST['descripcion'];
            $stockventa = $_POST['stockventa'];

            if($tipomaquina == -1)
            {
                $nombretipo = $_POST['nombretipo'];
                $tipomaq = new TipoMaquina($this->NX_CONFIG);
                $existe = $tipomaq->buscar(strtoupper($nombretipo));
                if(is_numeric($existe))
                {
                    $tipomaquina = $existe;//se le da la ID que ya estaba ingresada
                }else{
                    $tipomaquina = $tipomaq->nuevo(strtoupper($nombretipo));
                }
            }
            if($marca == -1)
            {
                $nombremarca = $_POST['nombremarca'];
                $marcas = new MarcaMaquina($this->NX_CONFIG);
                $existe = $marcas->buscar(strtoupper($nombremarca));
                if(is_numeric($existe))
                {
                    $marca = $existe;//se le da la ID que ya estaba ingresada
                }else{
                    $marca = $marcas->nuevo(strtoupper($nombremarca));
                }
            }
            $ultimoIdMaquinaCotizacionVentas = $this->maquinas->ultimoIdMaquinaCotizacionVentas() + 1;
            $ok = $this->maquinas->nuevoMaquinasParaCotizacionVentas($ultimoIdMaquinaCotizacionVentas, $tipomaquina, $marca, $modelo, $formato, $conectividad, 1,$preciocompra, $precioventa, $ganancia, $fleteproveedor, $fletecliente, $descripcion, $stockventa, $instalacion);

            if ($ok)
            {
                $n        = count($bnMinimo);
                $i        = 0;
                while ($i < $n){
                    $this->maquinas->nuevoMaquinasParaCotizacionValoresVentas($ultimoIdMaquinaCotizacion,$periodo[$i],$bnMinimo[$i], $colorMinimo[$i], $scannerMinimo[$i],$bnCosto[$i], $colorCosto[$i], $scannerCosto[$i], $cargoFijo[$i]);
                    $i++;
                }

                header("Location: index.php?controlador=Maquinas&accion=listarMaquinasParaCotizacionVentas");
                return;
            }else{//modificar el info msg
                $this->info_msg = "<script>javascript:alert('Error al ingresar nueva Máquina, contacte al Administrador.');</script>";
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Máquina', 1, 1, 1);
        }

        $tipomaquina = new TipoMaquina($this->NX_CONFIG);
        $this->tiposmaquina = $tipomaquina->listar();
        $marcamaquina = new MarcaMaquina($this->NX_CONFIG);
        $this->marcasmaquina = $marcamaquina->listar();
        $cotizaciones = new Cotizacion($this->NX_CONFIG);
        $this->contenido = $this->ver('nueva_maquina_para_cotizacion_ventas');
        return $this->ver('index');
    }

    function editarMaquinaParaCotizacionVentas()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 and $_SESSION['area']!=2 and $_SESSION['area']!=5 and $_SESSION['area']!=8 and $_SESSION['area']!=9 and $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $idmaquinacotizacionventas 	= $_POST['idmaquinacotizacionventas'];

            $modelo         = $_POST['modelo'];
            $formato        = $_POST['formato'];
            $conectividad   = $_POST['conectividad'];
            $instalacion   = $_POST['instalacion'];
            $descripcion    = $_POST['descripcion'];
            $preciocompra = $_POST['preciocompra'];
            $precioventa = $_POST['precioventa'];
            $ganancia = $_POST['ganancia'];
            $fleteproveedor = $_POST['fleteproveedor'];
            $fletecliente = $_POST['fletecliente'];
            $descripcion = $_POST['descripcion'];
            $stockventa = $_POST['stockventa'];


            $ok = $this->maquinas->modificarMaquinasCotizacionVentas($idmaquinacotizacionventas, $modelo, $formato, $conectividad, $preciocompra, $precioventa, $ganancia, $fleteproveedor, $fletecliente, $descripcion, $stockventa, $instalacion);

            if($ok)
            {
                header('Location: index.php?controlador=Maquinas&accion=editarMaquinaParaCotizacionVentas&infomsg=si&idmaquinacotizacionventas='.$idmaquinacotizacionventas);
                return;
            }else{
                $this->info_msg = "<script>alert('Error al actualizar la Máquina, contacte al Administrador.');</script>";
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Máquina', 2, 1, 1);
        }

        $idmaquinacotizacionventas = $_GET['idmaquinacotizacionventas'];
        $this->datosmaquina = $this->maquinas->obtenerDatosMaquinasCotizacionVentas($idmaquinacotizacionventas);
        $cotizaciones = new Cotizacion($this->NX_CONFIG);
        $this->contenido = $this->ver('editar_maquina_para_cotizacion_ventas');
        return $this->ver('index');
    }

    function eliminarMaquinaParaCotizacionVentas()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 and $_SESSION['area']!=9 and $_SESSION['area']!=10 && $_SESSION['area']!=11) {
            header('location: index.php?error=restringido');
            return;
        }
        $idmaquinacotizacionventas = $_GET['idmaquinacotizacionventas'];
        $this->maquinas->eliminarMaquinasCotizacionVentas($idmaquinacotizacionventas);
        header('location: index.php?controlador=Maquinas&accion=listarMaquinasParaCotizacionVentas');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarPorClienteMinimoCopiadoGlobal">
    function listarPorClienteMinimoCopiadoGlobal()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==6)//Solo secretaria no puede ver la información del cliente
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
        $this->ubicacion = (isset($_GET['ubicacion']) ? $_GET['ubicacion'] : null);
        $this->rutc = $_GET['rut'];

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'serieinterna';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'serieinterna DESC';
                break;
            case 3:
                $ordenStr = 'seriemaquina';
                break;
            case 4:
                $ordenStr = 'seriemaquina DESC';
                break;
        }

        $this->lista = $this->maquinas->listarPorCliente($this->rutc, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->ubicacion);
        $cantidad = $this->maquinas->cantidadPorCliente($this->buscar, $this->rutc, $this->ubicacion);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_maquinas_cliente');
    }
    //</editor-fold>
}
?>