﻿<?php

class LlamadosControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	private $llamados;
	private $fallas;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->fallas = new Fallas($this->NX_CONFIG);
		$this->llamados = new Llamados($this->NX_CONFIG);
		$this->tecnicos = new Usuarios($this->NX_CONFIG);
	}
    //</editor-fold>
	
	public function inicio()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->contenido = $this->ver('inicio_lista_llamados');
		return $this->ver('index');
	}
	
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']))
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$rut 				= $_POST['rut'];
			$serieInterna 		= $_POST['serieinterna'];
			$correlativo 		= $_POST['correlativo'];
			$tipo 				= $_POST['tipollamado'];
			$otroTipo			= addslashes($_POST['otrotipollamada']);
			$idFalla			= $_POST['idfalla'];
			$otraFalla			= addslashes($_POST['otrafalla']);
			$codFalla			= $_POST['codigofalla'];
			$prioridad			= $_POST['prioridad'];	
			$nombrecontacto 	= $_POST['nombrecontacto'];
			$telefonocontacto	= $_POST['telefonocontacto'];
			
			switch($tipo)
			{         
				case 1:
					$tipo = 'Tel�fono';
				break;
				case 2:
					$tipo = 'Correo';
				break;
				case 3:
					$tipo = 'Personal';
				break;
				case 4:
					$tipo = 'Fax';
				break;
			}			
						
			$ok = $this->llamados->nuevo($rut, $serieInterna, $correlativo, $tipo, $otroTipo, $idFalla, $otraFalla, $codFalla, $prioridad, $nombrecontacto, $telefonocontacto);	
			
			if($ok)
			{
				header("Location: index.php?controlador=Llamados&accion=nuevo&infomsg=si");
				return;	
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar el Llamado, contacte al Administrador.');</script>";
			}
		}
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
		{
			$this->info_msg  = $this->msg('completa', 'llamado', 1, 0, 1);	
		}
		$this->listaFallas = $this->fallas->listar();	
		$this->contenido = $this->ver('nuevo_llamado');				
		return $this->ver('index');
	}
	
	public function eliminar()
	{		
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=5) 
		{
			header('location: index.php?error=restringido');
			return;
		}	

		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$idllamado = $_POST['idllamado'];
			$razon = $_POST['razon'];
			$idmaquina = $_POST['idmaquina'];					
			//$this->proveedor->modificar($rut, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro);
			$this->llamados->eliminar($idllamado, $razon);
			return $this->info_msg = $this->msg('popup', 'llamado', 3,0,1);
		}
		$this->idllamado = (!isset($_GET['idllamado']) ? null : $_GET['idllamado']);
		$this->idmaquina = $_GET['idmaquina'];		
		//$this->datosproveedor = $this->proveedor->obtenerDatos($rut);
		return $this->ver('eliminar_llamado');						
	}

	public function listarLlamadosPendientesByMaquinaReport()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$serieInterna 	= $_POST['serieinterna'];
			$correlativo 	= $_POST['correlativo'];
			$this->listaPendientes = $this->llamados->listarLlamadosPendientesByMaquinaRep($serieInterna, $correlativo);
			return $this->ver('llamados_maquinas_report');		
		}		
	}
	
	/** LLAMADOS PENDIENTES DE TODOS LOS CLIENTES Y DEL CLIENTE **/
	public function listarLlamadosPendientesClientes()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		$this->resultados = 20;
        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

		switch($this->orden)
		{
			default:
				$ordenStr = 'razonsocial';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'razonsocial DESC';
			break;
			case 3:
				$ordenStr = 'rut';
			break;
			case 4:
				$ordenStr = 'rut DESC';
			break;	
		}
		
		$this->listaPendientes = $this->llamados->listarLlamadosPendientesClientes($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		$cantidad = $this->llamados->cantidad('rut')["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		$this->contenido = $this->ver('listar_llamados_clientes_pendientes');
		return $this->ver('index');	
		
	}
	
	public function listarLlamadosPendientesByCliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
		$this->listaPendientes = $this->llamados->listarLlamadosPendientesByCliente($rut);	
		return $this->ver('menu_llamados_pendientes_cliente');		

	}
	/** FIN **/

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarLlamadosPendientesMaquinas">
	public function listarLlamadosPendientesMaquinas()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n


        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

		switch($this->orden)
		{
			default:
				$ordenStr = 'llamados.fecha';
			break;
			case 1:
				$ordenStr = 'serieinterna';
			break;
			case 2:
				$ordenStr = 'serieinterna DESC';
			break;
			case 3:
				$ordenStr = 'llamados.fecha';
			break;
			case 4:
				$ordenStr = 'llamados.fecha DESC';
			break;	
		}
		
		$this->listaPendientes = $this->llamados->listarLlamadosPendientesMaquinas($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);	
		$cantidad = $this->llamados->cantidadllamadosPendientesMaquinas($this->buscar)["cantidad"];
		$this->nPaginas = ceil($cantidad / $this->resultados);
		$this->contenido = $this->ver('listar_llamados_maquinas_pendientes');
		return $this->ver('index');			
	}
    //</editor-fold>
	
	//LLAMADOS AL CLICKEAR EN LA MAQUINA
	public function listarLlamadosPendientesByMaquina()
	{
		if(!isset($_SESSION['usuario']) )
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$serieinterna 	= $_GET['serieinterna'];
		$this->listaPendientes = $this->llamados->listarLlamadosPendientesByMaquina($serieinterna);
		return $this->ver('menu_llamados_pendientes_maquinas');
	}
	/** FIN **/
	
	//LLAMADOS AL CLICKEAR EN LA MAQUINA
	public function listarLlamadosPendientesByMaquinaAsignarTecnico()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}	

		if($_SERVER['REQUEST_METHOD']=='POST')
		{			
			$serieinterna = $_POST['serieinterna'];
			$ruttecnico = $_POST['ruttecnico'];
			$this->llamados->asignartecnico($serieinterna, $ruttecnico);
			return $this->info_msg = $this->msg('popup', 'llamado, técnico asignado', 2,0,1);
		}
		
        $this->serieinterna = (!isset($_GET['serieinterna']) ? null : $_GET['serieinterna']);
		$this->listaPendientes = $this->llamados->listarLlamadosPendientesByMaquina($this->serieinterna);	
		$this->listaTecnicos = $this->tecnicos->listarUsuariosArea(7);
		return $this->ver('menu_llamados_pendientes_maquinas_asignar_tecnico');		

	}
	/** FIN **/	
	
	//LLAMADOS AL SELECCIONAR REPORTE POR TECNICO
	public function listarTecnico()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

		$this->fecha1 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
		$this->fecha2 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);
			
			if($this->fecha1 !="" && $this->fecha2 !="")
			{
				list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
				$fecha1 = "$anio/$mes/$dia"; 
				list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
				$fecha2 = "$anio/$mes/$dia"; 
				
				$fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
			}			

		switch($this->orden)
		{
			default:
				$ordenStr = 'usuarios.apellidos,clientes.razonsocial,maquinas.modelo';
			break;
			case 1:
				$ordenStr = 'usuarios.apellidos';
			break;
			case 2:
				$ordenStr = 'clientes.razonsocial';
			break;
			case 3:
				$ordenStr = 'maquinas.modelo';
			break;
			case 4:
				$ordenStr = 'llamados.fecha DESC';
			break;	
		}
		
		$this->listaPendientes = $this->llamados->listarLlamadosPorTecnico($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null);
		$cantidad = $this->llamados->cantidadLlamadosPorTecnico($this->buscar, $fechas ?? null);
		$this->nPaginas = ceil($cantidad / $this->resultados);
		$this->contenido = $this->ver('listar_llamado_por_tecnico');
		return $this->ver('index');			
	}

	public function listarLlamadosPorTecnicoByTecnico()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$tecnico	= $_GET['tecnico'];	
		$empresa 	= $_GET['empresa'];	
		$maquina 	= $_GET['maquina'];	
		$this->listaPendientes = $this->llamados->listarLlamadosPorTecnicoByTecnico($tecnico,$empresa,$maquina);	
		return $this->ver('menu_llamados_tecnico_bytecnico');		
	}
	/** FIN **/
	
	/** LLAMADOS HISTORICOS	DE LAS MAQUINAS, PRIMER LLAMADO AL ENTRAR A LA P�GINA**/
	public function listarLlamadosHistoricosMaquinas()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

		$this->fecha1 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
		$this->fecha2 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);
			
		if($this->fecha1 !="" && $this->fecha2 !="")
		{
			list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
			$fecha2 = "$anio/$mes/$dia"; 
			
			$fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
		}			

		switch($this->orden)
		{
			default:
				$ordenStr = 'llamados.fecha';
			break;
			case 1:
				$ordenStr = 'serieinterna';
			break;
			case 2:
				$ordenStr = 'serieinterna DESC';
			break;
			case 3:
				$ordenStr = 'Cantidad';
			break;
			case 4:
				$ordenStr = 'Cantidad DESC';
			break;	
		}
		
		$this->listaPendientes = $this->llamados->listarLlamadosHistoricosMaquinas($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null);
		$cantidad = $this->llamados->cantidadLlamadosHistoricosMaquinas($this->buscar, $fechas ?? null);
		$this->nPaginas = ceil($cantidad / $this->resultados);
		$this->contenido = $this->ver('listar_llamados_historicos_maquinas');
		return $this->ver('index');			
	}
	
	//LLAMADOS AL CLICKEAR EN LA MAQUINA
	public function listarLlamadosHistoricosByMaquina()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$serieinterna 	= $_GET['serieinterna'];  
		$this->listaPendientes = $this->llamados->listarLlamadosHistoricosMaquinasByMaquina($serieinterna);	
		return $this->ver('menu_llamados_historicos_maquina');		

	}
	/** FIN **/	

	/** LLAMADOS HISTORICOS DE TODOS LOS CLIENTES Y DEL CLIENTE **/
	public function listarLlamadosHistoricosClientes()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

		$this->fecha1 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
		$this->fecha2 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);
			
		if($this->fecha1 !="" && $this->fecha2 !="")
		{
			list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
			$fecha1 = "$anio/$mes/$dia"; 
			list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
			$fecha2 = "$anio/$mes/$dia"; 
			
			$fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";	
		}			

		switch($this->orden)
		{
			default:
				$ordenStr = 'razonsocial';
				$this->orden = 1;
			break;
			case 2:
				$ordenStr = 'razonsocial DESC';
			break;
			case 3:
				$ordenStr = 'rut';
			break;
			case 4:
				$ordenStr = 'rut DESC';
			break;	
		}
		
		$this->listaPendientes = $this->llamados->listarLlamadosHistoricosClientes($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null);
		$cantidad = $this->llamados->cantidadLlamadosHistoricosClientes($this->buscar, $fechas ?? null);
		$this->nPaginas = ceil($cantidad / $this->resultados);
		$this->contenido = $this->ver('listar_llamados_historicos_clientes');
		return $this->ver('index');		
	}
	
	public function listarLlamadosHistoricosByCliente()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']==4) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		$rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
		$this->listaPendientes = $this->llamados->listarLlamadosHistoricosByCliente($rut);	
		return $this->ver('menu_llamados_historicos_cliente');		

	}

    //LLAMADOS AL SELECCIONAR REPORTE POR ASIGNACION DE TECNICO
    public function listarAsignacionTecnico()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==4)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        $this->fecha1 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        if($this->fecha1 !="" && $this->fecha2 !="")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
            $fecha2 = "$anio/$mes/$dia";

            $fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'usuarios.apellidos,clientes.razonsocial,maquinas.modelo';
                break;
            case 1:
                $ordenStr = 'usuarios.apellidos';
                break;
            case 2:
                $ordenStr = 'clientes.razonsocial';
                break;
            case 3:
                $ordenStr = 'maquinas.modelo';
                break;
            case 4:
                $ordenStr = 'llamados.fecha DESC';
                break;
        }

        $this->listaPendientes = $this->llamados->listarLlamadosAsignacionPorTecnico($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null);
        $cantidad = $this->llamados->cantidadLlamadosAsignacionPorTecnico($this->buscar, $fechas ?? null);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_llamado_asignacion_por_tecnico');
        return $this->ver('index');
    }

    public function listarReportsSinLlamado()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==4)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada pagina
        $this->pagVisible = 8; //paginas a mostrar en la paginacion

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        $this->idReport = (!isset($_GET['idReport']) ? null : $_GET['idReport']);
        $this->idllamado = (!isset($_GET['idllamado']) ? null : $_GET['idllamado']);
        $this->pendiente = (!isset($_GET['pendiente']) ? null : $_GET['pendiente']);

        $this->fecha1 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        $idllamadoWhere = "";
        $fechas = "";

        if(empty($this->idllamado))
        {
            $idllamadoWhere = "";
        }
        else
        {
            $idllamadoWhere = "AND llamados.idllamado LIKE '%".$this->idllamado."%' ";
        }

        if($this->fecha1 !="" && $this->fecha2 !="")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
            $fecha2 = "$anio/$mes/$dia";

            $fechas= "AND reports.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'usuarios.apellidos,clientes.razonsocial,maquinas.modelo';
                break;
            case 1:
                $ordenStr = 'usuarios.apellidos';
                break;
            case 2:
                $ordenStr = 'clientes.razonsocial';
                break;
            case 3:
                $ordenStr = 'maquinas.modelo';
                break;
        }

        switch($this->pendiente)
        {
            default:
                $pendiente = ' ';
                break;
            case 1:
                $pendiente = ' ';
                break;
            case 2:
                $pendiente = 'and llamados.pendiente = "NO" ';
                break;
            case 3:
                $pendiente = 'and llamados.pendiente = "SI" ';
                break;
            case 4:
                $pendiente = 'and llamados.pendiente is null ';
                break;
        }

        $this->listaPendientes = $this->llamados->listarLlamadosReportsSinLlamado($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null, $this->idReport, $idllamadoWhere, $pendiente);
        $cantidad = $this->llamados->cantidadLlamadosReportsSinLlamado($this->buscar, $fechas ?? null, $this->idReport, $idllamadoWhere, $pendiente);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_llamado_reports_sin_llamado');
        return $this->ver('index');
    }

    public function listarLlamadosGeneral()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==4)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        $this->idReport = (!isset($_GET['idReport']) ? null : $_GET['idReport']);
        $this->idllamado = (!isset($_GET['idllamado']) ? null : $_GET['idllamado']);
        $this->pendiente = (!isset($_GET['pendiente']) ? null : $_GET['pendiente']);

        $this->fecha1 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        $idllamadoWhere = "";

        if(empty($this->idllamado))
        {
            $idllamadoWhere = "";
        }
        else
        {
            $idllamadoWhere = "AND llamados.idllamado LIKE '%".$this->idllamado."%' ";
        }

        if($this->fecha1 !="" && $this->fecha2 !="")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
            $fecha2 = "$anio/$mes/$dia";

            $fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'usuarios.apellidos,clientes.razonsocial,maquinas.modelo';
                break;
            case 1:
                $ordenStr = 'usuarios.apellidos';
                break;
            case 2:
                $ordenStr = 'clientes.razonsocial';
                break;
            case 3:
                $ordenStr = 'llamados.fecha DESC';
                break;
        }

        switch($this->pendiente)
        {
            default:
                $pendiente = ' ';
                break;
            case 1:
                $pendiente = ' ';
                break;
            case 2:
                $pendiente = ' and llamados.pendiente = "NO" ';
                break;
            case 3:
                $pendiente = 'and llamados.pendiente = "SI" ';
                break;
        }

        $this->listaPendientes = $this->llamados->listarLlamadosGeneral($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null, $this->idReport, $idllamadoWhere, $pendiente);
        $cantidad = $this->llamados->cantidadLlamadosGeneral($this->buscar, $fechas ?? null, $this->idReport, $idllamadoWhere, $pendiente);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_llamados_general');
        return $this->ver('index');
    }

    public function listarLlamadosEliminados()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']==4)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        $this->idReport = (!isset($_GET['idReport']) ? null : $_GET['idReport']);
        $this->idllamado = (!isset($_GET['idllamado']) ? null : $_GET['idllamado']);
        $this->pendiente = (!isset($_GET['pendiente']) ? null : $_GET['pendiente']);

        $this->fecha1 = (!isset($_GET['fecha1']) ? null : $_GET['fecha1']);
        $this->fecha2 = (!isset($_GET['fecha2']) ? null : $_GET['fecha2']);

        $idllamadoWhere = "";

        if(empty($this->idllamado))
        {
            $idllamadoWhere = "";
        }
        else
        {
            $idllamadoWhere = "AND llamados.idllamado LIKE '%".$this->idllamado."%' ";
        }

        if($this->fecha1 !="" && $this->fecha2 !="")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fecha1);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fecha2);
            $fecha2 = "$anio/$mes/$dia";

            $fechas= "AND llamados.fecha BETWEEN '" . $fecha1 . "' AND ' " . $fecha2 . "'";
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'usuarios.apellidos,clientes.razonsocial,maquinas.modelo';
                break;
            case 1:
                $ordenStr = 'usuarios.apellidos';
                break;
            case 2:
                $ordenStr = 'clientes.razonsocial';
                break;
            case 3:
                $ordenStr = 'llamados.fecha DESC';
                break;
        }

        switch($this->pendiente)
        {
            default:
                $pendiente = ' ';
                break;
            case 1:
                $pendiente = ' ';
                break;
            case 2:
                $pendiente = ' and llamados.pendiente = "NO" ';
                break;
            case 3:
                $pendiente = 'and llamados.pendiente = "SI" ';
                break;
        }

        $this->listaPendientes = $this->llamados->listarLlamadosEliminados($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null, $this->idReport, $idllamadoWhere, $pendiente);
        $cantidad = $this->llamados->cantidadLlamadosEliminados($this->buscar, $fechas ?? null, $this->idReport, $idllamadoWhere, $pendiente);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_llamados_eliminados');
        return $this->ver('index');
    }
}
?>