<?php
//<editor-fold defaultstate="collapsed" desc="INCLUDES">
require_once("modelos/ControladorBD.php");
require_once("modelos/nx_utils.php");
//</editor-fold>
class CotizacionControlador extends Controlador
{
    var $cotizacion;
    var $maquinas;
    var $usuarios;
    private $NX_CONFIG;
    private $NX_UTILS;

    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->NX_UTILS = new NX_UTILS();
        $this->cotizacion = new Cotizacion($this->NX_CONFIG);
        $this->maquinas = new Maquinas($this->NX_CONFIG);
        $this->usuarios = new Usuarios($this->NX_CONFIG);
        $this->inventario = new Inventario($this->NX_CONFIG);
        $this->configuraciones	= new Configuraciones($this->NX_CONFIG);
    }

    function obtenernumero()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11 && $_SESSION['area']!=12)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->numero = $this->cotizacion->obtenernumero()["numero"];
        return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
    }

    function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

    }

    function arriendoMaquinas()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11 && $_SESSION['area']!=12)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerocotizacion = $_POST['numerocotizacion'];
            $nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_POST['rut'];

            $itemid		                = $_POST['itemid'];
            $itemcant		            = $_POST['itemcant'];
            $itemidmaquinacotizacion    = $_POST['itemidmaquinacotizacion'];
            $itemidperiodo		        = $_POST['itemidperiodo'];


            $bnMinimo       = $_POST['bnMinimo'];
            $colorMinimo	= $_POST['colorMinimo'];
            $scannerMinimo	= $_POST['scannerMinimo'];
            $bnCosto		= $_POST['bnCosto'];
            $colorCosto		= $_POST['colorCosto'];
            $scannerCosto	= $_POST['scannerCosto'];
            $cargoFijo		= $_POST['cargoFijo'];

            $tipocotizacion = 1; //1 para arriendo maquinas

            $this->cotizacion->nuevo($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor, '');

            $n        = count($itemidperiodo);
            $i        = 0;

            while ($i < $n){
                $this->cotizacion->ingresaritems($numerocotizacion, $itemidperiodo[$i], $itemidmaquinacotizacion[$i], $itemcant[$i], $bnMinimo[$i], $colorMinimo[$i], $scannerMinimo[$i],$bnCosto[$i], $colorCosto[$i], $scannerCosto[$i],$cargoFijo[$i]);

                //Hacer pregunta y ciclo para cargar los valores de opciones
                $idCotizacionItem = $this->cotizacion->obtenerdatosCotizacionIdItem($numerocotizacion, $itemidperiodo[$i], $itemidmaquinacotizacion[$i])["idCotizacionItem"];
                $listaOpciones = $this->cotizacion->obtenerdatosMaquinaPeriodoCostoOpciones($itemidperiodo[$i], $itemidmaquinacotizacion[$i]);

                if(count($listaOpciones )>0) {
                    $n = 0;
                    foreach ($listaOpciones as $opcionIngresar){
                        $this->cotizacion->ingresaritemsopciones($numerocotizacion, $idCotizacionItem, $opcionIngresar["descripcion"], $opcionIngresar["valor"],0);
                    }
                }
                $i++;
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;

            header($urlSiguiente);
            return;

        }else{//modificar el info msg
            $this->info_msg = "<script>alert('Error al ingresar la Cotizacion, contacte al Administrador.');</script>";
        }

        $this->info_msg = "";

        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Cotizacion', 1, 1, 1);
        }
        $this->rutVendedor = $_SESSION['rut'];
        $this->contenido = $this->ver('nueva_cotizacion_arriendo_maquina');
        return $this->ver('index');
    }

    function ventaMaquinas()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerocotizacion = (!isset($_POST['numerocotizacion']) ? null : $_POST['numerocotizacion']);
            $nombrecontacto = (!isset($_POST['nombrecontacto']) ? null : ucwords(strtolower($_POST['nombrecontacto'])));
            $nombreempresa = (!isset($_POST['nombreempresa']) ? null : ucwords(strtolower($_POST['nombreempresa'])));
            $direccion = (!isset($_POST['direccion']) ? null : ucwords(strtolower($_POST['direccion'])));
            $telefono = (!isset($_POST['telefono']) ? null : $_POST['telefono']);
            $correo = (!isset($_POST['correo']) ? null : $_POST['correo']);
            $ciudad = (!isset($_POST['ciudad']) ? null : ucwords(strtolower($_POST['ciudad'])));;
            $validez = (!isset($_POST['validez']) ? null : ucwords(strtolower($_POST['validez'])));
            $stock = (!isset($_POST['stock']) ? null : ucwords(strtolower($_POST['stock'])));
            $fecha = (!isset($_POST['fecha']) ? null : $_POST['fecha']);
            $idVendedor = (!isset($_POST['rut']) ? null : $_POST['rut']);

            $maquinaventaid = (!isset($_POST['maquinaventaid']) ? null : $_POST['maquinaventaid']);
            $maquinaventacant = (!isset($_POST['maquinaventacant']) ? null : $_POST['maquinaventacant']);
            $maquinaventaprec = (!isset($_POST['maquinaventaprec']) ? null : $_POST['maquinaventaprec']);

            $itemid		                = (!isset($_POST['itemid']) ? null : $_POST['itemid']);
            $itemcant		            = (!isset($_POST['itemcant']) ? null : $_POST['itemcant']);
            $itemidmaquinacotizacion    = (!isset($_POST['itemidmaquinacotizacion']) ? null : $_POST['itemidmaquinacotizacion']);
            $itemprecioventa            = (!isset($_POST['itemprecioventa']) ? null : $_POST['itemprecioventa']);

            $nuevoservicioid = (!isset($_POST['nuevoservicioid']) ? null : $_POST['nuevoservicioid']);
            $nuevoserviciodescripcion = (!isset($_POST['nuevoserviciodescripcion']) ? null : $_POST['nuevoserviciodescripcion']);
            $nuevoserviciocant = (!isset($_POST['nuevoserviciocant']) ? null : $_POST['nuevoserviciocant']);
            $nuevoservicioprecio = (!isset($_POST['nuevoservicioprecio']) ? null : $_POST['nuevoservicioprecio']);

            $tipocotizacion = 2; //2 para venta maquinas

            $this->cotizacion->nuevo($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor, $stock);

            if(isset($maquinaventaid) && count($maquinaventaid)>0) {
                $cantMaquinas = count($maquinaventaid);
                $i = 0;
                while ($i < $cantMaquinas) {
                    $this->cotizacion->ingresaritemsmaquinaventa($numerocotizacion, $maquinaventaid[$i], $maquinaventacant[$i], $maquinaventaprec[$i]);
                    $i++;
                }
            }

            if(isset($itemid) && count($itemid)>0) {
                $cantItems = count($itemid);
                $i = 0;
                while ($i < $cantItems) {
                    $this->cotizacion->ingresaritemsinventario($numerocotizacion, $itemid[$i], $itemcant[$i], $itemprecioventa[$i]);
                    $i++;
                }
            }

            if(isset($nuevoservicioid) && count($nuevoservicioid)>0) {
                $cant = count($nuevoservicioid);
                $i = 0;
                while ($i < $cant) {
                    $this->cotizacion->ingresaritemsnuevoservicioventa($numerocotizacion, ucwords(strtolower($nuevoserviciodescripcion[$i])), $nuevoserviciocant[$i], $nuevoservicioprecio[$i]);
                    $i++;
                }
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;

            header($urlSiguiente);
            return;
        }else{//modificar el info msg
            $this->info_msg = "<script>alert('Error al ingresar la Cotizacion, contacte al Administrador.');</script>";
        }

        $this->info_msg = "";

        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Cotizacion', 1, 1, 1);
        }

        $this->contenido = $this->ver('nueva_cotizacion_venta_maquina');
        return $this->ver('index');
    }

    function centroCopiadoNoClientes()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerocotizacion = $_POST['numerocotizacion'];
            $rutCliente = $_POST['rutCliente'];

            $nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_POST['rut'];

            $itemid		    = $_POST['itemid'];
            $itemcant		= $_POST['itemcant'];
            $itemprec		= $_POST['precioVenta'];

            $tipocotizacion = 6; //6 para centro copiados NO CLIENTES


            $this->cotizacion->nuevo($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor, '');

            $n        = count($itemid);
            $i        = 0;

            while ($i < $n){
                $this->cotizacion->ingresaritemsservicio($numerocotizacion, $itemid[$i], $itemcant[$i], $itemprec[$i]);
                $i++;
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;

            header($urlSiguiente);
            return;
        }

        $this->info_msg = "";

        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);
        }

        $this->contenido = $this->ver('nueva_cotizacion_centro_copiado_cliente_nuevo');
        return $this->ver('index');
    }

    function centroCopiadoClientes()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerocotizacion = $_POST['numerocotizacion'];
            $rutCliente = $_POST['rutCliente'];

            $nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_POST['rut'];

            $itemid		    = $_POST['itemid'];
            $itemcant		= $_POST['itemcant'];
            $itemprec		= $_POST['precioVenta'];

            $tipocotizacion = 4; //4 para centro copiados VER COMO HACER CLIENTES Y NO CLIENTES


            $this->cotizacion->nuevo($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor, '');
            $this->cotizacion->actualizarCotizacion($numerocotizacion,$rutCliente,"rutClienteAprobado");

            $n        = count($itemid);
            $i        = 0;

            while ($i < $n){
                $this->cotizacion->ingresaritemsservicio($numerocotizacion, $itemid[$i], $itemcant[$i], $itemprec[$i]);
                //$this->inventario->actualizarPventa($itemid[$i], $itemprec[$i]);
                $i++;
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;

            header($urlSiguiente);
            return;


        }

        $this->info_msg = "";

        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);
        }

        $this->UF 	= $this->configuraciones->getValor(IDCONFIG_UF);
        $this->CSJ	= $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->contenido = $this->ver('nueva_cotizacion_centro_copiado_cliente');
        return $this->ver('index');
    }

    function ventaInsumos()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11 && $_SESSION['area']!=12)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerocotizacion = $_POST['numerocotizacion'];
            $nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_POST['rut'];

            $itemid		    = $_POST['itemid'];
            $itemcant		= $_POST['itemcant'];
            $itemprec		= $_POST['precioVenta'];

            $tipocotizacion = 3; //3 para venta insumos

            $this->cotizacion->nuevo($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor, '');

            $n        = count($itemid);
            $i        = 0;

            while ($i < $n){
                $this->cotizacion->ingresaritemsinventario($numerocotizacion, $itemid[$i], $itemcant[$i], $itemprec[$i]);
            //    $this->inventario->actualizarPventa($itemid[$i], $itemprec[$i]);
                $i++;
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;

            header($urlSiguiente);
            return;

        }else{//modificar el info msg
            $this->info_msg = "<script>alert('Error al ingresar la Cotizacion, contacte al Administrador.');</script>";
        }

        $this->info_msg = "";

        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Cotización Venta Insumo', 1, 1, 1);
        }

        $this->contenido = $this->ver('nueva_cotizacion_venta_insumo');
        return $this->ver('index');
    }

    function mantencionesExternas()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->info_msg = "";

        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Orden de Compra', 1, 1, 1);
        }

        $this->contenido = $this->ver('nueva_cotizacion_mantencion_externa');
        return $this->ver('index');
    }

    function iniciolistar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11 && $_SESSION['area']!=12)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->anios = $this->cotizacion->aniosDesc();
        $this->contenido = $this->ver('inicio_listar_cotizaciones');
        return $this->ver('index');
    }

    function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11 && $_SESSION['area']!=12)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];

        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->numcotizacion = $_GET['numcotizacion'];
        $this->buscar 		= $_GET['buscar'];
        $this->filtroorden 	= $_GET['orden'];
        $this->estado 		= $_GET['estado'];

        $this->fechaDesde 	= $_GET['desde'];
        $this->fechaHasta 	= $_GET['hasta'];


        if(is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];

        switch($this->filtroorden)
        {
            case 1:
                $ordenStr = 'cotizacion.idCotizacion DESC ';
                break;
            case 2:
                $ordenStr = 'cotizacion.idCotizacion ';
                break;
            case 3:
                $ordenStr = 'cotizacion.fechaCotizacion DESC ';
                break;
            case 4:
                $ordenStr = 'cotizacion.fechaCotizacion ';
                break;
        }

        switch($this->estado)
        {
            default:
                $whereTip = '';
                break;
            case 0: //enviada
                $whereTip = " AND cotizacion.estado=1";
                break;
            case 1: //Aprobada
                $whereTip = " AND cotizacion.estado=2";
                break;
            case 2: //Rechazada
                $whereTip = " AND cotizacion.estado=3";
                break;
            case 3: //Creada
                $whereTip = " AND cotizacion.estado=4";
                break;
            case 4: //Anulada
                $whereTip = " AND cotizacion.estado=5";
                break;
        }

        $cantidads = $this->cotizacion->cantidad($this->numcotizacion, $whereTip, $this->fechaDesde, $this->fechaHasta);
        $this->lista = $this->cotizacion->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->numcotizacion, $ordenStr, $whereTip, $this->fechaDesde, $this->fechaHasta);
        $this->nPaginas = ceil($cantidads / $this->resultados);
        //$this->contenido = $this->ver('listar_cotizaciones');
        return $this->ver('listar_cotizaciones');
    }

    function listarmaquinasarriendo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina 			= 1;
        $this->resultados 		= 10;
        $this->codinterno 		= (!isset($_GET['codigointerno']) ? "" : $_GET['codigointerno']);
        $this->busquedaModelo   = (!isset($_GET['busquedaModelo']) ? "" : $_GET['busquedaModelo']);
        $this->busquedaPeriodo   = (!isset($_GET['busquedaPeriodo']) ? "" : $_GET['busquedaPeriodo']);
        $this->rutp 			= (!isset($_GET['rutp']) ? "" : $_GET['rutp']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        $this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->busquedaModelo, $this->busquedaPeriodo);
        $cantidad = $this->maquinas->cantidadMaquinasCotizacion($this->busquedaModelo, $this->busquedaPeriodo);
        //$this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->rutp, $this->codinterno);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_cotizacion_maquinas');
    }

    function listarmaquinasventa()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina 			= 1;
        $this->resultados 		= 20;
        $this->busquedaModelo   = (!isset($_GET['busquedaModelo']) ? "" : $_GET['busquedaModelo']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }

        $cantidad = $this->maquinas->cantidadMaquinasCotizacionVentas($this->busquedaModelo);
        $this->lista = $this->maquinas->listarMaquinasCotizacionVentas($this->resultados * ($this->pagina-1), $this->resultados, $this->busquedaModelo);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_cotizacion_maquinas_venta');
    }

    function verpreviewpdf()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina 			= 1;
        $this->resultados 		= 20;
        $this->codinterno 		= $_GET['codigointerno'];
        $this->busquedaModelo   = $_GET['busquedaModelo'];
        $this->busquedaPeriodo   = $_GET['busquedaPeriodo'];
        $this->rutp 			= $_GET['rutp'];

        $this->numerocotizacion = $_GET['numerocotizacion'];
        $this->nombrecontacto = $_GET['nombrecontacto'];
        $this->nombreempresa = $_GET['nombreempresa'];
        $this->direccion = $_GET['direccion'];
        $this->telefono = $_GET['telefono'];
        $this->correo = $_GET['correo'];
        $this->ciudad = $_GET['ciudad'];
        $this->validez = $_GET['validez'];
        $this->fecha = $_GET['fecha'];
        $this->idVendedor = $_SESSION['rut'];

        $this->itemid		                = $_GET['itemid'];
        $this->itemcant		            = $_GET['itemcant'];
        $this->itemidmaquinacotizacion    = $_GET['itemidmaquinacotizacion'];
        $this->itemidperiodo		        = $_GET['itemidperiodo'];
        $this->itemprec		            = $_GET['itemprec'];
        //Nuevo Producto
        $this->nproductoid	= $_GET['nproductoid'];
        $this->nprodcant		= $_GET['nprodcant'];
        $this->nprodprecio	= $_GET['nprodprecio'];
        $this->datosprod		= $_GET['datosprod'];
        //Nueva maquina o servicio
        $this->maqservid			= $_GET['maqservid'];
        $this->maqservcant		= $_GET['maqservcant'];
        $this->maqservprecio		= $_GET['maqservprecio'];
        $this->datosmaqserv		= $_GET['datosmaqserv'];

        $this->tipocotizacion = 1; //1 para arriendo maquinas


        if(is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];
        $this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->busquedaModelo, $this->busquedaPeriodo);
        $cantidad = $this->maquinas->cantidadMaquinasCotizacion($this->busquedaModelo, $this->busquedaPeriodo);
        //$this->lista = $this->maquinas->listarMaquinasCotizacion($this->resultados * ($this->pagina-1), $this->resultados, $this->rutp, $this->codinterno);
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('cotizacion_previsualizar_pdf');
    }

    function editar()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        if ($_SESSION['area'] != 5 && $_SESSION['area'] != 2 && $_SESSION['area'] != 5 && $_SESSION['area'] != 8 && $_SESSION['area'] != 9 && $_SESSION['area'] != 12) {
            header('location: index.php?error=restringido');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $numerocotizacion = $_POST['numerocotizacion'];
            $nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_POST['rut'];

            $itemid		                = $_POST['itemid'];
            $itemcant		            = $_POST['itemcant'];
            $itemidmaquinacotizacion    = $_POST['itemidmaquinacotizacion'];
            $itemidperiodo		        = $_POST['itemidperiodo'];

            $itemOpcionID = $_POST['itemOpcionID'];
            $inputOpcionDesc = $_POST['inputOpcionDesc'];
            $inputOpcionValor = $_POST['inputOpcionValor'];
            $inputOpcionSeleccionada = isset($_POST['inputOpcionSeleccionada']);

            $inputMaquinaDesc   = $_POST['inputMaquinaDesc'];
            $inputbnMinimo      = $_POST['itembnMinimo'];
            $inputcolorMinimo   = $_POST['itemcolorMinimo'];
            $inputscannerMinimo = $_POST['itemscannerMinimo'];
            $inputbnCosto       = $_POST['itembnCosto'];
            $inputcolorCosto    = $_POST['itemcolorCosto'];
            $inputscannerCosto  = $_POST['itemscannerCosto'];
            $inputcargoFijo     = $_POST['itemcargoFijo'];

            $tipocotizacion = 1; //1 para arriendo maquinas

            $cantidad          = count($inputOpcionValor);
            $indice            = 0;

            while ($indice < $cantidad) {
                $arregloOpcionesSeleccionadas[] = 0;
                $indice++;
            }

            if (isset($_POST['inputOpcionSeleccionada'])) {
                if (is_array($_POST['inputOpcionSeleccionada'])) {
                    $selected = '';
                    $num_countries = count($_POST['inputOpcionSeleccionada']);
                    $current = 0;
                    foreach ($_POST['inputOpcionSeleccionada'] as $key => $value) {


                        if ($current != $num_countries - 1) {
                            $arregloOpcionesSeleccionadas[$value] = 1;
                            $selected .= $value . ', ';
                        }
                        else {
                            $arregloOpcionesSeleccionadas[$value] = 1;
                            $selected .= $value . '.';
                            $current++;
                        }
                    }
                } else {
                    $selected = 'Debes seleccionar un país';
                }

                //echo '<div>Has seleccionado: ' . $selected . '</div>';
            }






            $this->cotizacion->actualizarCotizacionCompleta($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor);
            $this->cotizacion->eliminarCotizacionItems($numerocotizacion,1);
            $this->cotizacion->eliminarCotizacionItemsOpciones($numerocotizacion);

            $n        = count($itemidperiodo);
            $i        = 0;
            //var_dump($arregloOpcionesSeleccionadas);

            while ($i < $n)
            {
                $this->cotizacion->ingresaritems($numerocotizacion, $itemidperiodo[$i], $itemidmaquinacotizacion[$i], $itemcant[$i], $inputbnMinimo[$i], $inputcolorMinimo[$i],$inputscannerMinimo[$i] , $inputbnCosto[$i], $inputcolorCosto[$i], $inputscannerCosto[$i], $inputcargoFijo[$i]);

                $idCotizacionItem = $this->cotizacion->obtenerdatosCotizacionIdItem($numerocotizacion, $itemidperiodo[$i], $itemidmaquinacotizacion[$i]);
                $m = count($inputOpcionDesc);
                $j = 0;

                while ($j < $m) {
                    $this->cotizacion->ingresaritemsopciones($numerocotizacion, $idCotizacionItem["idCotizacionItem"], $inputOpcionDesc[$j], $inputOpcionValor[$j], $arregloOpcionesSeleccionadas[$j]);
                    if($arregloOpcionesSeleccionadas[$j]==1) {
                        $this->cotizacion->actualizarCotizacionItemCargoFijo($idCotizacionItem["idCotizacionItem"], $inputOpcionValor[$j]);
                    }

                    $j++;
                }
                $i++;
            }

           $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;
           header($urlSiguiente);
        }

        $idCotizacion = $_GET['idCotizacion'];

        $this->cotizacionDatos  = $this->cotizacion->obtenerdatosCotizacion($idCotizacion);
        $this->listaMaquinas    = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,1);
        $this->listaOpciones = $this->cotizacion->obtenerItemsCotizacionOpcionesporIdCotizacion($idCotizacion);
        $this->vendedor         = $this->usuarios->obtenerDatos($this->cotizacionDatos["idVendedor"]);

        $this->contenido = $this->ver('editar_cotizacion_arriendo_maquina');
        return $this->ver('index');
    }

    function editarventainsumo()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        if ($_SESSION['area'] != 5 && $_SESSION['area'] != 2 && $_SESSION['area'] != 5 && $_SESSION['area'] != 8 && $_SESSION['area'] != 9 && $_SESSION['area'] != 12) {
            header('location: index.php?error=restringido');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $numerocotizacion = $_POST['numerocotizacion'];
            $nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_POST['rut'];

            $itemid		    = $_POST['itemid'];
            $itemcant		= $_POST['itemcant'];
            $itemprec		= $_POST['precioVenta'];

            $tipocotizacion = 3; //3 para venta insumos

            $this->cotizacion->actualizarCotizacionCompleta($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor);
            $this->cotizacion->eliminarCotizacionItems($numerocotizacion,3);

            $n        = count($itemid);
            $i        = 0;

            while ($i < $n){
                $this->cotizacion->ingresaritemsinventario($numerocotizacion, $itemid[$i], $itemcant[$i], $itemprec[$i]);
                $this->inventario->actualizarPventa($itemid[$i], $itemprec[$i]);
                $i++;
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;
            header($urlSiguiente);
        }

        $idCotizacion = $_GET['idCotizacion'];

        $this->cotizacionDatos  = $this->cotizacion->obtenerdatosCotizacion($idCotizacion);
        $this->listaItems = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,3);
        $this->vendedor         = $this->usuarios->obtenerDatos($this->cotizacionDatos["idVendedor"]);

        $this->contenido = $this->ver('editar_cotizacion_venta_insumo');
        return $this->ver('index');
    }

    function editarventamaquina()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        if ($_SESSION['area'] != 5 && $_SESSION['area'] != 2 && $_SESSION['area'] != 5 && $_SESSION['area'] != 8 && $_SESSION['area'] != 9 && $_SESSION['area'] != 12) {
            header('location: index.php?error=restringido');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $numerocotizacion = (!isset($_POST['numerocotizacion']) ? null : $_POST['numerocotizacion']);
            $nombrecontacto = (!isset($_POST['nombrecontacto']) ? null : ucwords(strtolower($_POST['nombrecontacto'])));
            $nombreempresa = (!isset($_POST['nombreempresa']) ? null : ucwords(strtolower($_POST['nombreempresa'])));
            $direccion = (!isset($_POST['direccion']) ? null : ucwords(strtolower($_POST['direccion'])));
            $telefono = (!isset($_POST['telefono']) ? null : $_POST['telefono']);
            $correo = (!isset($_POST['correo']) ? null : $_POST['correo']);
            $ciudad = (!isset($_POST['ciudad']) ? null : ucwords(strtolower($_POST['ciudad'])));;
            $validez = (!isset($_POST['validez']) ? null : ucwords(strtolower($_POST['validez'])));
            $stock = (!isset($_POST['stock']) ? null : ucwords(strtolower($_POST['stock'])));
            $fecha = (!isset($_POST['fecha']) ? null : $_POST['fecha']);
            $idVendedor = (!isset($_POST['rut']) ? null : $_POST['rut']);

            $maquinaventaid = (!isset($_POST['maquinaventaid']) ? null : $_POST['maquinaventaid']);
            $maquinaventacant = (!isset($_POST['maquinaventacant']) ? null : $_POST['maquinaventacant']);
            $maquinaventaprec = (!isset($_POST['maquinaventaprec']) ? null : $_POST['maquinaventaprec']);

            $itemid		                = (!isset($_POST['itemid']) ? null : $_POST['itemid']);
            $itemcant		            = (!isset($_POST['itemcant']) ? null : $_POST['itemcant']);
            $itemidmaquinacotizacion    = (!isset($_POST['itemidmaquinacotizacion']) ? null : $_POST['itemidmaquinacotizacion']);
            $itemprecioventa            = (!isset($_POST['itemprecioventa']) ? null : $_POST['itemprecioventa']);

            $nuevoservicioid = (!isset($_POST['nuevoservicioid']) ? null : $_POST['nuevoservicioid']);
            $nuevoserviciodescripcion = (!isset($_POST['nuevoserviciodescripcion']) ? null : $_POST['nuevoserviciodescripcion']);
            $nuevoserviciocant = (!isset($_POST['nuevoserviciocant']) ? null : $_POST['nuevoserviciocant']);
            $nuevoservicioprecio = (!isset($_POST['nuevoservicioprecio']) ? null : $_POST['nuevoservicioprecio']);

            $tipocotizacion = 2; //2 para venta maquinas

            $this->cotizacion->actualizarCotizacionCompleta($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor);
            $this->cotizacion->eliminarCotizacionItems($numerocotizacion,3);

            $n        = count($itemid);
            $i        = 0;

            while ($i < $n){
                $this->cotizacion->ingresaritemsinventario($numerocotizacion, $itemid[$i], $itemcant[$i], $itemprec[$i]);
                $this->inventario->actualizarPventa($itemid[$i], $itemprec[$i]);
                $i++;
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;
            header($urlSiguiente);
        }

        $numerocotizacion = $_GET['idCotizacion'];

        $this->cotizacionDatos          = $this->cotizacion->obtenerdatosCotizacion($numerocotizacion);
        $this->vendedor                 = $this->usuarios->obtenerDatos($this->cotizacionDatos["idVendedor"]);
        $this->listaMaquinas            = $this->cotizacion->obtenerItemsCotizacion($numerocotizacion,2);
        $this->listaItems               = $this->cotizacion->obtenerItemsCotizacion($numerocotizacion,3);
        $this->listaNuevoServicioVenta  = $this->cotizacion->obtenerItemsNuevoServicioVenta($numerocotizacion);
        $this->listaOpciones            = $this->cotizacion->obtenerValorServicioInstalacion();

        $this->contenido = $this->ver('editar_cotizacion_venta_maquina');
        return $this->ver('index');
    }

    function editarventaserviciocliente()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        if ($_SESSION['area'] != 5 && $_SESSION['area'] != 2 && $_SESSION['area'] != 5 && $_SESSION['area'] != 8 && $_SESSION['area'] != 9 && $_SESSION['area'] != 12) {
            header('location: index.php?error=restringido');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $numerocotizacion = $_POST['numerocotizacion'];
            $nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_POST['rut'];

            $itemid		    = $_POST['itemid'];
            $itemcant		= $_POST['itemcant'];
            $itemprec		= $_POST['precioVenta'];

            $tipocotizacion = 4; //3 para venta insumos

            $this->cotizacion->actualizarCotizacionCompleta($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor);
            $this->cotizacion->eliminarCotizacionItems($numerocotizacion,$tipocotizacion);

            $n        = count($itemid);
            $i        = 0;

            while ($i < $n){
                $this->cotizacion->ingresaritemsservicio($numerocotizacion, $itemid[$i], $itemcant[$i], $itemprec[$i]);
                $i++;
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;
            header($urlSiguiente);
        }

        $idCotizacion = $_GET['idCotizacion'];

        $this->cotizacionDatos  = $this->cotizacion->obtenerdatosCotizacion($idCotizacion);
        $this->listaItems = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,4);
        $this->vendedor         = $this->usuarios->obtenerDatos($this->cotizacionDatos["idVendedor"]);

        $this->contenido = $this->ver('editar_cotizacion_venta_servicio_cliente');
        return $this->ver('index');
    }

    function editarventaservicioclientenuevo()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        if ($_SESSION['area'] != 5 && $_SESSION['area'] != 2 && $_SESSION['area'] != 5 && $_SESSION['area'] != 8 && $_SESSION['area'] != 9 && $_SESSION['area'] != 12) {
            header('location: index.php?error=restringido');
            return;
        }

        if ($_SERVER['REQUEST_METHOD'] == 'POST') {

            $numerocotizacion = $_POST['numerocotizacion'];
            $nombrecontacto = $_POST['nombrecontacto'];
            $nombreempresa = $_POST['nombreempresa'];
            $direccion = $_POST['direccion'];
            $telefono = $_POST['telefono'];
            $correo = $_POST['correo'];
            $ciudad = $_POST['ciudad'];
            $validez = $_POST['validez'];
            $fecha = $_POST['fecha'];
            $idVendedor = $_POST['rut'];

            $itemid		    = $_POST['itemid'];
            $itemcant		= $_POST['itemcant'];
            $itemprec		= $_POST['precioVenta'];

            $tipocotizacion = 6; //6 para clientes nuevos

            $this->cotizacion->actualizarCotizacionCompleta($numerocotizacion, $fecha, $tipocotizacion, $validez, $nombrecontacto, $nombreempresa, $direccion, $ciudad, $correo, $telefono, $idVendedor);
            $this->cotizacion->eliminarCotizacionItems($numerocotizacion,$tipocotizacion);

            $n        = count($itemid);
            $i        = 0;

            while ($i < $n){
                $this->cotizacion->ingresaritemsservicio($numerocotizacion, $itemid[$i], $itemcant[$i], $itemprec[$i]);
                $i++;
            }

            $urlSiguiente = "Location: index.php?controlador=Cotizacion&accion=detalle&idCotizacion=".$numerocotizacion;
            header($urlSiguiente);
        }

        $idCotizacion = $_GET['idCotizacion'];

        $this->cotizacionDatos  = $this->cotizacion->obtenerdatosCotizacion($idCotizacion);
        $this->listaItems = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,4);
        $this->vendedor         = $this->usuarios->obtenerDatos($this->cotizacionDatos["idVendedor"]);

        $this->contenido = $this->ver('editar_cotizacion_venta_servicio_cliente_nuevo');
        return $this->ver('index');
    }

    function detalle()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11 && $_SESSION['area']!=12)
        {
            header('location: index.php?error=restringido');
            return;
        }
        $idCotizacion = $_GET['idCotizacion'];

        $this->cotizacionDatos  = $this->cotizacion->obtenerdatosCotizacion($idCotizacion);

        $this->vendedor         = $this->usuarios->obtenerDatos($this->cotizacionDatos["idVendedor"]);
        $this->info_msg         = "";

        $pagina_ver = "";

        switch ($this->cotizacionDatos["tipocotizacion"]) {
            case 1:   //ARRIENDO MAQUINA
                $this->listaMaquinas = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,1);
                $this->listaOpciones = $this->cotizacion->obtenerItemsCotizacionOpcionesporIdCotizacion($idCotizacion);
                $pagina_ver = 'ver_cotizacion';
                break;
            case 2:   //VENTA MAQUINA
                $this->listaMaquinas = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,2);
                $this->listaItems = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,3);
                $this->listaNuevoServicioVenta = $this->cotizacion->obtenerItemsNuevoServicioVenta($idCotizacion);
                $pagina_ver = 'ver_cotizacion_venta_maquina';
                break;
            case 3:   //VENTA INSUMOS
                $this->listaItems = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,3);
                $pagina_ver = 'ver_cotizacion_venta_insumo';
                break;
            case 4:   //VENTA SERVICIOS CLIENTE
                $this->listaItems = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,4);
                $pagina_ver = 'ver_cotizacion_venta_servicio_cliente';
                break;
            case 6:   //VENTA SERVICIOS CLIENTE NUEVO
                $this->listaItems = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,6);
                $pagina_ver = 'ver_cotizacion_venta_servicio_cliente_nuevo';
                break;
        }

        $this->contenido = $this->ver($pagina_ver);
        return $this->ver('index');
    }

    function aprobar()
    {
        if (!isset($_SESSION['usuario'])) {
            header('location: index.php?error=nologin');
            return;
        }

        $idCotizacion = $_GET['idCotizacion'];
        $rutCliente = $_GET['rutCliente'];

        $this->cotizacionDatos  = $this->cotizacion->obtenerdatosCotizacion($idCotizacion);

        switch ($this->cotizacionDatos["tipocotizacion"]) {
            case 1:   //ARRIENDO MAQUINA
                $listaMaquinas = $this->cotizacion->obtenerItemsCotizacion($idCotizacion,1);

                if(count($listaMaquinas )>0){
                    foreach ($listaMaquinas as $lm) {
                        $this->cotizacion->actualizarCotizacionMaquinaStockArriendo($lm["idMaquinaCotizacion"], $lm["cantidad"]);
                    }
                }

                break;
            case 2:   //VENTA MAQUINA

                break;
            case 3:   //VENTA INSUMOS

                break;
            case 4:   //VENTA SERVICIOS CLIENTE

                break;
            case 6:   //VENTA SERVICIOS CLIENTE NUEVO

                break;
        }

        $this->cotizacion->actualizarCotizacion($idCotizacion, 2, "estado"); // Cambiar a ESTADO = 2 APROBADA;
        $this->cotizacion->actualizarCotizacion($idCotizacion, $rutCliente, "rutClienteAprobado"); // Cambiar a cliente seleccionado;
    }

    function rechazar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }
        $idCotizacion = $_GET['idCotizacion'];
        $this->cotizacion->actualizarCotizacion($idCotizacion, 3, "estado");
    }

    function enviada()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }
        $idCotizacion = $_GET['idCotizacion'];
        $this->cotizacion->actualizarCotizacion($idCotizacion, 1, "estado");
    }

    function anular()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }
        $idCotizacion = $_GET['idCotizacion'];
        $this->cotizacion->actualizarCotizacion($idCotizacion, 5, "estado"); // Cambiar a ESTADO = 3;
    }

    function listarinventario()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina 			= 1;
        $this->resultados 		= 10;

        $this->buscar = (!isset($_GET['buscar']) ? "" : $_GET['buscar']);
        $this->modelo = (!isset($_GET['modelo']) ? "" : $_GET['modelo']);
        $this->orden = (!isset($_GET['orden']) ? "" : $_GET['orden']);
        $this->filtrocat = (!isset($_GET['categoria']) ? "" : $_GET['categoria']);
        $this->filtrotipo = (!isset($_GET['tipo']) ? "" : $_GET['tipo']);
        $this->numparte = (!isset($_GET['numparte']) ? "" : $_GET['numparte']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        switch($this->orden)
        {
            default:
                $ordenStr = 'modelo';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'modelo DESC';
                break;
            case 3:
                $ordenStr = 'nombremarca';
                break;
            case 4:
                $ordenStr = 'nombremarca DESC';
                break;
            case 5:
                $ordenStr = 'nombrecategoria';
                break;
            case 6:
                $ordenStr = 'nombrecategoria DESC';
                break;
            case 7:
                $ordenStr = 'contreal';
                break;
            case 8:
                $ordenStr = 'contreal DESC';
                break;
        }

        switch($this->filtrocat)
        {
            default:
                $whereCat = 'AND categoria='.$this->filtrocat;
                break;
            case 0:
                $whereCat = '';
                break;
        }

        switch($this->filtrotipo)
        {
            default:
                $whereTip = '';
                break;
            case 1: //Insumos
                $whereTip = "AND tipo='Insumo'";
                break;
            case 2: //Repuestos
                $whereTip = "AND tipo='Repuesto'";
                break;
        }

        $whereCant ="";//en caso de filtrar por contador

        $cantidad = $this->inventario->cantidad($this->buscar, $whereCat, $whereTip, $whereCant, $this->modelo, $this->numparte)["cantidad"];
        $this->lista = $this->inventario->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $whereCat, $whereTip, $whereCant, $this->modelo, $this->numparte);

        $categoriasInv = new Categorias($this->NX_CONFIG);
        $this->categorias = $categoriasInv->listar();

        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_cotizacion_inventario');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoServ">
    function nuevoServ()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10)
        {
            header('location: index.php?error=restringido');
            return;
        }

        return $this->ver('nuevo_serv_cotizacion_venta');
    }
    //</editor-fold>

}
?>