<?php
class ControlControlador extends Controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $control;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->control = new ControlSalida($this->NX_CONFIG);
        $this->centroCosto = new CentroCosto($this->NX_CONFIG);
    }
    //</editor-fold>

    public function obtenernumero()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }
        $this->numero = $this->control->obtenernumero()["numero"];
        return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
    }

    public function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $numerocontrol  = $_POST["numerocontrol"] ?? null;

            $rut 			= $_POST['rut'] ?? null;
            $nomresponsable = $_POST['nomresponsable'] ?? null;
            $rutcliente 	= $_POST['rutcliente'] ?? null;
            $recinto 	    = $_POST['recinto'] ?? null;
            $fecha 			= $_POST['fecha'] ?? null;
            $hora 			= $_POST['hora2'] ?? null;

            $productoid		= $_POST['productoid'] ?? null;
            $prodcant		= $_POST['prodcant'] ?? null;
            $idCentroCosto  = $_POST['cencosto'] ?? null;

            //Ingreso nuevo control salida
            $ok = $this->control->nuevo($numerocontrol, $rut, $nomresponsable, $rutcliente, $recinto, $fecha, $hora, $idCentroCosto);
            if($ok)
            {
                $inventario = new Inventario($this->NX_CONFIG);

                //Insumos y respuestos
                $n        = count($productoid);
                $i        = 0;
                while ($i < $n){
                    $this->control->ingresarinventario($numerocontrol, $productoid[$i], $prodcant[$i]);
                    $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contreal');
                    if ($idCentroCosto == 7 or $idCentroCosto == 6){ //CC Administracion es consumo interno. por lo tanto tambien se rebaja el contteorico
                        $inventario->actualizarStock($productoid[$i], $prodcant[$i], '-', 'contteorico');//INVENTARIO
                    }
                    $i++;
                }

                //Maquinas
                $maq = new Maquinas($this->NX_CONFIG);
                $n        = count($maquinas) ?? 0;
                $i        = 0;
                while ($i < $n){
                    $this->control->ingresarinventario($numerocontrol, $maquinas[$i], $maquinascant[$i]);
                    $maq->actualizarStock($maquinas[$i], $maquinascant[$i],'-', 'contreal');
                    if ($idCentroCosto == 7 or $idCentroCosto == 6){ //CC Administracion es consumo interno. por lo tanto tambien se rebaja el contteorico
                        $maq->actualizarStock($maquinas[$i], $maquinascant[$i], '-', 'contteorico');//INVENTARIO
                    }
                    $i++;
                }
                header("Location: index.php?controlador=Control&accion=nuevo&infomsg=si");
                return;
            }else{//modificar el info msg
                $this->info_msg = "<script>alert('Error al ingresar Control de Salida, contacte al Administrador.');</script>";
            }
        }
        if(isset($_GET["infomsg"]) && $_GET["infomsg"]=="si")
        {
            $this->info_msg  = $this->msg('completa', 'Control de Salida', 1, 0, 1);
        }
        $this->listaresponsables = $this->control->listarResponsables();
        $this->listaCentroCosto = $this->centroCosto->listar();
        $this->contenido = $this->ver('nuevo_control');
        return $this->ver('index');
    }

    public function seleccionar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = $_GET['buscar'] ?? null;
        $this->orden = $_GET['orden'] ?? null;
        $this->rut = $_GET['rut'] ?? null;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        switch($this->orden)
        {
            default:
                $ordenStr = 'IDcontrol';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'IDcontrol DESC';
                break;
            case 3:
                $ordenStr = 'Fecha';
                break;
            case 4:
                $ordenStr = 'Fecha DESC';
                break;
        }

        $this->lista = $this->control->listar_control_cliente($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $this->rut, $ordenStr);
        $cantidad = $this->control->cantidad_control_cliente($this->buscar, $this->rut)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_control');
    }

    public function ver_control_cliente()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $idcontrol = $_GET['idcontrol'] ?? null;
        $this->controlsalida = $this->control->obtenerdatosControl($idcontrol);
        $this->listainventario = $this->control->obtenerInventarioControl($idcontrol);
        $this->listamaquinas = $this->control->obtenerMaquinasControl($idcontrol);
        $this->contenido = $this->ver('ver_control_cliente');
        return $this->ver('index');
    }

    public function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = $_GET['buscar'] ?? null;
        $this->orden = $_GET['orden'] ?? null;
        $this->fechaDesde 	= $_GET['desde'] ?? null;
        $this->fechaHasta 	= $_GET['hasta'] ?? null;
        $this->idcontrol	= $_GET['idcontrol'] ?? null;

        if($this->fechaDesde != "" && $this->fechaHasta != "")
        {
            list( $dia, $mes, $anio) = explode( '-', $this->fechaDesde);
            $fecha1 = "$anio/$mes/$dia";
            list( $dia, $mes, $anio) = explode( '-', $this->fechaHasta);
            $fecha2  = "$anio/$mes/$dia";
            $fechas = "AND fecha BETWEEN '".$fecha1."' AND '".$fecha2."'";
        }

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        switch($this->orden)
        {
            default:
                $ordenStr = 'Fecha';
                $this->orden = 1;
                break;
            case 1:
                $ordenStr = 'Fecha';
                break;
            case 2:
                $ordenStr = 'Fecha DESC';
                break;
        }

        $this->lista = $this->control->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $fechas ?? null, $this->idcontrol);
        $cantidad = $this->control->cantidad($this->buscar, $fechas ?? null, $this->idcontrol)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_controlesSalida');
        return $this->ver('index');
    }

    public function listarParaDevolucionInsumos()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 20; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar 		= $_GET['buscar'] ?? null;
        $this->idcontrol	= $_GET['idcontrol'] ?? null;
        $this->orden 		= $_GET['orden'] ?? null;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
        switch($this->orden)
        {
            default:
                $ordenStr = 'Fecha';
                $this->orden = 1;
                break;
            case 1:
                $ordenStr = 'Fecha';
                break;
            case 2:
                $ordenStr = 'Fecha DESC';
                break;
        }

        $this->lista = $this->control->listarPorId($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->idcontrol);
        $cantidad = $this->control->cantidadPorID($this->buscar, $this->idcontrol)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('listar_controlesSalidaParaDevolucionInsumos');
    }
}
?>