<?php
class ContadoresControlador extends Controlador
{
    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $contadores;
    var $clientes;
    var $maquinas;
    var $tipoCapturas;
    var $reports;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->contadores 	= new Contadores($this->NX_CONFIG);
		$this->clientes 	= new Clientes($this->NX_CONFIG);
		$this->maquinas 	= new Maquinas($this->NX_CONFIG);
		$this->tipoCapturas = new TipoCapturas($this->NX_CONFIG);
		$this->reports 		= new Reports($this->NX_CONFIG);
	}
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : inicio">
    public function inicio()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        /*
        1. (CONTADORES) se obtiene ultima fecha de facturacion - tabla 'contadores'
        2. (CLIENTE) obtener datos - tabla 'clientes'
        3. (MAQUINA) obtener datos - tabla 'maquinas'
        4. (CONTADORES) obtener a�os de facturacion - tabla 'contadores'
        */

        $rut 						= (!isset($_GET['rut']) ? null : $_GET['rut']);
        $serieInterna 				= (!isset($_GET['serieinterna']) ? null : $_GET['serieinterna']);
        $this->correlativo 			= (!isset($_GET['correlativo']) ? null : $_GET['correlativo']);
        $this->tipoServicioMaquina 	= (!isset($_GET['tipoServicioMaquina']) ? null : $_GET['tipoServicioMaquina']);

        $ultimaFechaFacturacionData = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna, $this->tipoServicioMaquina);

        if ($ultimaFechaFacturacionData !== null && isset($ultimaFechaFacturacionData["fechafacturacion"])) {
            $ultimaFechaFacturacion = $ultimaFechaFacturacionData["fechafacturacion"];
        } else {
            $ultimaFechaFacturacion = null;
        }

        //$ultimaFechaFacturacion = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna, $this->tipoServicioMaquina)["fechafacturacion"];

        $this->cliente  	  = $this->clientes->obtenerDatos($rut);
        $this->maquina  	  = $this->maquinas->obtenerDatos($serieInterna);
        $this->maquinacliente = $this->maquinas->obtenerDatosMaquinaCliente($rut, $serieInterna);

        $this->anios    	= $this->contadores->anios($rut , $serieInterna);//Obtener los a�os de facturacion ordenados

        $this->mesHasta		= date('m', strtotime($ultimaFechaFacturacion));
        $this->anioHasta	= date('Y', strtotime($ultimaFechaFacturacion));

        if (!empty($this->anios)) {
            $primerAnio = $this->anios[0]["anio"];
            if ($primerAnio == $this->anioHasta) {
                // Dentro del mismo año
                $this->mesDesde = 1; // Mes 1 hasta el mes en el que se encuentra la última fecha de facturación
                $this->anioDesde = $this->anioHasta; // Es el mismo año tanto "desde" como "hasta"
            } else {
                // Hay más años facturados
                // Restar un año que es el lapso que se mostrará en la página, mostrando desde la última fecha hasta 1 año atrás
                $fechaUnAnioAtras = date('Y-m-d', strtotime($ultimaFechaFacturacion . ' -1 year'));
                $this->mesDesde = date('m', strtotime($fechaUnAnioAtras));
                $this->anioDesde = date('Y', strtotime($fechaUnAnioAtras));
            }
        } else {
            // No hay información sobre años de facturación
            // Aquí puedes manejar este caso según tus requisitos
        }

        //Valores de minimo copiado y costo copiado
        $this->datosCopiado = $this->contadores->obtenerMinCostCopia($rut, $this->tipoServicioMaquina, $serieInterna);

        $this->contenido 	= $this->ver('contadores');
        return $this->ver('index');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    public function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $rut				= $_POST['rut'];
            $serieInterna		= $_POST['serieinterna'];
            $correlativo		= $_POST['correlativo'];
            $dia = '28';
            if($_POST['mesfacturacion'] == 2)
            { $dia = '28';}
            $fechaFacturacion 	= $dia.'-'.$_POST['mesfacturacion']."-".$_POST['aniofacturacion'];
            $tipoCaptura		= $_POST['tipocaptura'];
            $contador			= $_POST['contador'];
            $copiaErrores		= $_POST['erroneas'];
            $fechaCaptura		= $_POST['fechacaptura'];
            $firma				= "'".$_POST['firma']."'";
            $diferencia			= $_POST['diferencia'];
            $copiasFacturadas	= $_POST['copias'];
            $tipoServicioMaquina= $_POST['tipoServicioMaquina'];

            $this->ultimoContador  	= $this->contadores->ultimoContador($rut, $serieInterna,$tipoServicioMaquina);
            $ultimaFechaFacturacion = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna,$tipoServicioMaquina);
            //{contador, diferencia, errores, facturadas}
            $flag = $this->contadores->nuevo($rut, $serieInterna, $correlativo, 0, $fechaFacturacion, $contador, $copiaErrores, $diferencia, $copiasFacturadas, $fechaCaptura, $tipoCaptura, $firma, "NULL",$tipoServicioMaquina);
            //Idreport NULL por que el ingreso es con otro tipo de captura
            if($flag)
            {
                return $this->info_msg = $this->msg('popup', 'contador', 1, 0, 1);
            }
            //error
            return "Error al ingresar el contador";
        }

        $this->rut 					= (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->serieInterna 		= (!isset($_GET['serieinterna']) ? null : $_GET['serieinterna']);
        $this->correlativo 			= (!isset($_GET['correlativo']) ? null : $_GET['correlativo']);
        $this->tipoServicioMaquina	= (!isset($_GET['tipoServicioMaquina']) ? null : $_GET['tipoServicioMaquina']);

        //Valores de minimo copiado y costo copiado
        $this->datosCopiado = $this->contadores->obtenerMinCostCopia($this->rut, $this->tipoServicioMaquina, $this->serieInterna);
        $this->ultimoContador  	= $this->contadores->ultimoContador($this->rut, $this->serieInterna, $this->tipoServicioMaquina);

        if($this->ultimoContador == "")
        {
            $this->ultimoContador = 0;
        }

        $this->listaCapturas 	= $this->tipoCapturas->listar();
        return $this->ver('nuevo_contador');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoByReport">
    public function nuevoByReport()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $rut				= $_POST['rut'];
            $serieInterna		= $_POST['serieinterna'];
            $correlativo		= $_POST['correlativo'];
            $idReport			= $_POST['idreport'];
            $dia = '31';
            if($_POST['mesfacturacion'] == 2)
            { $dia = '28';}
            $fechaFacturacion 	= $dia.'-'.$_POST['mesfacturacion']."-".$_POST['aniofacturacion'];
            $contador			= $_POST['contador'];
            $diferencia			= $_POST['diferencia'];
            $copiaErrores		= $_POST['erroneas'];
            $fechaCaptura		= $_POST['fechacaptura'];
            $movimientoReport	= substr($_POST['movimientoReport'],0,9);
            $copiasFacturadas	= $_POST['copias'];
            $tipoServicioMaquina= $_POST['tipoServicioMaquina'];

            if($movimientoReport == 'Instalaci')
            {
                //instalaci�n (fecha captura = fecha facturacion) {contador, diferencia, errores, facturadas}
                $flag = $this->contadores->nuevo($rut, $serieInterna, $correlativo, 1, $fechaCaptura, $contador, 0, 0, 0,$fechaCaptura, 1, "NULL", $idReport,$tipoServicioMaquina);
            }else{

                //Otro report
                $this->ultimoContador = $this->contadores->ultimoContador($rut, $serieInterna,$tipoServicioMaquina);
                $ultimaFechaFacturacion = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna,$tipoServicioMaquina);
                //{contador, diferencia, errores, facturadas}
                $flag = $this->contadores->nuevo($rut, $serieInterna, $correlativo, 0, $fechaFacturacion, $contador, $copiaErrores, $diferencia, $copiasFacturadas, $fechaCaptura, 1, "NULL", $idReport,$tipoServicioMaquina);
            }

            if($flag)
            {
                return $this->info_msg = $this->msg('popup', 'contador', 1, 0, 1);
            }
        }

        $this->rut 					= (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->serieInterna 		= (!isset($_GET['serieinterna']) ? null : $_GET['serieinterna']);
        $this->correlativo			= (!isset($_GET['correlativo']) ? null : $_GET['correlativo']);
        $this->idReport 			= (!isset($_GET['idreport']) ? null : $_GET['idreport']);
        $this->tipoServicioMaquina	= (!isset($_GET['tipoServicioMaquina']) ? null : $_GET['tipoServicioMaquina']);

        $this->report 			= $this->reports->getById($this->idReport);
        $this->ultimoContador  	= $this->contadores->ultimoContador($this->rut, $this->serieInterna, $this->tipoServicioMaquina);
        $this->copias  			= $this->report['contador'] - $this->ultimoContador;
        $this->diferencia  		= $this->copias;
        //Valores de minimo copiado y costo copiado
        $this->datosCopiado = $this->contadores->obtenerMinCostCopia($this->rut, $this->tipoServicioMaquina, $this->serieInterna);

        if($this->datosCopiado["minimocopia"] > $this->copias)
        {
            $this->copias = $this->datosCopiado["minimocopia"];
        }

        //Si es instalacion u otro report redireccionar
        if($this->report['nombre'] == "Instalaci�n")
        {
            return $this->ver('nuevo_contador_by_report_inst');
        }else{
            return $this->ver('nuevo_contador_by_report');
        }
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listar">
    public function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $rut 					= (!isset($_GET['rut']) ? null : $_GET['rut']);
        $serieInterna 			= (!isset($_GET['serieinterna']) ? null : $_GET['serieinterna']);
        $correlativo 			= (!isset($_GET['correlativo']) ? null : $_GET['correlativo']);
        $tipoServicioMaquina    = (!isset($_GET['tipoServicioMaquina']) ? null : $_GET['tipoServicioMaquina']);

       // $ultimaFechaFacturacion = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna, $tipoServicioMaquina);

        $ultimaFechaFacturacionData = $this->contadores->ultimaFechaFacturacion($rut, $serieInterna, $tipoServicioMaquina);

        if ($ultimaFechaFacturacionData !== null && isset($ultimaFechaFacturacionData["fechafacturacion"])) {
            $ultimaFechaFacturacion = $ultimaFechaFacturacionData["fechafacturacion"];
        } else {
            $ultimaFechaFacturacion = null;
        }

        if(isset($_GET['desde']	))//si no llegan datos (primera carga) toma desde la ultima fecha de facturacion un a�o atras
        {
            $desde	= (!isset($_GET['desde']) ? null : $_GET['desde']);
        }
        else
        {
            $desde	= date('Y-m-d', strtotime($ultimaFechaFacturacion . '-1 year'));
        }

        if(isset($_GET['hasta']	))
        {
            $hasta	= (!isset($_GET['hasta']) ? null : $_GET['hasta']);
        }
        else
        {
            $hasta	= $ultimaFechaFacturacion;
        }

        $this->lista = $this->contadores->listarByFechas($rut , $serieInterna, $correlativo, $desde, $hasta,$tipoServicioMaquina);
        //Valores de minimo copiado y costo copiado
        $this->datosCopiado = $this->contadores->obtenerMinCostCopia($rut, $tipoServicioMaquina, $serieInterna);
        return $this->ver('lista_contadores');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
    public function seleccionar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->lista = $this->contadores->seleccionar($rut);
        return $this->ver('seleccionar_contador');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevoMinCostCopia">
    public function nuevoMinCostCopia()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $rut					= $_POST['rut'];
            $costocopia				= $_POST['costocopia'];
            $minimocopia			= $_POST['mincopia'];
            $costofijo				= $_POST['costofijo'];
            $tipoServicioMaquina	= $_POST['tipoServicioMaquina'];
            $serieIntMaquina        = $_POST['serieIntMaquina'];

            $this->contadores->actualizarMinCostCopia($rut, $costocopia, $minimocopia, $costofijo,$tipoServicioMaquina,$serieIntMaquina);
            return $this->info_msg = $this->msg('popup', 'M&iacute;nimo y Costo de Copiado', 2, 0, 1);
        }

        $this->rut	=	(!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->serieIntMaquina = (!isset($_GET['serieIntMaquina']) ? null : $_GET['serieIntMaquina']);
        $this->tipoServicioMaquina	= (!isset($_GET['tipoServicioMaquina']) ? null : $_GET['tipoServicioMaquina']);
        $this->datosCopiado = $this->contadores->obtenerMinCostCopia($this->rut, $this->tipoServicioMaquina, $this->serieIntMaquina);
        return $this->ver('nuevo_mincost_copia');
    }
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="FUNCION : actualizarUbicacionMaquina">
    public function actualizarUbicacionMaquina()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $rut					= $_POST['rut'];
            $ubicacionNueva			= $_POST['ubicacionnueva'];
            $tipoServicioMaquina	= $_POST['tipoServicioMaquina'];
            $serieIntMaquina        = $_POST['serieIntMaquina'];

            $this->maquinas->actualizarUbicacionClienteMaquina($rut, $serieIntMaquina, $ubicacionNueva);
            return $this->info_msg = $this->msg('popup', 'dato de Ubicación Actual', 2, 0, 1);
        }

        $this->rut	=	(!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->serieIntMaquina = (!isset($_GET['serieIntMaquina']) ? null : $_GET['serieIntMaquina']);
        $this->tipoServicioMaquina	= (!isset($_GET['tipoServicioMaquina']) ? null : $_GET['tipoServicioMaquina']);
        $this->ubicacion = (!isset($_GET['ubicacion']) ? null : $_GET['ubicacion']);

        $this->cliente  	  = $this->clientes->obtenerDatos($this->rut);
        $this->maquina  	  = $this->maquinas->obtenerDatos($this->serieIntMaquina);
        return $this->ver('cambiar_ubicacion_maquina');
    }
    //</editor-fold>
}
?>