<?php
class CompraDirectaControlador extends Controlador
{
    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
	var $compra;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
	public function __construct($NX_CONFIG)
	{
        $this->NX_CONFIG = $NX_CONFIG;
		$this->compra = new CompraDirecta($this->NX_CONFIG);
	}
    //</editor-fold>
	
	public function obtenernumero()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$this->numero = $this->compra->obtenernumero()["numero"];
		return $this->numero+1;//se suma 1 para mostrar el siguiente ID a crear
	}
	
	public function nuevo()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9) 
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		if($_SERVER['REQUEST_METHOD']=='POST')
		{
			$numerocd		= $_POST['numerocd'] ?? null;
			$rutp 			= $_POST['rut'] ?? null;
			$razon 			= $_POST['razonsocial'] ?? null;
			$nombre			= $_POST['nombre'] ?? null;
			$fecha 			= $_POST['fecha'] ?? null;
			$sumatotal 		= $_POST['sumatotal'] ?? null;
			//Productos de inventario
			$productoid		= $_POST['productoid'] ?? null;
			$prodcant		= $_POST['prodcant'] ?? null;
			$prodprecio		= $_POST['prodprecio'] ?? null;
			//Nuevo Producto
			$nproductoid	= $_POST['nproductoid'] ?? null;
			$nprodcant		= $_POST['nprodcant'] ?? null;
			$nprodprecio	= $_POST['nprodprecio'] ?? null;
			$datosprod		= $_POST['datosmaqserv'] ?? null;
			//Nueva maquina o servicio
			$maqservid			= $_POST['maqservid'] ?? null; //id = descripcion
			$maqservcant		= $_POST['maqservcant'] ?? null;
			$maqservprecio		= $_POST['maqservprecio'] ?? null;
			$datosmaqserv		= $_POST['datosmaqserv'] ?? null; // = descripcion
			
			$ok =  $this->compra->nuevo($numerocd, $rutp, $razon, $nombre, $fecha, $sumatotal);
			
			if($ok)
			{
				$inventario = new Inventario($this->NX_CONFIG);
//---------> Ingreso de Insumos y respuestos del inventario (Tipo 1: inventario)
				$n        = count($productoid);
				$i        = 0;
				while ($i < $n){
					$this->compra->ingresaritems($numerocd, $productoid[$i], $prodcant[$i], $prodprecio[$i],1);
					$inventario->actualizarStock($productoid[$i], $prodcant[$i], '+', 'contteorico');
					$inventario->actualizarStock($productoid[$i], $prodcant[$i], '+', 'contreal');
					$inventario->actualizarPcompra($productoid[$i], $prodprecio[$i]);
					$i++;
				}
//****************************************************************
				
//---------> Ingreso de Nuevos Productos (Tipo 1: inventario)
				$cat = new Categorias($this->NX_CONFIG);
				$n        = count($nproductoid);
				$i        = 0;
				while ($i < $n){
list($tipo, $categoria, $nombrecategoria, $marca, $nombremarca, $modelo, $nombremaquina, $pventa, $numparte, $descripcion) = split( '%', $datosprod[$i] );

				if($categoria == -1)
				{					
					$existe = $cat->buscar(strtoupper($nombrecategoria));
					if(is_numeric($existe))
					{
						$categoria = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$categoria = $cat->nuevo(strtoupper($nombrecategoria));
					}					
				}
				
				if($marca == -1)
				{
					$existe = $marcamaq->buscar(strtoupper($nombremarca));
					if(is_numeric($existe))
					{
						$marca = $existe;//se le da la ID que ya estaba ingresada
					}else{
						$marca = $marcamaq->nuevo(strtoupper($nombremarca));
					}					
				}		

    		$corr = $inventario->obtenerCorrelativo($tipo[0]);
			$idproducto = strtoupper(substr($nombremarca,0,3)).'-'.$tipo[0].($corr+1);
			//nprodcant se le da a todos los valores
			$inventario->nuevo($idproducto, $tipo, $categoria, $marca, $modelo, $codinterno ?? null, $numparte, $descripcion, $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $nprodcant[$i], $pventa, 1, $nombremaquina);
			
			$this->compra->ingresaritems($numerocd, $idproducto, $nprodcant[$i], $nprodprecio[$i],1);
			$inventario->actualizarPcompra($idproducto, $nprodprecio[$i]);
			$i++;
				}
					
//****************************************************************

//---------> Ingreso de Nuevas M�quinas o SERVICIO
				$n        = count($maqservid);
				$i        = 0;
				while ($i < $n){
					//En inventario existe un producto con id = ESPECIAL
				  $this->compra->ingresarMaqServ($numerocd, 'ESPECIAL', $maqservcant[$i], $maqservprecio[$i], 0, $datosmaqserv[$i]);
					$i++;
				}
//****************************************************************
					
				
				header("Location: index.php?controlador=CompraDirecta&accion=nuevo&infomsg=si");
			    return;	
				
			}else{//modificar el info msg
				$this->info_msg = "<script>alert('Error al ingresar la Compra Directa, contacte al Administrador.');</script>";
			}
			
		}
		if(isset($_GET["infomsg"]) && $_GET["infomsg"] == "si")
		{
			$this->info_msg  = $this->msg('completa', 'Compra Directa', 1, 1, 1);	
		}
		$this->contenido = $this->ver('nueva_cd');
		return $this->ver('index');
	}
	
	public function verCD()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		$idcd = $_GET['idcd'];
		$this->cd = $this->compra->obtenerdatosCD($idcd);
		$this->listainventario = $this->compra->obtenerItemsInventarioCD($idcd);
		$this->listamaqserv = $this->compra->obtenerItemsMaqServCD($idcd);
		$this->contenido = $this->ver('ver_cd');
		return $this->ver('index');
	}
	
	public function iniciolistar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->anios = $this->compra->anios();
		$this->contenido = $this->ver('inicio_listar_cd');
		return $this->ver('index');	
	}	
	
	public function listar() 
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=6 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		$this->pagina = 1;
		if(isset($_GET['pagina']) && is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		$this->resultados = 20; //Registros a mostrar por cada p�gina
		$this->pagVisible = 8; //paginas a mostrar en la paginaci�n
		
		$this->buscar 		= $_GET['buscar'] ?? null;
		$this->filtroorden 	= $_GET['orden'] ?? null;

		$this->fechaDesde 	= $_GET['desde'] ?? null;
		$this->fechaHasta 	= $_GET['hasta'] ?? null;

		if(isset($_GET['pagina']) ?? is_numeric($_GET['pagina'])) {
            $this->pagina = $_GET['pagina'];
        }
		switch($this->filtroorden)
		{
			default:
				$ordenStr = 'IDcd';
				$this->filtroorden = 1;
			break;
			case 2:
				$ordenStr = 'IDcd DESC';
			break;
			case 3:
				$ordenStr = 'total';
			break;
			case 4:
				$ordenStr = 'total DESC';
			break;
			case 5:
				$ordenStr = 'fecha';
			break;
			case 6:
				$ordenStr = 'fecha DESC';
			break;	
		}
	
		$cantidads = $this->compra->cantidad($this->buscar, $this->fechaDesde, $this->fechaHasta)["cantidad"];
		$this->lista = $this->compra->listar($this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr, $this->fechaDesde, $this->fechaHasta);		
		$this->nPaginas = ceil($cantidads / $this->resultados);	
		$this->contenido = $this->ver('listar_cd');
		return $this->ver('listar_cd');
	}
	
	/* COMPRA DIRECTA NUEVA MAQ o SERV */
	public function nuevoMaqServ()
	{
		if(!isset($_SESSION['usuario']) ) 
		{
			header('location: index.php?error=nologin');
			return;
		}
		
		if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
		{
			header('location: index.php?error=restringido');
			return;
		}
		
		return $this->ver('nuevo_maqserv');
	}
}
?>