<?php

class ClientesControlador extends controlador
{

    //<editor-fold defaultstate="collapsed" desc="DECLARACION DE VARIABLES">
    var $clientes;
    var $cotizacion;
    private $NX_CONFIG;
    //</editor-fold>

    //<editor-fold defaultstate="collapsed" desc="CONSTRUCTOR">
    public function __construct($NX_CONFIG)
    {
        $this->NX_CONFIG = $NX_CONFIG;
        $this->clientes = new Clientes($this->NX_CONFIG);
        $this->cotizacion = new Cotizacion($this->NX_CONFIG);
        $this->configuraciones	= new Configuraciones($this->NX_CONFIG);
    }
    //</editor-fold>

    public function listar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listar($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidad($this->buscar)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $this->contenido = $this->ver('listar_clientes');
        return $this->ver('index');
    }

    public function listarClientesArriendo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listar($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidad($this->buscar);
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $this->contenido = $this->ver('listar_clientes_arriendo');
        return $this->ver('index');
    }

    public function listarClientesArriendoV2()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listar($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidad($this->buscar);
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $this->contenido = $this->ver('listar_clientes_arriendoV2');
        return $this->ver('index');
    }

    public function listarClientesVentas()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listar($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidad($this->buscar);
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $this->contenido = $this->ver('listar_clientes_venta');
        return $this->ver('index');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : listarClientesCentroCopiado">
    public function listarClientesCentroCopiado()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
            $this->pagina = $_GET['pagina'];
        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listarCentroCopiado($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidadCentroCopiado($this->buscar);
        $this->nPaginas = ceil($cantidad / $this->resultados);

        $this->contenido = $this->ver('listar_clientes_centro_copiado');
        return $this->ver('index');
    }
    //</editor-fold>

    public function editar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $rut = $_POST['rut'];
            $razonSocial = $_POST['razonsocial'];
            $nombre = $_POST['nombre'];
            $telefono = $_POST['telefono'];
            $direccion = $_POST['direccion'];
            $ciudad = $_POST['ciudad'];
            $giro = $_POST['giro'];
            $this->clientes->modificar($rut, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro);
            return $this->info_msg = $this->msg('popup', 'cliente', 2,0,1);
        }
        $rut = $_GET['rut'];
        $this->datoscliente = $this->clientes->obtenerDatos($rut);
        return $this->ver('editar_cliente');
    }

    public function eliminar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $rut = $_GET['rut'];
        $this->clientes->eliminar($rut);
        header('location: index.php?controlador=Clientes&accion=listar');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : nuevo">
    public function nuevo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $cliente = new Clientes($this->NX_CONFIG);
            $rut 			= $_POST['rut'];
            $dv 			= $_POST['dv'];
            $razonSocial 	= $_POST['razonsocial'];
            $nombre		 	= $_POST['nombre'];
            $telefono 		= $_POST['telefono'];
            $direccion 		= $_POST['direccion'];
            $ciudad 		= $_POST['ciudad'];
            $giro 			= $_POST['giro'];
            $cont = $cliente->existe($rut);
            if($cont["cantidad"] > 0) { //error nuevo cliente, ya existe
                return "<script type=\"text/javascript\">javascript:self.parent.tb_remove();alert('El cliente ya existe');</script>";
            } else {
                $ok = $cliente->nuevo($rut, $dv, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro);
                if($ok)
                {
                    return $this->info_msg = $this->msg('popup', 'cliente', 1,0,1);
                }else{
                    return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Cliente, contacte al Administrador.');</script>";
                }
            }
        }
        return $this->ver('nuevo_cliente');
    }
    //</editor-fold>

    public function nuevoClienteCotizacion()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=9 && $_SESSION['area']!=12)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $cliente        = new Clientes($this->NX_CONFIG);
            $rut 			= $_POST['rut'];
            $dv 			= $_POST['dv'];
            $razonSocial 	= $_POST['razonsocial'];
            $nombre		 	= $_POST['nombre'];
            $telefono 		= $_POST['telefono'];
            $direccion 		= $_POST['direccion'];
            $ciudad 		= $_POST['ciudad'];
            $giro 			= $_POST['giro'];
            $idCotizacion   = $_POST['idCotizacion'];

            $cont = $cliente->existe($rut);
            if(($cont)>0) { //error nuevo cliente, ya existe
                return "<script type=\"text/javascript\">javascript:self.parent.tb_remove();alert('El cliente ya existe');</script>";
            } else {
                $ok = $cliente->nuevo($rut, $dv, $razonSocial, $nombre, $telefono, $direccion, $ciudad, $giro);
                if($ok)
                {
                    $this->cotizacion->actualizarCotizacion($idCotizacion, 2, "estado"); // Cambiar a ESTADO = 2 APROBADA;
                    $this->cotizacion->actualizarCotizacion($idCotizacion, $rut, "rutClienteAprobado"); // Cambiar a cliente seleccionado;
                    return $this->info_msg = $this->msg('popup', 'cliente', 1,0,1);
                }else{
                    return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Cliente, contacte al Administrador.');</script>";
                }
            }
        }
        $idCotizacion = $_GET['idCotizacion'];
        $this->cotizacionDatos = $this->cotizacion->obtenerdatosCotizacion($idCotizacion);
        return $this->ver('nuevo_cliente_cotizacion');
    }

    //<editor-fold defaultstate="collapsed" desc="FUNCION : seleccionar">
    public function seleccionar()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;
        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listar($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidad($this->buscar)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_cliente');
    }
    //</editor-fold>

    public function seleccionarClienteCotizacion()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        $this->resultados = 20;

        $this->buscar = (isset($_GET['buscar']) ? $_GET['buscar'] : null);
        $this->orden = (isset($_GET['orden']) ? $_GET['orden'] : null);
        $this->idCotizacion = (isset($_GET['idCotizacion']) ? $_GET['idCotizacion'] : null);

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listar($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidad($this->buscar)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        return $this->ver('seleccionar_cliente_cotizacion');
    }

    public function menu()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->rut = $_GET['rut'];
        return $this->ver('menu_cliente');
    }

    public function menuClientesArriendo()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->rut = $_GET['rut'];
        return $this->ver('menu_cliente_arriendo');
    }

    public function listarServicios()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;

        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->buscar = (!isset($_GET['buscar']) ? "" : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? "" : $_GET['orden']);

        switch($this->orden)
        {
            default:
                $ordenStr = 'razonsocial';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'razonsocial DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listar($rutcsj, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidad($this->buscar)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);
        $this->contenido = $this->ver('listar_clientesServicios');
        return $this->ver('index');
    }

    public function listarDepartamentos()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);

        switch($this->orden)
        {
            default:
                $ordenStr = 'nombreDepartamentoCliente';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'nombreDepartamentoCliente DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listarDepartamentos($this->rut, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidadListarDepartamentos($this->rut)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);

        return $this->ver('listar_clientesDepartamentos');
        //$this->contenido = $this->ver('listar_clientesDepartamentos');
        //return $this->ver('index');
    }

    public function listarDepartamentosFacturacion()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }
        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $this->rut = (!isset($_GET['rut']) ? null : $_GET['rut']);
        $this->buscar = (!isset($_GET['buscar']) ? null : $_GET['buscar']);
        $this->orden = (!isset($_GET['orden']) ? null : $_GET['orden']);
        $this->posicion = (!isset($_GET['posicion']) ? null : $_GET['posicion']);

        switch($this->orden)
        {
            default:
                $ordenStr = 'nombreDepartamentoCliente';
                $this->orden = 1;
                break;
            case 2:
                $ordenStr = 'nombreDepartamentoCliente DESC';
                break;
            case 3:
                $ordenStr = 'CAST(rut as UNSIGNED)';
                break;
            case 4:
                $ordenStr = 'CAST(rut as UNSIGNED) DESC';
                break;
        }
        $rutcsj = $this->configuraciones->getValor(IDCONFIG_RUT_CSJ);
        $this->lista = $this->clientes->listarDepartamentos($this->rut, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad = $this->clientes->cantidadListarDepartamentos($this->rut)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);

        return $this->ver('listar_clientesDepartamentosFacturacion');
        //$this->contenido = $this->ver('listar_clientesDepartamentos');
        //return $this->ver('index');
    }

    public function nuevoDepartamento()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $cliente = new Clientes();
            $rut 			    = $_POST['rut'];
            $nombreDepartamento = $_POST['nombreDepartamento'];
            $cont = $cliente->existe($rut);
            $ok = $cliente->nuevoDepartamento($rut, $nombreDepartamento);
            if($ok)
            {
                //return $this->info_msg = $this->msg('popup', 'departamento', 1,0,1);
                $this->info_msg = "<script>javascript:alert('Departamento Ingresado.');listar('index.php?controlador=clientes&accion=listarDepartamentos&rut=<?=$this->rut?>','Listar Departamentos');</script>";
                $this->rut = $rut;
                return $this->ver('nuevo_departamento');
                return $this->ver('listar_clientesDepartamentos');
            }else{
                return "<script>javascript:self.parent.tb_remove();alert('Error al ingresar Departamento, contacte al Administrador.');</script>";
            }
        }
        $this->rut    = $_GET['rut'];
        return $this->ver('nuevo_departamento');
    }

    public function editarDepartamento()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        if($_SERVER['REQUEST_METHOD']=='POST')
        {
            $rut 			    = $_POST['rut'];
            $nombreDepartamento = $_POST['nombreDepartamento'];
            $idDepartamento 	= $_POST['idDepartamento'];


            $this->clientes->modificarDepartamento($idDepartamento, $nombreDepartamento);

            $this->info_msg = "<script>javascript:alert('Departamento Actualizado.');listar('index.php?controlador=clientes&accion=listarDepartamentos&rut=<?=$this->rut?>','Listar Departamentos');</script>";
            $this->rut = $rut;
            return $this->ver('editar_departamento');

            return $this->info_msg = $this->msg('popup', 'departamento', 2,0,1);
        }
        $rut = $_GET['rut'];
        $idDepartamento = $_GET['idDepartamento'];
        $this->datoscliente = $this->clientes->listarDepartamentoByID($idDepartamento);
        return $this->ver('editar_departamento');
    }

    public function eliminarDepartamento()
    {
        if(!isset($_SESSION['usuario']) )
        {
            header('location: index.php?error=nologin');
            return;
        }

        if($_SESSION['area']!=1 && $_SESSION['area']!=2 && $_SESSION['area']!=5 && $_SESSION['area']!=8 && $_SESSION['area']!=10 && $_SESSION['area']!=11)
        {
            header('location: index.php?error=restringido');
            return;
        }

        $idDepartamento = $_GET['idDepartamento'];
        $this->clientes->eliminarDepartamento($idDepartamento);
        $this->pagina = 1;
        if(isset($_GET['pagina']) && is_numeric($_GET['pagina']))
        {
            $this->pagina = $_GET['pagina'];
        }

        $this->resultados = 10; //Registros a mostrar por cada p�gina
        $this->pagVisible = 8; //paginas a mostrar en la paginaci�n

        $ordenStr = 'nombreDepartamentoCliente';
        $this->rut		= $_GET['rut'];
        $this->lista 	= $this->clientes->listarDepartamentos($this->rut, $this->resultados * ($this->pagina-1), $this->resultados, $this->buscar, $ordenStr);
        $cantidad 		= $this->clientes->cantidadListarDepartamentos($this->rut)["cantidad"];
        $this->nPaginas = ceil($cantidad / $this->resultados);

        return $this->ver('listar_clientesDepartamentos');
    }
}
?>